#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
layout(local_size_x = 4, local_size_y = 4, local_size_z = 4) in;

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer OcclusionInputData
{
    uint in_data_occlusion[];
} _226;

layout(set = 0, binding = 2, std430) buffer ColorInputData
{
    uint in_data_color[];
} _411;

layout(set = 0, binding = 3, r8) uniform writeonly image3D imTarget0Occupancy;
layout(set = 0, binding = 4, rgba8) uniform writeonly image3D imTarget0Color;
layout(set = 0, binding = 5, rgba8) uniform writeonly image3D imTarget1Color;
layout(set = 0, binding = 6, r8) uniform writeonly image3D imTarget1Occupancy;
layout(set = 0, binding = 7, rgba8) uniform writeonly image3D imTarget2Color;
layout(set = 0, binding = 8, r8) uniform writeonly image3D imTarget2Occupancy;

shared vec4 cube_samples_mip1[4][4][4];

float rt_voxel_occlusion_decode(uint vi)
{
    return float(vi) / 1024.0;
}

vec4 color_convert_rgb_rgbm(inout vec3 v)
{
    v = sqrt(v);
    v /= vec3(128.0);
    vec4 rgbm;
    rgbm.w = clamp(max(max(v.x, v.y), max(v.z, 9.9999999747524270787835121154785e-07)), 0.0, 1.0);
    rgbm.w = ceil(rgbm.w * 256.0) / 255.0;
    float _63 = rgbm.w;
    vec3 _65 = v / vec3(_63);
    rgbm.x = _65.x;
    rgbm.y = _65.y;
    rgbm.z = _65.z;
    return rgbm;
}

vec4 rt_voxel_color_decode(uint vi)
{
    vec4 v = vec4(0.0);
    if ((vi >> uint(31)) > 0u)
    {
        uint v_mag = (vi >> uint(24)) & 127u;
        float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
        v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
        v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
        v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
        v.w = 1.0;
    }
    return v;
}

void main()
{
    uvec3 grid_pos_16x16x16 = uvec3(gl_WorkGroupID);
    uvec3 grid_pos = (grid_pos_16x16x16 * uvec3(8u)) + (uvec3(gl_LocalInvocationID) * uvec3(2u));
    int grid_size = 256;
    cube_samples_mip1[gl_LocalInvocationID.z][gl_LocalInvocationID.y][gl_LocalInvocationID.x] = vec4(0.0);
    barrier();
    memoryBarrierShared();
    uvec3 store_pos = grid_pos;
    bool all_occlusion_zero = true;
    int iz = 0;
    for (;;)
    {
        if (iz < 2)
        {
            int iy = 0;
            for (;;)
            {
                if (iy < 2)
                {
                    int ix = 0;
                    for (;;)
                    {
                        if (ix < 2)
                        {
                            uint source_off = (store_pos.x + (store_pos.y * uint(grid_size))) + ((store_pos.z * uint(grid_size)) * uint(grid_size));
                            uint vi = _226.in_data_occlusion[source_off];
                            uint param = vi;
                            float a = rt_voxel_occlusion_decode(param);
                            all_occlusion_zero = all_occlusion_zero && (a == 0.0);
                            cube_samples_mip1[gl_LocalInvocationID.z][gl_LocalInvocationID.y][gl_LocalInvocationID.x].w += a;
                            imageStore(imTarget0Occupancy, ivec3(store_pos), vec4(a));
                            store_pos.x++;
                            ix++;
                            continue;
                        }
                        else
                        {
                            break;
                        }
                    }
                    store_pos.x -= 2u;
                    store_pos.y++;
                    iy++;
                    continue;
                }
                else
                {
                    break;
                }
            }
            store_pos.y -= 2u;
            store_pos.z++;
            iz++;
            continue;
        }
        else
        {
            break;
        }
    }
    store_pos = grid_pos;
    if (all_occlusion_zero)
    {
        int iz_1 = 0;
        for (;;)
        {
            if (iz_1 < 2)
            {
                int iy_1 = 0;
                for (;;)
                {
                    if (iy_1 < 2)
                    {
                        int ix_1 = 0;
                        for (;;)
                        {
                            if (ix_1 < 2)
                            {
                                uint source_off_1 = (store_pos.x + (store_pos.y * uint(grid_size))) + ((store_pos.z * uint(grid_size)) * uint(grid_size));
                                vec4 v = vec4(0.0);
                                vec3 param_1 = v.xyz;
                                vec4 _340 = color_convert_rgb_rgbm(param_1);
                                imageStore(imTarget0Color, ivec3(store_pos), _340);
                                store_pos.x++;
                                ix_1++;
                                continue;
                            }
                            else
                            {
                                break;
                            }
                        }
                        store_pos.x -= 2u;
                        store_pos.y++;
                        iy_1++;
                        continue;
                    }
                    else
                    {
                        break;
                    }
                }
                store_pos.y -= 2u;
                store_pos.z++;
                iz_1++;
                continue;
            }
            else
            {
                break;
            }
        }
    }
    else
    {
        int iz_2 = 0;
        for (;;)
        {
            if (iz_2 < 2)
            {
                int iy_2 = 0;
                for (;;)
                {
                    if (iy_2 < 2)
                    {
                        int ix_2 = 0;
                        for (;;)
                        {
                            if (ix_2 < 2)
                            {
                                uint source_off_2 = (store_pos.x + (store_pos.y * uint(grid_size))) + ((store_pos.z * uint(grid_size)) * uint(grid_size));
                                uint vi_1 = _411.in_data_color[source_off_2];
                                uint param_2 = vi_1;
                                vec4 v_1 = rt_voxel_color_decode(param_2);
                                vec3 param_3 = v_1.xyz;
                                vec4 _425 = color_convert_rgb_rgbm(param_3);
                                imageStore(imTarget0Color, ivec3(store_pos), _425);
                                vec4 _435 = cube_samples_mip1[gl_LocalInvocationID.z][gl_LocalInvocationID.y][gl_LocalInvocationID.x];
                                vec3 _437 = _435.xyz + v_1.xyz;
                                cube_samples_mip1[gl_LocalInvocationID.z][gl_LocalInvocationID.y][gl_LocalInvocationID.x].x = _437.x;
                                cube_samples_mip1[gl_LocalInvocationID.z][gl_LocalInvocationID.y][gl_LocalInvocationID.x].y = _437.y;
                                cube_samples_mip1[gl_LocalInvocationID.z][gl_LocalInvocationID.y][gl_LocalInvocationID.x].z = _437.z;
                                store_pos.x++;
                                ix_2++;
                                continue;
                            }
                            else
                            {
                                break;
                            }
                        }
                        store_pos.x -= 2u;
                        store_pos.y++;
                        iy_2++;
                        continue;
                    }
                    else
                    {
                        break;
                    }
                }
                store_pos.y -= 2u;
                store_pos.z++;
                iz_2++;
                continue;
            }
            else
            {
                break;
            }
        }
    }
    barrier();
    groupMemoryBarrier();
    memoryBarrierShared();
    store_pos = grid_pos;
    int iz_3 = 0;
    for (;;)
    {
        if (iz_3 < 2)
        {
            int iy_3 = 0;
            for (;;)
            {
                if (iy_3 < 2)
                {
                    int ix_3 = 0;
                    for (;;)
                    {
                        if (ix_3 < 2)
                        {
                            uint source_off_3 = (store_pos.x + (store_pos.y * uint(grid_size))) + ((store_pos.z * uint(grid_size)) * uint(grid_size));
                            _411.in_data_color[source_off_3] = 0u;
                            _226.in_data_occlusion[source_off_3] = 0u;
                            store_pos.x++;
                            ix_3++;
                            continue;
                        }
                        else
                        {
                            break;
                        }
                    }
                    store_pos.x -= 2u;
                    store_pos.y++;
                    iy_3++;
                    continue;
                }
                else
                {
                    break;
                }
            }
            store_pos.y -= 2u;
            store_pos.z++;
            iz_3++;
            continue;
        }
        else
        {
            break;
        }
    }
    int iz_4 = 0;
    for (;;)
    {
        if (iz_4 < 1)
        {
            int iy_4 = 0;
            for (;;)
            {
                if (iy_4 < 1)
                {
                    int ix_4 = 0;
                    for (;;)
                    {
                        if (ix_4 < 1)
                        {
                            store_pos = (grid_pos / uvec3(2u)) + uvec3(ivec3(ix_4, iy_4, iz_4));
                            vec4 samples_color = vec4(0.0);
                            samples_color.w = cube_samples_mip1[gl_LocalInvocationID.z][gl_LocalInvocationID.y][gl_LocalInvocationID.x].w / 4.0;
                            vec3 _593 = cube_samples_mip1[gl_LocalInvocationID.z][gl_LocalInvocationID.y][gl_LocalInvocationID.x].xyz / vec3(4.0);
                            samples_color.x = _593.x;
                            samples_color.y = _593.y;
                            samples_color.z = _593.z;
                            vec3 param_4 = samples_color.xyz;
                            vec4 _607 = color_convert_rgb_rgbm(param_4);
                            imageStore(imTarget1Color, ivec3(store_pos), _607);
                            imageStore(imTarget1Occupancy, ivec3(store_pos), samples_color.wwww);
                            ix_4++;
                            continue;
                        }
                        else
                        {
                            break;
                        }
                    }
                    iy_4++;
                    continue;
                }
                else
                {
                    break;
                }
            }
            iz_4++;
            continue;
        }
        else
        {
            break;
        }
    }
    bool _623 = (gl_LocalInvocationID.z & 1u) == 0u;
    bool _630;
    if (_623)
    {
        _630 = (gl_LocalInvocationID.y & 1u) == 0u;
    }
    else
    {
        _630 = _623;
    }
    bool _637;
    if (_630)
    {
        _637 = (gl_LocalInvocationID.x & 1u) == 0u;
    }
    else
    {
        _637 = _630;
    }
    if (_637)
    {
        uint _642 = gl_LocalInvocationID.z + 0u;
        uint _645 = gl_LocalInvocationID.y + 0u;
        uint _648 = gl_LocalInvocationID.x + 0u;
        vec4 _731 = (((((cube_samples_mip1[gl_LocalInvocationID.z + 1u][gl_LocalInvocationID.y + 0u][gl_LocalInvocationID.x + 0u] + cube_samples_mip1[gl_LocalInvocationID.z + 0u][gl_LocalInvocationID.y + 1u][gl_LocalInvocationID.x + 0u]) + cube_samples_mip1[gl_LocalInvocationID.z + 1u][gl_LocalInvocationID.y + 1u][gl_LocalInvocationID.x + 0u]) + cube_samples_mip1[gl_LocalInvocationID.z + 0u][gl_LocalInvocationID.y + 0u][gl_LocalInvocationID.x + 1u]) + cube_samples_mip1[gl_LocalInvocationID.z + 1u][gl_LocalInvocationID.y + 0u][gl_LocalInvocationID.x + 1u]) + cube_samples_mip1[gl_LocalInvocationID.z + 0u][gl_LocalInvocationID.y + 1u][gl_LocalInvocationID.x + 1u]) + cube_samples_mip1[gl_LocalInvocationID.z + 1u][gl_LocalInvocationID.y + 1u][gl_LocalInvocationID.x + 1u];
        cube_samples_mip1[_642][_645][_648] += _731;
        uint _738 = gl_LocalInvocationID.z + 0u;
        uint _741 = gl_LocalInvocationID.y + 0u;
        uint _744 = gl_LocalInvocationID.x + 0u;
        cube_samples_mip1[_738][_741][_744] /= vec4(16.0);
        vec3 param_5 = cube_samples_mip1[gl_LocalInvocationID.z + 0u][gl_LocalInvocationID.y + 0u][gl_LocalInvocationID.x + 0u].xyz;
        vec4 _770 = color_convert_rgb_rgbm(param_5);
        imageStore(imTarget2Color, ivec3(grid_pos / uvec3(4u)), _770);
        imageStore(imTarget2Occupancy, ivec3(grid_pos / uvec3(4u)), cube_samples_mip1[gl_LocalInvocationID.z + 0u][gl_LocalInvocationID.y + 0u][gl_LocalInvocationID.x + 0u].wwww);
    }
}

 