#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
layout(local_size_x = 1, local_size_y = 1, local_size_z = 1) in;

struct BuildDrawPointsIndirectFromGeometryInformationParams
{
    uint indirect_buffer_idx;
    uint _pad0;
    uint _pad1;
    uint _pad2;
};

struct DrawArraysIndirectParams
{
    uint count;
    uint instance_count;
    uint first_index;
    uint base_instance;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 2, std140) uniform BuildDrawPointsIndirectFromGeometryInformationParamsBuffer
{
    BuildDrawPointsIndirectFromGeometryInformationParams params;
} _26;

layout(set = 0, binding = 1, std430) buffer DrawArraysIndirectParamsBuffer
{
    DrawArraysIndirectParams draw_indirect_params[];
} _36;

layout(set = 0, binding = 3, std140) uniform DrawIndirectGeometryInformationParamsBuffer
{
    GeometryInformation draw_indirect_geometry_information;
} _46;

layout(set = 0, binding = 4, std140) uniform DrawIndirectInstanceParamsBuffer
{
    InstanceParams draw_indirect_instance_params;
} _56;

void main()
{
    uint idx = gl_GlobalInvocationID.x;
    if (idx == 0u)
    {
        uint indirect_buffer_idx = _26.params.indirect_buffer_idx;
        _36.draw_indirect_params[indirect_buffer_idx].count = _46.draw_indirect_geometry_information.vtx_num;
        _36.draw_indirect_params[indirect_buffer_idx].instance_count = uint(min(_56.draw_indirect_instance_params.buffer_capacity, _56.draw_indirect_instance_params.instance_count));
        _36.draw_indirect_params[indirect_buffer_idx].first_index = 0u;
        _36.draw_indirect_params[indirect_buffer_idx].base_instance = 0u;
    }
}

 