#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct RibbonRenderParams
{
    int max_segments;
    int base_idx;
    int base_segment;
    int particles_per_segment;
    float thickness;
    int lights_num;
    int material_index;
    float first_segment_time_factor;
    int render_as_strips;
    int _pad0;
    int _pad1;
    int _pad2;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct ParticleRibbonState
{
    float generation_id;
    uint segments;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct LightProperties
{
    vec4 diffuse;
    vec4 direction;
    vec4 position;
    vec4 up;
    vec4 right;
    vec2 dimensions;
    vec2 _pad1;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct _710
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _146;

layout(set = 0, binding = 4, std140) uniform RibbonRenderParamsBuffer
{
    RibbonRenderParams ribbon_render_params;
} _188;

layout(set = 0, binding = 2, std430) buffer RibbonPositionsData
{
    float position[];
} prt_position_snapshots;

layout(set = 0, binding = 5, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _272;

layout(set = 0, binding = 3, std430) buffer RibbonStatesData
{
    ParticleRibbonState states[];
} prt_states_snapshots;

layout(location = 1) out _710 vtx_output;
layout(location = 0) out uint instanceID;

bool prt_is_alive(uint id)
{
    return _146.prt_states[id].life_time < _146.prt_states[id].life_span;
}

int calculate_vidx_for_ribbon_segment(int ribbon_id, inout int ribbon_segment)
{
    ribbon_segment = _188.ribbon_render_params.base_segment - ribbon_segment;
    if (ribbon_segment < 0)
    {
        ribbon_segment += _188.ribbon_render_params.max_segments;
    }
    if (ribbon_segment >= _188.ribbon_render_params.max_segments)
    {
        ribbon_segment -= _188.ribbon_render_params.max_segments;
    }
    int vidx = ((ribbon_segment * _188.ribbon_render_params.particles_per_segment) + ribbon_id) + _188.ribbon_render_params.base_idx;
    return vidx;
}

vec3 color_convert_uint_to_float3(uint vi)
{
    vec3 v = vec3(0.0);
    uint v_mag = vi >> uint(24);
    float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
    v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
    v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
    v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
    return v;
}

vec4 prt_get_color(uint id)
{
    vec4 c = vec4(1.0);
    uint param = _146.prt_states[id].color;
    vec3 _175 = color_convert_uint_to_float3(param);
    c.x = _175.x;
    c.y = _175.y;
    c.z = _175.z;
    return c;
}

vec3 apply_vtx_modifier(vec3 pos, vec3 norm, vec3 color, uint ribbon_id)
{
    return pos;
}

ParticleState prt_get_state(uint id)
{
    ParticleState _163;
    _163.life_time = _146.prt_states[id].life_time;
    _163.life_span = _146.prt_states[id].life_span;
    _163.generation_id = _146.prt_states[id].generation_id;
    _163.color = _146.prt_states[id].color;
    ParticleState _162 = _163;
    return _162;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec3 get_ribbon_transformed_segment_position(int ribbon_id, int segment_idx)
{
    int param = ribbon_id;
    int param_1 = segment_idx;
    int _233 = calculate_vidx_for_ribbon_segment(param, param_1);
    int vidx = _233;
    vec3 p = vec3(prt_position_snapshots.position[(vidx * 3) + 0], prt_position_snapshots.position[(vidx * 3) + 1], prt_position_snapshots.position[(vidx * 3) + 2]);
    vec3 dummy_normal = vec3(0.0);
    vec3 dummy_color = vec3(0.0);
    vec3 param_2 = p;
    vec3 param_3 = dummy_normal;
    vec3 param_4 = dummy_color;
    uint param_5 = uint(ribbon_id);
    dummy_color = param_4;
    vec3 modified_p = apply_vtx_modifier(param_2, param_3, param_4, param_5);
    vec3 param_6 = modified_p;
    mat4 param_7 = _272.transform_params.mModelView;
    vec3 _279 = vector_transform_by_mat43(param_6, param_7);
    return _279;
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    return m * vec4(v, 1.0);
}

void main()
{
    int odd_even = ((gl_VertexIndex & 1) == 0) ? 1 : (-1);
    int ribbon_id;
    int ribbon_segment;
    if (_188.ribbon_render_params.render_as_strips != 0)
    {
        ribbon_id = gl_InstanceIndex;
        ribbon_segment = gl_VertexIndex / 2;
    }
    else
    {
        uint max_segments_uint = uint(_188.ribbon_render_params.max_segments);
        ribbon_segment = gl_VertexIndex / 2;
        ribbon_id = (gl_InstanceIndex * 64) + int(uint(ribbon_segment) / max_segments_uint);
        ribbon_segment = int(uint(ribbon_segment) % max_segments_uint);
    }
    if (false)
    {
        uint param = uint(ribbon_id);
        if (!prt_is_alive(param))
        {
            gl_Position = vec4(0.0, 0.0, 0.0, -1.0);
            return;
        }
    }
    int ribbon_segments = max(0, (min(_188.ribbon_render_params.max_segments, int(prt_states_snapshots.states[ribbon_id].segments)) - 1));
    ribbon_segment = min(ribbon_segment, ribbon_segments);
    int param_1 = ribbon_id;
    int param_2 = ribbon_segment;
    int _364 = calculate_vidx_for_ribbon_segment(param_1, param_2);
    int vidx = _364;
    vec3 vInstPosition = vec3(prt_position_snapshots.position[(vidx * 3) + 0], prt_position_snapshots.position[(vidx * 3) + 1], prt_position_snapshots.position[(vidx * 3) + 2]);
    vec3 vInstNormal = vec3(1.0, 0.0, 0.0);
    uint param_3 = uint(ribbon_id);
    vec4 vInstColor = prt_get_color(param_3);
    vec3 param_4 = vInstPosition;
    vec3 param_5 = vInstNormal;
    vec3 param_6 = vInstColor.xyz;
    uint param_7 = uint(ribbon_id);
    vInstColor.x = param_6.x;
    vInstColor.y = param_6.y;
    vInstColor.z = param_6.z;
    vInstPosition = apply_vtx_modifier(param_4, param_5, param_6, param_7);
    uint param_8 = uint(ribbon_id);
    ParticleState vState = prt_get_state(param_8);
    bool is_last = ribbon_segment >= ribbon_segments;
    bool is_first = ribbon_segment == 0;
    vec3 extrusion = vec3(0.0);
    vec3 modelview_cylinder_axis = vec3(0.0, 0.0, 1.0);
    int second_segment_offset = -1;
    if (ribbon_segment == 0)
    {
        second_segment_offset = 1;
    }
    if (true)
    {
        float shrink_factor = _188.ribbon_render_params.first_segment_time_factor;
        float min_shrink_modifier = 0.1500000059604644775390625;
        int param_9 = ribbon_id;
        int param_10 = ribbon_segment;
        vec3 currPosition = get_ribbon_transformed_segment_position(param_9, param_10);
        int param_11 = ribbon_id;
        int param_12 = ribbon_segment + second_segment_offset;
        vec3 nextPosition = get_ribbon_transformed_segment_position(param_11, param_12);
        modelview_cylinder_axis = currPosition - nextPosition;
        if (length(modelview_cylinder_axis) <= 9.9999997473787516355514526367188e-05)
        {
            if (ribbon_segment > 1)
            {
                int param_13 = ribbon_id;
                int param_14 = ribbon_segment + (second_segment_offset * 2);
                nextPosition = get_ribbon_transformed_segment_position(param_13, param_14);
                modelview_cylinder_axis = currPosition - nextPosition;
            }
        }
        modelview_cylinder_axis = normalize(modelview_cylinder_axis);
        vec2 dir2d = normalize(currPosition.xy - nextPosition.xy);
        dir2d = vec2(-dir2d.y, dir2d.x);
        vec3 dir = vec3(dir2d, 0.0);
        if ((ribbon_segment == ribbon_segments) && (ribbon_segments > 1))
        {
        }
        if (is_first)
        {
            dir *= (-min_shrink_modifier);
        }
        else
        {
            if (is_last)
            {
                dir *= min_shrink_modifier;
            }
            else
            {
                if ((ribbon_segment == 1) && (ribbon_segments > 2))
                {
                    dir *= max(min_shrink_modifier, shrink_factor);
                }
                if ((ribbon_segment == (ribbon_segments - 1)) && (ribbon_segments == 2))
                {
                    dir *= max(min_shrink_modifier, shrink_factor);
                }
            }
        }
        extrusion = dir * _188.ribbon_render_params.thickness;
    }
    if (ribbon_segment == 0)
    {
        modelview_cylinder_axis *= (-1.0);
    }
    uint param_15 = uint(ribbon_id);
    if (!prt_is_alive(param_15))
    {
        gl_Position = vec4(0.0, 0.0, 0.0, -1.0);
        return;
    }
    vec3 pos = vInstPosition;
    vec3 vPos1 = pos;
    vec3 param_16 = vPos1;
    mat4 param_17 = _272.transform_params.mModelView;
    vec3 _577 = vector_transform_by_mat43(param_16, param_17);
    vec3 vPos = _577;
    if (vPos.z > 1.0)
    {
        mat4 projection_no_jitter = _272.transform_params.mProjection;
        projection_no_jitter[2].x = 0.0;
        projection_no_jitter[2].y = 0.0;
        vec3 param_18 = vec3(extrusion.xy, vPos.z);
        mat4 param_19 = projection_no_jitter;
        vec4 _600 = vector_transform_by_mat_projection(param_18, param_19);
        vec4 projected_extrusion = _600;
        vec4 _601 = projected_extrusion;
        float _604 = projected_extrusion.w;
        vec3 _606 = _601.xyz / vec3(_604);
        projected_extrusion.x = _606.x;
        projected_extrusion.y = _606.y;
        projected_extrusion.z = _606.z;
        float min_extrusion_size = 0.0006500000017695128917694091796875;
        float projected_extrusion_size = length(projected_extrusion.xy);
        if (projected_extrusion_size > 0.0)
        {
            if (projected_extrusion_size < min_extrusion_size)
            {
                float scale = min_extrusion_size / projected_extrusion_size;
                extrusion *= scale;
            }
        }
    }
    vPos += (extrusion * float(odd_even));
    vec3 param_20 = vPos;
    mat4 param_21 = _272.transform_params.mProjection;
    vec4 _646 = vector_transform_by_mat_projection(param_20, param_21);
    gl_Position = _646;
}

 