#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
layout(depth_less) out float gl_FragDepth;

struct RaymarchParams
{
    vec3 function_scale;
    int show_bounding_box;
    vec3 function_origin;
    int clamp_to_volume;
    float animation_time;
    float prestep;
    float intersection_density_modifier;
    float density;
    int use_instance_origin;
    int txt1_flip_y;
    int txt2_flip_y;
    int gradient_idx;
    vec4 near_far_plane;
    int trace_inside;
    int _pad0;
    int _pad1;
    int _pad2;
    vec4 camera_projection_params;
    vec2 frustum_shift;
    vec2 resolution;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct _1286
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct LightProperties
{
    vec4 diffuse;
    vec4 direction;
    vec4 position;
    vec4 up;
    vec4 right;
    vec2 dimensions;
    vec2 _pad1;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 1, binding = 3, std140) uniform RaymarchParamsBuffer
{
    RaymarchParams raymarch_params;
} _146;

layout(set = 1, binding = 1, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_raytrace_recip;
    vec4 grid_size_voxelize;
    vec4 grid_size_voxelize_recip;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 1, binding = 4, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _681;

layout(set = 1, binding = 5, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 1, binding = 6, std140) uniform BaseMaterialPropertiesBuffer
{
    vec4 colorDiffuse;
    int gUseDerivedNormal;
    int gMaterialMode;
    int materialId;
    int materialIndex;
    int componentTags;
} _1054;

layout(set = 1, binding = 7, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1077;

layout(set = 1, binding = 2, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1087;

layout(set = 1, binding = 8) uniform sampler3D s_voxel_colors_filtered;
layout(set = 1, binding = 9) uniform sampler3D s_voxel_occupancy_filtered;
layout(set = 1, binding = 10) uniform sampler2DArray s_BlueNoise;

layout(location = 0) flat in uint instanceID;
layout(location = 1) in _1286 vtx_input;

float det(mat2 matrix)
{
    return (matrix[0].x * matrix[1].y) - (matrix[0].y * matrix[1].x);
}

mat3 transpose_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat3 result = mat3(vec3(vec3(row0.x, row1.x, row2.x)), vec3(vec3(row0.y, row1.y, row2.y)), vec3(vec3(row0.z, row1.z, row2.z)));
    return result;
}

mat3 inverse_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat2 param = mat2(vec2(row1.y, row1.z), vec2(row2.y, row2.z));
    mat2 param_1 = mat2(vec2(row1.z, row1.x), vec2(row2.z, row2.x));
    mat2 param_2 = mat2(vec2(row1.x, row1.y), vec2(row2.x, row2.y));
    vec3 minors0 = vec3(det(param), det(param_1), det(param_2));
    mat2 param_3 = mat2(vec2(row2.y, row2.z), vec2(row0.y, row0.z));
    mat2 param_4 = mat2(vec2(row2.z, row2.x), vec2(row0.z, row0.x));
    mat2 param_5 = mat2(vec2(row2.x, row2.y), vec2(row0.x, row0.y));
    vec3 minors1 = vec3(det(param_3), det(param_4), det(param_5));
    mat2 param_6 = mat2(vec2(row0.y, row0.z), vec2(row1.y, row1.z));
    mat2 param_7 = mat2(vec2(row0.z, row0.x), vec2(row1.z, row1.x));
    mat2 param_8 = mat2(vec2(row0.x, row0.y), vec2(row1.x, row1.y));
    vec3 minors2 = vec3(det(param_6), det(param_7), det(param_8));
    mat3 param_9 = mat3(vec3(minors0), vec3(minors1), vec3(minors2));
    mat3 adj = transpose_mat3(param_9);
    return adj * (1.0 / dot(row0, minors0));
}

float sdBox(vec3 p, vec3 b)
{
    vec3 q = abs(p) - b;
    return length(max(q, vec3(0.0))) + min(max(q.x, max(q.y, q.z)), 0.0);
}

float raymarchBBox(vec3 ro, vec3 rd, vec3 function_scale)
{
    float h = 0.00200000009499490261077880859375;
    float t = 0.0;
    float res = -1.0;
    int i = 0;
    for (;;)
    {
        if (i < 48)
        {
            if ((h < 0.001000000047497451305389404296875) || (t > 20000.0))
            {
                break;
            }
            vec3 param = ro + (rd * t);
            vec3 param_1 = vec3(1000.0);
            vec3 param_2 = ro + (rd * t);
            vec3 param_3 = (function_scale * 0.5) + vec3(0.00999999977648258209228515625);
            h = max(sdBox(param, param_1), -sdBox(param_2, param_3));
            t += h;
            i++;
            continue;
        }
        else
        {
            break;
        }
    }
    if (t < 20000.0)
    {
        res = t;
    }
    return res;
}

vec3 get_view_direction(vec2 screen_pos)
{
    vec2 vd_pos = screen_pos - ((_146.raymarch_params.frustum_shift * _146.raymarch_params.resolution) * vec2(0.5, -0.5));
    vec3 view_direction;
    view_direction.x = (-_146.raymarch_params.camera_projection_params.z) + ((_146.raymarch_params.camera_projection_params.x * vd_pos.x) / _146.raymarch_params.resolution.x);
    view_direction.y = (-_146.raymarch_params.camera_projection_params.w) + ((_146.raymarch_params.camera_projection_params.y * vd_pos.y) / _146.raymarch_params.resolution.y);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    return view_direction;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec3 color_convert_rgbm_rgb(inout vec4 v)
{
    vec4 _95 = v;
    float _100 = v.w;
    vec3 _103 = (_95.xyz * _100) * 128.0;
    v.x = _103.x;
    v.y = _103.y;
    v.z = _103.z;
    return v.xyz * v.xyz;
}

vec4 sample_voxelization_data(vec3 world_position, float color_lod, float occupancy_lod)
{
    vec3 voxelizer_bbox_origin = in_bbox_data.bbox_voxelize_min.xyz;
    vec3 voxelizer_bbox_size = in_bbox_data.grid_size_voxelize.xyz * 256.0;
    vec3 source_voxel_position = (world_position - voxelizer_bbox_origin) / voxelizer_bbox_size;
    bool _221 = source_voxel_position.x < 0.0;
    bool _228;
    if (!_221)
    {
        _228 = source_voxel_position.y < 0.0;
    }
    else
    {
        _228 = _221;
    }
    bool _235;
    if (!_228)
    {
        _235 = source_voxel_position.z < 0.0;
    }
    else
    {
        _235 = _228;
    }
    bool _242;
    if (!_235)
    {
        _242 = source_voxel_position.x >= 1.0;
    }
    else
    {
        _242 = _235;
    }
    bool _249;
    if (!_242)
    {
        _249 = source_voxel_position.y >= 1.0;
    }
    else
    {
        _249 = _242;
    }
    bool _256;
    if (!_249)
    {
        _256 = source_voxel_position.z >= 1.0;
    }
    else
    {
        _256 = _249;
    }
    if (_256)
    {
        return vec4(0.0);
    }
    vec4 param = textureLod(s_voxel_colors_filtered, source_voxel_position, color_lod);
    vec3 _271 = color_convert_rgbm_rgb(param);
    vec3 voxel_color = _271;
    float voxel_occupancy = textureLod(s_voxel_occupancy_filtered, source_voxel_position, occupancy_lod).x;
    return vec4(voxel_color, voxel_occupancy);
}

float hash(inout vec3 p)
{
    p = fract((p * 0.31830990314483642578125) + vec3(0.10999999940395355224609375, 0.17000000178813934326171875, 0.12999999523162841796875)) * 17.0;
    return fract(((p.x * p.y) * p.z) * ((p.x + p.y) + p.z));
}

float sdBase(vec3 p)
{
    vec3 i = floor(p);
    vec3 f = fract(p);
    vec3 param = i + vec3(0.0);
    float _436 = hash(param);
    vec3 param_1 = i + vec3(0.0);
    float _440 = hash(param_1);
    vec3 param_2 = i + vec3(0.0, 0.0, 1.0);
    float _452 = hash(param_2);
    vec3 param_3 = i + vec3(0.0, 0.0, 1.0);
    float _456 = hash(param_3);
    vec3 param_4 = i + vec3(0.0, 1.0, 0.0);
    float _468 = hash(param_4);
    vec3 param_5 = i + vec3(0.0, 1.0, 0.0);
    float _472 = hash(param_5);
    vec3 param_6 = i + vec3(0.0, 1.0, 1.0);
    float _483 = hash(param_6);
    vec3 param_7 = i + vec3(0.0, 1.0, 1.0);
    float _487 = hash(param_7);
    vec3 param_8 = i + vec3(1.0, 0.0, 0.0);
    float _500 = hash(param_8);
    vec3 param_9 = i + vec3(1.0, 0.0, 0.0);
    float _504 = hash(param_9);
    vec3 param_10 = i + vec3(1.0, 0.0, 1.0);
    float _515 = hash(param_10);
    vec3 param_11 = i + vec3(1.0, 0.0, 1.0);
    float _519 = hash(param_11);
    vec3 param_12 = i + vec3(1.0, 1.0, 0.0);
    float _531 = hash(param_12);
    vec3 param_13 = i + vec3(1.0, 1.0, 0.0);
    float _535 = hash(param_13);
    vec3 param_14 = i + vec3(1.0);
    float _546 = hash(param_14);
    vec3 param_15 = i + vec3(1.0);
    float _550 = hash(param_15);
    return min(min(min(length(f - vec3(0.0)) - ((_436 * _440) * 0.699999988079071044921875), length(f - vec3(0.0, 0.0, 1.0)) - ((_452 * _456) * 0.699999988079071044921875)), min(length(f - vec3(0.0, 1.0, 0.0)) - ((_468 * _472) * 0.699999988079071044921875), length(f - vec3(0.0, 1.0, 1.0)) - ((_483 * _487) * 0.699999988079071044921875))), min(min(length(f - vec3(1.0, 0.0, 0.0)) - ((_500 * _504) * 0.699999988079071044921875), length(f - vec3(1.0, 0.0, 1.0)) - ((_515 * _519) * 0.699999988079071044921875)), min(length(f - vec3(1.0, 1.0, 0.0)) - ((_531 * _535) * 0.699999988079071044921875), length(f - vec3(1.0)) - ((_546 * _550) * 0.699999988079071044921875))));
}

float smax(float a, float b, float k)
{
    float h = max(k - abs(a - b), 0.0);
    return max(a, b) + (((h * h) * 0.25) / k);
}

vec2 sdFbm(inout vec3 p, inout float d)
{
    float t = 0.0;
    float s = 1.0;
    int i = 0;
    for (;;)
    {
        if (i < 7)
        {
            vec3 param = p;
            float n = s * sdBase(param);
            float param_1 = d;
            float param_2 = -n;
            float param_3 = 0.1500000059604644775390625 * s;
            d = smax(param_1, param_2, param_3);
            t += d;
            p = mat3(vec3(0.0, 1.60000002384185791015625, 1.2000000476837158203125), vec3(-1.60000002384185791015625, 0.7200000286102294921875, -0.959999978542327880859375), vec3(-1.2000000476837158203125, -0.959999978542327880859375, 1.2799999713897705078125)) * p;
            s = 0.550000011920928955078125 * s;
            i++;
            continue;
        }
        else
        {
            break;
        }
    }
    return vec2(d, t);
}

vec4 raymarch(vec3 ro, vec3 rd, float max_t, out float intersection)
{
    vec4 sum = vec4(0.0);
    float t = 0.0;
    intersection = -1.0;
    float t_step = 0.100000001490116119384765625;
    float dither = texelFetch(s_BlueNoise, ivec3(ivec2(uvec2(gl_FragCoord.xy) % uvec2(128u)), 0), 0).x;
    t += (0.100000001490116119384765625 * dither);
    int i = 0;
    for (;;)
    {
        if (i < 128)
        {
            float trace_t = t;
            if (trace_t >= max_t)
            {
                break;
            }
            vec3 pos = ro + (rd * trace_t);
            vec3 world_pos = pos;
            world_pos -= _146.raymarch_params.function_origin;
            world_pos /= _146.raymarch_params.function_scale;
            vec3 param = world_pos;
            mat4 param_1 = _681.transform_params.mModel;
            vec3 _688 = vector_transform_by_mat43(param, param_1);
            world_pos = _688;
            vec3 param_2 = world_pos;
            float param_3 = 1.0;
            float param_4 = 1.0;
            vec4 voxel_color_occupancy = sample_voxelization_data(param_2, param_3, param_4);
            if (voxel_color_occupancy.w > 0.00999999977648258209228515625)
            {
                break;
            }
            t += (t_step * _146.raymarch_params.prestep);
            i++;
            continue;
        }
        else
        {
            break;
        }
    }
    int i_1 = 0;
    for (;;)
    {
        if (i_1 < 64)
        {
            float trace_t_1 = t;
            vec3 pos_1 = ro + (rd * trace_t_1);
            vec3 world_pos_1 = pos_1;
            world_pos_1 -= _146.raymarch_params.function_origin;
            world_pos_1 /= _146.raymarch_params.function_scale;
            vec3 param_5 = world_pos_1;
            mat4 param_6 = _681.transform_params.mModel;
            vec3 _742 = vector_transform_by_mat43(param_5, param_6);
            world_pos_1 = _742;
            vec3 param_7 = world_pos_1;
            float param_8 = 1.0;
            float param_9 = 1.0;
            vec4 voxel_color_occupancy_1 = sample_voxelization_data(param_7, param_8, param_9);
            if (voxel_color_occupancy_1.w < 0.00999999977648258209228515625)
            {
                return vec4(0.0);
            }
            vec3 param_10 = pos_1;
            float param_11 = -0.0040000001899898052215576171875;
            vec2 _760 = sdFbm(param_10, param_11);
            vec2 d = _760;
            if (d.x < 0.00025000001187436282634735107421875)
            {
                break;
            }
            vec3 _770 = vec3(d.y);
            sum.x = _770.x;
            sum.y = _770.y;
            sum.z = _770.z;
            t += d.x;
            i_1++;
            continue;
        }
        else
        {
            break;
        }
    }
    sum.w = sum.x;
    if (t >= max_t)
    {
        sum.x = 0.0;
        sum.y = 0.0;
        sum.z = 0.0;
    }
    intersection = min(max_t, t);
    return vec4(max(vec3(0.0), sum.xyz), sum.w);
}

float calcIntersection(vec3 ro, vec3 rd, float max_t, out vec4 color)
{
    vec3 param = ro;
    vec3 param_1 = rd;
    float param_2 = max_t;
    float param_3;
    vec4 _819 = raymarch(param, param_1, param_2, param_3);
    float intersection = param_3;
    color = _819;
    return intersection;
}

void main()
{
    MaterialPropertiesGPU _1062;
    _1062.diffuse = materials.material_properties[_1054.materialIndex].diffuse;
    _1062.transparency = materials.material_properties[_1054.materialIndex].transparency;
    _1062.emissive = materials.material_properties[_1054.materialIndex].emissive;
    _1062.roughness = materials.material_properties[_1054.materialIndex].roughness;
    _1062.triplanar_factor = materials.material_properties[_1054.materialIndex].triplanar_factor;
    _1062.refraction = materials.material_properties[_1054.materialIndex].refraction;
    _1062.normal_factor = materials.material_properties[_1054.materialIndex].normal_factor;
    _1062.emissive_factor = materials.material_properties[_1054.materialIndex].emissive_factor;
    _1062.temporal_accumulation_factor = materials.material_properties[_1054.materialIndex].temporal_accumulation_factor;
    _1062.shadowmap_bias = materials.material_properties[_1054.materialIndex].shadowmap_bias;
    _1062.metalness = materials.material_properties[_1054.materialIndex].metalness;
    _1062.albedo_sampler = materials.material_properties[_1054.materialIndex].albedo_sampler;
    _1062.emissive_sampler = materials.material_properties[_1054.materialIndex].emissive_sampler;
    _1062.normal_sampler = materials.material_properties[_1054.materialIndex].normal_sampler;
    _1062.metalic_roughness_sampler = materials.material_properties[_1054.materialIndex].metalic_roughness_sampler;
    _1062.flags = materials.material_properties[_1054.materialIndex].flags;
    _1062._pad0 = materials.material_properties[_1054.materialIndex]._pad0;
    _1062._pad1 = materials.material_properties[_1054.materialIndex]._pad1;
    MaterialPropertiesGPU material = _1062;
    vec4 outAlbedo = vec4(1.0);
    mat4 mat_instance_model;
    mat_instance_model[0] = vec4(1.0, 0.0, 0.0, 0.0);
    mat_instance_model[1] = vec4(0.0, 1.0, 0.0, 0.0);
    mat_instance_model[2] = vec4(0.0, 0.0, 1.0, 0.0);
    mat_instance_model[3] = vec4(0.0, 0.0, 0.0, 1.0);
    if (_1077.instance_params.stride > 0)
    {
        vec4 inst_m0 = _1087.instance_transform[(instanceID * uint(_1077.instance_params.stride)) + 0u];
        vec4 inst_m1 = _1087.instance_transform[(instanceID * uint(_1077.instance_params.stride)) + 1u];
        vec4 inst_m2 = _1087.instance_transform[(instanceID * uint(_1077.instance_params.stride)) + 2u];
        vec3 _1122 = vec3(inst_m0.x, inst_m1.x, inst_m2.x);
        mat_instance_model[0].x = _1122.x;
        mat_instance_model[0].y = _1122.y;
        mat_instance_model[0].z = _1122.z;
        vec3 _1135 = vec3(inst_m0.y, inst_m1.y, inst_m2.y);
        mat_instance_model[1].x = _1135.x;
        mat_instance_model[1].y = _1135.y;
        mat_instance_model[1].z = _1135.z;
        vec3 _1148 = vec3(inst_m0.z, inst_m1.z, inst_m2.z);
        mat_instance_model[2].x = _1148.x;
        mat_instance_model[2].y = _1148.y;
        mat_instance_model[2].z = _1148.z;
        vec3 _1161 = vec3(inst_m0.w, inst_m1.w, inst_m2.w);
        mat_instance_model[3].x = _1161.x;
        mat_instance_model[3].y = _1161.y;
        mat_instance_model[3].z = _1161.z;
    }
    vec3 instance_function_origin = _146.raymarch_params.function_origin;
    if (_146.raymarch_params.use_instance_origin != 0)
    {
        instance_function_origin = (mat_instance_model * vec4(_146.raymarch_params.function_origin, 1.0)).xyz * 0.001000000047497451305389404296875;
    }
    mat_instance_model = _681.transform_params.mModel * mat_instance_model;
    mat4 mat_instance_model_inv = mat_instance_model;
    mat3 param = mat3(mat_instance_model_inv[0].xyz, mat_instance_model_inv[1].xyz, mat_instance_model_inv[2].xyz);
    mat3 inv = inverse_mat3(param);
    mat_instance_model_inv[0].x = inv[0].x;
    mat_instance_model_inv[0].y = inv[0].y;
    mat_instance_model_inv[0].z = inv[0].z;
    mat_instance_model_inv[1].x = inv[1].x;
    mat_instance_model_inv[1].y = inv[1].y;
    mat_instance_model_inv[1].z = inv[1].z;
    mat_instance_model_inv[2].x = inv[2].x;
    mat_instance_model_inv[2].y = inv[2].y;
    mat_instance_model_inv[2].z = inv[2].z;
    mat_instance_model_inv[3].x = -(((inv[0].x * mat_instance_model[3].x) + (inv[1].x * mat_instance_model[3].y)) + (inv[2].x * mat_instance_model[3].z));
    mat_instance_model_inv[3].y = -(((inv[0].y * mat_instance_model[3].x) + (inv[1].y * mat_instance_model[3].y)) + (inv[2].y * mat_instance_model[3].z));
    mat_instance_model_inv[3].z = -(((inv[0].z * mat_instance_model[3].x) + (inv[1].z * mat_instance_model[3].y)) + (inv[2].z * mat_instance_model[3].z));
    float g = (vtx_input.vNorm.z * 0.5) + 0.5;
    vec3 ro = (mat_instance_model_inv * vec4(vtx_input.vCameraRelativeWorldPos + _681.transform_params.vCameraPosition, 1.0)).xyz;
    vec3 rd = (mat_instance_model_inv * vec4(_681.transform_params.vCameraPosition, 1.0)).xyz;
    rd = normalize(ro - rd);
    if (_146.raymarch_params.trace_inside != 0)
    {
        ro = (mat_instance_model_inv * vec4(_681.transform_params.vCameraPosition, 1.0)).xyz;
    }
    ro *= _146.raymarch_params.function_scale;
    vec3 ro_bounding_volume = ro;
    ro += instance_function_origin;
    float max_depth = 100000.0;
    vec4 color = vec4(1.0);
    float bounding_volume_intersection = 100000.0;
    if (_146.raymarch_params.clamp_to_volume != 0)
    {
        vec3 param_1 = ro_bounding_volume;
        vec3 param_2 = rd;
        vec3 param_3 = _146.raymarch_params.function_scale;
        bounding_volume_intersection = raymarchBBox(param_1, param_2, param_3);
    }
    bounding_volume_intersection = max_depth;
    vec2 param_4 = vec2(gl_FragCoord.xy);
    vec3 view_direction = get_view_direction(param_4);
    vec3 world = (_681.transform_params.mViewInv * vec4(view_direction * max_depth, 1.0)).xyz;
    float d = length((_681.transform_params.mModelInv * vec4(world - _681.transform_params.vCameraPosition, 0.0)).xyz);
    bounding_volume_intersection = d * _146.raymarch_params.function_scale.z;
    vec3 param_5 = ro;
    vec3 param_6 = rd;
    float param_7 = bounding_volume_intersection;
    vec4 param_8;
    float _1411 = calcIntersection(param_5, param_6, param_7, param_8);
    color = param_8;
    float intersection = _1411;
    if (intersection > 0.0)
    {
        vec3 ri = ro + (rd * intersection);
        ri -= instance_function_origin;
        ri /= _146.raymarch_params.function_scale;
        ri = ((_681.transform_params.mView * mat_instance_model) * vec4(ri, 1.0)).xyz;
        outAlbedo.x = color.xyz.x;
        outAlbedo.y = color.xyz.y;
        outAlbedo.z = color.xyz.z;
        outAlbedo.w = 1.0 - color.w;
        vec2 param_9 = vec2(gl_FragCoord.xy);
        vec3 view_direction_1 = get_view_direction(param_9);
        vec3 world_1 = (_681.transform_params.mViewInv * vec4(view_direction_1 * max_depth, 1.0)).xyz;
        float d_1 = length(_681.transform_params.vCameraPosition - world_1);
        float near = -1.0;
        float far = 1.0;
        float depth = (_681.transform_params.mProjection * vec4(ri, 1.0)).z / (_681.transform_params.mProjection * vec4(ri, 1.0)).w;
        depth = ((((far - near) * depth) + near) + far) / 2.0;
        gl_FragDepth = depth;
    }
    else
    {
        if (_146.raymarch_params.show_bounding_box != 0)
        {
            if (intersection == (-1.0))
            {
                outAlbedo = vec4(0.4000000059604644775390625, 0.20000000298023223876953125, 0.0, 1.0);
            }
            else
            {
                outAlbedo = vec4(5.0, 0.0, 0.0, 1.0);
            }
            vec3 _1534 = fract(vtx_input.vCoords * 0.00999999977648258209228515625);
            outAlbedo.x = _1534.x;
            outAlbedo.y = _1534.y;
            outAlbedo.z = _1534.z;
        }
        else
        {
            outAlbedo.w = 1.0;
            discard;
        }
    }
}

 