#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct _308
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 8, scalar) uniform GeometryInformationBuffer
{
    GeometryInformation geometry_information;
} _104;

layout(set = 0, binding = 1, std430) readonly buffer VTXCoords
{
    float coords[];
} vtx_coords;

layout(set = 0, binding = 2, std430) readonly buffer VTXNormals
{
    float normals[];
} vtx_normals;

layout(set = 0, binding = 3, std430) readonly buffer VTXAlbedo
{
    float albedo[];
} vtx_albedo;

layout(set = 0, binding = 4, std430) readonly buffer VTXUV0
{
    float uv0[];
} vtx_uv0;

layout(set = 0, binding = 9, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _220;

layout(set = 0, binding = 5, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _232;

layout(set = 0, binding = 6, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _328;

layout(set = 0, binding = 7, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _409;

layout(set = 0, binding = 10, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _452;

layout(location = 1) out _308 vtx_output;
layout(location = 0) out uint instanceID;

vec3 vtx_coords_load(inout uint idx)
{
    idx *= _104.geometry_information.attributes[0].stride;
    idx += _104.geometry_information.attributes[0].offset;
    return vec3(vtx_coords.coords[idx + 0u], vtx_coords.coords[idx + 1u], vtx_coords.coords[idx + 2u]);
}

vec3 vtx_albedo_load(inout uint idx)
{
    idx *= _104.geometry_information.attributes[2].stride;
    idx += _104.geometry_information.attributes[2].offset;
    return vec3(vtx_albedo.albedo[idx + 0u], vtx_albedo.albedo[idx + 1u], vtx_albedo.albedo[idx + 2u]);
}

vec3 vtx_normals_load(inout uint idx)
{
    idx *= _104.geometry_information.attributes[1].stride;
    idx += _104.geometry_information.attributes[1].offset;
    return vec3(vtx_normals.normals[idx + 0u], vtx_normals.normals[idx + 1u], vtx_normals.normals[idx + 2u]);
}

vec2 vtx_uv0_load(inout uint idx)
{
    idx *= _104.geometry_information.attributes[3].stride;
    idx += _104.geometry_information.attributes[3].offset;
    return vec2(vtx_uv0.uv0[idx + 0u], vtx_uv0.uv0[idx + 1u]);
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    return m * vec4(v, 1.0);
}

void main()
{
    uint load_vertex_idx = uint(gl_VertexIndex);
    if (_220.instance_params.stride > 0)
    {
        uint flipbook_card = _232.instance_flipbook_card[gl_InstanceIndex];
        flipbook_card = min(flipbook_card, (_104.geometry_information.flipbook_cards_num - 1u));
        load_vertex_idx += (_104.geometry_information.vtx_num * flipbook_card);
    }
    VertexInput vtx_input;
    vtx_input.id = uint(gl_VertexIndex);
    uint param = load_vertex_idx;
    vec3 _257 = vtx_coords_load(param);
    vtx_input.pos = _257;
    vtx_input.norm = vec3(1.0, 0.0, 0.0);
    vtx_input.color = vec4(1.0);
    vtx_input.uv0 = vtx_input.pos.xy;
    if ((_104.geometry_information.builtin_attribute_mask & 4u) != 0u)
    {
        uint param_1 = uint(gl_VertexIndex);
        vec3 _280 = vtx_albedo_load(param_1);
        vtx_input.color.x = _280.x;
        vtx_input.color.y = _280.y;
        vtx_input.color.z = _280.z;
    }
    if ((_104.geometry_information.builtin_attribute_mask & 2u) != 0u)
    {
        uint param_2 = load_vertex_idx;
        vec3 _295 = vtx_normals_load(param_2);
        vtx_input.norm = _295;
    }
    if ((_104.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_3 = uint(gl_VertexIndex);
        vec2 _306 = vtx_uv0_load(param_3);
        vtx_input.uv0 = _306;
    }
    vtx_output.vLocalPos = vtx_input.pos;
    instanceID = uint(gl_InstanceIndex);
    if (_220.instance_params.stride > 0)
    {
        vec4 inst_m0 = _328.instance_transform[(gl_InstanceIndex * _220.instance_params.stride) + 0];
        vec4 inst_m1 = _328.instance_transform[(gl_InstanceIndex * _220.instance_params.stride) + 1];
        vec4 inst_m2 = _328.instance_transform[(gl_InstanceIndex * _220.instance_params.stride) + 2];
        vec4 v = vec4(vtx_input.pos, 1.0);
        vtx_input.pos.x = dot(inst_m0, v);
        vtx_input.pos.y = dot(inst_m1, v);
        vtx_input.pos.z = dot(inst_m2, v);
        vec3 param_4 = vtx_input.norm;
        mat4 param_5 = transpose(mat4(vec4(inst_m0), vec4(inst_m1), vec4(inst_m2), vec4(0.0, 0.0, 0.0, 1.0)));
        vtx_input.norm = normalize(vector_transform_by_mat33(param_4, param_5));
        vec2 _415 = unpackHalf2x16(_409.instance_color[(gl_InstanceIndex * 2) + 0]);
        vec4 inst_c;
        inst_c.x = _415.x;
        inst_c.y = _415.y;
        vec2 _425 = unpackHalf2x16(_409.instance_color[(gl_InstanceIndex * 2) + 1]);
        inst_c.z = _425.x;
        inst_c.w = _425.y;
        vec4 _431 = vtx_input.color;
        vec3 _435 = _431.xyz * inst_c.xyz;
        vtx_input.color.x = _435.x;
        vtx_input.color.y = _435.y;
        vtx_input.color.z = _435.z;
        vtx_input.color.w *= inst_c.w;
    }
    vec3 param_6 = vtx_input.pos;
    mat4 param_7 = _452.transform_params.mModel;
    vec3 _460 = vector_transform_by_mat43(param_6, param_7);
    vec3 vPosModel = _460;
    vec3 param_8 = vtx_input.norm;
    mat4 param_9 = _452.transform_params.mModelNormal;
    vtx_output.vWorldNorm = vector_transform_by_mat33(param_8, param_9);
    vec3 param_10 = vPosModel;
    mat4 param_11 = _452.transform_params.mView;
    vec3 _475 = vector_transform_by_mat43(param_10, param_11);
    vec3 vPosModelView = _475;
    vtx_output.vCoords = vPosModelView;
    vtx_output.vCameraRelativeWorldPos = vPosModel - _452.transform_params.vCameraPosition;
    vtx_output.vNorm.x = dot(_452.transform_params.mModelViewInvTrans[0].xyz, vtx_input.norm);
    vtx_output.vNorm.y = dot(_452.transform_params.mModelViewInvTrans[1].xyz, vtx_input.norm);
    vtx_output.vNorm.z = dot(_452.transform_params.mModelViewInvTrans[2].xyz, vtx_input.norm);
    vtx_output.vNorm = vtx_input.norm;
    vtx_output.vColor = vtx_input.color;
    vtx_output.vUV0 = vtx_input.uv0;
    vec3 param_12 = vtx_output.vCoords;
    mat4 param_13 = _452.transform_params.mProjection;
    vec4 _531 = vector_transform_by_mat_projection(param_12, param_13);
    gl_Position = _531;
}

 