#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ModifierFactorDistancePlane_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_mirror;
    int domain_repeat;
    int influence_scope;
    int modifier_function;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorWaveTransfer_Params
{
    int type;
    int modulate;
    float frequency;
    float phase_shift;
    float amplitude;
    float base;
};

struct VertexModifierDisplaceParams
{
    vec3 displace_normal;
    float displace_normal_modifier_factor;
    vec3 displace_base;
    float displace_base_modifier_factor;
    int influence_scope;
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct ModifierFactorMulAdd_Params
{
    float multiply_value;
    float add_value;
};

struct VertexModifierColorizeParams
{
    vec3 color;
    float alpha;
    int use_gradient;
    float color_blend;
    float alpha_blend;
    int color_gradient_idx;
    int mixing_mode;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct _1421
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 10, scalar) uniform GeometryInformationBuffer
{
    GeometryInformation geometry_information;
} _269;

layout(set = 0, binding = 1, std430) readonly buffer VTXCoords
{
    float coords[];
} vtx_coords;

layout(set = 0, binding = 2, std430) readonly buffer VTXNormals
{
    float normals[];
} vtx_normals;

layout(set = 0, binding = 3, std430) readonly buffer VTXAlbedo
{
    float albedo[];
} vtx_albedo;

layout(set = 0, binding = 4, std430) readonly buffer VTXUV0
{
    float uv0[];
} vtx_uv0;

layout(set = 0, binding = 5, std430) readonly buffer VTXCustom0
{
    uint custom0[];
} vtx_custom0;

layout(set = 0, binding = 11, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _961;

layout(set = 0, binding = 6, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _972;

layout(set = 0, binding = 7, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1060;

layout(set = 0, binding = 8, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _1252;

layout(set = 0, binding = 12, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _1293;

layout(set = 0, binding = 13, std140) uniform VM0
{
    layout(row_major) ModifierFactorDistancePlane_Params VM0_params;
} _1306;

layout(set = 0, binding = 14, std140) uniform VM1
{
    ModifierFactorWaveTransfer_Params VM1_params;
} _1321;

layout(set = 0, binding = 15, std140) uniform VM2
{
    VertexModifierDisplaceParams VM2_params;
} _1334;

layout(set = 0, binding = 16, std140) uniform VM3
{
    layout(row_major) ModifierFactorDistancePlane_Params VM3_params;
} _1354;

layout(set = 0, binding = 17, std140) uniform VM4
{
    ModifierFactorWaveTransfer_Params VM4_params;
} _1367;

layout(set = 0, binding = 18, std140) uniform VM5
{
    ModifierFactorMulAdd_Params VM5_params;
} _1379;

layout(set = 0, binding = 19, std140) uniform VM6
{
    VertexModifierDisplaceParams VM6_params;
} _1391;

layout(set = 0, binding = 20, std140) uniform VM7
{
    VertexModifierColorizeParams VM7_params;
} _1408;

layout(set = 0, binding = 9, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _1516;

layout(set = 0, binding = 21) uniform sampler2D s_Curves;
layout(set = 0, binding = 22) uniform sampler2D s_Gradients;

layout(location = 1) out _1421 vtx_output;
layout(location = 0) out uint instanceID;

vec3 vtx_coords_load(inout uint idx)
{
    idx *= _269.geometry_information.attributes[0].stride;
    idx += _269.geometry_information.attributes[0].offset;
    return vec3(vtx_coords.coords[idx + 0u], vtx_coords.coords[idx + 1u], vtx_coords.coords[idx + 2u]);
}

vec3 vtx_albedo_load(inout uint idx)
{
    idx *= _269.geometry_information.attributes[2].stride;
    idx += _269.geometry_information.attributes[2].offset;
    return vec3(vtx_albedo.albedo[idx + 0u], vtx_albedo.albedo[idx + 1u], vtx_albedo.albedo[idx + 2u]);
}

vec3 vtx_normals_load(inout uint idx)
{
    idx *= _269.geometry_information.attributes[1].stride;
    idx += _269.geometry_information.attributes[1].offset;
    return vec3(vtx_normals.normals[idx + 0u], vtx_normals.normals[idx + 1u], vtx_normals.normals[idx + 2u]);
}

vec2 vtx_uv0_load(inout uint idx)
{
    idx *= _269.geometry_information.attributes[3].stride;
    idx += _269.geometry_information.attributes[3].offset;
    return vec2(vtx_uv0.uv0[idx + 0u], vtx_uv0.uv0[idx + 1u]);
}

float det(mat2 matrix)
{
    return (matrix[0].x * matrix[1].y) - (matrix[0].y * matrix[1].x);
}

mat3 transpose_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat3 result = mat3(vec3(vec3(row0.x, row1.x, row2.x)), vec3(vec3(row0.y, row1.y, row2.y)), vec3(vec3(row0.z, row1.z, row2.z)));
    return result;
}

mat3 inverse_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat2 param = mat2(vec2(row1.y, row1.z), vec2(row2.y, row2.z));
    mat2 param_1 = mat2(vec2(row1.z, row1.x), vec2(row2.z, row2.x));
    mat2 param_2 = mat2(vec2(row1.x, row1.y), vec2(row2.x, row2.y));
    vec3 minors0 = vec3(det(param), det(param_1), det(param_2));
    mat2 param_3 = mat2(vec2(row2.y, row2.z), vec2(row0.y, row0.z));
    mat2 param_4 = mat2(vec2(row2.z, row2.x), vec2(row0.z, row0.x));
    mat2 param_5 = mat2(vec2(row2.x, row2.y), vec2(row0.x, row0.y));
    vec3 minors1 = vec3(det(param_3), det(param_4), det(param_5));
    mat2 param_6 = mat2(vec2(row0.y, row0.z), vec2(row1.y, row1.z));
    mat2 param_7 = mat2(vec2(row0.z, row0.x), vec2(row1.z, row1.x));
    mat2 param_8 = mat2(vec2(row0.x, row0.y), vec2(row1.x, row1.y));
    vec3 minors2 = vec3(det(param_6), det(param_7), det(param_8));
    mat3 param_9 = mat3(vec3(minors0), vec3(minors1), vec3(minors2));
    mat3 adj = transpose_mat3(param_9);
    return adj * (1.0 / dot(row0, minors0));
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

uint vtx_custom0_load(inout uint idx)
{
    idx *= _269.geometry_information.attributes[6].stride;
    idx += _269.geometry_information.attributes[6].offset;
    return vtx_custom0.custom0[idx + 0u];
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_distance_plane(ModifierFactorDistancePlane_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _427 = vector_transform_by_mat43(param, param_1);
        coords = _427;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _434 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _434;
    float influence = rel_coords.z;
    if (modifier_params.domain_mirror != 0)
    {
        influence = abs(influence);
    }
    if (modifier_params.domain_repeat != 0)
    {
        influence = fract(influence);
    }
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_4 = modifier_params.falloff_curve_idx;
    float param_5 = influence;
    influence = curve_sample(param_4, param_5);
    float v = influence;
    ModifierFactor param_6 = modifier_factor;
    uint param_7 = uint(modifier_params.modifier_function);
    float param_8 = v;
    modifier_process_modifier_factor(param_6, param_7, param_8);
    modifier_factor = param_6;
}

void modifier_factor_wave_transfer(ModifierFactorWaveTransfer_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v * modifier_params.frequency) + modifier_params.phase_shift;
    if (modifier_params.type == 0)
    {
        v = sin((v * 3.1415927410125732421875) * 2.0);
    }
    else
    {
        if (modifier_params.type == 1)
        {
            float phase = mod(v, 1.0) - 0.5;
            v = (abs(2.0 * (phase - floor(phase + 0.5))) * 2.0) - 1.0;
        }
        else
        {
            if (modifier_params.type == 2)
            {
                float phase_1 = mod(v, 1.0) - 0.5;
                v = sign(phase_1);
            }
        }
    }
    if (modifier_params.modulate != 0)
    {
        v = modifier_factor.factor * ((v * modifier_params.amplitude) + modifier_params.base);
    }
    else
    {
        v = (v * modifier_params.amplitude) + modifier_params.base;
    }
    modifier_factor.factor = v;
}

void _vertex_modifier_displace_apply(VertexModifierDisplaceParams params, ModifierFactor modifier_factor, inout VertexInput vtx, CoordinateSystemTrasforms cs_transforms)
{
    vec3 modifier_position = vec3(0.0);
    float influence = modifier_factor.factor;
    if (influence != 0.0)
    {
        vec3 n = vtx.norm;
        vec3 p = vtx.pos;
        p += ((params.displace_base * params.displace_base_modifier_factor) * influence);
        p += (((n * params.displace_normal) * params.displace_normal_modifier_factor) * influence);
        vtx.pos = p;
    }
}

void vertex_modifier_displace_apply(VertexModifierDisplaceParams params, inout ModifierFactor modifier_factor, inout VertexInput vtx, CoordinateSystemTrasforms cs_transforms)
{
    VertexModifierDisplaceParams param = params;
    ModifierFactor param_1 = modifier_factor;
    VertexInput param_2 = vtx;
    CoordinateSystemTrasforms param_3 = cs_transforms;
    _vertex_modifier_displace_apply(param, param_1, param_2, param_3);
    modifier_factor = param_1;
    vtx = param_2;
}

void modifier_factor_mul_add(ModifierFactorMulAdd_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v * modifier_params.multiply_value) + modifier_params.add_value;
    modifier_factor.factor = v;
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

void vertex_modifier_colorize_apply(VertexModifierColorizeParams modifier_params, ModifierFactor modifier_factor, inout VertexInput vtx)
{
    vec3 c = vec3(1.0);
    float a = modifier_params.alpha;
    if (modifier_params.use_gradient != 0)
    {
        int param = modifier_params.color_gradient_idx;
        float param_1 = modifier_factor.factor;
        c = gradient_sample(param, param_1).xyz;
        c *= modifier_params.color;
    }
    else
    {
        c = modifier_params.color;
    }
    if (modifier_params.mixing_mode == 0)
    {
        if (modifier_params.use_gradient == 0)
        {
            c *= modifier_factor.factor;
        }
        a *= modifier_factor.factor;
    }
    if (modifier_params.mixing_mode == 1)
    {
        c = mix(vtx.color.xyz, c, vec3(modifier_factor.factor));
        a = mix(vtx.color.w, a, modifier_factor.factor);
    }
    if (modifier_params.mixing_mode == 2)
    {
        c = vtx.color.xyz + (c * modifier_factor.factor);
        a = vtx.color.w + (a * modifier_factor.factor);
    }
    vec4 _714 = vtx.color;
    vec3 _720 = mix(_714.xyz, c, vec3(modifier_params.color_blend));
    vtx.color.x = _720.x;
    vtx.color.y = _720.y;
    vtx.color.z = _720.z;
    vtx.color.w = mix(vtx.color.w, a, modifier_params.alpha_blend);
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    return m * vec4(v, 1.0);
}

void main()
{
    uint load_vertex_idx = uint(gl_VertexIndex);
    if (_961.instance_params.stride > 0)
    {
        uint flipbook_card = _972.instance_flipbook_card[gl_InstanceIndex];
        flipbook_card = min(flipbook_card, (_269.geometry_information.flipbook_cards_num - 1u));
        load_vertex_idx += (_269.geometry_information.vtx_num * flipbook_card);
    }
    VertexInput vtx_input;
    vtx_input.id = uint(gl_VertexIndex);
    uint param = load_vertex_idx;
    vec3 _994 = vtx_coords_load(param);
    vtx_input.pos = _994;
    vtx_input.norm = vec3(1.0, 0.0, 0.0);
    vtx_input.color = vec4(1.0);
    vtx_input.uv0 = vtx_input.pos.xy;
    if ((_269.geometry_information.builtin_attribute_mask & 4u) != 0u)
    {
        uint param_1 = uint(gl_VertexIndex);
        vec3 _1012 = vtx_albedo_load(param_1);
        vtx_input.color.x = _1012.x;
        vtx_input.color.y = _1012.y;
        vtx_input.color.z = _1012.z;
    }
    if ((_269.geometry_information.builtin_attribute_mask & 2u) != 0u)
    {
        uint param_2 = load_vertex_idx;
        vec3 _1027 = vtx_normals_load(param_2);
        vtx_input.norm = _1027;
    }
    if ((_269.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_3 = uint(gl_VertexIndex);
        vec2 _1038 = vtx_uv0_load(param_3);
        vtx_input.uv0 = _1038;
    }
    mat4 mat_instance_model;
    mat_instance_model[0] = vec4(1.0, 0.0, 0.0, 0.0);
    mat_instance_model[1] = vec4(0.0, 1.0, 0.0, 0.0);
    mat_instance_model[2] = vec4(0.0, 0.0, 1.0, 0.0);
    mat_instance_model[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 mat_instance_model_inv = mat_instance_model;
    if (_961.instance_params.stride > 0)
    {
        vec4 inst_m0 = _1060.instance_transform[(gl_InstanceIndex * _961.instance_params.stride) + 0];
        vec4 inst_m1 = _1060.instance_transform[(gl_InstanceIndex * _961.instance_params.stride) + 1];
        vec4 inst_m2 = _1060.instance_transform[(gl_InstanceIndex * _961.instance_params.stride) + 2];
        vec3 _1091 = vec3(inst_m0.x, inst_m1.x, inst_m2.x);
        mat_instance_model[0].x = _1091.x;
        mat_instance_model[0].y = _1091.y;
        mat_instance_model[0].z = _1091.z;
        vec3 _1104 = vec3(inst_m0.y, inst_m1.y, inst_m2.y);
        mat_instance_model[1].x = _1104.x;
        mat_instance_model[1].y = _1104.y;
        mat_instance_model[1].z = _1104.z;
        vec3 _1117 = vec3(inst_m0.z, inst_m1.z, inst_m2.z);
        mat_instance_model[2].x = _1117.x;
        mat_instance_model[2].y = _1117.y;
        mat_instance_model[2].z = _1117.z;
        vec3 _1130 = vec3(inst_m0.w, inst_m1.w, inst_m2.w);
        mat_instance_model[3].x = _1130.x;
        mat_instance_model[3].y = _1130.y;
        mat_instance_model[3].z = _1130.z;
        mat_instance_model_inv = mat_instance_model;
        mat3 param_4 = mat3(mat_instance_model_inv[0].xyz, mat_instance_model_inv[1].xyz, mat_instance_model_inv[2].xyz);
        mat3 inv = inverse_mat3(param_4);
        mat_instance_model_inv[0].x = inv[0].x;
        mat_instance_model_inv[0].y = inv[0].y;
        mat_instance_model_inv[0].z = inv[0].z;
        mat_instance_model_inv[1].x = inv[1].x;
        mat_instance_model_inv[1].y = inv[1].y;
        mat_instance_model_inv[1].z = inv[1].z;
        mat_instance_model_inv[2].x = inv[2].x;
        mat_instance_model_inv[2].y = inv[2].y;
        mat_instance_model_inv[2].z = inv[2].z;
        mat_instance_model_inv[3].x = -(((inv[0].x * mat_instance_model[3].x) + (inv[1].x * mat_instance_model[3].y)) + (inv[2].x * mat_instance_model[3].z));
        mat_instance_model_inv[3].y = -(((inv[0].y * mat_instance_model[3].x) + (inv[1].y * mat_instance_model[3].y)) + (inv[2].y * mat_instance_model[3].z));
        mat_instance_model_inv[3].z = -(((inv[0].z * mat_instance_model[3].x) + (inv[1].z * mat_instance_model[3].y)) + (inv[2].z * mat_instance_model[3].z));
    }
    VertexInput vtx_modifier_input_base = vtx_input;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = uint(gl_VertexIndex);
    modifier_factor.id = uint(gl_VertexIndex);
    modifier_factor.instance_id = uint(gl_InstanceIndex);
    if (_961.instance_params.stride > 0)
    {
        modifier_factor.instance_id = _1252.instance_hash[gl_InstanceIndex];
    }
    modifier_factor.position = vtx_input.pos;
    modifier_factor.normal = vtx_input.norm;
    modifier_factor.color = vtx_input.color;
    if ((_269.geometry_information.builtin_attribute_mask & 64u) != 0u)
    {
        uint param_5 = uint(gl_VertexIndex);
        uint _1275 = vtx_custom0_load(param_5);
        modifier_factor.custom0 = _1275;
    }
    if ((_269.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_6 = uint(gl_VertexIndex);
        vec2 _1286 = vtx_uv0_load(param_6);
        modifier_factor.uv0 = _1286;
    }
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _1293.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_instance_model;
    cs_transforms.mat_local_to_model_inv = _1293.transform_params.mModelInv;
    ModifierFactorDistancePlane_Params _1311;
    _1311.transform_local_to_gizmo = _1306.VM0_params.transform_local_to_gizmo;
    _1311.falloff_curve_idx = _1306.VM0_params.falloff_curve_idx;
    _1311.falloff_inverse = _1306.VM0_params.falloff_inverse;
    _1311.domain_mirror = _1306.VM0_params.domain_mirror;
    _1311.domain_repeat = _1306.VM0_params.domain_repeat;
    _1311.influence_scope = _1306.VM0_params.influence_scope;
    _1311.modifier_function = _1306.VM0_params.modifier_function;
    ModifierFactorDistancePlane_Params param_7 = _1311;
    ModifierFactor param_8 = modifier_factor;
    CoordinateSystemTrasforms param_9 = cs_transforms;
    modifier_factor_distance_plane(param_7, param_8, param_9);
    modifier_factor = param_8;
    ModifierFactorWaveTransfer_Params _1326;
    _1326.type = _1321.VM1_params.type;
    _1326.modulate = _1321.VM1_params.modulate;
    _1326.frequency = _1321.VM1_params.frequency;
    _1326.phase_shift = _1321.VM1_params.phase_shift;
    _1326.amplitude = _1321.VM1_params.amplitude;
    _1326.base = _1321.VM1_params.base;
    ModifierFactorWaveTransfer_Params param_10 = _1326;
    ModifierFactor param_11 = modifier_factor;
    modifier_factor_wave_transfer(param_10, param_11);
    modifier_factor = param_11;
    VertexModifierDisplaceParams _1339;
    _1339.displace_normal = _1334.VM2_params.displace_normal;
    _1339.displace_normal_modifier_factor = _1334.VM2_params.displace_normal_modifier_factor;
    _1339.displace_base = _1334.VM2_params.displace_base;
    _1339.displace_base_modifier_factor = _1334.VM2_params.displace_base_modifier_factor;
    _1339.influence_scope = _1334.VM2_params.influence_scope;
    VertexModifierDisplaceParams param_12 = _1339;
    ModifierFactor param_13 = modifier_factor;
    VertexInput param_14 = vtx_input;
    CoordinateSystemTrasforms param_15 = cs_transforms;
    vertex_modifier_displace_apply(param_12, param_13, param_14, param_15);
    modifier_factor = param_13;
    vtx_input = param_14;
    modifier_factor.position = vtx_input.pos;
    ModifierFactorDistancePlane_Params _1358;
    _1358.transform_local_to_gizmo = _1354.VM3_params.transform_local_to_gizmo;
    _1358.falloff_curve_idx = _1354.VM3_params.falloff_curve_idx;
    _1358.falloff_inverse = _1354.VM3_params.falloff_inverse;
    _1358.domain_mirror = _1354.VM3_params.domain_mirror;
    _1358.domain_repeat = _1354.VM3_params.domain_repeat;
    _1358.influence_scope = _1354.VM3_params.influence_scope;
    _1358.modifier_function = _1354.VM3_params.modifier_function;
    ModifierFactorDistancePlane_Params param_16 = _1358;
    ModifierFactor param_17 = modifier_factor;
    CoordinateSystemTrasforms param_18 = cs_transforms;
    modifier_factor_distance_plane(param_16, param_17, param_18);
    modifier_factor = param_17;
    ModifierFactorWaveTransfer_Params _1371;
    _1371.type = _1367.VM4_params.type;
    _1371.modulate = _1367.VM4_params.modulate;
    _1371.frequency = _1367.VM4_params.frequency;
    _1371.phase_shift = _1367.VM4_params.phase_shift;
    _1371.amplitude = _1367.VM4_params.amplitude;
    _1371.base = _1367.VM4_params.base;
    ModifierFactorWaveTransfer_Params param_19 = _1371;
    ModifierFactor param_20 = modifier_factor;
    modifier_factor_wave_transfer(param_19, param_20);
    modifier_factor = param_20;
    ModifierFactorMulAdd_Params _1384;
    _1384.multiply_value = _1379.VM5_params.multiply_value;
    _1384.add_value = _1379.VM5_params.add_value;
    ModifierFactorMulAdd_Params param_21 = _1384;
    ModifierFactor param_22 = modifier_factor;
    modifier_factor_mul_add(param_21, param_22);
    modifier_factor = param_22;
    VertexModifierDisplaceParams _1395;
    _1395.displace_normal = _1391.VM6_params.displace_normal;
    _1395.displace_normal_modifier_factor = _1391.VM6_params.displace_normal_modifier_factor;
    _1395.displace_base = _1391.VM6_params.displace_base;
    _1395.displace_base_modifier_factor = _1391.VM6_params.displace_base_modifier_factor;
    _1395.influence_scope = _1391.VM6_params.influence_scope;
    VertexModifierDisplaceParams param_23 = _1395;
    ModifierFactor param_24 = modifier_factor;
    VertexInput param_25 = vtx_input;
    CoordinateSystemTrasforms param_26 = cs_transforms;
    vertex_modifier_displace_apply(param_23, param_24, param_25, param_26);
    modifier_factor = param_24;
    vtx_input = param_25;
    VertexModifierColorizeParams _1413;
    _1413.color = _1408.VM7_params.color;
    _1413.alpha = _1408.VM7_params.alpha;
    _1413.use_gradient = _1408.VM7_params.use_gradient;
    _1413.color_blend = _1408.VM7_params.color_blend;
    _1413.alpha_blend = _1408.VM7_params.alpha_blend;
    _1413.color_gradient_idx = _1408.VM7_params.color_gradient_idx;
    _1413.mixing_mode = _1408.VM7_params.mixing_mode;
    VertexModifierColorizeParams param_27 = _1413;
    ModifierFactor param_28 = modifier_factor;
    VertexInput param_29 = vtx_input;
    vertex_modifier_colorize_apply(param_27, param_28, param_29);
    modifier_factor = param_28;
    vtx_input = param_29;
    vtx_output.vLocalPos = vtx_input.pos;
    instanceID = uint(gl_InstanceIndex);
    if (_961.instance_params.stride > 0)
    {
        vec4 inst_m0_1 = _1060.instance_transform[(gl_InstanceIndex * _961.instance_params.stride) + 0];
        vec4 inst_m1_1 = _1060.instance_transform[(gl_InstanceIndex * _961.instance_params.stride) + 1];
        vec4 inst_m2_1 = _1060.instance_transform[(gl_InstanceIndex * _961.instance_params.stride) + 2];
        vec4 v = vec4(vtx_input.pos, 1.0);
        vtx_input.pos.x = dot(inst_m0_1, v);
        vtx_input.pos.y = dot(inst_m1_1, v);
        vtx_input.pos.z = dot(inst_m2_1, v);
        vec3 param_30 = vtx_input.norm;
        mat4 param_31 = transpose(mat4(vec4(inst_m0_1), vec4(inst_m1_1), vec4(inst_m2_1), vec4(0.0, 0.0, 0.0, 1.0)));
        vtx_input.norm = normalize(vector_transform_by_mat33(param_30, param_31));
        vec2 _1522 = unpackHalf2x16(_1516.instance_color[(gl_InstanceIndex * 2) + 0]);
        vec4 inst_c;
        inst_c.x = _1522.x;
        inst_c.y = _1522.y;
        vec2 _1532 = unpackHalf2x16(_1516.instance_color[(gl_InstanceIndex * 2) + 1]);
        inst_c.z = _1532.x;
        inst_c.w = _1532.y;
        vec4 _1538 = vtx_input.color;
        vec3 _1542 = _1538.xyz * inst_c.xyz;
        vtx_input.color.x = _1542.x;
        vtx_input.color.y = _1542.y;
        vtx_input.color.z = _1542.z;
        vtx_input.color.w *= inst_c.w;
    }
    vec3 param_32 = vtx_input.pos;
    mat4 param_33 = _1293.transform_params.mModel;
    vec3 _1562 = vector_transform_by_mat43(param_32, param_33);
    vec3 vPosModel = _1562;
    vec3 param_34 = vtx_input.norm;
    mat4 param_35 = _1293.transform_params.mModelNormal;
    vtx_output.vWorldNorm = vector_transform_by_mat33(param_34, param_35);
    vec3 param_36 = vPosModel;
    mat4 param_37 = _1293.transform_params.mView;
    vec3 _1577 = vector_transform_by_mat43(param_36, param_37);
    vec3 vPosModelView = _1577;
    vtx_output.vCoords = vPosModelView;
    vtx_output.vCameraRelativeWorldPos = vPosModel - _1293.transform_params.vCameraPosition;
    vtx_output.vNorm.x = dot(_1293.transform_params.mModelViewInvTrans[0].xyz, vtx_input.norm);
    vtx_output.vNorm.y = dot(_1293.transform_params.mModelViewInvTrans[1].xyz, vtx_input.norm);
    vtx_output.vNorm.z = dot(_1293.transform_params.mModelViewInvTrans[2].xyz, vtx_input.norm);
    vtx_output.vNorm = vtx_input.norm;
    vtx_output.vColor = vtx_input.color;
    vtx_output.vUV0 = vtx_input.uv0;
    vec3 param_38 = vtx_output.vCoords;
    mat4 param_39 = _1293.transform_params.mProjection;
    vec4 _1630 = vector_transform_by_mat_projection(param_38, param_39);
    gl_Position = _1630;
}

 