#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct ParticleEmitterPrimitive_Params
{
    mat4 transform;
    vec4 particle_color;
    vec3 primitive_size;
    int perimeter_only;
    int primitive_type;
    float particle_lifetime;
    float particle_lifetime_randomness;
    float rate;
    float seed;
    int pending;
};

struct ParticleLifecycleParams
{
    float time_step;
    float max_lifetime;
    uint reset;
    uint _pad1;
};

struct Particle
{
    vec3 pos;
    ParticleState state;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorDistanceRadial_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_repeat_x;
    int domain_repeat_y;
    int domain_repeat_z;
    int influence_scope;
    int modifier_function;
};

struct ModifierFactorMulAdd_Params
{
    float multiply_value;
    float add_value;
};

struct RTFace
{
    uint v0;
    uint v1;
    uint v2;
    uint material_flags;
};

struct ParticleModifierGeometryAttractorParams
{
    float strength;
    float strength_modifier_factor;
    float min_distance;
    float min_distance_modifier_factor;
    float search_distance;
    int transformed_data_location_idx;
    int transformed_data_location_num;
    int iteration;
    float probability_of_reattach;
    int _pad1;
    int _pad2;
    uint nearest_face_buffer_size;
};

struct ParticleModifierCurl_Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 noise_strength;
    float noise_speed;
    vec3 noise_scale;
};

struct ParticleModifierSwirl_Params
{
    vec3 position;
    int falloff_curve_idx;
    vec3 radius;
    int falloff_inverse;
    float velocity;
    float velocity_randomness;
    float time_step;
    float axis_randomness;
    vec3 axis;
    float _pad0;
    vec3 scale;
    float _pad1;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct ModifierFactorSet_Params
{
    float value;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _486;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    float prt_positions[];
} _510;

layout(set = 0, binding = 3, std430) buffer ParticlePrevPositionsData
{
    float prt_prev_positions[];
} _533;

layout(set = 0, binding = 4, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _1211;

layout(set = 0, binding = 5, std430) buffer TransformedDataIndexBuffer
{
    uint transformed_data_indices[];
} _1232;

layout(set = 0, binding = 6, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _1291;

layout(set = 0, binding = 10, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _1926;

layout(set = 0, binding = 11, std140) uniform ParticleLifecycleParamsBuffer
{
    ParticleLifecycleParams lifecycle_params;
} _2116;

layout(set = 0, binding = 7, std430) buffer VM0
{
    layout(row_major) ParticleEmitterPrimitive_Params VM0_params;
} _2160;

layout(set = 0, binding = 12, std140) uniform VM1
{
    layout(row_major) ModifierFactorNoise_Params VM1_params;
} _2188;

layout(set = 0, binding = 13, std140) uniform VM2
{
    ModifierFactorSet_Params VM2_params;
} _2203;

layout(set = 0, binding = 14, std140) uniform VM3
{
    layout(row_major) ModifierFactorDistanceRadial_Params VM3_params;
} _2210;

layout(set = 0, binding = 15, std140) uniform VM4
{
    ModifierFactorMulAdd_Params VM4_params;
} _2225;

layout(set = 0, binding = 8, std430) buffer VM5
{
    ParticleModifierGeometryAttractorParams VM5_params;
    uint VM5_closest_face_idx[];
} _2246;

layout(set = 0, binding = 16, std140) uniform VM6
{
    ParticleModifierCurl_Params VM6_params;
} _2289;

layout(set = 0, binding = 9, std430) buffer VM7
{
    ParticleModifierSwirl_Params VM7_params;
} _2317;

layout(set = 0, binding = 17, std140) uniform VM8
{
    ParticleModifierCurl_Params VM8_params;
} _2343;

layout(set = 0, binding = 18) uniform sampler2D s_Curves;

vec3 prt_get_prev_position(uint id)
{
    return vec3(_533.prt_prev_positions[(id * 3u) + 0u], _533.prt_prev_positions[(id * 3u) + 1u], _533.prt_prev_positions[(id * 3u) + 2u]);
}

ParticleState prt_get_state(uint id)
{
    ParticleState _492;
    _492.life_time = _486.prt_states[id].life_time;
    _492.life_span = _486.prt_states[id].life_span;
    _492.generation_id = _486.prt_states[id].generation_id;
    _492.color = _486.prt_states[id].color;
    ParticleState _491 = _492;
    return _491;
}

void prt_kill(inout ParticleState state)
{
    state.life_time = state.life_span;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

bool prt_is_alive(ParticleState state)
{
    return state.life_time < state.life_span;
}

float particle_emitter_primitive_rand(float n)
{
    return fract(sin(n) * 43758.546875);
}

void prt_spawn(inout ParticleState state, float life_span)
{
    state.life_time = 0.0;
    state.life_span = life_span;
    state.generation_id += 1.0;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

uint color_convert_rgb_float3_uint(inout vec3 v)
{
    float v_mag = ceil(length(v));
    v /= vec3(v_mag);
    v_mag = min(255.0, v_mag);
    uint vi = (uint(v.x * 255.0) | (uint(v.y * 255.0) << uint(8))) | (uint(v.z * 255.0) << uint(16));
    vi |= (uint(v_mag) * 16777216u);
    return vi;
}

void prt_set_color(inout ParticleState state, vec3 c)
{
    vec3 param = c;
    uint _555 = color_convert_rgb_float3_uint(param);
    uint v = _555;
    state.color = v;
}

void particle_emitter_primitive_emit(ParticleEmitterPrimitive_Params emitter_params, ParticleLifecycleParams lifecycle_params, inout Particle p, uint id)
{
    float fid = float(id);
    float param = fid * 5.131999969482421875;
    float lifetime = emitter_params.particle_lifetime * (1.0 + (emitter_params.particle_lifetime_randomness * particle_emitter_primitive_rand(param)));
    ParticleState param_1 = p.state;
    float param_2 = lifetime;
    prt_spawn(param_1, param_2);
    p.state = param_1;
    float param_3 = fid * 0.0130000002682209014892578125;
    float param_4 = (fid * 0.112999998033046722412109375) + 132.1410064697265625;
    float param_5 = (fid * 0.3129999935626983642578125) - 43.120998382568359375;
    vec3 pos = (vec3(particle_emitter_primitive_rand(param_3), particle_emitter_primitive_rand(param_4), particle_emitter_primitive_rand(param_5)) * 2.0) - vec3(1.0);
    if (emitter_params.primitive_type == 0)
    {
        float l = length(pos);
        if (l > 1.0)
        {
            pos /= vec3(l);
        }
        pos *= emitter_params.primitive_size;
    }
    else
    {
        if (emitter_params.primitive_type == 1)
        {
            pos *= emitter_params.primitive_size;
        }
    }
    vec3 param_6 = pos;
    mat4 param_7 = emitter_params.transform;
    vec3 _1007 = vector_transform_by_mat43(param_6, param_7);
    pos = _1007;
    p.pos = pos;
    ParticleState param_8 = p.state;
    vec3 param_9 = emitter_params.particle_color.xyz;
    prt_set_color(param_8, param_9);
    p.state = param_8;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise_default(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1034 = vector_transform_by_mat43(param, param_1);
        coords = _1034;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1041 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1041;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_factor_distance_radial(ModifierFactorDistanceRadial_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_factor.has_world_position == false)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_model;
        vec3 _1101 = vector_transform_by_mat43(param, param_1);
        coords = _1101;
        if (modifier_params.influence_scope == 1)
        {
            vec3 param_2 = coords;
            mat4 param_3 = cs_transforms.mat_local_to_instance;
            vec3 _1112 = vector_transform_by_mat43(param_2, param_3);
            coords = _1112;
        }
    }
    else
    {
        coords = modifier_factor.world_position;
    }
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 _1122 = vector_transform_by_mat43(param_4, param_5);
    vec3 rel_coords = _1122;
    if (modifier_params.domain_repeat_x != 0)
    {
        rel_coords.x = (fract(rel_coords.x * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_y != 0)
    {
        rel_coords.y = (fract(rel_coords.y * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_z != 0)
    {
        rel_coords.z = (fract(rel_coords.z * 2.0) - 0.5) * 2.0;
    }
    float influence = length(rel_coords);
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_6 = modifier_params.falloff_curve_idx;
    float param_7 = influence;
    influence = curve_sample(param_6, param_7);
    float v = influence;
    ModifierFactor param_8 = modifier_factor;
    uint param_9 = uint(modifier_params.modifier_function);
    float param_10 = v;
    modifier_process_modifier_factor(param_8, param_9, param_10);
    modifier_factor = param_8;
}

void modifier_factor_mul_add(ModifierFactorMulAdd_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v * modifier_params.multiply_value) + modifier_params.add_value;
    modifier_factor.factor = v;
}

uint particle_modifier_geometry_attractor_get_first_face_idx(ParticleModifierGeometryAttractorParams emitter_params)
{
    uint tdl_idx = uint(emitter_params.transformed_data_location_idx);
    if (tdl_idx > 0u)
    {
        return _1291.transformed_data_location[tdl_idx - 1u].last_face_idx + 1u;
    }
    return 0u;
}

uint particle_modifier_geometry_attractor_get_last_face_idx(ParticleModifierGeometryAttractorParams emitter_params)
{
    uint tdl_idx = uint((emitter_params.transformed_data_location_idx + emitter_params.transformed_data_location_num) - 1);
    return _1291.transformed_data_location[tdl_idx].last_face_idx;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _466 = hash(param);
    uint param_1 = _466;
    float _468 = floatConstruct(param_1);
    return _468;
}

RTFace rt_get_face(uint face_idx)
{
    uint v0 = _1232.transformed_data_indices[(face_idx * 3u) + 0u];
    uint v1 = _1232.transformed_data_indices[(face_idx * 3u) + 1u];
    uint v2 = _1232.transformed_data_indices[(face_idx * 3u) + 2u];
    uint flags0 = v0 >> uint(24);
    uint flags1 = v1 >> uint(24);
    RTFace f;
    f.v0 = v0 & 16777215u;
    f.v1 = v1 & 16777215u;
    f.v2 = v2;
    f.material_flags = flags0 | (flags1 << uint(8));
    return f;
}

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_1211.in_vtx_data[coord_offset + 0u], _1211.in_vtx_data[coord_offset + 1u], _1211.in_vtx_data[coord_offset + 2u]);
    return p;
}

void particle_modifier_geometry_attractor(ParticleModifierGeometryAttractorParams modifier_params, ParticleLifecycleParams lifecycle_params, ModifierFactor modifier_factor, inout Particle p, uint id, inout uint closest_face_idx)
{
    ParticleModifierGeometryAttractorParams param = modifier_params;
    uint first_face_idx = particle_modifier_geometry_attractor_get_first_face_idx(param);
    ParticleModifierGeometryAttractorParams param_1 = modifier_params;
    uint last_face_idx = particle_modifier_geometry_attractor_get_last_face_idx(param_1);
    if (first_face_idx >= last_face_idx)
    {
        return;
    }
    float fid = float((id * 45827u) & 16777215u);
    float param_2 = fid * 0.34130001068115234375;
    vec2 bc;
    bc.x = random(param_2);
    float param_3 = fid * 0.1412999927997589111328125;
    bc.y = random(param_3);
    if ((bc.x + bc.y) >= 1.0)
    {
        bc.x = 1.0 - bc.x;
        bc.y = 1.0 - bc.y;
    }
    float closest_face_distance = 100000000.0;
    vec3 o = p.pos;
    float param_4 = fid + float(modifier_params.iteration & 4095);
    bool do_reattach = random(param_4) < modifier_params.probability_of_reattach;
    if (do_reattach)
    {
        ParticleState param_5 = p.state;
        vec3 param_6 = vec3(0.0, 1.0, 0.0);
        prt_set_color(param_5, param_6);
        p.state = param_5;
    }
    vec3 dir;
    int iteration = 0;
    for (;;)
    {
        if (iteration < 2)
        {
            float min_distance = mix(modifier_params.min_distance, modifier_params.min_distance * modifier_factor.factor, modifier_params.min_distance_modifier_factor);
            if (((closest_face_idx != 0u) && (iteration == 0)) && (do_reattach == false))
            {
                uint param_7 = (first_face_idx + closest_face_idx) - 1u;
                RTFace rt_face = rt_get_face(param_7);
                uint p0_idx = rt_face.v0;
                uint p1_idx = rt_face.v1;
                uint p2_idx = rt_face.v2;
                uint param_8 = p0_idx;
                vec3 p0 = rt_get_vertex(param_8);
                uint param_9 = p1_idx;
                vec3 p1 = rt_get_vertex(param_9);
                uint param_10 = p2_idx;
                vec3 p2 = rt_get_vertex(param_10);
                vec3 closest_pos = ((p0 * bc.x) + (p1 * bc.y)) + (p2 * ((1.0 - bc.x) - bc.y));
                closest_face_distance = length(closest_pos - o);
                dir = (closest_pos - o) / vec3(closest_face_distance + 9.9999997473787516355514526367188e-05);
            }
            bool _1480 = closest_face_idx != 0u;
            bool _1487;
            if (_1480)
            {
                _1487 = closest_face_distance > modifier_params.search_distance;
            }
            else
            {
                _1487 = _1480;
            }
            if (_1487)
            {
                float param_11 = fid + float(modifier_params.iteration & 4095);
                do_reattach = (random(param_11) * 0.25) < modifier_params.probability_of_reattach;
            }
            if ((closest_face_idx != 0u) && (closest_face_distance < min_distance))
            {
                float param_12 = fid + float(modifier_params.iteration & 4095);
                do_reattach = (random(param_12) * 0.25) < modifier_params.probability_of_reattach;
            }
            if (((closest_face_idx == 0u) || (iteration > 0)) || do_reattach)
            {
                uint face_idx_range = last_face_idx - first_face_idx;
                float param_13 = fid;
                uint face_idx = uint(float(face_idx_range - 1u) * random(param_13));
                if (do_reattach || (closest_face_idx == 0u))
                {
                    face_idx += uint(modifier_params.iteration);
                    face_idx %= face_idx_range;
                }
                uint param_14 = first_face_idx + face_idx;
                RTFace rt_face_1 = rt_get_face(param_14);
                uint p0_idx_1 = rt_face_1.v0;
                uint p1_idx_1 = rt_face_1.v1;
                uint p2_idx_1 = rt_face_1.v2;
                uint param_15 = p0_idx_1;
                vec3 p0_1 = rt_get_vertex(param_15);
                uint param_16 = p1_idx_1;
                vec3 p1_1 = rt_get_vertex(param_16);
                uint param_17 = p2_idx_1;
                vec3 p2_1 = rt_get_vertex(param_17);
                if (length(cross(p0_1 - p1_1, p0_1 - p2_1)) < 1.10000002384185791015625)
                {
                    int _1665 = iteration;
                    iteration = _1665 + 1;
                    continue;
                }
                vec3 closest_pos_1 = ((p0_1 * bc.x) + (p1_1 * bc.y)) + (p2_1 * ((1.0 - bc.x) - bc.y));
                dir = normalize(closest_pos_1 - o);
                float d = length(closest_pos_1 - p.pos);
                if (d < modifier_params.search_distance)
                {
                    bool _1640 = (d < closest_face_distance) && (d > min_distance);
                    bool _1651;
                    if (!_1640)
                    {
                        _1651 = (d > closest_face_distance) && (d < min_distance);
                    }
                    else
                    {
                        _1651 = _1640;
                    }
                    if (_1651)
                    {
                        closest_face_distance = d;
                        closest_face_idx = face_idx + 1u;
                        ParticleState param_18 = p.state;
                        vec3 param_19 = vec3(1.0, 0.0, 0.0);
                        prt_set_color(param_18, param_19);
                        p.state = param_18;
                    }
                }
            }
            int _1665 = iteration;
            iteration = _1665 + 1;
            continue;
        }
        else
        {
            break;
        }
    }
    if (closest_face_idx > 0u)
    {
        uint param_20 = (first_face_idx + closest_face_idx) - 1u;
        RTFace rt_face_2 = rt_get_face(param_20);
        uint p0_idx_2 = rt_face_2.v0;
        uint p1_idx_2 = rt_face_2.v1;
        uint p2_idx_2 = rt_face_2.v2;
        uint param_21 = p0_idx_2;
        vec3 p0_2 = rt_get_vertex(param_21);
        uint param_22 = p1_idx_2;
        vec3 p1_2 = rt_get_vertex(param_22);
        uint param_23 = p2_idx_2;
        vec3 p2_2 = rt_get_vertex(param_23);
        vec3 closest_pos_2 = ((p0_2 * bc.x) + (p1_2 * bc.y)) + (p2_2 * ((1.0 - bc.x) - bc.y));
        vec3 d_1 = closest_pos_2 - p.pos;
        float time_step = min(1.0, lifecycle_params.time_step);
        float strength = mix(modifier_params.strength * time_step, (modifier_params.strength * time_step) * modifier_factor.factor, modifier_params.strength_modifier_factor);
        float d_length = length(d_1);
        bool _1746 = d_length > 0.0;
        bool _1753;
        if (_1746)
        {
            _1753 = d_length < modifier_params.search_distance;
        }
        else
        {
            _1753 = _1746;
        }
        if (_1753)
        {
            d_1 = (d_1 / vec3(d_length)) * min(strength, d_length);
            p.pos += d_1;
        }
    }
}

vec3 pm_curl_snoiseVec3(vec3 x)
{
    vec3 param = vec3(x);
    float s = snoise(param);
    vec3 param_1 = vec3(x.y - 19.1000003814697265625, x.z + 33.40000152587890625, x.x + 47.200000762939453125);
    float s1 = snoise(param_1);
    vec3 param_2 = vec3(x.z + 74.1999969482421875, x.x - 124.5, x.y + 99.40000152587890625);
    float s2 = snoise(param_2);
    vec3 c = vec3(s, s1, s2);
    return c;
}

vec3 pm_curl_curlNoise(vec3 p, out vec3 gradient, out float out_scale)
{
    vec3 dx = vec3(0.100000001490116119384765625, 0.0, 0.0);
    vec3 dy = vec3(0.0, 0.100000001490116119384765625, 0.0);
    vec3 dz = vec3(0.0, 0.0, 0.100000001490116119384765625);
    vec3 param = p - dx;
    vec3 p_x0 = pm_curl_snoiseVec3(param);
    vec3 param_1 = p + dx;
    vec3 p_x1 = pm_curl_snoiseVec3(param_1);
    vec3 param_2 = p - dy;
    vec3 p_y0 = pm_curl_snoiseVec3(param_2);
    vec3 param_3 = p + dy;
    vec3 p_y1 = pm_curl_snoiseVec3(param_3);
    vec3 param_4 = p - dz;
    vec3 p_z0 = pm_curl_snoiseVec3(param_4);
    vec3 param_5 = p + dz;
    vec3 p_z1 = pm_curl_snoiseVec3(param_5);
    float x = ((p_y1.z - p_y0.z) - p_z1.y) + p_z0.y;
    float y = ((p_z1.x - p_z0.x) - p_x1.z) + p_x0.z;
    float z = ((p_x1.y - p_x0.y) - p_y1.x) + p_y0.x;
    gradient = vec3(p_x0.x, p_y0.y, p_z0.z) * 3.1400001049041748046875;
    out_scale = p_x0.x;
    return normalize(vec3(x, y, z));
}

void particle_modifier_curl(ParticleModifierCurl_Params modifier_params, ParticleLifecycleParams lifecycle_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    vec3 modifier_position = modifier_params.position;
    vec3 param = (p.pos * modifier_params.noise_scale) + (vec3(_1926.globals.time, _1926.globals.time * 0.3014999926090240478515625, (-_1926.globals.time) * 0.3129999935626983642578125) * modifier_params.noise_speed);
    vec3 param_1;
    float param_2;
    vec3 _1948 = pm_curl_curlNoise(param, param_1, param_2);
    vec3 gradient = param_1;
    float out_scale = param_2;
    p.pos += (((_1948 * modifier_params.noise_strength) * modifier_factor.factor) * lifecycle_params.time_step);
}

vec4 quaternion_from_axis_angle(vec3 axis, float angle_in_radians)
{
    vec4 v = vec4((-axis) * sin(angle_in_radians * 0.5), cos(angle_in_radians * 0.5));
    return v;
}

vec3 vector_rotate_by_quaternion(vec3 v, vec4 q)
{
    vec3 u = q.xyz;
    float s = q.w;
    return ((u * (2.0 * dot(u, v))) + (v * ((s * s) - dot(u, u)))) + (cross(u, v) * (2.0 * s));
}

void particle_modifier_swirl(ParticleModifierSwirl_Params modifier_params, ParticleLifecycleParams lifecycle_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    vec3 modifier_position = modifier_params.position;
    vec3 influence_pos = p.pos;
    float influence = length((influence_pos - modifier_position) / (modifier_params.radius * 0.5));
    if (influence > 1.0)
    {
        influence = 1.0;
    }
    if (modifier_params.falloff_inverse == 0)
    {
        influence = 1.0 - influence;
    }
    influence = 1.0 - influence;
    int param = modifier_params.falloff_curve_idx;
    float param_1 = influence;
    influence = clamp(curve_sample(param, param_1), 0.0, 1.0);
    vec3 axis = modifier_params.axis;
    float param_2 = float(id) * 0.012470000423491001129150390625;
    float randomness_1 = random(param_2);
    float param_3 = float(id) * 0.1031199991703033447265625;
    float randomness_2 = random(param_3);
    axis.x += (randomness_1 * modifier_params.axis_randomness);
    axis.y -= (randomness_1 * modifier_params.axis_randomness);
    axis.z += (randomness_2 * modifier_params.axis_randomness);
    axis = normalize(axis);
    float angle_rad = modifier_params.velocity * (1.0 + (randomness_1 * modifier_params.velocity_randomness));
    angle_rad *= (lifecycle_params.time_step * influence);
    vec3 param_4 = axis;
    float param_5 = angle_rad * modifier_factor.factor;
    vec4 q = quaternion_from_axis_angle(param_4, param_5);
    vec3 pos = p.pos - modifier_params.position;
    vec3 param_6 = pos;
    vec4 param_7 = q;
    pos = vector_rotate_by_quaternion(param_6, param_7);
    vec3 pos_scaled = pos * modifier_params.scale;
    pos = mix(pos, pos_scaled, vec3(lifecycle_params.time_step * influence));
    pos += modifier_params.position;
    p.pos = pos;
}

void prt_advance_life(inout ParticleState state, float time_step, float max_lifespan)
{
    state.life_time += time_step;
    state.life_span = min(state.life_span, max_lifespan);
}

void prt_set_state(uint id, ParticleState state)
{
    ParticleState _499;
    _499.life_time = state.life_time;
    _499.life_span = state.life_span;
    _499.generation_id = state.generation_id;
    _499.color = state.color;
    _486.prt_states[id] = _499;
}

void prt_set_position(uint id, vec3 p)
{
    _510.prt_positions[(id * 3u) + 0u] = p.x;
    _510.prt_positions[(id * 3u) + 1u] = p.y;
    _510.prt_positions[(id * 3u) + 2u] = p.z;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint param = id;
    Particle p;
    p.pos = prt_get_prev_position(param);
    uint param_1 = id;
    p.state = prt_get_state(param_1);
    if (_2116.lifecycle_params.reset != 0u)
    {
        ParticleState param_2 = p.state;
        prt_kill(param_2);
        p.state = param_2;
    }
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    modifier_factor.position = p.pos;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ParticleState param_3 = p.state;
    if (!prt_is_alive(param_3))
    {
        int _2164 = atomicAdd(_2160.VM0_params.pending, -1);
        int pending = _2164;
        if (pending > 0)
        {
            ParticleEmitterPrimitive_Params _2173;
            _2173.transform = _2160.VM0_params.transform;
            _2173.particle_color = _2160.VM0_params.particle_color;
            _2173.primitive_size = _2160.VM0_params.primitive_size;
            _2173.perimeter_only = _2160.VM0_params.perimeter_only;
            _2173.primitive_type = _2160.VM0_params.primitive_type;
            _2173.particle_lifetime = _2160.VM0_params.particle_lifetime;
            _2173.particle_lifetime_randomness = _2160.VM0_params.particle_lifetime_randomness;
            _2173.rate = _2160.VM0_params.rate;
            _2173.seed = _2160.VM0_params.seed;
            _2173.pending = _2160.VM0_params.pending;
            ParticleEmitterPrimitive_Params param_4 = _2173;
            ParticleLifecycleParams _2178;
            _2178.time_step = _2116.lifecycle_params.time_step;
            _2178.max_lifetime = _2116.lifecycle_params.max_lifetime;
            _2178.reset = _2116.lifecycle_params.reset;
            _2178._pad1 = _2116.lifecycle_params._pad1;
            ParticleLifecycleParams param_5 = _2178;
            Particle param_6 = p;
            uint param_7 = id;
            particle_emitter_primitive_emit(param_4, param_5, param_6, param_7);
            p = param_6;
        }
    }
    ModifierFactorNoise_Params _2193;
    _2193.transform_local_to_gizmo = _2188.VM1_params.transform_local_to_gizmo;
    _2193.noise_domain_scale = _2188.VM1_params.noise_domain_scale;
    _2193.modifier_function = _2188.VM1_params.modifier_function;
    _2193.noise_domain_offset = _2188.VM1_params.noise_domain_offset;
    _2193.noise_value_scale = _2188.VM1_params.noise_value_scale;
    _2193.noise_value_offset = _2188.VM1_params.noise_value_offset;
    _2193.influence_scope = _2188.VM1_params.influence_scope;
    _2193._pad0 = _2188.VM1_params._pad0;
    _2193._pad1 = _2188.VM1_params._pad1;
    ModifierFactorNoise_Params param_8 = _2193;
    ModifierFactor param_9 = modifier_factor;
    CoordinateSystemTrasforms param_10 = cs_transforms;
    modifier_factor_noise_default(param_8, param_9, param_10);
    modifier_factor = param_9;
    modifier_factor.factor = _2203.VM2_params.value;
    ModifierFactorDistanceRadial_Params _2215;
    _2215.transform_local_to_gizmo = _2210.VM3_params.transform_local_to_gizmo;
    _2215.falloff_curve_idx = _2210.VM3_params.falloff_curve_idx;
    _2215.falloff_inverse = _2210.VM3_params.falloff_inverse;
    _2215.domain_repeat_x = _2210.VM3_params.domain_repeat_x;
    _2215.domain_repeat_y = _2210.VM3_params.domain_repeat_y;
    _2215.domain_repeat_z = _2210.VM3_params.domain_repeat_z;
    _2215.influence_scope = _2210.VM3_params.influence_scope;
    _2215.modifier_function = _2210.VM3_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_11 = _2215;
    ModifierFactor param_12 = modifier_factor;
    CoordinateSystemTrasforms param_13 = cs_transforms;
    modifier_factor_distance_radial(param_11, param_12, param_13);
    modifier_factor = param_12;
    ModifierFactorMulAdd_Params _2230;
    _2230.multiply_value = _2225.VM4_params.multiply_value;
    _2230.add_value = _2225.VM4_params.add_value;
    ModifierFactorMulAdd_Params param_14 = _2230;
    ModifierFactor param_15 = modifier_factor;
    modifier_factor_mul_add(param_14, param_15);
    modifier_factor = param_15;
    ParticleState param_16 = p.state;
    if (prt_is_alive(param_16))
    {
        if (id < _2246.VM5_params.nearest_face_buffer_size)
        {
            uint closest_face_idx = _2246.VM5_closest_face_idx[id];
            ParticleModifierGeometryAttractorParams _2260;
            _2260.strength = _2246.VM5_params.strength;
            _2260.strength_modifier_factor = _2246.VM5_params.strength_modifier_factor;
            _2260.min_distance = _2246.VM5_params.min_distance;
            _2260.min_distance_modifier_factor = _2246.VM5_params.min_distance_modifier_factor;
            _2260.search_distance = _2246.VM5_params.search_distance;
            _2260.transformed_data_location_idx = _2246.VM5_params.transformed_data_location_idx;
            _2260.transformed_data_location_num = _2246.VM5_params.transformed_data_location_num;
            _2260.iteration = _2246.VM5_params.iteration;
            _2260.probability_of_reattach = _2246.VM5_params.probability_of_reattach;
            _2260._pad1 = _2246.VM5_params._pad1;
            _2260._pad2 = _2246.VM5_params._pad2;
            _2260.nearest_face_buffer_size = _2246.VM5_params.nearest_face_buffer_size;
            ParticleModifierGeometryAttractorParams param_17 = _2260;
            ParticleLifecycleParams _2264;
            _2264.time_step = _2116.lifecycle_params.time_step;
            _2264.max_lifetime = _2116.lifecycle_params.max_lifetime;
            _2264.reset = _2116.lifecycle_params.reset;
            _2264._pad1 = _2116.lifecycle_params._pad1;
            ParticleLifecycleParams param_18 = _2264;
            ModifierFactor param_19 = modifier_factor;
            Particle param_20 = p;
            uint param_21 = id;
            uint param_22 = closest_face_idx;
            particle_modifier_geometry_attractor(param_17, param_18, param_19, param_20, param_21, param_22);
            modifier_factor = param_19;
            p = param_20;
            closest_face_idx = param_22;
            _2246.VM5_closest_face_idx[id] = closest_face_idx;
        }
    }
    ParticleState param_23 = p.state;
    if (prt_is_alive(param_23))
    {
        ParticleModifierCurl_Params _2294;
        _2294.position = _2289.VM6_params.position;
        _2294.falloff_mode = _2289.VM6_params.falloff_mode;
        _2294.radius = _2289.VM6_params.radius;
        _2294.falloff_inverse = _2289.VM6_params.falloff_inverse;
        _2294.noise_strength = _2289.VM6_params.noise_strength;
        _2294.noise_speed = _2289.VM6_params.noise_speed;
        _2294.noise_scale = _2289.VM6_params.noise_scale;
        ParticleModifierCurl_Params param_24 = _2294;
        ParticleLifecycleParams _2298;
        _2298.time_step = _2116.lifecycle_params.time_step;
        _2298.max_lifetime = _2116.lifecycle_params.max_lifetime;
        _2298.reset = _2116.lifecycle_params.reset;
        _2298._pad1 = _2116.lifecycle_params._pad1;
        ParticleLifecycleParams param_25 = _2298;
        ModifierFactor param_26 = modifier_factor;
        Particle param_27 = p;
        uint param_28 = id;
        particle_modifier_curl(param_24, param_25, param_26, param_27, param_28);
        modifier_factor = param_26;
        p = param_27;
    }
    ParticleState param_29 = p.state;
    if (prt_is_alive(param_29))
    {
        ParticleModifierSwirl_Params _2322;
        _2322.position = _2317.VM7_params.position;
        _2322.falloff_curve_idx = _2317.VM7_params.falloff_curve_idx;
        _2322.radius = _2317.VM7_params.radius;
        _2322.falloff_inverse = _2317.VM7_params.falloff_inverse;
        _2322.velocity = _2317.VM7_params.velocity;
        _2322.velocity_randomness = _2317.VM7_params.velocity_randomness;
        _2322.time_step = _2317.VM7_params.time_step;
        _2322.axis_randomness = _2317.VM7_params.axis_randomness;
        _2322.axis = _2317.VM7_params.axis;
        _2322._pad0 = _2317.VM7_params._pad0;
        _2322.scale = _2317.VM7_params.scale;
        _2322._pad1 = _2317.VM7_params._pad1;
        ParticleModifierSwirl_Params param_30 = _2322;
        ParticleLifecycleParams _2326;
        _2326.time_step = _2116.lifecycle_params.time_step;
        _2326.max_lifetime = _2116.lifecycle_params.max_lifetime;
        _2326.reset = _2116.lifecycle_params.reset;
        _2326._pad1 = _2116.lifecycle_params._pad1;
        ParticleLifecycleParams param_31 = _2326;
        ModifierFactor param_32 = modifier_factor;
        Particle param_33 = p;
        uint param_34 = id;
        particle_modifier_swirl(param_30, param_31, param_32, param_33, param_34);
        p = param_33;
    }
    ParticleState param_35 = p.state;
    if (prt_is_alive(param_35))
    {
        ParticleModifierCurl_Params _2347;
        _2347.position = _2343.VM8_params.position;
        _2347.falloff_mode = _2343.VM8_params.falloff_mode;
        _2347.radius = _2343.VM8_params.radius;
        _2347.falloff_inverse = _2343.VM8_params.falloff_inverse;
        _2347.noise_strength = _2343.VM8_params.noise_strength;
        _2347.noise_speed = _2343.VM8_params.noise_speed;
        _2347.noise_scale = _2343.VM8_params.noise_scale;
        ParticleModifierCurl_Params param_36 = _2347;
        ParticleLifecycleParams _2351;
        _2351.time_step = _2116.lifecycle_params.time_step;
        _2351.max_lifetime = _2116.lifecycle_params.max_lifetime;
        _2351.reset = _2116.lifecycle_params.reset;
        _2351._pad1 = _2116.lifecycle_params._pad1;
        ParticleLifecycleParams param_37 = _2351;
        ModifierFactor param_38 = modifier_factor;
        Particle param_39 = p;
        uint param_40 = id;
        particle_modifier_curl(param_36, param_37, param_38, param_39, param_40);
        modifier_factor = param_38;
        p = param_39;
    }
    ParticleState param_41 = p.state;
    float param_42 = _2116.lifecycle_params.time_step;
    float param_43 = _2116.lifecycle_params.max_lifetime;
    prt_advance_life(param_41, param_42, param_43);
    p.state = param_41;
    uint param_44 = id;
    ParticleState param_45 = p.state;
    prt_set_state(param_44, param_45);
    uint param_46 = id;
    vec3 param_47 = p.pos;
    prt_set_position(param_46, param_47);
}

 