#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct IBLOutput
{
    vec3 color_weighted;
    vec3 color_raw;
};

struct BasicDeferredParams
{
    mat4 mModel;
    mat4 mModelview;
    mat4 mCameraModelview;
    mat4 mProjection;
    vec4 camera_projection_params;
    vec4 camera_near_far_plane;
    vec3 camera_position;
};

struct DeferredRenderLightsParams
{
    vec2 frustum_shift;
    vec2 resolution;
    int lights_num;
    float env_map_intensity;
    float raytrace_scaling_factor;
    float raytrace_strength;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct MaterialInfo
{
    float perceptualRoughness;
    vec3 reflectance0;
    float alphaRoughness;
    vec3 diffuseColor;
    vec3 reflectance90;
    vec3 specularColor;
};

struct DeferredCompositeSetup
{
    vec4 ambient_color;
    vec4 fill_color;
    vec4 fog_color;
    float fog_range;
    float fog_height;
    float fog_height_density;
    float occlusion_strength;
    float occlusion_specular_from_diffuse;
    float global_illumination_strength;
    float global_illumination_base_strength;
    float occlusion_base_strength;
    float ssr_strength;
    float sso_strength;
    float volumetric_fog_strength;
    float volumetric_fog_intensity;
    float rt_strength;
    float ibl_intensity;
    uint transparency_blend;
    float taa_blend;
    float taa_gamma;
    float _pad0;
    float _pad1;
    float _pad2;
    vec2 taa_jitter;
};

struct LightProperties
{
    vec4 diffuse;
    vec4 direction;
    vec4 position;
    vec4 up;
    vec4 right;
    vec2 dimensions;
    vec2 _pad1;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform BasicDeferredParamsBuffer
{
    layout(row_major) BasicDeferredParams basic_params;
} _242;

layout(set = 1, binding = 2, std140) uniform DeferredRenderLightsParamsBuffer
{
    DeferredRenderLightsParams render_lights_params;
} _334;

layout(set = 1, binding = 3, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 1, binding = 4, std140) uniform DeferredCompositeSetupBuffer
{
    DeferredCompositeSetup composite_setup;
} _684;

layout(set = 1, binding = 6) uniform sampler2D s_BRDF;
layout(set = 1, binding = 7) uniform samplerCube sEnviromentMap;
layout(set = 1, binding = 8) uniform sampler2D sAlbedo;
layout(set = 1, binding = 9) uniform usampler2D sNormalMaterial;
layout(set = 1, binding = 10) uniform sampler2D sDepth;
layout(set = 1, binding = 11) uniform usampler2D sMetalnessRoughnessMaterialTags;
layout(set = 1, binding = 12) uniform sampler2D sVoxelOcclusion;
layout(set = 1, binding = 5, rgba32f) uniform readonly image2D imHitDirectionPrimitiveID;
layout(set = 1, binding = 13) uniform sampler2D sRaytraceReflection;
layout(set = 1, binding = 14) uniform sampler2D sRaytrace;
layout(set = 1, binding = 15) uniform usampler2D sRaytraceHitInfo;
layout(set = 1, binding = 16) uniform sampler2D sScreenSpaceOcclusion;

layout(location = 0) out vec4 outColor;

vec3 i_octahedral_32(uint data, uint sh)
{
    uint mu = (1u << sh) - 1u;
    uvec2 d = uvec2(data, data >> sh) & uvec2(mu);
    vec2 v = vec2(d) / vec2(float(mu));
    v = vec2(-1.0) + (v * 2.0);
    vec3 nor = vec3(v, (1.0 - abs(v.x)) - abs(v.y));
    float t = max(-nor.z, 0.0);
    float _132;
    if (nor.x > 0.0)
    {
        _132 = -t;
    }
    else
    {
        _132 = t;
    }
    nor.x += _132;
    float _147;
    if (nor.y > 0.0)
    {
        _147 = -t;
    }
    else
    {
        _147 = t;
    }
    nor.y += _147;
    return normalize(nor);
}

vec3 decode_normal(inout uint data)
{
    data &= 2147483647u;
    uint param = data;
    uint param_1 = 15u;
    vec3 n = i_octahedral_32(param, param_1);
    return n;
}

int decode_material(uint data)
{
    return int(data >> 31u);
}

float linearizeDepth(float d)
{
    return _242.basic_params.camera_near_far_plane.z / ((_242.basic_params.camera_near_far_plane.y + _242.basic_params.camera_near_far_plane.x) - (d * _242.basic_params.camera_near_far_plane.w));
}

vec3 get_view_direction(vec2 screen_pos)
{
    vec2 vd_pos = screen_pos - ((_334.render_lights_params.frustum_shift * _334.render_lights_params.resolution) * vec2(0.5, -0.5));
    vec3 view_direction;
    view_direction.x = (-_242.basic_params.camera_projection_params.z) + ((_242.basic_params.camera_projection_params.x * vd_pos.x) / _334.render_lights_params.resolution.x);
    view_direction.y = (-_242.basic_params.camera_projection_params.w) + ((_242.basic_params.camera_projection_params.y * vd_pos.y) / _334.render_lights_params.resolution.y);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    return view_direction;
}

vec3 positionFromDepth(vec3 vDirection, float depth)
{
    return vDirection * depth;
}

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

void decode_component_tags(uint ct, out uint component_tags)
{
    component_tags = ct;
}

MetalnessRoughnessMeterialTags decode_metalness_roughness_material_tags(uvec4 v)
{
    uvec2 param = v.xy;
    float param_1;
    float param_2;
    uint param_3;
    decode_metalness_roughness_material(param, param_1, param_2, param_3);
    MetalnessRoughnessMeterialTags o;
    o.metalness = param_1;
    o.roughness = param_2;
    o.material_index = param_3;
    uint param_4 = v.z;
    uint param_5;
    decode_component_tags(param_4, param_5);
    o.component_tags = param_5;
    o.material_flag_overrides = v.w;
    return o;
}

uint asuint(float v)
{
    return floatBitsToUint(v);
}

IBLOutput ibl(vec3 n, vec3 v, vec3 diffuseColor, vec3 specularColor, vec3 f0, vec3 f90, float perceptual_roughness)
{
    float NdotV = clamp(dot(n, v), 0.0, 1.0);
    vec3 r = reflect(-v, n);
    float mip_count = 7.5;
    float lod = clamp(perceptual_roughness * mip_count, 0.0, mip_count);
    vec2 brdf_sample_point = clamp(vec2(NdotV, 1.0 - perceptual_roughness), vec2(0.0), vec2(1.0));
    vec2 brdf = texture(s_BRDF, brdf_sample_point).xy;
    vec3 diffuseLight = textureLod(sEnviromentMap, n, 5.0).xyz;
    vec3 specularLight = textureLod(sEnviromentMap, r, lod).xyz * (brdf.x + brdf.y);
    IBLOutput ibl_1;
    ibl_1.color_weighted = ((diffuseColor * diffuseLight) + (specularColor * specularLight)) * _334.render_lights_params.env_map_intensity;
    ibl_1.color_raw = (diffuseLight + specularLight) * _334.render_lights_params.env_map_intensity;
    return ibl_1;
}

void main()
{
    ivec2 screen_pos = ivec2(gl_FragCoord.xy);
    vec4 base_color = texelFetch(sAlbedo, screen_pos, 0);
    uint encoded_normal_material = texelFetch(sNormalMaterial, screen_pos, 0).x;
    uint param = encoded_normal_material;
    vec3 _425 = decode_normal(param);
    vec3 vNorm = _425;
    uint param_1 = encoded_normal_material;
    int materialId = decode_material(param_1);
    float param_2 = texelFetch(sDepth, screen_pos, 0).x;
    float depth = linearizeDepth(param_2);
    vec2 param_3 = vec2(screen_pos);
    vec3 view_direction = get_view_direction(param_3);
    vec3 param_4 = view_direction;
    float param_5 = depth;
    vec3 world = (_242.basic_params.mModel * vec4(positionFromDepth(param_4, param_5), 1.0)).xyz;
    outColor = vec4(0.0);
    uvec4 param_6 = texelFetch(sMetalnessRoughnessMaterialTags, screen_pos, 0);
    MetalnessRoughnessMeterialTags metalness_roughness_material_tags = decode_metalness_roughness_material_tags(param_6);
    float metalness = metalness_roughness_material_tags.metalness;
    float roughness = metalness_roughness_material_tags.roughness;
    uint material = metalness_roughness_material_tags.material_index;
    uint material_flags = materials.material_properties[material].flags;
    if ((metalness_roughness_material_tags.material_flag_overrides & 2u) != 0u)
    {
        material_flags &= 4294967280u;
        material_flags |= (metalness_roughness_material_tags.material_flag_overrides & 15u);
    }
    if ((material_flags & 4096u) != 0u)
    {
        outColor.w = 0.0;
        return;
    }
    bool is_background = (materialId & 1) == 1;
    bool is_raytraced = (material_flags & 1u) != 0u;
    bool is_particle = (material_flags & 8192u) != 0u;
    vec3 f0 = vec3(0.039999999105930328369140625);
    vec3 diffuseColor = (base_color.xyz * (vec3(1.0) - f0)) * (1.0 - metalness);
    vec3 specularColor = mix(f0, base_color.xyz, vec3(metalness));
    float alphaRoughness = roughness * roughness;
    vec3 specularEnvironmentR0 = specularColor;
    float reflectance = max(max(specularColor.x, specularColor.y), specularColor.z);
    vec3 specularEnvironmentR90 = vec3(1.0) * clamp(reflectance * 25.0, 0.0, 1.0);
    MaterialInfo materialInfo = MaterialInfo(roughness, specularEnvironmentR0, alphaRoughness, diffuseColor, specularEnvironmentR90, specularColor);
    vec3 view = normalize(_242.basic_params.camera_position - world);
    vec3 outLightColor = vec3(0.0);
    if (is_background == false)
    {
        float rt_specular_occlusion = 1.0;
        vec2 vx_diffuse_specular_occlusion = vec2(1.0) - texelFetch(sVoxelOcclusion, screen_pos, 0).xy;
        float vx_specular_occlusion = vx_diffuse_specular_occlusion.y;
        if (is_raytraced)
        {
            bool evaluated = false;
            vec4 hit_direction_primitiveID = imageLoad(imHitDirectionPrimitiveID, ivec2(screen_pos));
            float param_7 = hit_direction_primitiveID.w;
            uint hit_primitiveID_candidate = asuint(param_7);
            if (hit_primitiveID_candidate != 4294967295u)
            {
                vec4 rt_reflection = texelFetch(sRaytraceReflection, screen_pos, 0);
                rt_specular_occlusion = rt_reflection.w;
                evaluated = true;
            }
            if (evaluated == false)
            {
                vec4 raytraceColor = texelFetch(sRaytrace, screen_pos, 0);
                uvec4 raytraceHitAttribute = texelFetch(sRaytraceHitInfo, screen_pos, 0);
                uint bounces = raytraceHitAttribute.x;
                if (bounces >= 2u)
                {
                    rt_specular_occlusion = raytraceColor.w;
                }
            }
        }
        float specular_occlusion = min(rt_specular_occlusion, vx_specular_occlusion);
        float diffuse_occlusion = 0.0;
        float ss_ao = max(texelFetch(sScreenSpaceOcclusion, screen_pos, 0).x, 0.0);
        float vx_ao = vx_diffuse_specular_occlusion.x;
        if (_684.composite_setup.sso_strength > 0.0)
        {
            ss_ao = pow(ss_ao, _684.composite_setup.sso_strength);
            vx_ao = pow(vx_ao, _684.composite_setup.sso_strength);
            ss_ao = 1.0 - clamp((1.0 - ss_ao) * _684.composite_setup.occlusion_strength, 0.0, 1.0);
            vx_ao = 1.0 - clamp((1.0 - vx_ao) * _684.composite_setup.occlusion_strength, 0.0, 1.0);
            specular_occlusion = pow(specular_occlusion, _684.composite_setup.sso_strength);
            specular_occlusion = 1.0 - clamp((1.0 - specular_occlusion) * _684.composite_setup.occlusion_strength, 0.0, 1.0);
        }
        float ao = min(ss_ao, vx_ao);
        specular_occlusion = 1.0 - max(1.0 - specular_occlusion, (1.0 - ao) * _684.composite_setup.occlusion_specular_from_diffuse);
        diffuse_occlusion = 1.0 - ao;
        specular_occlusion = 1.0 - specular_occlusion;
        vec3 param_8 = vNorm;
        vec3 param_9 = view;
        vec3 param_10 = materialInfo.diffuseColor * (1.0 - diffuse_occlusion);
        vec3 param_11 = materialInfo.specularColor * (1.0 - specular_occlusion);
        vec3 param_12 = specularEnvironmentR0;
        vec3 param_13 = specularEnvironmentR90;
        float param_14 = roughness;
        IBLOutput ibl_1 = ibl(param_8, param_9, param_10, param_11, param_12, param_13, param_14);
        outColor.x = ibl_1.color_weighted.x;
        outColor.y = ibl_1.color_weighted.y;
        outColor.z = ibl_1.color_weighted.z;
        outColor.w = diffuse_occlusion + specular_occlusion;
    }
}

 