#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct MaterialEval
{
    vec4 albedo;
    vec4 albedo_texture;
    vec3 emissive;
    vec3 emissive_texture;
    float roughness;
    float roughness_texture;
    float metalness;
    float metalness_texture;
    float transparency;
    vec3 normal;
    bool is_discarded;
    uint flag_overrides;
};

struct MaterialEvalInput
{
    vec2 uv0;
    vec3 normal;
    vec4 color;
    vec3 world_coords;
    vec3 local_coords;
    vec3 world_normal;
    vec3 local_normal;
    float modifier_factor;
};

struct _572
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 1, binding = 2, std140) uniform BaseMaterialPropertiesBuffer
{
    vec4 colorDiffuse;
    int gUseDerivedNormal;
    int gMaterialMode;
    int materialId;
    int materialIndex;
    int componentTags;
} _644;

layout(set = 1, binding = 3, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _658;

layout(set = 1, binding = 4) uniform sampler2D material_textures[64];

layout(location = 1) in _572 vtx_input;
layout(location = 1) out uint outNormalMaterial;
layout(location = 0) out vec4 outAlbedo;
layout(location = 3) out vec4 outEmissive;
layout(location = 2) out uvec4 outMetalnessRoughnessMeterialTags;

vec3 getMaterialNormal(MaterialPropertiesGPU material, vec3 normal, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return normal;
}

bool getMaterialDiscard(MaterialPropertiesGPU material, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return false;
}

vec3 mapping_triplanar_normal(sampler2D smpl, vec3 p, vec3 n, vec3 scale)
{
    vec3 coords = p;
    vec3 blending = abs(n);
    blending = normalize(max(blending, vec3(9.9999997473787516355514526367188e-06)));
    float b = (blending.x + blending.y) + blending.z;
    blending /= vec3(b);
    vec3 axis_sign = sign(n);
    vec3 xaxis = (texture(smpl, coords.zy * scale.zy).xyz * 2.0) - vec3(1.0);
    vec3 yaxis = (texture(smpl, coords.xz * scale.xz).xyz * 2.0) - vec3(1.0);
    vec3 zaxis = (texture(smpl, coords.xy * scale.xy).xyz * 2.0) - vec3(1.0);
    xaxis.z *= axis_sign.x;
    yaxis.z *= axis_sign.y;
    zaxis.z *= axis_sign.z;
    vec3 tex = normalize(((xaxis.zyx * blending.x) + (yaxis.xzy * blending.y)) + (zaxis * blending.z));
    return tex;
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

uint octahedral_32(inout vec3 nor, uint sh)
{
    nor /= vec3((abs(nor.x) + abs(nor.y)) + abs(nor.z));
    vec2 _134;
    if (nor.z >= 0.0)
    {
        _134 = nor.xy;
    }
    else
    {
        _134 = (vec2(1.0) - abs(nor.yx)) * sign(nor.xy);
    }
    nor.x = _134.x;
    nor.y = _134.y;
    vec2 v = vec2(0.5) + (nor.xy * 0.5);
    uint mu = (1u << sh) - 1u;
    uvec2 d = uvec2(floor((v * float(mu)) + vec2(0.5)));
    return (d.y << sh) | d.x;
}

uint encode_normal_material(vec3 n, int id)
{
    vec3 param = n;
    uint param_1 = 15u;
    uint _190 = octahedral_32(param, param_1);
    uint normal_material = _190;
    normal_material = (uint(id) << 31u) | normal_material;
    return normal_material;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

vec4 mapping_triplanar(sampler2D smpl, vec3 p, vec3 n, vec3 scale)
{
    vec3 coords = p;
    vec3 blending = abs(n);
    blending = normalize(max(blending, vec3(9.9999997473787516355514526367188e-06)));
    float b = (blending.x + blending.y) + blending.z;
    blending /= vec3(b);
    vec4 xaxis = texture(smpl, coords.yz * scale.yz);
    vec4 yaxis = texture(smpl, coords.xz * scale.xz);
    vec4 zaxis = texture(smpl, coords.xy * scale.xy);
    vec4 tex = ((xaxis * blending.x) + (yaxis * blending.y)) + (zaxis * blending.z);
    return tex;
}

void material_evaluate_sample_textures(MaterialPropertiesGPU material, inout MaterialEval material_eval, MaterialEvalInput eval_input)
{
    vec2 uv0 = eval_input.uv0;
    vec3 norm = eval_input.normal;
    bool _548 = material.albedo_sampler >= 0;
    bool _555;
    if (_548)
    {
        _555 = material.albedo_sampler < 16;
    }
    else
    {
        _555 = _548;
    }
    if (_555)
    {
        if ((material.flags & 1024u) != 0u)
        {
            vec3 param = vtx_input.vLocalPos;
            vec3 param_1 = norm;
            vec3 param_2 = material.triplanar_factor;
            material_eval.albedo_texture = mapping_triplanar(material_textures[material.albedo_sampler], param, param_1, param_2);
        }
        else
        {
            material_eval.albedo_texture = texture(material_textures[material.albedo_sampler], uv0);
        }
    }
    bool _597 = material.emissive_sampler >= 0;
    bool _603;
    if (_597)
    {
        _603 = material.emissive_sampler < 16;
    }
    else
    {
        _603 = _597;
    }
    if (_603)
    {
        if ((material.flags & 1024u) != 0u)
        {
            vec3 param_3 = vtx_input.vLocalPos;
            vec3 param_4 = norm;
            vec3 param_5 = material.triplanar_factor;
            material_eval.emissive_texture = mapping_triplanar(material_textures[material.emissive_sampler], param_3, param_4, param_5).xyz;
        }
        else
        {
            material_eval.emissive_texture = texture(material_textures[material.emissive_sampler], uv0).xyz;
        }
    }
}

void material_evaluate(MaterialPropertiesGPU material, inout MaterialEval eval, inout MaterialEvalInput eval_input)
{
    MaterialPropertiesGPU param = material;
    MaterialEval param_1 = eval;
    MaterialEvalInput param_2 = eval_input;
    material_evaluate_sample_textures(param, param_1, param_2);
    eval = param_1;
    eval_input = param_2;
    vec3 n = eval_input.normal;
    n.y = abs(n.y);
    n.x = abs(n.x);
    n.z = abs(n.z);
    vec4 _501 = eval.albedo_texture;
    vec4 _512 = eval.albedo;
    vec3 _514 = _512.xyz * (((n * (0.75 + (0.25 * length(_501.xyz)))) * 0.5) + vec3(0.5));
    eval.albedo.x = _514.x;
    eval.albedo.y = _514.y;
    eval.albedo.z = _514.z;
    eval.albedo_texture.x = 1.0;
    eval.albedo_texture.y = 1.0;
    eval.albedo_texture.z = 1.0;
    if (eval.albedo_texture.w < 0.5)
    {
        eval.is_discarded = true;
    }
}

uvec2 encode_metalness_roughness_material(float metalness, float roughness, uint material)
{
    return uvec2((uint(min(1.0, metalness) * 255.0) << uint(8)) | (uint(min(1.0, roughness) * 255.0) << uint(0)), material);
}

uint encode_component_tags(uint component_tags)
{
    return component_tags & 65535u;
}

uvec4 encode_metalness_roughness_material_tags(MetalnessRoughnessMeterialTags v)
{
    float param = v.metalness;
    float param_1 = v.roughness;
    uint param_2 = v.material_index;
    uvec2 _236 = encode_metalness_roughness_material(param, param_1, param_2);
    uvec4 o;
    o.x = _236.x;
    o.y = _236.y;
    uint param_3 = v.component_tags;
    o.z = encode_component_tags(param_3);
    o.w = v.material_flag_overrides;
    return o;
}

void main()
{
    MaterialPropertiesGPU _651;
    _651.diffuse = materials.material_properties[_644.materialIndex].diffuse;
    _651.transparency = materials.material_properties[_644.materialIndex].transparency;
    _651.emissive = materials.material_properties[_644.materialIndex].emissive;
    _651.roughness = materials.material_properties[_644.materialIndex].roughness;
    _651.triplanar_factor = materials.material_properties[_644.materialIndex].triplanar_factor;
    _651.refraction = materials.material_properties[_644.materialIndex].refraction;
    _651.normal_factor = materials.material_properties[_644.materialIndex].normal_factor;
    _651.emissive_factor = materials.material_properties[_644.materialIndex].emissive_factor;
    _651.temporal_accumulation_factor = materials.material_properties[_644.materialIndex].temporal_accumulation_factor;
    _651.shadowmap_bias = materials.material_properties[_644.materialIndex].shadowmap_bias;
    _651.metalness = materials.material_properties[_644.materialIndex].metalness;
    _651.albedo_sampler = materials.material_properties[_644.materialIndex].albedo_sampler;
    _651.emissive_sampler = materials.material_properties[_644.materialIndex].emissive_sampler;
    _651.normal_sampler = materials.material_properties[_644.materialIndex].normal_sampler;
    _651.metalic_roughness_sampler = materials.material_properties[_644.materialIndex].metalic_roughness_sampler;
    _651.flags = materials.material_properties[_644.materialIndex].flags;
    _651._pad0 = materials.material_properties[_644.materialIndex]._pad0;
    _651._pad1 = materials.material_properties[_644.materialIndex]._pad1;
    MaterialPropertiesGPU material = _651;
    vec3 worldPos = vtx_input.vCameraRelativeWorldPos + _658.transform_params.vCameraPosition;
    float g = (vtx_input.vNorm.z * 0.5) + 0.5;
    vec3 worldNorm = vtx_input.vWorldNorm;
    vec3 norm = vtx_input.vNorm;
    if ((material.flags & 128u) != 0u)
    {
    }
    else
    {
        if (gl_FrontFacing)
        {
            worldNorm = -worldNorm;
            norm = -norm;
        }
    }
    worldNorm = normalize(worldNorm);
    norm = normalize(norm);
    vec3 normal = worldNorm;
    MaterialPropertiesGPU param = material;
    vec3 param_1 = normal;
    vec3 param_2 = worldPos;
    vec3 param_3 = vtx_input.vLocalPos;
    vec3 param_4 = vtx_input.vNorm;
    vec3 param_5 = vtx_input.vWorldNorm;
    normal = getMaterialNormal(param, param_1, param_2, param_3, param_4, param_5);
    MaterialPropertiesGPU param_6 = material;
    vec3 param_7 = worldPos;
    vec3 param_8 = vtx_input.vLocalPos;
    vec3 param_9 = vtx_input.vNorm;
    vec3 param_10 = vtx_input.vWorldNorm;
    bool to_discard = getMaterialDiscard(param_6, param_7, param_8, param_9, param_10);
    if (to_discard)
    {
        discard;
    }
    bool _736 = material.normal_sampler >= 0;
    bool _742;
    if (_736)
    {
        _742 = material.normal_sampler < 16;
    }
    else
    {
        _742 = _736;
    }
    if (_742)
    {
        if ((material.flags & 1024u) == 0u)
        {
            vec3 pos_dx = dFdxFine(worldPos);
            vec3 pos_dy = dFdyFine(worldPos);
            vec3 tex_dx = dFdxFine(vec3(vtx_input.vUV0, 0.0));
            vec3 tex_dy = dFdyFine(vec3(vtx_input.vUV0, 0.0));
            float denom = (tex_dx.x * tex_dy.y) - (tex_dy.x * tex_dx.y);
            if (abs(denom) >= 1.0000000133514319600180897396058e-10)
            {
                vec3 t = ((pos_dx * tex_dy.y) - (pos_dy * tex_dx.y)) / vec3(denom);
                vec3 ng = normal;
                t = normalize(t - (ng * dot(ng, t)));
                vec3 b = normalize(cross(ng, t));
                mat3 tbn = mat3(vec3(t), vec3(b), vec3(ng));
                vec3 n = (texture(material_textures[material.normal_sampler], vtx_input.vUV0).xyz * 2.0) - vec3(1.0);
                n = normalize(n * transpose(tbn));
                n = mix(normal, n, vec3(material.normal_factor));
                normal = n;
            }
        }
        else
        {
            vec3 param_11 = vtx_input.vLocalPos;
            vec3 param_12 = norm;
            vec3 param_13 = material.triplanar_factor;
            vec3 n_1 = mapping_triplanar_normal(material_textures[material.normal_sampler], param_11, param_12, param_13);
            vec3 param_14 = n_1;
            mat4 param_15 = _658.transform_params.mModelNormal;
            n_1 = vector_transform_by_mat33(param_14, param_15);
            mat4 m = _658.transform_params.mModelNormal;
            n_1 = normalize(mix(normal, n_1, vec3(material.normal_factor)));
            normal = n_1;
        }
    }
    vec2 uv0 = vtx_input.vUV0;
    uint material_flag_overrides = 0u;
    vec3 param_16 = normal;
    int param_17 = _644.materialId;
    outNormalMaterial = encode_normal_material(param_16, param_17);
    float factor = 1.0;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = 0u;
    modifier_factor.id = 0u;
    modifier_factor.instance_id = 0u;
    modifier_factor.position = vtx_input.vLocalPos;
    modifier_factor.is_spawned = false;
    modifier_factor.has_world_position = true;
    modifier_factor.world_position = worldPos;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _658.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = _658.transform_params.mModelInv;
    factor = modifier_factor.factor;
    MaterialEval material_eval;
    material_eval.albedo = vec4(material.diffuse, _644.colorDiffuse.w);
    material_eval.emissive = vec3(0.0);
    material_eval.roughness = material.roughness;
    material_eval.metalness = material.metalness;
    material_eval.transparency = material.transparency;
    material_eval.is_discarded = false;
    material_eval.normal = normal;
    material_eval.albedo_texture = vec4(1.0);
    material_eval.emissive_texture = vec3(1.0);
    material_eval.roughness_texture = 1.0;
    material_eval.metalness_texture = 1.0;
    material_eval.flag_overrides = 0u;
    MaterialEvalInput eval_input;
    eval_input.uv0 = uv0;
    eval_input.normal = norm;
    eval_input.color = vtx_input.vColor;
    eval_input.world_coords = worldPos;
    eval_input.local_coords = vtx_input.vLocalPos;
    eval_input.world_normal = vtx_input.vWorldNorm;
    eval_input.local_normal = vtx_input.vNorm;
    eval_input.modifier_factor = factor;
    MaterialPropertiesGPU param_18 = material;
    MaterialEval param_19 = material_eval;
    MaterialEvalInput param_20 = eval_input;
    material_evaluate(param_18, param_19, param_20);
    material_eval = param_19;
    eval_input = param_20;
    if ((material_eval.flag_overrides & 2u) != 0u)
    {
        material_flag_overrides = material_eval.flag_overrides;
    }
    if (material_eval.is_discarded)
    {
        discard;
    }
    outAlbedo = material_eval.albedo * material_eval.albedo_texture;
    vec3 _1018 = material_eval.emissive * material_eval.emissive_texture;
    outEmissive.x = _1018.x;
    outEmissive.y = _1018.y;
    outEmissive.z = _1018.z;
    outEmissive.w = material_eval.transparency;
    float roughness = material_eval.roughness * material_eval.roughness_texture;
    float metalness = material_eval.metalness * material_eval.metalness_texture;
    MetalnessRoughnessMeterialTags metalness_roughness_material_tags;
    metalness_roughness_material_tags.metalness = metalness;
    metalness_roughness_material_tags.roughness = roughness;
    metalness_roughness_material_tags.material_index = uint(_644.materialIndex);
    metalness_roughness_material_tags.component_tags = uint(_644.componentTags);
    metalness_roughness_material_tags.material_flag_overrides = material_flag_overrides;
    MetalnessRoughnessMeterialTags param_21 = metalness_roughness_material_tags;
    outMetalnessRoughnessMeterialTags = encode_metalness_roughness_material_tags(param_21);
}

 