#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require

struct TexGenCustomParams
{
    vec2 resolution;
    vec2 resolutionInv;
    float param1;
    float param2;
    float _pad0;
    float _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

layout(set = 1, binding = 1, std140) uniform TexGenCustomParamsBuffer
{
    TexGenCustomParams params;
} _27;

layout(set = 1, binding = 2, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _68;

layout(location = 0) in vec2 vTexcoord0;
layout(location = 0) out vec4 outColor;

void main()
{
    vec4 base_color = vec4(1.0, 0.0, 0.5, 1.0);
    vec2 d = vTexcoord0 - vec2(0.5);
    d.x *= (_27.params.resolution.x / _27.params.resolution.y);
    float r = length(d);
    float m = _27.params.param2 * 0.20000000298023223876953125;
    float ps = _27.params.param1 * 0.100000001490116119384765625;
    float v1 = 0.5 + (0.5 * sin((((r * 13.1201000213623046875) * m) + (_68.globals.time * 1.12000000476837158203125)) + 0.12399999797344207763671875));
    float v2 = 0.5 + (0.5 * sin((((r * 21.325099945068359375) * m) - (_68.globals.time * 3.673099994659423828125)) + 10.12399959564208984375));
    float v3 = 0.5 + (0.5 * sin((((r * 31.325099945068359375) * m) + (_68.globals.time * 6.173099994659423828125)) + 3.124000072479248046875));
    v1 = (smoothstep(0.20000000298023223876953125, 0.89999997615814208984375, v1) - 0.5) * 0.64999997615814208984375;
    v2 = (smoothstep(0.100000001490116119384765625, 0.89999997615814208984375, v2) - 0.5) * 0.4469999969005584716796875;
    v3 = (smoothstep(0.0500000007450580596923828125, 0.89999997615814208984375, v3) - 0.5) * 0.5299999713897705078125;
    outColor = vec4(0.5 + (0.5 * sin((r * m) + (ps * 2.0))));
    outColor = smoothstep(vec4(0.0500000007450580596923828125), vec4(0.949999988079071044921875), outColor);
    float r_modifier = max(0.0, r);
    r_modifier = smoothstep(0.07999999821186065673828125, 0.4000000059604644775390625, r_modifier);
    r_modifier = 1.0 - r_modifier;
    outColor = clamp(outColor, vec4(0.0), vec4(1.0));
}

 