#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct ModifierFactorFrustumCull_Params
{
    mat4 transform_local_to_gizmo;
    mat4 transform_world_to_view;
    mat4 transform_projection;
    float instance_radius;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct InstanceModifierRandomizerV2_Params
{
    int replace_previous_rotation_scale;
    int randomness_seed;
    int replace_previous_position;
    int randomization_input;
    vec3 position_modifier_base;
    float position_modifier_base_modifier_factor;
    vec3 position_modifier_range;
    float position_modifier_range_modifier_factor;
    vec3 rotation_modifier_base;
    float rotation_modifier_base_modifier_factor;
    vec3 rotation_modifier_range;
    float rotation_modifier_range_modifier_factor;
    vec3 scale_modifier_base;
    float scale_modifier_base_modifier_factor;
    vec3 scale_modifier_range;
    float scale_modifier_range_modifier_factor;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct InstancingGeneratorParams
{
    int seed;
    int first_particle;
    int skip_particles;
    int num_particles;
    float fade_lifetime;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct ModifierFactorSet_Params
{
    float value;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _369;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    float prt_positions[];
} _393;

layout(set = 0, binding = 3, std430) buffer ParticlePrevPositionsData
{
    float prt_prev_positions[];
} _415;

layout(set = 0, binding = 9, std140) uniform InstancingGeneratorParamsBuffer
{
    InstancingGeneratorParams instancing_generator_params;
} _1308;

layout(set = 0, binding = 10, std140) uniform VM0
{
    layout(row_major) ModifierFactorFrustumCull_Params VM0_params;
} _1405;

layout(set = 0, binding = 4, std430) buffer InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1435;

layout(set = 0, binding = 11, std140) uniform VM1
{
    layout(row_major) ModifierFactorNoise_Params VM1_params;
} _1538;

layout(set = 0, binding = 12, std140) uniform VM2
{
    InstanceModifierRandomizerV2_Params VM2_params;
} _1553;

layout(set = 0, binding = 13, std140) uniform VM3
{
    ModifierFactorSet_Params VM3_params;
} _1579;

layout(set = 0, binding = 14, std140) uniform VM4
{
    InstanceModifierRandomizerV2_Params VM4_params;
} _1585;

layout(set = 0, binding = 5, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1602;

layout(set = 0, binding = 6, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _1625;

layout(set = 0, binding = 7, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _1645;

layout(set = 0, binding = 8, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _1653;

bool prt_is_alive(uint id)
{
    return _369.prt_states[id].life_time < _369.prt_states[id].life_span;
}

vec3 prt_get_prev_position(uint id)
{
    return vec3(_415.prt_prev_positions[(id * 3u) + 0u], _415.prt_prev_positions[(id * 3u) + 1u], _415.prt_prev_positions[(id * 3u) + 2u]);
}

vec3 prt_get_position(uint id)
{
    return vec3(_393.prt_positions[(id * 3u) + 0u], _393.prt_positions[(id * 3u) + 1u], _393.prt_positions[(id * 3u) + 2u]);
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    return m * vec4(v, 1.0);
}

void modifier_factor_frustum_cull(ModifierFactorFrustumCull_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    vec3 param = coords;
    mat4 param_1 = cs_transforms.mat_local_to_model;
    vec3 _459 = vector_transform_by_mat43(param, param_1);
    coords = _459;
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_world_to_view;
    vec3 _465 = vector_transform_by_mat43(param_2, param_3);
    coords = _465;
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 _472 = vector_transform_by_mat43(param_4, param_5);
    vec3 rel_coords = _472;
    vec3 param_6 = rel_coords;
    mat4 param_7 = modifier_params.transform_projection;
    vec4 _479 = vector_transform_by_mat_projection(param_6, param_7);
    vec4 projected = _479;
    float margin = 0.100000001490116119384765625;
    vec4 _484 = projected;
    vec2 _486 = _484.xy * (1.0 - margin);
    projected.x = _486.x;
    projected.y = _486.y;
    bool _496 = projected.x < (-projected.w);
    bool _505;
    if (!_496)
    {
        _505 = projected.x > projected.w;
    }
    else
    {
        _505 = _496;
    }
    bool _515;
    if (!_505)
    {
        _515 = projected.y < (-projected.w);
    }
    else
    {
        _515 = _505;
    }
    bool _524;
    if (!_515)
    {
        _524 = projected.y > projected.w;
    }
    else
    {
        _524 = _515;
    }
    bool _533;
    if (!_524)
    {
        _533 = projected.z < (-margin);
    }
    else
    {
        _533 = _524;
    }
    if (_533)
    {
        modifier_factor.is_discarded = true;
    }
}

ParticleState prt_get_state(uint id)
{
    ParticleState _386;
    _386.life_time = _369.prt_states[id].life_time;
    _386.life_span = _369.prt_states[id].life_span;
    _386.generation_id = _369.prt_states[id].generation_id;
    _386.color = _369.prt_states[id].color;
    ParticleState _385 = _386;
    return _385;
}

vec3 color_convert_uint_to_float3(uint vi)
{
    vec3 v = vec3(0.0);
    uint v_mag = vi >> uint(24);
    float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
    v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
    v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
    v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
    return v;
}

vec4 prt_get_color(uint id)
{
    vec4 c = vec4(1.0);
    uint param = _369.prt_states[id].color;
    vec3 _440 = color_convert_uint_to_float3(param);
    c.x = _440.x;
    c.y = _440.y;
    c.z = _440.z;
    return c;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise_default(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _903 = vector_transform_by_mat43(param, param_1);
        coords = _903;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _910 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _910;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

uint hash(uvec3 v)
{
    uint param = v.y;
    uint _324 = hash(param);
    uint param_1 = v.z;
    uint _329 = hash(param_1);
    uint param_2 = (v.x ^ _324) ^ _329;
    uint _332 = hash(param_2);
    return _332;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(vec3 v)
{
    uvec3 param = floatBitsToUint(v);
    uint param_1 = hash(param);
    float _361 = floatConstruct(param_1);
    return _361;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _351 = hash(param);
    uint param_1 = _351;
    float _353 = floatConstruct(param_1);
    return _353;
}

void instance_modifier_randomizer_v2(InstanceModifierRandomizerV2_Params modifier_params, ModifierFactor modifier_factor, inout Instance instance, uint id)
{
    float influence = modifier_factor.factor;
    float fid = float(id);
    if (modifier_params.randomization_input == 0)
    {
        fid = float(id);
    }
    if (modifier_params.randomization_input == 1)
    {
        vec3 param = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
        fid = random(param);
    }
    if (modifier_params.randomization_input == 2)
    {
        float param_1 = uintBitsToFloat(instance.hash);
        fid = random(param_1);
    }
    float param_2 = fid;
    vec3 angles;
    angles.x = random(param_2);
    float param_3 = fid + 123.3000030517578125;
    angles.y = random(param_3);
    float param_4 = (fid * 2.131700038909912109375) + 13.4137096405029296875;
    angles.z = random(param_4);
    if (modifier_params.randomization_input == 3)
    {
        angles = vec3(1.0);
    }
    angles = (modifier_params.rotation_modifier_base * (modifier_params.rotation_modifier_base_modifier_factor * influence)) + ((angles * modifier_params.rotation_modifier_range) * (modifier_params.rotation_modifier_range_modifier_factor * influence));
    float param_5 = fid;
    vec3 scales;
    scales.x = random(param_5);
    scales.y = scales.x;
    scales.z = scales.x;
    if (modifier_params.randomization_input == 3)
    {
        scales = vec3(1.0);
    }
    scales = mix(vec3(1.0), modifier_params.scale_modifier_base, vec3(modifier_params.scale_modifier_base_modifier_factor * influence)) + ((scales * modifier_params.scale_modifier_range) * (modifier_params.scale_modifier_range_modifier_factor * influence));
    float param_6 = fid;
    vec3 translations;
    translations.x = random(param_6);
    float param_7 = fid + 123.73169708251953125;
    translations.y = random(param_7);
    float param_8 = (fid * 2.131700038909912109375) + 13.71000003814697265625;
    translations.z = random(param_8);
    if (modifier_params.randomization_input == 3)
    {
        translations = vec3(1.0);
    }
    else
    {
        translations = normalize(translations);
    }
    translations = (modifier_params.position_modifier_base * (modifier_params.position_modifier_base_modifier_factor * influence)) + ((translations * modifier_params.position_modifier_range) * (modifier_params.position_modifier_range_modifier_factor * influence));
    float cosb = cos(angles.z);
    float sinb = sin(angles.z);
    float cosp = cos(angles.x);
    float sinp = sin(angles.x);
    float _cosh = cos(angles.y);
    float _sinh = sin(angles.y);
    vec3 mx;
    mx.x = (_cosh * cosb) + ((_sinh * sinp) * sinb);
    mx.y = ((_sinh * sinp) * cosb) - (_cosh * sinb);
    mx.z = _sinh * cosp;
    vec3 my;
    my.x = cosp * sinb;
    my.y = cosp * cosb;
    my.z = -sinp;
    vec3 mz;
    mz.x = ((_cosh * sinp) * sinb) - (_sinh * cosb);
    mz.y = (_sinh * sinb) + ((_cosh * sinp) * cosb);
    mz.z = _cosh * cosp;
    mat4 tm_rot;
    tm_rot[0] = vec4(mx.x, my.x, mz.x, translations.x);
    tm_rot[1] = vec4(mx.y, my.y, mz.y, translations.y);
    tm_rot[2] = vec4(mx.z, my.z, mz.z, translations.z);
    tm_rot[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 tm_sc;
    tm_sc[0] = vec4(scales.x, 0.0, 0.0, 0.0);
    tm_sc[1] = vec4(0.0, scales.y, 0.0, 0.0);
    tm_sc[2] = vec4(0.0, 0.0, scales.z, 0.0);
    tm_sc[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 m;
    m[0] = instance.m0;
    m[1] = instance.m1;
    m[2] = instance.m2;
    m[3] = vec4(0.0, 0.0, 0.0, 1.0);
    if (modifier_params.replace_previous_rotation_scale == 0)
    {
        m = (tm_sc * tm_rot) * m;
    }
    else
    {
        mat4 lm = tm_sc * tm_rot;
        m = (tm_sc * tm_rot) * m;
        m[0].x = lm[0].xyz.x;
        m[0].y = lm[0].xyz.y;
        m[0].z = lm[0].xyz.z;
        m[1].x = lm[1].xyz.x;
        m[1].y = lm[1].xyz.y;
        m[1].z = lm[1].xyz.z;
        m[2].x = lm[2].xyz.x;
        m[2].y = lm[2].xyz.y;
        m[2].z = lm[2].xyz.z;
    }
    instance.m0 = m[0];
    instance.m1 = m[1];
    instance.m2 = m[2];
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint particle_idx = (id * uint(_1308.instancing_generator_params.skip_particles)) + uint(_1308.instancing_generator_params.first_particle);
    if (particle_idx >= uint(_1308.instancing_generator_params.num_particles))
    {
        return;
    }
    uint param = particle_idx;
    if (prt_is_alive(param) == false)
    {
        return;
    }
    uint param_1 = particle_idx;
    vec3 pos_prev = prt_get_prev_position(param_1);
    uint param_2 = particle_idx;
    vec3 pos = prt_get_position(param_2);
    bool has_direction = true;
    bool _1346 = pos.x == pos_prev.x;
    bool _1354;
    if (_1346)
    {
        _1354 = pos.y == pos_prev.y;
    }
    else
    {
        _1354 = _1346;
    }
    bool _1362;
    if (_1354)
    {
        _1362 = pos.z == pos_prev.z;
    }
    else
    {
        _1362 = _1354;
    }
    if (_1362)
    {
        has_direction = false;
    }
    vec3 nx = vec3(1.0, 0.0, 0.0);
    vec3 ny = vec3(0.0, 1.0, 0.0);
    vec3 nz = vec3(0.0, 0.0, 1.0);
    if (has_direction)
    {
        vec3 d = normalize(pos_prev - pos);
        nz = d;
        nx = cross(nz, ny);
        ny = cross(nz, nx);
    }
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = particle_idx;
    modifier_factor.id = id;
    modifier_factor.position = pos;
    modifier_factor.is_spawned = true;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ModifierFactorFrustumCull_Params _1410;
    _1410.transform_local_to_gizmo = _1405.VM0_params.transform_local_to_gizmo;
    _1410.transform_world_to_view = _1405.VM0_params.transform_world_to_view;
    _1410.transform_projection = _1405.VM0_params.transform_projection;
    _1410.instance_radius = _1405.VM0_params.instance_radius;
    ModifierFactorFrustumCull_Params param_3 = _1410;
    ModifierFactor param_4 = modifier_factor;
    CoordinateSystemTrasforms param_5 = cs_transforms;
    modifier_factor_frustum_cull(param_3, param_4, param_5);
    modifier_factor = param_4;
    bool _1420 = modifier_factor.factor <= 9.9999997473787516355514526367188e-05;
    bool _1427;
    if (!_1420)
    {
        _1427 = modifier_factor.is_discarded == true;
    }
    else
    {
        _1427 = _1420;
    }
    if (_1427)
    {
        return;
    }
    int _1438 = atomicAdd(_1435.instance_params.instance_count, 1);
    uint instance_id = uint(_1438);
    if (instance_id >= uint(_1435.instance_params.buffer_capacity))
    {
        return;
    }
    uint param_6 = particle_idx;
    ParticleState particle_state = prt_get_state(param_6);
    float size = 1.0;
    if (particle_state.life_time < _1308.instancing_generator_params.fade_lifetime)
    {
        size = smoothstep(0.0, _1308.instancing_generator_params.fade_lifetime, particle_state.life_time);
    }
    if (particle_state.life_time >= (particle_state.life_span - _1308.instancing_generator_params.fade_lifetime))
    {
        size = 1.0 - smoothstep(particle_state.life_span - _1308.instancing_generator_params.fade_lifetime, particle_state.life_span, particle_state.life_time);
    }
    nx *= size;
    ny *= size;
    nz *= size;
    Instance instance;
    instance.m0 = vec4(nx.x, ny.x, nz.x, pos.x);
    instance.m1 = vec4(nx.y, ny.y, nz.y, pos.y);
    instance.m2 = vec4(nx.z, ny.z, nz.z, pos.z);
    instance.hash = modifier_factor.hash;
    uint param_7 = particle_idx;
    instance.c = prt_get_color(param_7);
    instance.flipbook_card = 0u;
    ModifierFactorNoise_Params _1543;
    _1543.transform_local_to_gizmo = _1538.VM1_params.transform_local_to_gizmo;
    _1543.noise_domain_scale = _1538.VM1_params.noise_domain_scale;
    _1543.modifier_function = _1538.VM1_params.modifier_function;
    _1543.noise_domain_offset = _1538.VM1_params.noise_domain_offset;
    _1543.noise_value_scale = _1538.VM1_params.noise_value_scale;
    _1543.noise_value_offset = _1538.VM1_params.noise_value_offset;
    _1543.influence_scope = _1538.VM1_params.influence_scope;
    _1543._pad0 = _1538.VM1_params._pad0;
    _1543._pad1 = _1538.VM1_params._pad1;
    ModifierFactorNoise_Params param_8 = _1543;
    ModifierFactor param_9 = modifier_factor;
    CoordinateSystemTrasforms param_10 = cs_transforms;
    modifier_factor_noise_default(param_8, param_9, param_10);
    modifier_factor = param_9;
    InstanceModifierRandomizerV2_Params _1558;
    _1558.replace_previous_rotation_scale = _1553.VM2_params.replace_previous_rotation_scale;
    _1558.randomness_seed = _1553.VM2_params.randomness_seed;
    _1558.replace_previous_position = _1553.VM2_params.replace_previous_position;
    _1558.randomization_input = _1553.VM2_params.randomization_input;
    _1558.position_modifier_base = _1553.VM2_params.position_modifier_base;
    _1558.position_modifier_base_modifier_factor = _1553.VM2_params.position_modifier_base_modifier_factor;
    _1558.position_modifier_range = _1553.VM2_params.position_modifier_range;
    _1558.position_modifier_range_modifier_factor = _1553.VM2_params.position_modifier_range_modifier_factor;
    _1558.rotation_modifier_base = _1553.VM2_params.rotation_modifier_base;
    _1558.rotation_modifier_base_modifier_factor = _1553.VM2_params.rotation_modifier_base_modifier_factor;
    _1558.rotation_modifier_range = _1553.VM2_params.rotation_modifier_range;
    _1558.rotation_modifier_range_modifier_factor = _1553.VM2_params.rotation_modifier_range_modifier_factor;
    _1558.scale_modifier_base = _1553.VM2_params.scale_modifier_base;
    _1558.scale_modifier_base_modifier_factor = _1553.VM2_params.scale_modifier_base_modifier_factor;
    _1558.scale_modifier_range = _1553.VM2_params.scale_modifier_range;
    _1558.scale_modifier_range_modifier_factor = _1553.VM2_params.scale_modifier_range_modifier_factor;
    InstanceModifierRandomizerV2_Params param_11 = _1558;
    ModifierFactor param_12 = modifier_factor;
    Instance param_13 = instance;
    uint param_14 = id;
    instance_modifier_randomizer_v2(param_11, param_12, param_13, param_14);
    modifier_factor = param_12;
    instance = param_13;
    modifier_factor.position = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
    modifier_factor.factor = _1579.VM3_params.value;
    InstanceModifierRandomizerV2_Params _1589;
    _1589.replace_previous_rotation_scale = _1585.VM4_params.replace_previous_rotation_scale;
    _1589.randomness_seed = _1585.VM4_params.randomness_seed;
    _1589.replace_previous_position = _1585.VM4_params.replace_previous_position;
    _1589.randomization_input = _1585.VM4_params.randomization_input;
    _1589.position_modifier_base = _1585.VM4_params.position_modifier_base;
    _1589.position_modifier_base_modifier_factor = _1585.VM4_params.position_modifier_base_modifier_factor;
    _1589.position_modifier_range = _1585.VM4_params.position_modifier_range;
    _1589.position_modifier_range_modifier_factor = _1585.VM4_params.position_modifier_range_modifier_factor;
    _1589.rotation_modifier_base = _1585.VM4_params.rotation_modifier_base;
    _1589.rotation_modifier_base_modifier_factor = _1585.VM4_params.rotation_modifier_base_modifier_factor;
    _1589.rotation_modifier_range = _1585.VM4_params.rotation_modifier_range;
    _1589.rotation_modifier_range_modifier_factor = _1585.VM4_params.rotation_modifier_range_modifier_factor;
    _1589.scale_modifier_base = _1585.VM4_params.scale_modifier_base;
    _1589.scale_modifier_base_modifier_factor = _1585.VM4_params.scale_modifier_base_modifier_factor;
    _1589.scale_modifier_range = _1585.VM4_params.scale_modifier_range;
    _1589.scale_modifier_range_modifier_factor = _1585.VM4_params.scale_modifier_range_modifier_factor;
    InstanceModifierRandomizerV2_Params param_15 = _1589;
    ModifierFactor param_16 = modifier_factor;
    Instance param_17 = instance;
    uint param_18 = id;
    instance_modifier_randomizer_v2(param_15, param_16, param_17, param_18);
    modifier_factor = param_16;
    instance = param_17;
    _1602.instance_transform[(instance_id * 3u) + 0u] = instance.m0;
    _1602.instance_transform[(instance_id * 3u) + 1u] = instance.m1;
    _1602.instance_transform[(instance_id * 3u) + 2u] = instance.m2;
    _1625.instance_color[(instance_id * 2u) + 0u] = packHalf2x16(instance.c.xy);
    _1625.instance_color[(instance_id * 2u) + 1u] = packHalf2x16(instance.c.zw);
    _1645.instance_hash[instance_id] = instance.hash;
    _1653.instance_flipbook_card[instance_id] = instance.flipbook_card;
}

 