#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
layout(triangles) in;
layout(max_vertices = 3, triangle_strip) out;

struct PartitionGeometryDrawParams
{
    uint instance_idx;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct LightProperties
{
    vec4 diffuse;
    vec4 direction;
    vec4 position;
    vec4 up;
    vec4 right;
    vec2 dimensions;
    vec2 _pad1;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 2, binding = 1, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_raytrace_recip;
    vec4 grid_size_voxelize;
    vec4 grid_size_voxelize_recip;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 2, binding = 3, std140) uniform PartitionGeometryDrawParamsBuffer
{
    PartitionGeometryDrawParams partition_geometry_params;
} _83;

layout(set = 2, binding = 2, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _96;

layout(location = 1) in Vertex
{
    vec3 vLocalPos;
    vec4 vColor;
    vec2 vUV0;
    uint vIdx;
} vtx_inputs[3];

layout(location = 3) flat out vec3 vTriNormal;
layout(location = 5) flat out uint vTriIndex[3];
layout(location = 4) flat out vec3 vTriNormalForLighting;
layout(location = 0) flat out int vOrientationIndex;
layout(location = 1) out vec3 vGridCoords;
layout(location = 2) out vec2 vUV0;
layout(location = 8) out vec4 vColor;

void main()
{
    vec3 bbox_origin = in_bbox_data.bbox_voxelize_min.xyz;
    vec3 bbox_grid_size = in_bbox_data.grid_size_voxelize.xyz;
    vec3 n = cross(vtx_inputs[1].vLocalPos - vtx_inputs[0].vLocalPos, vtx_inputs[2].vLocalPos - vtx_inputs[0].vLocalPos);
    vTriNormal = vec3(normalize(n));
    vec3 nn = cross(vtx_inputs[1].vLocalPos - vtx_inputs[0].vLocalPos, vtx_inputs[2].vLocalPos - vtx_inputs[0].vLocalPos);
    vec3 tri_normal_for_lighting = vec3(normalize(nn));
    n = abs(n);
    uint first_face_idx = 0u;
    if (_83.partition_geometry_params.instance_idx > 0u)
    {
        first_face_idx = _96.transformed_data_location[_83.partition_geometry_params.instance_idx - 1u].last_face_idx + 1u;
    }
    vec3 v0 = vtx_inputs[0].vLocalPos;
    vec3 v1 = vtx_inputs[1].vLocalPos;
    vec3 v2 = vtx_inputs[2].vLocalPos;
    vec3 s = -bbox_origin;
    v0 += s;
    v1 += s;
    v2 += s;
    vec3 f = vec3(1.0) / bbox_grid_size;
    v0 *= f;
    v1 *= f;
    v2 *= f;
    float area = length(cross(v1 - v0, v2 - v0));
    if (area <= 0.001000000047497451305389404296875)
    {
        return;
    }
    vec3 grid_v0 = v0;
    vec3 grid_v1 = v1;
    vec3 grid_v2 = v2;
    vec3 tri_normal = vec3(cross(v1 - v0, v2 - v1) / vec3(area));
    bool _181 = n.x > n.y;
    bool _190;
    if (_181)
    {
        _190 = n.x > n.z;
    }
    else
    {
        _190 = _181;
    }
    int orientation_index;
    if (_190)
    {
        grid_v0 = grid_v0.yzx;
        grid_v1 = grid_v1.yzx;
        grid_v2 = grid_v2.yzx;
        orientation_index = 0;
    }
    else
    {
        bool _206 = n.y > n.x;
        bool _214;
        if (_206)
        {
            _214 = n.y > n.z;
        }
        else
        {
            _214 = _206;
        }
        if (_214)
        {
            grid_v0 = grid_v0.zxy;
            grid_v1 = grid_v1.zxy;
            grid_v2 = grid_v2.zxy;
            orientation_index = 1;
        }
        else
        {
            grid_v0 = grid_v0;
            grid_v1 = grid_v1;
            grid_v2 = grid_v2;
            orientation_index = 2;
        }
    }
    vTriIndex[0] = vtx_inputs[0].vIdx;
    vTriIndex[1] = vtx_inputs[1].vIdx;
    vTriIndex[2] = vtx_inputs[2].vIdx;
    vTriNormalForLighting = vec3(tri_normal_for_lighting);
    vTriNormal = vec3(tri_normal);
    gl_PrimitiveID = gl_PrimitiveIDIn + int(first_face_idx);
    vOrientationIndex = orientation_index;
    gl_Position = vec4((grid_v0 * 2.0) - vec3(256.0), 256.0);
    vGridCoords = grid_v0;
    vUV0 = vtx_inputs[0].vUV0;
    vColor = vtx_inputs[2].vColor;
    EmitVertex();
    vTriIndex[0] = vtx_inputs[0].vIdx;
    vTriIndex[1] = vtx_inputs[1].vIdx;
    vTriIndex[2] = vtx_inputs[2].vIdx;
    vTriNormalForLighting = vec3(tri_normal_for_lighting);
    vTriNormal = vec3(tri_normal);
    gl_PrimitiveID = gl_PrimitiveIDIn + int(first_face_idx);
    vOrientationIndex = orientation_index;
    gl_Position = vec4((grid_v1 * 2.0) - vec3(256.0), 256.0);
    vGridCoords = grid_v1;
    vUV0 = vtx_inputs[1].vUV0;
    vColor = vtx_inputs[2].vColor;
    EmitVertex();
    vTriIndex[0] = vtx_inputs[0].vIdx;
    vTriIndex[1] = vtx_inputs[1].vIdx;
    vTriIndex[2] = vtx_inputs[2].vIdx;
    vTriNormalForLighting = vec3(tri_normal_for_lighting);
    vTriNormal = vec3(tri_normal);
    gl_PrimitiveID = gl_PrimitiveIDIn + int(first_face_idx);
    vOrientationIndex = orientation_index;
    gl_Position = vec4((grid_v2 * 2.0) - vec3(256.0), 256.0);
    vGridCoords = grid_v2;
    vUV0 = vtx_inputs[2].vUV0;
    vColor = vtx_inputs[2].vColor;
    EmitVertex();
    EndPrimitive();
}

 