#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ModifierFactorFromCustom_Params
{
    uint modifier_function;
    int _pad0;
    int _pad1;
    int _pad2;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorClamp_Params
{
    float clamp_min;
    float clamp_max;
    int clamp_min_enable;
    int clamp_max_enable;
};

struct VertexModifierColorizeParams
{
    vec3 color;
    float alpha;
    int use_gradient;
    float color_blend;
    float alpha_blend;
    int color_gradient_idx;
    int mixing_mode;
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct ModifierFactorMulAdd_Params
{
    float multiply_value;
    float add_value;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct VertexModifierDisplaceParams
{
    vec3 displace_normal;
    float displace_normal_modifier_factor;
    vec3 displace_base;
    float displace_base_modifier_factor;
    int influence_scope;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct _1697
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 10, scalar) uniform GeometryInformationBuffer
{
    GeometryInformation geometry_information;
} _640;

layout(set = 0, binding = 1, std430) readonly buffer VTXCoords
{
    float coords[];
} vtx_coords;

layout(set = 0, binding = 2, std430) readonly buffer VTXNormals
{
    float normals[];
} vtx_normals;

layout(set = 0, binding = 3, std430) readonly buffer VTXAlbedo
{
    float albedo[];
} vtx_albedo;

layout(set = 0, binding = 4, std430) readonly buffer VTXUV0
{
    float uv0[];
} vtx_uv0;

layout(set = 0, binding = 5, std430) readonly buffer VTXCustom0
{
    uint custom0[];
} vtx_custom0;

layout(set = 0, binding = 11, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1262;

layout(set = 0, binding = 6, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _1273;

layout(set = 0, binding = 7, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1361;

layout(set = 0, binding = 8, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _1553;

layout(set = 0, binding = 12, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _1594;

layout(set = 0, binding = 13, std140) uniform VM0
{
    ModifierFactorFromCustom_Params VM0_params;
} _1607;

layout(set = 0, binding = 14, std140) uniform VM1
{
    ModifierFactorClamp_Params VM1_params;
} _1622;

layout(set = 0, binding = 15, std140) uniform VM2
{
    VertexModifierColorizeParams VM2_params;
} _1635;

layout(set = 0, binding = 16, std140) uniform VM3
{
    ModifierFactorMulAdd_Params VM3_params;
} _1654;

layout(set = 0, binding = 17, std140) uniform VM4
{
    layout(row_major) ModifierFactorNoise_Params VM4_params;
} _1667;

layout(set = 0, binding = 18, std140) uniform VM5
{
    VertexModifierDisplaceParams VM5_params;
} _1682;

layout(set = 0, binding = 9, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _1792;

layout(set = 0, binding = 19) uniform sampler2D s_Gradients;

layout(location = 1) out _1697 vtx_output;
layout(location = 0) out uint instanceID;

vec3 vtx_coords_load(inout uint idx)
{
    idx *= _640.geometry_information.attributes[0].stride;
    idx += _640.geometry_information.attributes[0].offset;
    return vec3(vtx_coords.coords[idx + 0u], vtx_coords.coords[idx + 1u], vtx_coords.coords[idx + 2u]);
}

vec3 vtx_albedo_load(inout uint idx)
{
    idx *= _640.geometry_information.attributes[2].stride;
    idx += _640.geometry_information.attributes[2].offset;
    return vec3(vtx_albedo.albedo[idx + 0u], vtx_albedo.albedo[idx + 1u], vtx_albedo.albedo[idx + 2u]);
}

vec3 vtx_normals_load(inout uint idx)
{
    idx *= _640.geometry_information.attributes[1].stride;
    idx += _640.geometry_information.attributes[1].offset;
    return vec3(vtx_normals.normals[idx + 0u], vtx_normals.normals[idx + 1u], vtx_normals.normals[idx + 2u]);
}

vec2 vtx_uv0_load(inout uint idx)
{
    idx *= _640.geometry_information.attributes[3].stride;
    idx += _640.geometry_information.attributes[3].offset;
    return vec2(vtx_uv0.uv0[idx + 0u], vtx_uv0.uv0[idx + 1u]);
}

float det(mat2 matrix)
{
    return (matrix[0].x * matrix[1].y) - (matrix[0].y * matrix[1].x);
}

mat3 transpose_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat3 result = mat3(vec3(vec3(row0.x, row1.x, row2.x)), vec3(vec3(row0.y, row1.y, row2.y)), vec3(vec3(row0.z, row1.z, row2.z)));
    return result;
}

mat3 inverse_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat2 param = mat2(vec2(row1.y, row1.z), vec2(row2.y, row2.z));
    mat2 param_1 = mat2(vec2(row1.z, row1.x), vec2(row2.z, row2.x));
    mat2 param_2 = mat2(vec2(row1.x, row1.y), vec2(row2.x, row2.y));
    vec3 minors0 = vec3(det(param), det(param_1), det(param_2));
    mat2 param_3 = mat2(vec2(row2.y, row2.z), vec2(row0.y, row0.z));
    mat2 param_4 = mat2(vec2(row2.z, row2.x), vec2(row0.z, row0.x));
    mat2 param_5 = mat2(vec2(row2.x, row2.y), vec2(row0.x, row0.y));
    vec3 minors1 = vec3(det(param_3), det(param_4), det(param_5));
    mat2 param_6 = mat2(vec2(row0.y, row0.z), vec2(row1.y, row1.z));
    mat2 param_7 = mat2(vec2(row0.z, row0.x), vec2(row1.z, row1.x));
    mat2 param_8 = mat2(vec2(row0.x, row0.y), vec2(row1.x, row1.y));
    vec3 minors2 = vec3(det(param_6), det(param_7), det(param_8));
    mat3 param_9 = mat3(vec3(minors0), vec3(minors1), vec3(minors2));
    mat3 adj = transpose_mat3(param_9);
    return adj * (1.0 / dot(row0, minors0));
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

uint vtx_custom0_load(inout uint idx)
{
    idx *= _640.geometry_information.attributes[6].stride;
    idx += _640.geometry_information.attributes[6].offset;
    return vtx_custom0.custom0[idx + 0u];
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_from_custom(ModifierFactorFromCustom_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    float v = uintBitsToFloat(modifier_factor.custom0);
    ModifierFactor param = modifier_factor;
    uint param_1 = modifier_params.modifier_function;
    float param_2 = v;
    modifier_process_modifier_factor(param, param_1, param_2);
    modifier_factor = param;
}

void modifier_factor_clamp(ModifierFactorClamp_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    if (modifier_params.clamp_min_enable != 0)
    {
        v = max(v, modifier_params.clamp_min);
    }
    if (modifier_params.clamp_max_enable != 0)
    {
        v = min(v, modifier_params.clamp_max);
    }
    modifier_factor.factor = v;
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

void vertex_modifier_colorize_apply(VertexModifierColorizeParams modifier_params, ModifierFactor modifier_factor, inout VertexInput vtx)
{
    vec3 c = vec3(1.0);
    float a = modifier_params.alpha;
    if (modifier_params.use_gradient != 0)
    {
        int param = modifier_params.color_gradient_idx;
        float param_1 = modifier_factor.factor;
        c = gradient_sample(param, param_1).xyz;
        c *= modifier_params.color;
    }
    else
    {
        c = modifier_params.color;
    }
    if (modifier_params.mixing_mode == 0)
    {
        if (modifier_params.use_gradient == 0)
        {
            c *= modifier_factor.factor;
        }
        a *= modifier_factor.factor;
    }
    if (modifier_params.mixing_mode == 1)
    {
        c = mix(vtx.color.xyz, c, vec3(modifier_factor.factor));
        a = mix(vtx.color.w, a, modifier_factor.factor);
    }
    if (modifier_params.mixing_mode == 2)
    {
        c = vtx.color.xyz + (c * modifier_factor.factor);
        a = vtx.color.w + (a * modifier_factor.factor);
    }
    vec4 _904 = vtx.color;
    vec3 _910 = mix(_904.xyz, c, vec3(modifier_params.color_blend));
    vtx.color.x = _910.x;
    vtx.color.y = _910.y;
    vtx.color.z = _910.z;
    vtx.color.w = mix(vtx.color.w, a, modifier_params.alpha_blend);
}

void modifier_factor_mul_add(ModifierFactorMulAdd_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v * modifier_params.multiply_value) + modifier_params.add_value;
    modifier_factor.factor = v;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_factor_noise_default(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _951 = vector_transform_by_mat43(param, param_1);
        coords = _951;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _958 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _958;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

void _vertex_modifier_displace_apply(VertexModifierDisplaceParams params, ModifierFactor modifier_factor, inout VertexInput vtx, CoordinateSystemTrasforms cs_transforms)
{
    vec3 modifier_position = vec3(0.0);
    float influence = modifier_factor.factor;
    if (influence != 0.0)
    {
        vec3 n = vtx.norm;
        vec3 p = vtx.pos;
        p += ((params.displace_base * params.displace_base_modifier_factor) * influence);
        p += (((n * params.displace_normal) * params.displace_normal_modifier_factor) * influence);
        vtx.pos = p;
    }
}

void vertex_modifier_displace_apply(VertexModifierDisplaceParams params, inout ModifierFactor modifier_factor, inout VertexInput vtx, CoordinateSystemTrasforms cs_transforms)
{
    VertexModifierDisplaceParams param = params;
    ModifierFactor param_1 = modifier_factor;
    VertexInput param_2 = vtx;
    CoordinateSystemTrasforms param_3 = cs_transforms;
    _vertex_modifier_displace_apply(param, param_1, param_2, param_3);
    modifier_factor = param_1;
    vtx = param_2;
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    return m * vec4(v, 1.0);
}

void main()
{
    uint load_vertex_idx = uint(gl_VertexIndex);
    if (_1262.instance_params.stride > 0)
    {
        uint flipbook_card = _1273.instance_flipbook_card[gl_InstanceIndex];
        flipbook_card = min(flipbook_card, (_640.geometry_information.flipbook_cards_num - 1u));
        load_vertex_idx += (_640.geometry_information.vtx_num * flipbook_card);
    }
    VertexInput vtx_input;
    vtx_input.id = uint(gl_VertexIndex);
    uint param = load_vertex_idx;
    vec3 _1295 = vtx_coords_load(param);
    vtx_input.pos = _1295;
    vtx_input.norm = vec3(1.0, 0.0, 0.0);
    vtx_input.color = vec4(1.0);
    vtx_input.uv0 = vtx_input.pos.xy;
    if ((_640.geometry_information.builtin_attribute_mask & 4u) != 0u)
    {
        uint param_1 = uint(gl_VertexIndex);
        vec3 _1313 = vtx_albedo_load(param_1);
        vtx_input.color.x = _1313.x;
        vtx_input.color.y = _1313.y;
        vtx_input.color.z = _1313.z;
    }
    if ((_640.geometry_information.builtin_attribute_mask & 2u) != 0u)
    {
        uint param_2 = load_vertex_idx;
        vec3 _1328 = vtx_normals_load(param_2);
        vtx_input.norm = _1328;
    }
    if ((_640.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_3 = uint(gl_VertexIndex);
        vec2 _1339 = vtx_uv0_load(param_3);
        vtx_input.uv0 = _1339;
    }
    mat4 mat_instance_model;
    mat_instance_model[0] = vec4(1.0, 0.0, 0.0, 0.0);
    mat_instance_model[1] = vec4(0.0, 1.0, 0.0, 0.0);
    mat_instance_model[2] = vec4(0.0, 0.0, 1.0, 0.0);
    mat_instance_model[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 mat_instance_model_inv = mat_instance_model;
    if (_1262.instance_params.stride > 0)
    {
        vec4 inst_m0 = _1361.instance_transform[(gl_InstanceIndex * _1262.instance_params.stride) + 0];
        vec4 inst_m1 = _1361.instance_transform[(gl_InstanceIndex * _1262.instance_params.stride) + 1];
        vec4 inst_m2 = _1361.instance_transform[(gl_InstanceIndex * _1262.instance_params.stride) + 2];
        vec3 _1392 = vec3(inst_m0.x, inst_m1.x, inst_m2.x);
        mat_instance_model[0].x = _1392.x;
        mat_instance_model[0].y = _1392.y;
        mat_instance_model[0].z = _1392.z;
        vec3 _1405 = vec3(inst_m0.y, inst_m1.y, inst_m2.y);
        mat_instance_model[1].x = _1405.x;
        mat_instance_model[1].y = _1405.y;
        mat_instance_model[1].z = _1405.z;
        vec3 _1418 = vec3(inst_m0.z, inst_m1.z, inst_m2.z);
        mat_instance_model[2].x = _1418.x;
        mat_instance_model[2].y = _1418.y;
        mat_instance_model[2].z = _1418.z;
        vec3 _1431 = vec3(inst_m0.w, inst_m1.w, inst_m2.w);
        mat_instance_model[3].x = _1431.x;
        mat_instance_model[3].y = _1431.y;
        mat_instance_model[3].z = _1431.z;
        mat_instance_model_inv = mat_instance_model;
        mat3 param_4 = mat3(mat_instance_model_inv[0].xyz, mat_instance_model_inv[1].xyz, mat_instance_model_inv[2].xyz);
        mat3 inv = inverse_mat3(param_4);
        mat_instance_model_inv[0].x = inv[0].x;
        mat_instance_model_inv[0].y = inv[0].y;
        mat_instance_model_inv[0].z = inv[0].z;
        mat_instance_model_inv[1].x = inv[1].x;
        mat_instance_model_inv[1].y = inv[1].y;
        mat_instance_model_inv[1].z = inv[1].z;
        mat_instance_model_inv[2].x = inv[2].x;
        mat_instance_model_inv[2].y = inv[2].y;
        mat_instance_model_inv[2].z = inv[2].z;
        mat_instance_model_inv[3].x = -(((inv[0].x * mat_instance_model[3].x) + (inv[1].x * mat_instance_model[3].y)) + (inv[2].x * mat_instance_model[3].z));
        mat_instance_model_inv[3].y = -(((inv[0].y * mat_instance_model[3].x) + (inv[1].y * mat_instance_model[3].y)) + (inv[2].y * mat_instance_model[3].z));
        mat_instance_model_inv[3].z = -(((inv[0].z * mat_instance_model[3].x) + (inv[1].z * mat_instance_model[3].y)) + (inv[2].z * mat_instance_model[3].z));
    }
    VertexInput vtx_modifier_input_base = vtx_input;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = uint(gl_VertexIndex);
    modifier_factor.id = uint(gl_VertexIndex);
    modifier_factor.instance_id = uint(gl_InstanceIndex);
    if (_1262.instance_params.stride > 0)
    {
        modifier_factor.instance_id = _1553.instance_hash[gl_InstanceIndex];
    }
    modifier_factor.position = vtx_input.pos;
    modifier_factor.normal = vtx_input.norm;
    modifier_factor.color = vtx_input.color;
    if ((_640.geometry_information.builtin_attribute_mask & 64u) != 0u)
    {
        uint param_5 = uint(gl_VertexIndex);
        uint _1576 = vtx_custom0_load(param_5);
        modifier_factor.custom0 = _1576;
    }
    if ((_640.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_6 = uint(gl_VertexIndex);
        vec2 _1587 = vtx_uv0_load(param_6);
        modifier_factor.uv0 = _1587;
    }
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _1594.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_instance_model;
    cs_transforms.mat_local_to_model_inv = _1594.transform_params.mModelInv;
    ModifierFactorFromCustom_Params _1612;
    _1612.modifier_function = _1607.VM0_params.modifier_function;
    _1612._pad0 = _1607.VM0_params._pad0;
    _1612._pad1 = _1607.VM0_params._pad1;
    _1612._pad2 = _1607.VM0_params._pad2;
    ModifierFactorFromCustom_Params param_7 = _1612;
    ModifierFactor param_8 = modifier_factor;
    CoordinateSystemTrasforms param_9 = cs_transforms;
    modifier_factor_from_custom(param_7, param_8, param_9);
    modifier_factor = param_8;
    ModifierFactorClamp_Params _1627;
    _1627.clamp_min = _1622.VM1_params.clamp_min;
    _1627.clamp_max = _1622.VM1_params.clamp_max;
    _1627.clamp_min_enable = _1622.VM1_params.clamp_min_enable;
    _1627.clamp_max_enable = _1622.VM1_params.clamp_max_enable;
    ModifierFactorClamp_Params param_10 = _1627;
    ModifierFactor param_11 = modifier_factor;
    modifier_factor_clamp(param_10, param_11);
    modifier_factor = param_11;
    VertexModifierColorizeParams _1640;
    _1640.color = _1635.VM2_params.color;
    _1640.alpha = _1635.VM2_params.alpha;
    _1640.use_gradient = _1635.VM2_params.use_gradient;
    _1640.color_blend = _1635.VM2_params.color_blend;
    _1640.alpha_blend = _1635.VM2_params.alpha_blend;
    _1640.color_gradient_idx = _1635.VM2_params.color_gradient_idx;
    _1640.mixing_mode = _1635.VM2_params.mixing_mode;
    VertexModifierColorizeParams param_12 = _1640;
    ModifierFactor param_13 = modifier_factor;
    VertexInput param_14 = vtx_input;
    vertex_modifier_colorize_apply(param_12, param_13, param_14);
    modifier_factor = param_13;
    vtx_input = param_14;
    modifier_factor.position = vtx_input.pos;
    ModifierFactorMulAdd_Params _1659;
    _1659.multiply_value = _1654.VM3_params.multiply_value;
    _1659.add_value = _1654.VM3_params.add_value;
    ModifierFactorMulAdd_Params param_15 = _1659;
    ModifierFactor param_16 = modifier_factor;
    modifier_factor_mul_add(param_15, param_16);
    modifier_factor = param_16;
    ModifierFactorNoise_Params _1672;
    _1672.transform_local_to_gizmo = _1667.VM4_params.transform_local_to_gizmo;
    _1672.noise_domain_scale = _1667.VM4_params.noise_domain_scale;
    _1672.modifier_function = _1667.VM4_params.modifier_function;
    _1672.noise_domain_offset = _1667.VM4_params.noise_domain_offset;
    _1672.noise_value_scale = _1667.VM4_params.noise_value_scale;
    _1672.noise_value_offset = _1667.VM4_params.noise_value_offset;
    _1672.influence_scope = _1667.VM4_params.influence_scope;
    _1672._pad0 = _1667.VM4_params._pad0;
    _1672._pad1 = _1667.VM4_params._pad1;
    ModifierFactorNoise_Params param_17 = _1672;
    ModifierFactor param_18 = modifier_factor;
    CoordinateSystemTrasforms param_19 = cs_transforms;
    modifier_factor_noise_default(param_17, param_18, param_19);
    modifier_factor = param_18;
    VertexModifierDisplaceParams _1687;
    _1687.displace_normal = _1682.VM5_params.displace_normal;
    _1687.displace_normal_modifier_factor = _1682.VM5_params.displace_normal_modifier_factor;
    _1687.displace_base = _1682.VM5_params.displace_base;
    _1687.displace_base_modifier_factor = _1682.VM5_params.displace_base_modifier_factor;
    _1687.influence_scope = _1682.VM5_params.influence_scope;
    VertexModifierDisplaceParams param_20 = _1687;
    ModifierFactor param_21 = modifier_factor;
    VertexInput param_22 = vtx_input;
    CoordinateSystemTrasforms param_23 = cs_transforms;
    vertex_modifier_displace_apply(param_20, param_21, param_22, param_23);
    modifier_factor = param_21;
    vtx_input = param_22;
    vtx_output.vLocalPos = vtx_input.pos;
    instanceID = uint(gl_InstanceIndex);
    if (_1262.instance_params.stride > 0)
    {
        vec4 inst_m0_1 = _1361.instance_transform[(gl_InstanceIndex * _1262.instance_params.stride) + 0];
        vec4 inst_m1_1 = _1361.instance_transform[(gl_InstanceIndex * _1262.instance_params.stride) + 1];
        vec4 inst_m2_1 = _1361.instance_transform[(gl_InstanceIndex * _1262.instance_params.stride) + 2];
        vec4 v = vec4(vtx_input.pos, 1.0);
        vtx_input.pos.x = dot(inst_m0_1, v);
        vtx_input.pos.y = dot(inst_m1_1, v);
        vtx_input.pos.z = dot(inst_m2_1, v);
        vec3 param_24 = vtx_input.norm;
        mat4 param_25 = transpose(mat4(vec4(inst_m0_1), vec4(inst_m1_1), vec4(inst_m2_1), vec4(0.0, 0.0, 0.0, 1.0)));
        vtx_input.norm = normalize(vector_transform_by_mat33(param_24, param_25));
        vec2 _1798 = unpackHalf2x16(_1792.instance_color[(gl_InstanceIndex * 2) + 0]);
        vec4 inst_c;
        inst_c.x = _1798.x;
        inst_c.y = _1798.y;
        vec2 _1808 = unpackHalf2x16(_1792.instance_color[(gl_InstanceIndex * 2) + 1]);
        inst_c.z = _1808.x;
        inst_c.w = _1808.y;
        vec4 _1814 = vtx_input.color;
        vec3 _1818 = _1814.xyz * inst_c.xyz;
        vtx_input.color.x = _1818.x;
        vtx_input.color.y = _1818.y;
        vtx_input.color.z = _1818.z;
        vtx_input.color.w *= inst_c.w;
    }
    vec3 param_26 = vtx_input.pos;
    mat4 param_27 = _1594.transform_params.mModel;
    vec3 _1838 = vector_transform_by_mat43(param_26, param_27);
    vec3 vPosModel = _1838;
    vec3 param_28 = vtx_input.norm;
    mat4 param_29 = _1594.transform_params.mModelNormal;
    vtx_output.vWorldNorm = vector_transform_by_mat33(param_28, param_29);
    vec3 param_30 = vPosModel;
    mat4 param_31 = _1594.transform_params.mView;
    vec3 _1853 = vector_transform_by_mat43(param_30, param_31);
    vec3 vPosModelView = _1853;
    vtx_output.vCoords = vPosModelView;
    vtx_output.vCameraRelativeWorldPos = vPosModel - _1594.transform_params.vCameraPosition;
    vtx_output.vNorm.x = dot(_1594.transform_params.mModelViewInvTrans[0].xyz, vtx_input.norm);
    vtx_output.vNorm.y = dot(_1594.transform_params.mModelViewInvTrans[1].xyz, vtx_input.norm);
    vtx_output.vNorm.z = dot(_1594.transform_params.mModelViewInvTrans[2].xyz, vtx_input.norm);
    vtx_output.vNorm = vtx_input.norm;
    vtx_output.vColor = vtx_input.color;
    vtx_output.vUV0 = vtx_input.uv0;
    vec3 param_32 = vtx_output.vCoords;
    mat4 param_33 = _1594.transform_params.mProjection;
    vec4 _1906 = vector_transform_by_mat_projection(param_32, param_33);
    gl_Position = _1906;
}

 