#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct InstanceModifierRandomizerV2_Params
{
    int replace_previous_rotation_scale;
    int randomness_seed;
    int replace_previous_position;
    int randomization_input;
    vec3 position_modifier_base;
    float position_modifier_base_modifier_factor;
    vec3 position_modifier_range;
    float position_modifier_range_modifier_factor;
    vec3 rotation_modifier_base;
    float rotation_modifier_base_modifier_factor;
    vec3 rotation_modifier_range;
    float rotation_modifier_range_modifier_factor;
    vec3 scale_modifier_base;
    float scale_modifier_base_modifier_factor;
    vec3 scale_modifier_range;
    float scale_modifier_range_modifier_factor;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorWaveTransfer_Params
{
    int type;
    int modulate;
    float frequency;
    float phase_shift;
    float amplitude;
    float base;
};

struct InstanceModifierFactorToColor_Params
{
    vec3 color;
    int use_gradient;
    int color_gradient_idx;
    int mixing_mode;
};

struct InstancingGeneratorParams
{
    int first_ribbon;
    int skip_ribbons;
    int skip_segments;
    int num_ribbons;
    int base_segment;
    int segments;
};

struct RibbonRenderParams
{
    int max_segments;
    int base_idx;
    int base_segment;
    int particles_per_segment;
    float thickness;
    int lights_num;
    int material_index;
    float first_segment_time_factor;
    int render_as_strips;
    int _pad0;
    int _pad1;
    int _pad2;
};

struct ParticleRibbonState
{
    float generation_id;
    uint segments;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _361;

layout(set = 0, binding = 10, std140) uniform InstancingGeneratorParamsBuffer
{
    InstancingGeneratorParams instancing_generator_params;
} _1325;

layout(set = 0, binding = 11, std140) uniform RibbonRenderParamsBuffer
{
    RibbonRenderParams ribbon_render_params;
} _1338;

layout(set = 0, binding = 2, std430) readonly buffer RibbonStatesData
{
    ParticleRibbonState states[];
} prt_states_snapshots;

layout(set = 0, binding = 3, std430) buffer RibbonPositionsData
{
    float position[];
} prt_position_snapshots;

layout(set = 0, binding = 4, std430) buffer InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1534;

layout(set = 0, binding = 12, std140) uniform VM0
{
    InstanceModifierRandomizerV2_Params VM0_params;
} _1597;

layout(set = 0, binding = 13, std140) uniform VM1
{
    layout(row_major) ModifierFactorNoise_Params VM1_params;
} _1623;

layout(set = 0, binding = 14, std140) uniform VM2
{
    InstanceModifierRandomizerV2_Params VM2_params;
} _1637;

layout(set = 0, binding = 15, std140) uniform VM3
{
    ModifierFactorWaveTransfer_Params VM3_params;
} _1662;

layout(set = 0, binding = 5, std430) buffer VM4
{
    InstanceModifierFactorToColor_Params VM4_params;
} _1675;

layout(set = 0, binding = 6, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1691;

layout(set = 0, binding = 7, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _1714;

layout(set = 0, binding = 8, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _1734;

layout(set = 0, binding = 9, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _1742;

layout(set = 0, binding = 16) uniform sampler2D s_Gradients;

bool prt_is_alive(uint id)
{
    return _361.prt_states[id].life_time < _361.prt_states[id].life_span;
}

vec3 color_convert_uint_to_float3(uint vi)
{
    vec3 v = vec3(0.0);
    uint v_mag = vi >> uint(24);
    float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
    v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
    v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
    v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
    return v;
}

vec4 prt_get_color(uint id)
{
    vec4 c = vec4(1.0);
    uint param = _361.prt_states[id].color;
    vec3 _388 = color_convert_uint_to_float3(param);
    c.x = _388.x;
    c.y = _388.y;
    c.z = _388.z;
    return c;
}

ParticleState prt_get_state(uint id)
{
    ParticleState _378;
    _378.life_time = _361.prt_states[id].life_time;
    _378.life_span = _361.prt_states[id].life_span;
    _378.generation_id = _361.prt_states[id].generation_id;
    _378.color = _361.prt_states[id].color;
    ParticleState _377 = _378;
    return _377;
}

int calculate_vidx_for_ribbon_segment(int ribbon_id, inout int ribbon_segment)
{
    ribbon_segment = _1325.instancing_generator_params.base_segment - ribbon_segment;
    if (ribbon_segment < 0)
    {
        ribbon_segment += _1338.ribbon_render_params.max_segments;
    }
    if (ribbon_segment >= _1338.ribbon_render_params.max_segments)
    {
        ribbon_segment -= _1338.ribbon_render_params.max_segments;
    }
    int vidx = (ribbon_segment * _1338.ribbon_render_params.particles_per_segment) + ribbon_id;
    return vidx;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

uint hash(uvec3 v)
{
    uint param = v.y;
    uint _316 = hash(param);
    uint param_1 = v.z;
    uint _321 = hash(param_1);
    uint param_2 = (v.x ^ _316) ^ _321;
    uint _324 = hash(param_2);
    return _324;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(vec3 v)
{
    uvec3 param = floatBitsToUint(v);
    uint param_1 = hash(param);
    float _353 = floatConstruct(param_1);
    return _353;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _343 = hash(param);
    uint param_1 = _343;
    float _345 = floatConstruct(param_1);
    return _345;
}

void instance_modifier_randomizer_v2(InstanceModifierRandomizerV2_Params modifier_params, ModifierFactor modifier_factor, inout Instance instance, uint id)
{
    float influence = modifier_factor.factor;
    float fid = float(id);
    if (modifier_params.randomization_input == 0)
    {
        fid = float(id);
    }
    if (modifier_params.randomization_input == 1)
    {
        vec3 param = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
        fid = random(param);
    }
    if (modifier_params.randomization_input == 2)
    {
        float param_1 = uintBitsToFloat(instance.hash);
        fid = random(param_1);
    }
    float param_2 = fid;
    vec3 angles;
    angles.x = random(param_2);
    float param_3 = fid + 123.3000030517578125;
    angles.y = random(param_3);
    float param_4 = (fid * 2.131700038909912109375) + 13.4137096405029296875;
    angles.z = random(param_4);
    if (modifier_params.randomization_input == 3)
    {
        angles = vec3(1.0);
    }
    angles = (modifier_params.rotation_modifier_base * (modifier_params.rotation_modifier_base_modifier_factor * influence)) + ((angles * modifier_params.rotation_modifier_range) * (modifier_params.rotation_modifier_range_modifier_factor * influence));
    float param_5 = fid;
    vec3 scales;
    scales.x = random(param_5);
    scales.y = scales.x;
    scales.z = scales.x;
    if (modifier_params.randomization_input == 3)
    {
        scales = vec3(1.0);
    }
    scales = mix(vec3(1.0), modifier_params.scale_modifier_base, vec3(modifier_params.scale_modifier_base_modifier_factor * influence)) + ((scales * modifier_params.scale_modifier_range) * (modifier_params.scale_modifier_range_modifier_factor * influence));
    float param_6 = fid;
    vec3 translations;
    translations.x = random(param_6);
    float param_7 = fid + 123.73169708251953125;
    translations.y = random(param_7);
    float param_8 = (fid * 2.131700038909912109375) + 13.71000003814697265625;
    translations.z = random(param_8);
    if (modifier_params.randomization_input == 3)
    {
        translations = vec3(1.0);
    }
    else
    {
        translations = normalize(translations);
    }
    translations = (modifier_params.position_modifier_base * (modifier_params.position_modifier_base_modifier_factor * influence)) + ((translations * modifier_params.position_modifier_range) * (modifier_params.position_modifier_range_modifier_factor * influence));
    float cosb = cos(angles.z);
    float sinb = sin(angles.z);
    float cosp = cos(angles.x);
    float sinp = sin(angles.x);
    float _cosh = cos(angles.y);
    float _sinh = sin(angles.y);
    vec3 mx;
    mx.x = (_cosh * cosb) + ((_sinh * sinp) * sinb);
    mx.y = ((_sinh * sinp) * cosb) - (_cosh * sinb);
    mx.z = _sinh * cosp;
    vec3 my;
    my.x = cosp * sinb;
    my.y = cosp * cosb;
    my.z = -sinp;
    vec3 mz;
    mz.x = ((_cosh * sinp) * sinb) - (_sinh * cosb);
    mz.y = (_sinh * sinb) + ((_cosh * sinp) * cosb);
    mz.z = _cosh * cosp;
    mat4 tm_rot;
    tm_rot[0] = vec4(mx.x, my.x, mz.x, translations.x);
    tm_rot[1] = vec4(mx.y, my.y, mz.y, translations.y);
    tm_rot[2] = vec4(mx.z, my.z, mz.z, translations.z);
    tm_rot[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 tm_sc;
    tm_sc[0] = vec4(scales.x, 0.0, 0.0, 0.0);
    tm_sc[1] = vec4(0.0, scales.y, 0.0, 0.0);
    tm_sc[2] = vec4(0.0, 0.0, scales.z, 0.0);
    tm_sc[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 m;
    m[0] = instance.m0;
    m[1] = instance.m1;
    m[2] = instance.m2;
    m[3] = vec4(0.0, 0.0, 0.0, 1.0);
    if (modifier_params.replace_previous_rotation_scale == 0)
    {
        m = (tm_sc * tm_rot) * m;
    }
    else
    {
        mat4 lm = tm_sc * tm_rot;
        m = (tm_sc * tm_rot) * m;
        m[0].x = lm[0].xyz.x;
        m[0].y = lm[0].xyz.y;
        m[0].z = lm[0].xyz.z;
        m[1].x = lm[1].xyz.x;
        m[1].y = lm[1].xyz.y;
        m[1].z = lm[1].xyz.z;
        m[2].x = lm[2].xyz.x;
        m[2].y = lm[2].xyz.y;
        m[2].z = lm[2].xyz.z;
    }
    instance.m0 = m[0];
    instance.m1 = m[1];
    instance.m2 = m[2];
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise_default(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1120 = vector_transform_by_mat43(param, param_1);
        coords = _1120;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1127 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1127;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

void modifier_factor_wave_transfer(ModifierFactorWaveTransfer_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v * modifier_params.frequency) + modifier_params.phase_shift;
    if (modifier_params.type == 0)
    {
        v = sin((v * 3.1415927410125732421875) * 2.0);
    }
    else
    {
        if (modifier_params.type == 1)
        {
            float phase = mod(v, 1.0) - 0.5;
            v = (abs(2.0 * (phase - floor(phase + 0.5))) * 2.0) - 1.0;
        }
        else
        {
            if (modifier_params.type == 2)
            {
                float phase_1 = mod(v, 1.0) - 0.5;
                v = sign(phase_1);
            }
        }
    }
    if (modifier_params.modulate != 0)
    {
        v = modifier_factor.factor * ((v * modifier_params.amplitude) + modifier_params.base);
    }
    else
    {
        v = (v * modifier_params.amplitude) + modifier_params.base;
    }
    modifier_factor.factor = v;
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

void instance_modifier_factor_to_color(InstanceModifierFactorToColor_Params modifier_params, ModifierFactor modifier_factor, inout Instance instance)
{
    vec3 c = vec3(1.0);
    if (modifier_params.use_gradient != 0)
    {
        int param = modifier_params.color_gradient_idx;
        float param_1 = fract(modifier_factor.factor);
        c = gradient_sample(param, param_1).xyz;
        c *= modifier_params.color;
    }
    else
    {
        c = modifier_params.color * modifier_factor.factor;
    }
    if (modifier_params.mixing_mode == 0)
    {
        instance.c.x = c.x;
        instance.c.y = c.y;
        instance.c.z = c.z;
    }
    if (modifier_params.mixing_mode == 1)
    {
        vec4 _1293 = instance.c;
        vec3 _1299 = mix(_1293.xyz, c, vec3(modifier_factor.factor));
        instance.c.x = _1299.x;
        instance.c.y = _1299.y;
        instance.c.z = _1299.z;
    }
    if (modifier_params.mixing_mode == 2)
    {
        vec4 _1313 = instance.c;
        vec3 _1315 = _1313.xyz + c;
        instance.c.x = _1315.x;
        instance.c.y = _1315.y;
        instance.c.z = _1315.z;
    }
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint ribbon_id = (id * uint(_1325.instancing_generator_params.skip_ribbons)) + uint(_1325.instancing_generator_params.first_ribbon);
    if (ribbon_id >= uint(_1325.instancing_generator_params.num_ribbons))
    {
        return;
    }
    uint param = ribbon_id;
    if (prt_is_alive(param) == false)
    {
        return;
    }
    int ribbon_segments = max(0, (min(_1338.ribbon_render_params.max_segments, int(prt_states_snapshots.states[ribbon_id].segments)) - 1));
    uint param_1 = ribbon_id;
    vec4 particle_color = prt_get_color(param_1);
    uint param_2 = ribbon_id;
    ParticleState particle_state = prt_get_state(param_2);
    int emited = 0;
    CoordinateSystemTrasforms cs_transforms;
    Instance instance;
    int si = 0;
    for (;;)
    {
        if (si < ribbon_segments)
        {
            int param_3 = int(ribbon_id);
            int param_4 = si;
            int _1433 = calculate_vidx_for_ribbon_segment(param_3, param_4);
            int vidx = _1433;
            vec3 pos = vec3(prt_position_snapshots.position[(vidx * 3) + 0], prt_position_snapshots.position[(vidx * 3) + 1], prt_position_snapshots.position[(vidx * 3) + 2]);
            vec3 pos_prev = pos;
            vec3 normal = vec3(1.0, 0.0, 0.0);
            bool has_direction = true;
            bool _1465 = pos.x == pos_prev.x;
            bool _1473;
            if (_1465)
            {
                _1473 = pos.y == pos_prev.y;
            }
            else
            {
                _1473 = _1465;
            }
            bool _1481;
            if (_1473)
            {
                _1481 = pos.z == pos_prev.z;
            }
            else
            {
                _1481 = _1473;
            }
            if (_1481)
            {
                has_direction = false;
            }
            vec3 nx = vec3(1.0, 0.0, 0.0);
            vec3 ny = vec3(0.0, 1.0, 0.0);
            vec3 nz = vec3(0.0, 0.0, 1.0);
            if (has_direction)
            {
                vec3 d = normalize(pos_prev - pos);
                nz = d;
                nx = cross(nz, ny);
                ny = cross(nz, nx);
            }
            ModifierFactor modifier_factor = modifier_factor_defaults();
            modifier_factor.factor = 1.0;
            modifier_factor.hash = ribbon_id;
            modifier_factor.id = ribbon_id;
            modifier_factor.position = pos;
            modifier_factor.is_spawned = true;
            cs_transforms.mat_local_to_model = mat_identity();
            cs_transforms.mat_local_to_instance = mat_identity();
            cs_transforms.mat_local_to_model_inv = mat_identity();
            if ((modifier_factor.factor <= 9.9999997473787516355514526367188e-05) || modifier_factor.is_discarded)
            {
                int _1751 = si;
                si = _1751 + _1325.instancing_generator_params.skip_segments;
                continue;
            }
            int _1537 = atomicAdd(_1534.instance_params.instance_count, 1);
            uint instance_id = uint(_1537);
            if (instance_id >= uint(_1534.instance_params.buffer_capacity))
            {
                break;
            }
            float size = 1.0;
            nx *= size;
            ny *= size;
            nz *= size;
            instance.m0 = vec4(nx.x, ny.x, nz.x, pos.x);
            instance.m1 = vec4(nx.y, ny.y, nz.y, pos.y);
            instance.m2 = vec4(nx.z, ny.z, nz.z, pos.z);
            instance.hash = modifier_factor.hash;
            instance.c = particle_color;
            instance.flipbook_card = 0u;
            InstanceModifierRandomizerV2_Params _1602;
            _1602.replace_previous_rotation_scale = _1597.VM0_params.replace_previous_rotation_scale;
            _1602.randomness_seed = _1597.VM0_params.randomness_seed;
            _1602.replace_previous_position = _1597.VM0_params.replace_previous_position;
            _1602.randomization_input = _1597.VM0_params.randomization_input;
            _1602.position_modifier_base = _1597.VM0_params.position_modifier_base;
            _1602.position_modifier_base_modifier_factor = _1597.VM0_params.position_modifier_base_modifier_factor;
            _1602.position_modifier_range = _1597.VM0_params.position_modifier_range;
            _1602.position_modifier_range_modifier_factor = _1597.VM0_params.position_modifier_range_modifier_factor;
            _1602.rotation_modifier_base = _1597.VM0_params.rotation_modifier_base;
            _1602.rotation_modifier_base_modifier_factor = _1597.VM0_params.rotation_modifier_base_modifier_factor;
            _1602.rotation_modifier_range = _1597.VM0_params.rotation_modifier_range;
            _1602.rotation_modifier_range_modifier_factor = _1597.VM0_params.rotation_modifier_range_modifier_factor;
            _1602.scale_modifier_base = _1597.VM0_params.scale_modifier_base;
            _1602.scale_modifier_base_modifier_factor = _1597.VM0_params.scale_modifier_base_modifier_factor;
            _1602.scale_modifier_range = _1597.VM0_params.scale_modifier_range;
            _1602.scale_modifier_range_modifier_factor = _1597.VM0_params.scale_modifier_range_modifier_factor;
            InstanceModifierRandomizerV2_Params param_5 = _1602;
            ModifierFactor param_6 = modifier_factor;
            Instance param_7 = instance;
            uint param_8 = id;
            instance_modifier_randomizer_v2(param_5, param_6, param_7, param_8);
            modifier_factor = param_6;
            instance = param_7;
            modifier_factor.position = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
            ModifierFactorNoise_Params _1628;
            _1628.transform_local_to_gizmo = _1623.VM1_params.transform_local_to_gizmo;
            _1628.noise_domain_scale = _1623.VM1_params.noise_domain_scale;
            _1628.modifier_function = _1623.VM1_params.modifier_function;
            _1628.noise_domain_offset = _1623.VM1_params.noise_domain_offset;
            _1628.noise_value_scale = _1623.VM1_params.noise_value_scale;
            _1628.noise_value_offset = _1623.VM1_params.noise_value_offset;
            _1628.influence_scope = _1623.VM1_params.influence_scope;
            _1628._pad0 = _1623.VM1_params._pad0;
            _1628._pad1 = _1623.VM1_params._pad1;
            ModifierFactorNoise_Params param_9 = _1628;
            ModifierFactor param_10 = modifier_factor;
            CoordinateSystemTrasforms param_11 = cs_transforms;
            modifier_factor_noise_default(param_9, param_10, param_11);
            modifier_factor = param_10;
            InstanceModifierRandomizerV2_Params _1641;
            _1641.replace_previous_rotation_scale = _1637.VM2_params.replace_previous_rotation_scale;
            _1641.randomness_seed = _1637.VM2_params.randomness_seed;
            _1641.replace_previous_position = _1637.VM2_params.replace_previous_position;
            _1641.randomization_input = _1637.VM2_params.randomization_input;
            _1641.position_modifier_base = _1637.VM2_params.position_modifier_base;
            _1641.position_modifier_base_modifier_factor = _1637.VM2_params.position_modifier_base_modifier_factor;
            _1641.position_modifier_range = _1637.VM2_params.position_modifier_range;
            _1641.position_modifier_range_modifier_factor = _1637.VM2_params.position_modifier_range_modifier_factor;
            _1641.rotation_modifier_base = _1637.VM2_params.rotation_modifier_base;
            _1641.rotation_modifier_base_modifier_factor = _1637.VM2_params.rotation_modifier_base_modifier_factor;
            _1641.rotation_modifier_range = _1637.VM2_params.rotation_modifier_range;
            _1641.rotation_modifier_range_modifier_factor = _1637.VM2_params.rotation_modifier_range_modifier_factor;
            _1641.scale_modifier_base = _1637.VM2_params.scale_modifier_base;
            _1641.scale_modifier_base_modifier_factor = _1637.VM2_params.scale_modifier_base_modifier_factor;
            _1641.scale_modifier_range = _1637.VM2_params.scale_modifier_range;
            _1641.scale_modifier_range_modifier_factor = _1637.VM2_params.scale_modifier_range_modifier_factor;
            InstanceModifierRandomizerV2_Params param_12 = _1641;
            ModifierFactor param_13 = modifier_factor;
            Instance param_14 = instance;
            uint param_15 = id;
            instance_modifier_randomizer_v2(param_12, param_13, param_14, param_15);
            modifier_factor = param_13;
            instance = param_14;
            modifier_factor.position = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
            ModifierFactorWaveTransfer_Params _1667;
            _1667.type = _1662.VM3_params.type;
            _1667.modulate = _1662.VM3_params.modulate;
            _1667.frequency = _1662.VM3_params.frequency;
            _1667.phase_shift = _1662.VM3_params.phase_shift;
            _1667.amplitude = _1662.VM3_params.amplitude;
            _1667.base = _1662.VM3_params.base;
            ModifierFactorWaveTransfer_Params param_16 = _1667;
            ModifierFactor param_17 = modifier_factor;
            modifier_factor_wave_transfer(param_16, param_17);
            modifier_factor = param_17;
            InstanceModifierFactorToColor_Params _1680;
            _1680.color = _1675.VM4_params.color;
            _1680.use_gradient = _1675.VM4_params.use_gradient;
            _1680.color_gradient_idx = _1675.VM4_params.color_gradient_idx;
            _1680.mixing_mode = _1675.VM4_params.mixing_mode;
            InstanceModifierFactorToColor_Params param_18 = _1680;
            ModifierFactor param_19 = modifier_factor;
            Instance param_20 = instance;
            instance_modifier_factor_to_color(param_18, param_19, param_20);
            modifier_factor = param_19;
            instance = param_20;
            _1691.instance_transform[(instance_id * 3u) + 0u] = instance.m0;
            _1691.instance_transform[(instance_id * 3u) + 1u] = instance.m1;
            _1691.instance_transform[(instance_id * 3u) + 2u] = instance.m2;
            _1714.instance_color[(instance_id * 2u) + 0u] = packHalf2x16(instance.c.xy);
            _1714.instance_color[(instance_id * 2u) + 1u] = packHalf2x16(instance.c.zw);
            _1734.instance_hash[instance_id] = instance.hash;
            _1742.instance_flipbook_card[instance_id] = instance.flipbook_card;
            emited++;
            int _1751 = si;
            si = _1751 + _1325.instancing_generator_params.skip_segments;
            continue;
        }
        else
        {
            break;
        }
    }
}

 