#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct InstancingGeneratorParams
{
    float color_lod;
    float occupancy_lod;
    float occupancy_threshold;
    int bbox_from_voxelizer;
    uvec3 resolution;
    int _pad2;
    vec3 bbox_position;
    int _pad3;
    vec3 bbox_dimensions;
    int _pad4;
    vec3 instance_scale_base;
    int _pad7;
    vec3 instance_scale_factor;
    int _pad8;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 1, std430) buffer InstanceParamsBuffer
{
    InstanceParams instance_params;
} _114;

layout(set = 0, binding = 7, std140) uniform InstancingGeneratorParamsBuffer
{
    InstancingGeneratorParams instancing_generator_params;
} _132;

layout(set = 0, binding = 2, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_raytrace_recip;
    vec4 grid_size_voxelize;
    vec4 grid_size_voxelize_recip;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 0, binding = 3, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _462;

layout(set = 0, binding = 4, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _484;

layout(set = 0, binding = 5, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _505;

layout(set = 0, binding = 6, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _513;

layout(set = 0, binding = 8) uniform sampler3D s_voxel_colors_filtered;
layout(set = 0, binding = 9) uniform sampler3D s_voxel_occupancy_filtered;

vec3 color_convert_rgbm_rgb(inout vec4 v)
{
    vec4 _27 = v;
    float _32 = v.w;
    vec3 _35 = (_27.xyz * _32) * 128.0;
    v.x = _35.x;
    v.y = _35.y;
    v.z = _35.z;
    return v.xyz * v.xyz;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    if (_114.instance_params.instance_count >= _114.instance_params.buffer_capacity)
    {
        return;
    }
    uint instance_position_id = id;
    uvec3 instance_position_int;
    instance_position_int.z = instance_position_id / (_132.instancing_generator_params.resolution.x * _132.instancing_generator_params.resolution.y);
    instance_position_id -= (instance_position_int.z * (_132.instancing_generator_params.resolution.x * _132.instancing_generator_params.resolution.y));
    instance_position_int.y = instance_position_id / _132.instancing_generator_params.resolution.x;
    instance_position_id -= (instance_position_int.y * _132.instancing_generator_params.resolution.x);
    instance_position_int.x = instance_position_id;
    vec3 instancing_bbox_origin = in_bbox_data.bbox_voxelize_min.xyz;
    vec3 instancing_bbox_size = in_bbox_data.grid_size_voxelize.xyz * 256.0;
    if (_132.instancing_generator_params.bbox_from_voxelizer == 0)
    {
        instancing_bbox_origin = _132.instancing_generator_params.bbox_position;
        instancing_bbox_size = _132.instancing_generator_params.bbox_dimensions;
    }
    vec3 instance_position = ((vec3(instance_position_int) / vec3(_132.instancing_generator_params.resolution)) * instancing_bbox_size) + instancing_bbox_origin;
    vec3 voxelizer_bbox_origin = in_bbox_data.bbox_voxelize_min.xyz;
    vec3 voxelizer_bbox_size = in_bbox_data.grid_size_voxelize.xyz * 256.0;
    vec3 source_voxel_position = (instance_position - voxelizer_bbox_origin) / voxelizer_bbox_size;
    bool _219 = source_voxel_position.x < 0.0;
    bool _226;
    if (!_219)
    {
        _226 = source_voxel_position.y < 0.0;
    }
    else
    {
        _226 = _219;
    }
    bool _233;
    if (!_226)
    {
        _233 = source_voxel_position.z < 0.0;
    }
    else
    {
        _233 = _226;
    }
    bool _240;
    if (!_233)
    {
        _240 = source_voxel_position.x >= 1.0;
    }
    else
    {
        _240 = _233;
    }
    bool _247;
    if (!_240)
    {
        _247 = source_voxel_position.y >= 1.0;
    }
    else
    {
        _247 = _240;
    }
    bool _254;
    if (!_247)
    {
        _254 = source_voxel_position.z >= 1.0;
    }
    else
    {
        _254 = _247;
    }
    if (_254)
    {
        return;
    }
    vec4 param = textureLod(s_voxel_colors_filtered, source_voxel_position, _132.instancing_generator_params.color_lod);
    vec3 _270 = color_convert_rgbm_rgb(param);
    vec3 voxel_color = _270;
    float voxel_occupancy = textureLod(s_voxel_occupancy_filtered, source_voxel_position, _132.instancing_generator_params.occupancy_lod).x;
    if (voxel_occupancy <= _132.instancing_generator_params.occupancy_threshold)
    {
        return;
    }
    voxel_occupancy -= _132.instancing_generator_params.occupancy_threshold;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    modifier_factor.position = instance_position;
    modifier_factor.is_spawned = true;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    bool _316 = modifier_factor.factor <= 9.9999997473787516355514526367188e-05;
    bool _323;
    if (!_316)
    {
        _323 = modifier_factor.is_discarded == true;
    }
    else
    {
        _323 = _316;
    }
    if (_323)
    {
        return;
    }
    vec3 instance_scale = _132.instancing_generator_params.instance_scale_base + (_132.instancing_generator_params.instance_scale_factor * (voxel_occupancy * modifier_factor.factor));
    bool _340 = instance_scale.x <= 0.0;
    bool _347;
    if (!_340)
    {
        _347 = instance_scale.y <= 0.0;
    }
    else
    {
        _347 = _340;
    }
    bool _354;
    if (!_347)
    {
        _354 = instance_scale.z <= 0.0;
    }
    else
    {
        _354 = _347;
    }
    if (_354)
    {
        return;
    }
    voxel_color += vec3(voxel_occupancy * 0.00999999977648258209228515625);
    mat3 transform;
    transform[0] = vec3(instance_scale.x, 0.0, 0.0);
    transform[1] = vec3(0.0, instance_scale.y, 0.0);
    transform[2] = vec3(0.0, 0.0, instance_scale.z);
    transform = transpose(transform);
    Instance instance;
    instance.m0 = vec4(transform[0], instance_position.x);
    instance.m1 = vec4(transform[1], instance_position.y);
    instance.m2 = vec4(transform[2], instance_position.z);
    instance.hash = modifier_factor.hash;
    instance.c = vec4(voxel_color, 1.0);
    instance.flipbook_card = 0u;
    bool _425 = length(instance.m0.xyz) < 9.9999997473787516355514526367188e-05;
    bool _434;
    if (!_425)
    {
        _434 = length(instance.m1.xyz) < 9.9999997473787516355514526367188e-05;
    }
    else
    {
        _434 = _425;
    }
    bool _443;
    if (!_434)
    {
        _443 = length(instance.m1.xyz) < 9.9999997473787516355514526367188e-05;
    }
    else
    {
        _443 = _434;
    }
    if (_443)
    {
        return;
    }
    int _449 = atomicAdd(_114.instance_params.instance_count, 1);
    uint instance_id = uint(_449);
    if (instance_id >= uint(_114.instance_params.buffer_capacity))
    {
        return;
    }
    _462.instance_transform[(instance_id * 3u) + 0u] = instance.m0;
    _462.instance_transform[(instance_id * 3u) + 1u] = instance.m1;
    _462.instance_transform[(instance_id * 3u) + 2u] = instance.m2;
    _484.instance_color[(instance_id * 2u) + 0u] = packHalf2x16(instance.c.xy);
    _484.instance_color[(instance_id * 2u) + 1u] = packHalf2x16(instance.c.zw);
    _505.instance_hash[instance_id] = instance.hash;
    _513.instance_flipbook_card[instance_id] = instance.flipbook_card;
}

 