#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 2) uniform sampler3D s_voxel_colors_filtered;
layout(set = 0, binding = 1, rgba16f) uniform writeonly image2D imTarget;

void main()
{
    uvec2 tile_pos = gl_WorkGroupID.xy;
    uvec2 pixel_pos = (tile_pos * uvec2(8u)) + gl_LocalInvocationID.xy;
    vec4 c = vec4(0.0);
    int i = 0;
    for (;;)
    {
        if (i < 255)
        {
            i++;
            continue;
        }
        else
        {
            break;
        }
    }
    uvec3 p;
    int i_1 = 0;
    for (;;)
    {
        if (i_1 < 255)
        {
            p.x = pixel_pos.x + uint(i_1 * 3);
            p.y = pixel_pos.y;
            p.z = uint(i_1 * 13);
            p.z -= p.x;
            c += textureLod(s_voxel_colors_filtered, fract(vec3(p) / vec3(255.0)), 0.0);
            i_1++;
            continue;
        }
        else
        {
            break;
        }
    }
    imageStore(imTarget, ivec2(pixel_pos), c);
}

 