#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require

struct PostprocessParams
{
    vec2 resolution;
    vec2 inv_resolution;
    vec2 frustum_shift;
    vec2 _pad0;
    float param1;
    float param2;
    float _pad1;
    float _pad2;
    int txt1_flip_y;
    int txt2_flip_y;
    int txt3_flip_y;
    int _pad3;
};

layout(set = 1, binding = 1, std140) uniform PostprocessParamsBuffer
{
    PostprocessParams params;
} _32;

layout(set = 1, binding = 2) uniform sampler2D s_texture0;

layout(location = 0) out vec4 outColor;
layout(location = 0) in vec2 vTexcoord0;

void main()
{
    outColor = texture(s_texture0, vTexcoord0);
    vec2 vTexcoord1 = vTexcoord0;
    vec2 vTexcoord2 = vTexcoord0;
    vec2 vTexcoord3 = vTexcoord0;
    if (_32.params.txt1_flip_y != 0)
    {
        vTexcoord1.y = 1.0 - vTexcoord1.y;
    }
    if (_32.params.txt2_flip_y != 0)
    {
        vTexcoord2.y = 1.0 - vTexcoord2.y;
    }
    if (_32.params.txt3_flip_y != 0)
    {
        vTexcoord3.y = 1.0 - vTexcoord3.y;
    }
    vec3 v = outColor.xyz;
    vec3 c = v;
    vec4 K = vec4(0.0, -0.3333333432674407958984375, 0.666666686534881591796875, -1.0);
    vec4 p = mix(vec4(c.zy, K.wz), vec4(c.yz, K.xy), vec4(step(c.z, c.y)));
    vec4 q = mix(vec4(p.xyw, c.x), vec4(c.x, p.yzx), vec4(step(p.x, c.x)));
    float d = q.x - min(q.w, q.y);
    float e = 1.0000000133514319600180897396058e-10;
    vec3 hsv = vec3(abs(q.z + ((q.w - q.y) / ((6.0 * d) + e))), d / (q.x + e), q.x);
    vec2 sv = hsv.yz;
    hsv.y = 1.0;
    hsv.z = 1.0;
    vec3 c_1 = hsv;
    vec4 K_1 = vec4(1.0, 0.666666686534881591796875, 0.3333333432674407958984375, 3.0);
    vec3 p_1 = abs((fract(c_1.xxx + K_1.xyz) * 6.0) - K_1.www);
    vec3 rgb = mix(K_1.xxx, clamp(p_1 - K_1.xxx, vec3(0.0), vec3(1.0)), vec3(c_1.y)) * c_1.z;
    rgb = vec3(1.0) - rgb;
    vec3 c_2 = rgb;
    vec4 K_2 = vec4(0.0, -0.3333333432674407958984375, 0.666666686534881591796875, -1.0);
    vec4 p_2 = mix(vec4(c_2.zy, K_2.wz), vec4(c_2.yz, K_2.xy), vec4(step(c_2.z, c_2.y)));
    vec4 q_1 = mix(vec4(p_2.xyw, c_2.x), vec4(c_2.x, p_2.yzx), vec4(step(p_2.x, c_2.x)));
    float d_1 = q_1.x - min(q_1.w, q_1.y);
    float e_1 = 1.0000000133514319600180897396058e-10;
    hsv.x = vec3(abs(q_1.z + ((q_1.w - q_1.y) / ((6.0 * d_1) + e_1))), d_1 / (q_1.x + e_1), q_1.x).x;
    hsv.y = sv.x;
    hsv.z = sv.y;
    vec3 c_3 = hsv;
    vec4 K_3 = vec4(1.0, 0.666666686534881591796875, 0.3333333432674407958984375, 3.0);
    vec3 p_3 = abs((fract(c_3.xxx + K_3.xyz) * 6.0) - K_3.www);
    rgb = mix(K_3.xxx, clamp(p_3 - K_3.xxx, vec3(0.0), vec3(1.0)), vec3(c_3.y)) * c_3.z;
    float t = rgb.x;
    rgb.x = rgb.z;
    rgb.z = t;
    outColor.x = rgb.x;
    outColor.y = rgb.y;
    outColor.z = rgb.z;
}

 