#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_ARB_gpu_shader_int64)
#extension GL_ARB_gpu_shader_int64 : require
#else
#error No extension available for 64-bit integers.
#endif
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct RTFace
{
    uint v0;
    uint v1;
    uint v2;
    uint material_flags;
};

struct InstancingGeneratorParams
{
    int seed;
    int transformed_data_location_idx;
    int transformed_data_location_num;
    float surface_distance;
    vec3 instance_scale;
    int alpha_to_modifier_factor;
    vec3 duplicate_elimination_position_decimation;
    int duplicate_elimination_position;
    vec3 duplicate_elimination_position_decimation_rcp;
    float duplicate_elimination_normal_decimation;
    float duplicate_elimination_normal_decimation_rcp;
    int duplicate_elimination_normal;
    float min_face_size;
    int _pad0;
};

struct InstanceModifierRandomizerV2_Params
{
    int replace_previous_rotation_scale;
    int randomness_seed;
    int replace_previous_position;
    int randomization_input;
    vec3 position_modifier_base;
    float position_modifier_base_modifier_factor;
    vec3 position_modifier_range;
    float position_modifier_range_modifier_factor;
    vec3 rotation_modifier_base;
    float rotation_modifier_base_modifier_factor;
    vec3 rotation_modifier_range;
    float rotation_modifier_range_modifier_factor;
    vec3 scale_modifier_base;
    float scale_modifier_base_modifier_factor;
    vec3 scale_modifier_range;
    float scale_modifier_range_modifier_factor;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct GPUHashMapHeader
{
    uint capacity;
    uint _pad0;
    uint _pad1;
    uint _pad2;
};

layout(set = 0, binding = 1, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _308;

layout(set = 0, binding = 2, std430) buffer TransformedDataIndexBuffer
{
    uint transformed_data_indices[];
} _367;

layout(set = 0, binding = 3, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _425;

layout(set = 0, binding = 9, std140) uniform InstancingGeneratorParamsBuffer
{
    InstancingGeneratorParams instancing_generator_params;
} _1215;

layout(set = 0, binding = 4, std430) buffer InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1457;

layout(set = 0, binding = 10, std140) uniform VM0
{
    InstanceModifierRandomizerV2_Params VM0_params;
} _1536;

layout(set = 0, binding = 11, std140) uniform VM1
{
    layout(row_major) ModifierFactorNoise_Params VM1_params;
} _1562;

layout(set = 0, binding = 12, std140) uniform VM2
{
    InstanceModifierRandomizerV2_Params VM2_params;
} _1576;

layout(set = 0, binding = 5, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1593;

layout(set = 0, binding = 6, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _1616;

layout(set = 0, binding = 7, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _1636;

layout(set = 0, binding = 8, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _1644;

uint particle_emitter_geometry_get_first_face_idx(InstancingGeneratorParams emitter_params)
{
    uint tdl_idx = uint(emitter_params.transformed_data_location_idx);
    if (tdl_idx > 0u)
    {
        return _425.transformed_data_location[tdl_idx - 1u].last_face_idx + 1u;
    }
    return 0u;
}

uint particle_emitter_geometry_get_last_face_idx(InstancingGeneratorParams emitter_params)
{
    uint tdl_idx = uint((emitter_params.transformed_data_location_idx + emitter_params.transformed_data_location_num) - 1);
    return _425.transformed_data_location[tdl_idx].last_face_idx;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _286 = hash(param);
    uint param_1 = _286;
    float _288 = floatConstruct(param_1);
    return _288;
}

RTFace rt_get_face(uint face_idx)
{
    uint v0 = _367.transformed_data_indices[(face_idx * 3u) + 0u];
    uint v1 = _367.transformed_data_indices[(face_idx * 3u) + 1u];
    uint v2 = _367.transformed_data_indices[(face_idx * 3u) + 2u];
    uint flags0 = v0 >> uint(24);
    uint flags1 = v1 >> uint(24);
    RTFace f;
    f.v0 = v0 & 16777215u;
    f.v1 = v1 & 16777215u;
    f.v2 = v2;
    f.material_flags = flags0 | (flags1 << uint(8));
    return f;
}

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_308.in_vtx_data[coord_offset + 0u], _308.in_vtx_data[coord_offset + 1u], _308.in_vtx_data[coord_offset + 2u]);
    return p;
}

vec4 rt_get_vertex_color(uint idx)
{
    uint color_offset = (idx * 1u) + 70000000u;
    uint packed_color = floatBitsToUint(_308.in_vtx_data[color_offset + 0u]);
    vec4 p = vec4(float((packed_color >> uint(24)) & 255u), float((packed_color >> uint(16)) & 255u), float((packed_color >> uint(8)) & 255u), float((packed_color >> uint(0)) & 255u)) * 0.0039215688593685626983642578125;
    return p;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

uint hash(uvec3 v)
{
    uint param = v.y;
    uint _259 = hash(param);
    uint param_1 = v.z;
    uint _264 = hash(param_1);
    uint param_2 = (v.x ^ _259) ^ _264;
    uint _267 = hash(param_2);
    return _267;
}

float random(vec3 v)
{
    uvec3 param = floatBitsToUint(v);
    uint param_1 = hash(param);
    float _296 = floatConstruct(param_1);
    return _296;
}

void instance_modifier_randomizer_v2(InstanceModifierRandomizerV2_Params modifier_params, ModifierFactor modifier_factor, inout Instance instance, uint id)
{
    float influence = modifier_factor.factor;
    float fid = float(id);
    if (modifier_params.randomization_input == 0)
    {
        fid = float(id);
    }
    if (modifier_params.randomization_input == 1)
    {
        vec3 param = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
        fid = random(param);
    }
    if (modifier_params.randomization_input == 2)
    {
        float param_1 = uintBitsToFloat(instance.hash);
        fid = random(param_1);
    }
    float param_2 = fid;
    vec3 angles;
    angles.x = random(param_2);
    float param_3 = fid + 123.3000030517578125;
    angles.y = random(param_3);
    float param_4 = (fid * 2.131700038909912109375) + 13.4137096405029296875;
    angles.z = random(param_4);
    if (modifier_params.randomization_input == 3)
    {
        angles = vec3(1.0);
    }
    angles = (modifier_params.rotation_modifier_base * (modifier_params.rotation_modifier_base_modifier_factor * influence)) + ((angles * modifier_params.rotation_modifier_range) * (modifier_params.rotation_modifier_range_modifier_factor * influence));
    float param_5 = fid;
    vec3 scales;
    scales.x = random(param_5);
    scales.y = scales.x;
    scales.z = scales.x;
    if (modifier_params.randomization_input == 3)
    {
        scales = vec3(1.0);
    }
    scales = mix(vec3(1.0), modifier_params.scale_modifier_base, vec3(modifier_params.scale_modifier_base_modifier_factor * influence)) + ((scales * modifier_params.scale_modifier_range) * (modifier_params.scale_modifier_range_modifier_factor * influence));
    float param_6 = fid;
    vec3 translations;
    translations.x = random(param_6);
    float param_7 = fid + 123.73169708251953125;
    translations.y = random(param_7);
    float param_8 = (fid * 2.131700038909912109375) + 13.71000003814697265625;
    translations.z = random(param_8);
    if (modifier_params.randomization_input == 3)
    {
        translations = vec3(1.0);
    }
    else
    {
        translations = normalize(translations);
    }
    translations = (modifier_params.position_modifier_base * (modifier_params.position_modifier_base_modifier_factor * influence)) + ((translations * modifier_params.position_modifier_range) * (modifier_params.position_modifier_range_modifier_factor * influence));
    float cosb = cos(angles.z);
    float sinb = sin(angles.z);
    float cosp = cos(angles.x);
    float sinp = sin(angles.x);
    float _cosh = cos(angles.y);
    float _sinh = sin(angles.y);
    vec3 mx;
    mx.x = (_cosh * cosb) + ((_sinh * sinp) * sinb);
    mx.y = ((_sinh * sinp) * cosb) - (_cosh * sinb);
    mx.z = _sinh * cosp;
    vec3 my;
    my.x = cosp * sinb;
    my.y = cosp * cosb;
    my.z = -sinp;
    vec3 mz;
    mz.x = ((_cosh * sinp) * sinb) - (_sinh * cosb);
    mz.y = (_sinh * sinb) + ((_cosh * sinp) * cosb);
    mz.z = _cosh * cosp;
    mat4 tm_rot;
    tm_rot[0] = vec4(mx.x, my.x, mz.x, translations.x);
    tm_rot[1] = vec4(mx.y, my.y, mz.y, translations.y);
    tm_rot[2] = vec4(mx.z, my.z, mz.z, translations.z);
    tm_rot[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 tm_sc;
    tm_sc[0] = vec4(scales.x, 0.0, 0.0, 0.0);
    tm_sc[1] = vec4(0.0, scales.y, 0.0, 0.0);
    tm_sc[2] = vec4(0.0, 0.0, scales.z, 0.0);
    tm_sc[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 m;
    m[0] = instance.m0;
    m[1] = instance.m1;
    m[2] = instance.m2;
    m[3] = vec4(0.0, 0.0, 0.0, 1.0);
    if (modifier_params.replace_previous_rotation_scale == 0)
    {
        m = (tm_sc * tm_rot) * m;
    }
    else
    {
        mat4 lm = tm_sc * tm_rot;
        m = (tm_sc * tm_rot) * m;
        m[0].x = lm[0].xyz.x;
        m[0].y = lm[0].xyz.y;
        m[0].z = lm[0].xyz.z;
        m[1].x = lm[1].xyz.x;
        m[1].y = lm[1].xyz.y;
        m[1].z = lm[1].xyz.z;
        m[2].x = lm[2].xyz.x;
        m[2].y = lm[2].xyz.y;
        m[2].z = lm[2].xyz.z;
    }
    instance.m0 = m[0];
    instance.m1 = m[1];
    instance.m2 = m[2];
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise_default(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1169 = vector_transform_by_mat43(param, param_1);
        coords = _1169;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1176 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1176;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    InstancingGeneratorParams _1220;
    _1220.seed = _1215.instancing_generator_params.seed;
    _1220.transformed_data_location_idx = _1215.instancing_generator_params.transformed_data_location_idx;
    _1220.transformed_data_location_num = _1215.instancing_generator_params.transformed_data_location_num;
    _1220.surface_distance = _1215.instancing_generator_params.surface_distance;
    _1220.instance_scale = _1215.instancing_generator_params.instance_scale;
    _1220.alpha_to_modifier_factor = _1215.instancing_generator_params.alpha_to_modifier_factor;
    _1220.duplicate_elimination_position_decimation = _1215.instancing_generator_params.duplicate_elimination_position_decimation;
    _1220.duplicate_elimination_position = _1215.instancing_generator_params.duplicate_elimination_position;
    _1220.duplicate_elimination_position_decimation_rcp = _1215.instancing_generator_params.duplicate_elimination_position_decimation_rcp;
    _1220.duplicate_elimination_normal_decimation = _1215.instancing_generator_params.duplicate_elimination_normal_decimation;
    _1220.duplicate_elimination_normal_decimation_rcp = _1215.instancing_generator_params.duplicate_elimination_normal_decimation_rcp;
    _1220.duplicate_elimination_normal = _1215.instancing_generator_params.duplicate_elimination_normal;
    _1220.min_face_size = _1215.instancing_generator_params.min_face_size;
    _1220._pad0 = _1215.instancing_generator_params._pad0;
    InstancingGeneratorParams param = _1220;
    uint first_face_idx = particle_emitter_geometry_get_first_face_idx(param);
    InstancingGeneratorParams _1226;
    _1226.seed = _1215.instancing_generator_params.seed;
    _1226.transformed_data_location_idx = _1215.instancing_generator_params.transformed_data_location_idx;
    _1226.transformed_data_location_num = _1215.instancing_generator_params.transformed_data_location_num;
    _1226.surface_distance = _1215.instancing_generator_params.surface_distance;
    _1226.instance_scale = _1215.instancing_generator_params.instance_scale;
    _1226.alpha_to_modifier_factor = _1215.instancing_generator_params.alpha_to_modifier_factor;
    _1226.duplicate_elimination_position_decimation = _1215.instancing_generator_params.duplicate_elimination_position_decimation;
    _1226.duplicate_elimination_position = _1215.instancing_generator_params.duplicate_elimination_position;
    _1226.duplicate_elimination_position_decimation_rcp = _1215.instancing_generator_params.duplicate_elimination_position_decimation_rcp;
    _1226.duplicate_elimination_normal_decimation = _1215.instancing_generator_params.duplicate_elimination_normal_decimation;
    _1226.duplicate_elimination_normal_decimation_rcp = _1215.instancing_generator_params.duplicate_elimination_normal_decimation_rcp;
    _1226.duplicate_elimination_normal = _1215.instancing_generator_params.duplicate_elimination_normal;
    _1226.min_face_size = _1215.instancing_generator_params.min_face_size;
    _1226._pad0 = _1215.instancing_generator_params._pad0;
    InstancingGeneratorParams param_1 = _1226;
    uint last_face_idx = particle_emitter_geometry_get_last_face_idx(param_1);
    if (first_face_idx == last_face_idx)
    {
        return;
    }
    float face_min_size_threshold = _1215.instancing_generator_params.min_face_size;
    vec3 bc;
    float _1419;
    CoordinateSystemTrasforms cs_transforms;
    Instance instance;
    int i = 0;
    for (;;)
    {
        if (i < 4)
        {
            float fid = float(id);
            float fid_seed = (((fid * 0.0131700001657009124755859375) + float(_1215.instancing_generator_params.seed)) + float(i)) * 0.00113200000487267971038818359375;
            float param_2 = fid_seed;
            uint face_idx = uint(float((last_face_idx - first_face_idx) - 1u) * random(param_2));
            face_idx += first_face_idx;
            uint param_3 = face_idx;
            RTFace rt_face = rt_get_face(param_3);
            uint p0_idx = rt_face.v0;
            uint p1_idx = rt_face.v1;
            uint p2_idx = rt_face.v2;
            uint param_4 = p0_idx;
            vec3 p0 = rt_get_vertex(param_4);
            uint param_5 = p1_idx;
            vec3 p1 = rt_get_vertex(param_5);
            uint param_6 = p2_idx;
            vec3 p2 = rt_get_vertex(param_6);
            float face_size = length(cross(p0 - p1, p0 - p2));
            if (face_size < face_min_size_threshold)
            {
                int _1650 = i;
                i = _1650 + 1;
                continue;
            }
            uint param_7 = p0_idx;
            vec4 c0 = rt_get_vertex_color(param_7);
            uint param_8 = p1_idx;
            vec4 c1 = rt_get_vertex_color(param_8);
            uint param_9 = p2_idx;
            vec4 c2 = rt_get_vertex_color(param_9);
            float param_10 = fid_seed * 0.34130001068115234375;
            bc.x = random(param_10);
            float param_11 = fid_seed * 0.1412999927997589111328125;
            bc.y = random(param_11);
            if ((bc.x + bc.y) >= 1.0)
            {
                bc.x = 1.0 - bc.x;
                bc.y = 1.0 - bc.y;
            }
            vec4 col = ((c0 * bc.x) + (c1 * bc.y)) + (c2 * ((1.0 - bc.x) - bc.y));
            vec3 pos = ((p0 * bc.x) + (p1 * bc.y)) + (p2 * ((1.0 - bc.x) - bc.y));
            vec3 nx = normalize(p0 - p2);
            vec3 ny = normalize(p0 - p1);
            vec3 nz = normalize(cross(nx, ny));
            ny = cross(nz, nx);
            ModifierFactor modifier_factor = modifier_factor_defaults();
            if (_1215.instancing_generator_params.alpha_to_modifier_factor != 0)
            {
                _1419 = col.w;
            }
            else
            {
                _1419 = 1.0;
            }
            modifier_factor.factor = _1419;
            modifier_factor.hash = floatBitsToUint(fid_seed);
            modifier_factor.id = id;
            modifier_factor.position = pos;
            modifier_factor.is_spawned = true;
            modifier_factor.color = col;
            modifier_factor.normal = nz;
            cs_transforms.mat_local_to_model = mat_identity();
            cs_transforms.mat_local_to_instance = mat_identity();
            cs_transforms.mat_local_to_model_inv = mat_identity();
            if (modifier_factor.factor <= 9.9999997473787516355514526367188e-05)
            {
                int _1650 = i;
                i = _1650 + 1;
                continue;
            }
            if (_1457.instance_params.instance_count >= _1457.instance_params.buffer_capacity)
            {
                return;
            }
            int _1469 = atomicAdd(_1457.instance_params.instance_count, 1);
            uint instance_id = uint(_1469);
            if (instance_id >= uint(_1457.instance_params.buffer_capacity))
            {
                return;
            }
            pos -= (nz * _1215.instancing_generator_params.surface_distance);
            nx *= _1215.instancing_generator_params.instance_scale.x;
            ny *= _1215.instancing_generator_params.instance_scale.y;
            nz *= _1215.instancing_generator_params.instance_scale.z;
            instance.m0 = vec4(nx.x, ny.x, nz.x, pos.x);
            instance.m1 = vec4(nx.y, ny.y, nz.y, pos.y);
            instance.m2 = vec4(nx.z, ny.z, nz.z, pos.z);
            instance.hash = modifier_factor.hash;
            instance.c = vec4(1.0);
            instance.flipbook_card = 0u;
            InstanceModifierRandomizerV2_Params _1541;
            _1541.replace_previous_rotation_scale = _1536.VM0_params.replace_previous_rotation_scale;
            _1541.randomness_seed = _1536.VM0_params.randomness_seed;
            _1541.replace_previous_position = _1536.VM0_params.replace_previous_position;
            _1541.randomization_input = _1536.VM0_params.randomization_input;
            _1541.position_modifier_base = _1536.VM0_params.position_modifier_base;
            _1541.position_modifier_base_modifier_factor = _1536.VM0_params.position_modifier_base_modifier_factor;
            _1541.position_modifier_range = _1536.VM0_params.position_modifier_range;
            _1541.position_modifier_range_modifier_factor = _1536.VM0_params.position_modifier_range_modifier_factor;
            _1541.rotation_modifier_base = _1536.VM0_params.rotation_modifier_base;
            _1541.rotation_modifier_base_modifier_factor = _1536.VM0_params.rotation_modifier_base_modifier_factor;
            _1541.rotation_modifier_range = _1536.VM0_params.rotation_modifier_range;
            _1541.rotation_modifier_range_modifier_factor = _1536.VM0_params.rotation_modifier_range_modifier_factor;
            _1541.scale_modifier_base = _1536.VM0_params.scale_modifier_base;
            _1541.scale_modifier_base_modifier_factor = _1536.VM0_params.scale_modifier_base_modifier_factor;
            _1541.scale_modifier_range = _1536.VM0_params.scale_modifier_range;
            _1541.scale_modifier_range_modifier_factor = _1536.VM0_params.scale_modifier_range_modifier_factor;
            InstanceModifierRandomizerV2_Params param_12 = _1541;
            ModifierFactor param_13 = modifier_factor;
            Instance param_14 = instance;
            uint param_15 = id;
            instance_modifier_randomizer_v2(param_12, param_13, param_14, param_15);
            modifier_factor = param_13;
            instance = param_14;
            modifier_factor.position = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
            ModifierFactorNoise_Params _1567;
            _1567.transform_local_to_gizmo = _1562.VM1_params.transform_local_to_gizmo;
            _1567.noise_domain_scale = _1562.VM1_params.noise_domain_scale;
            _1567.modifier_function = _1562.VM1_params.modifier_function;
            _1567.noise_domain_offset = _1562.VM1_params.noise_domain_offset;
            _1567.noise_value_scale = _1562.VM1_params.noise_value_scale;
            _1567.noise_value_offset = _1562.VM1_params.noise_value_offset;
            _1567.influence_scope = _1562.VM1_params.influence_scope;
            _1567._pad0 = _1562.VM1_params._pad0;
            _1567._pad1 = _1562.VM1_params._pad1;
            ModifierFactorNoise_Params param_16 = _1567;
            ModifierFactor param_17 = modifier_factor;
            CoordinateSystemTrasforms param_18 = cs_transforms;
            modifier_factor_noise_default(param_16, param_17, param_18);
            modifier_factor = param_17;
            InstanceModifierRandomizerV2_Params _1580;
            _1580.replace_previous_rotation_scale = _1576.VM2_params.replace_previous_rotation_scale;
            _1580.randomness_seed = _1576.VM2_params.randomness_seed;
            _1580.replace_previous_position = _1576.VM2_params.replace_previous_position;
            _1580.randomization_input = _1576.VM2_params.randomization_input;
            _1580.position_modifier_base = _1576.VM2_params.position_modifier_base;
            _1580.position_modifier_base_modifier_factor = _1576.VM2_params.position_modifier_base_modifier_factor;
            _1580.position_modifier_range = _1576.VM2_params.position_modifier_range;
            _1580.position_modifier_range_modifier_factor = _1576.VM2_params.position_modifier_range_modifier_factor;
            _1580.rotation_modifier_base = _1576.VM2_params.rotation_modifier_base;
            _1580.rotation_modifier_base_modifier_factor = _1576.VM2_params.rotation_modifier_base_modifier_factor;
            _1580.rotation_modifier_range = _1576.VM2_params.rotation_modifier_range;
            _1580.rotation_modifier_range_modifier_factor = _1576.VM2_params.rotation_modifier_range_modifier_factor;
            _1580.scale_modifier_base = _1576.VM2_params.scale_modifier_base;
            _1580.scale_modifier_base_modifier_factor = _1576.VM2_params.scale_modifier_base_modifier_factor;
            _1580.scale_modifier_range = _1576.VM2_params.scale_modifier_range;
            _1580.scale_modifier_range_modifier_factor = _1576.VM2_params.scale_modifier_range_modifier_factor;
            InstanceModifierRandomizerV2_Params param_19 = _1580;
            ModifierFactor param_20 = modifier_factor;
            Instance param_21 = instance;
            uint param_22 = id;
            instance_modifier_randomizer_v2(param_19, param_20, param_21, param_22);
            modifier_factor = param_20;
            instance = param_21;
            _1593.instance_transform[(instance_id * 3u) + 0u] = instance.m0;
            _1593.instance_transform[(instance_id * 3u) + 1u] = instance.m1;
            _1593.instance_transform[(instance_id * 3u) + 2u] = instance.m2;
            _1616.instance_color[(instance_id * 2u) + 0u] = packHalf2x16(instance.c.xy);
            _1616.instance_color[(instance_id * 2u) + 1u] = packHalf2x16(instance.c.zw);
            _1636.instance_hash[instance_id] = instance.hash;
            _1644.instance_flipbook_card[instance_id] = instance.flipbook_card;
            return;
        }
        else
        {
            break;
        }
    }
}

 