#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ModifierFactorDistanceRadial_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_repeat_x;
    int domain_repeat_y;
    int domain_repeat_z;
    int influence_scope;
    int modifier_function;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct ModifierFactorMulAdd_Params
{
    float multiply_value;
    float add_value;
};

struct VertexModifierDisplaceParams
{
    vec3 displace_normal;
    float displace_normal_modifier_factor;
    vec3 displace_base;
    float displace_base_modifier_factor;
    int influence_scope;
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GeometryCopyDeformParams
{
    int surfaces_num;
    int surface_idx;
    int attribute_mask;
    int create_copy;
    int export_factor_as_custom0;
    int _pad0;
    int _pad1;
    int _pad2;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

layout(set = 0, binding = 1, std430) buffer OutGeometryInformationBuffer
{
    GeometryInformation output_geometry_information;
} _260;

layout(set = 0, binding = 2, std430) buffer OutIndexBuffer
{
    uint data[];
} out_idx_data;

layout(set = 0, binding = 3, std430) buffer OutVTXCoords
{
    float data[];
} out_vtx_coords;

layout(set = 0, binding = 4, std430) buffer OutVTXNormals
{
    float data[];
} out_vtx_normals;

layout(set = 0, binding = 5, std430) buffer OutVTXAlbedo
{
    float data[];
} out_vtx_albedo;

layout(set = 0, binding = 6, std430) buffer OutVTXCustom0
{
    uint data[];
} out_vtx_custom0;

layout(set = 0, binding = 13, scalar) uniform InGeometryInformationBuffer
{
    GeometryInformation input_geometry_information;
} _373;

layout(set = 0, binding = 7, std430) readonly buffer InIndexBuffer
{
    uint data[];
} in_idx_data;

layout(set = 0, binding = 8, std430) readonly buffer InVTXCoords
{
    float data[];
} in_vtx_coords;

layout(set = 0, binding = 9, std430) readonly buffer InVTXNormals
{
    float data[];
} in_vtx_normals;

layout(set = 0, binding = 10, std430) readonly buffer InVTXAlbedo
{
    float data[];
} in_vtx_albedo;

layout(set = 0, binding = 11, std430) readonly buffer InVTXCustom0
{
    uint data[];
} in_vtx_custom0;

layout(set = 0, binding = 14, std140) uniform VM0
{
    layout(row_major) ModifierFactorDistanceRadial_Params VM0_params;
} _1301;

layout(set = 0, binding = 15, std140) uniform VM1
{
    layout(row_major) ModifierFactorNoise_Params VM1_params;
} _1316;

layout(set = 0, binding = 16, std140) uniform VM2
{
    ModifierFactorMulAdd_Params VM2_params;
} _1335;

layout(set = 0, binding = 17, std140) uniform VM3
{
    layout(row_major) ModifierFactorDistanceRadial_Params VM3_params;
} _1347;

layout(set = 0, binding = 18, std140) uniform VM4
{
    VertexModifierDisplaceParams VM4_params;
} _1361;

layout(set = 0, binding = 19, std140) uniform GeometryCopyDeformParamsBuffer
{
    GeometryCopyDeformParams geometry_copy_deform_params;
} _1392;

layout(set = 0, binding = 12, std430) buffer VertexCopyFlagBuffer
{
    uint data[];
} vtx_copy_flag_data;

layout(set = 0, binding = 20) uniform sampler2D s_Curves;

uint get_idx(inout uint idx)
{
    idx += _373.input_geometry_information.idx_buffer_offset;
    return in_idx_data.data[idx];
}

void put_idx(inout uint idx, uint v)
{
    idx += _260.output_geometry_information.idx_buffer_offset;
    out_idx_data.data[idx] = v;
}

vec3 get_coords(inout uint idx)
{
    idx *= _373.input_geometry_information.attributes[0].stride;
    idx += _373.input_geometry_information.attributes[0].offset;
    return vec3(in_vtx_coords.data[idx + 0u], in_vtx_coords.data[idx + 1u], in_vtx_coords.data[idx + 2u]);
}

vec3 get_normal(inout uint idx)
{
    idx *= _373.input_geometry_information.attributes[1].stride;
    idx += _373.input_geometry_information.attributes[1].offset;
    return vec3(in_vtx_normals.data[idx + 0u], in_vtx_normals.data[idx + 1u], in_vtx_normals.data[idx + 2u]);
}

vec3 get_albedo(inout uint idx)
{
    idx *= _373.input_geometry_information.attributes[2].stride;
    idx += _373.input_geometry_information.attributes[2].offset;
    return vec3(in_vtx_albedo.data[idx + 0u], in_vtx_albedo.data[idx + 1u], in_vtx_albedo.data[idx + 2u]);
}

uint get_custom0(inout uint idx)
{
    idx *= _373.input_geometry_information.attributes[6].stride;
    idx += _373.input_geometry_information.attributes[6].offset;
    return in_vtx_custom0.data[idx + 0u];
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_distance_radial(ModifierFactorDistanceRadial_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_factor.has_world_position == false)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_model;
        vec3 _519 = vector_transform_by_mat43(param, param_1);
        coords = _519;
        if (modifier_params.influence_scope == 1)
        {
            vec3 param_2 = coords;
            mat4 param_3 = cs_transforms.mat_local_to_instance;
            vec3 _530 = vector_transform_by_mat43(param_2, param_3);
            coords = _530;
        }
    }
    else
    {
        coords = modifier_factor.world_position;
    }
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 _540 = vector_transform_by_mat43(param_4, param_5);
    vec3 rel_coords = _540;
    if (modifier_params.domain_repeat_x != 0)
    {
        rel_coords.x = (fract(rel_coords.x * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_y != 0)
    {
        rel_coords.y = (fract(rel_coords.y * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_z != 0)
    {
        rel_coords.z = (fract(rel_coords.z * 2.0) - 0.5) * 2.0;
    }
    float influence = length(rel_coords);
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_6 = modifier_params.falloff_curve_idx;
    float param_7 = influence;
    influence = curve_sample(param_6, param_7);
    float v = influence;
    ModifierFactor param_8 = modifier_factor;
    uint param_9 = uint(modifier_params.modifier_function);
    float param_10 = v;
    modifier_process_modifier_factor(param_8, param_9, param_10);
    modifier_factor = param_8;
}

vec4 _permute(vec4 x)
{
    vec4 xm = mod(x, vec4(289.0));
    return mod(((xm * 34.0) + vec4(10.0)) * xm, vec4(289.0));
}

float psrdnoise(vec3 x, vec3 period, float alpha, out vec3 gradient)
{
    vec3 uvw = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * x;
    vec3 i0 = floor(uvw);
    vec3 f0 = fract(uvw);
    vec3 g_ = step(f0.xyx, f0.yzz);
    vec3 l_ = vec3(1.0) - g_;
    vec3 g = vec3(l_.z, g_.xy);
    vec3 l = vec3(l_.xy, g_.z);
    vec3 o1 = min(g, l);
    vec3 o2 = max(g, l);
    vec3 i1 = i0 + o1;
    vec3 i2 = i0 + o2;
    vec3 i3 = i0 + vec3(1.0);
    vec3 v0 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i0;
    vec3 v1 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i1;
    vec3 v2 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i2;
    vec3 v3 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i3;
    vec3 x0 = x - v0;
    vec3 x1 = x - v1;
    vec3 x2 = x - v2;
    vec3 x3 = x - v3;
    if (any(greaterThan(period, vec3(0.0))))
    {
        vec4 vx = vec4(v0.x, v1.x, v2.x, v3.x);
        vec4 vy = vec4(v0.y, v1.y, v2.y, v3.y);
        vec4 vz = vec4(v0.z, v1.z, v2.z, v3.z);
        if (period.x > 0.0)
        {
            vx = mod(vx, vec4(period.x));
        }
        if (period.y > 0.0)
        {
            vy = mod(vy, vec4(period.y));
        }
        if (period.z > 0.0)
        {
            vz = mod(vz, vec4(period.z));
        }
        i0 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.x, vy.x, vz.x);
        i1 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.y, vy.y, vz.y);
        i2 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.z, vy.z, vz.z);
        i3 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.w, vy.w, vz.w);
        i0 = floor(i0 + vec3(0.5));
        i1 = floor(i1 + vec3(0.5));
        i2 = floor(i2 + vec3(0.5));
        i3 = floor(i3 + vec3(0.5));
    }
    vec4 param = vec4(i0.z, i1.z, i2.z, i3.z);
    vec4 param_1 = _permute(param) + vec4(i0.y, i1.y, i2.y, i3.y);
    vec4 param_2 = _permute(param_1) + vec4(i0.x, i1.x, i2.x, i3.x);
    vec4 hash = _permute(param_2);
    vec4 theta = hash * 3.883222103118896484375;
    vec4 sz = (hash * (-0.006920414976775646209716796875)) + vec4(0.996539771556854248046875);
    vec4 psi = hash * 0.10870562493801116943359375;
    vec4 Ct = cos(theta);
    vec4 St = sin(theta);
    vec4 sz_prime = sqrt(vec4(1.0) - (sz * sz));
    vec4 gx;
    vec4 gy;
    vec4 gz;
    if (alpha != 0.0)
    {
        vec4 Sp = sin(psi);
        vec4 Cp = cos(psi);
        vec4 px = Ct * sz_prime;
        vec4 py = St * sz_prime;
        vec4 pz = sz;
        vec4 Ctp = (St * Sp) - (Ct * Cp);
        vec4 qx = mix(Ctp * St, Sp, sz);
        vec4 qy = mix((-Ctp) * Ct, Cp, sz);
        vec4 qz = -((py * Cp) + (px * Sp));
        vec4 Sa = vec4(sin(alpha));
        vec4 Ca = vec4(cos(alpha));
        gx = (Ca * px) + (Sa * qx);
        gy = (Ca * py) + (Sa * qy);
        gz = (Ca * pz) + (Sa * qz);
    }
    else
    {
        gx = Ct * sz_prime;
        gy = St * sz_prime;
        gz = sz;
    }
    vec3 g0 = vec3(gx.x, gy.x, gz.x);
    vec3 g1 = vec3(gx.y, gy.y, gz.y);
    vec3 g2 = vec3(gx.z, gy.z, gz.z);
    vec3 g3 = vec3(gx.w, gy.w, gz.w);
    vec4 w = vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3));
    w = max(w, vec4(0.0));
    vec4 w2 = w * w;
    vec4 w3 = w2 * w;
    vec4 gdotx = vec4(dot(g0, x0), dot(g1, x1), dot(g2, x2), dot(g3, x3));
    float n = dot(w3, gdotx);
    vec4 dw = (w2 * (-6.0)) * gdotx;
    vec3 dn0 = (g0 * w3.x) + (x0 * dw.x);
    vec3 dn1 = (g1 * w3.y) + (x1 * dw.y);
    vec3 dn2 = (g2 * w3.z) + (x2 * dw.z);
    vec3 dn3 = (g3 * w3.w) + (x3 * dw.w);
    gradient = (((dn0 + dn1) + dn2) + dn3) * 39.5;
    return 39.5 * n;
}

float modifier_factor_noise_snoise_simplex2(vec3 v)
{
    vec3 param = v;
    vec3 param_1 = vec3(0.0);
    float param_2 = 0.0;
    vec3 param_3;
    float _1132 = psrdnoise(param, param_1, param_2, param_3);
    vec3 gradient = param_3;
    float n = _1132;
    return n;
}

void modifier_factor_noise_simplex2(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1150 = vector_transform_by_mat43(param, param_1);
        coords = _1150;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1157 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1157;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = modifier_factor_noise_snoise_simplex2(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

void modifier_factor_mul_add(ModifierFactorMulAdd_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v * modifier_params.multiply_value) + modifier_params.add_value;
    modifier_factor.factor = v;
}

void _vertex_modifier_displace_apply(VertexModifierDisplaceParams params, ModifierFactor modifier_factor, inout VertexInput vtx, CoordinateSystemTrasforms cs_transforms)
{
    vec3 modifier_position = vec3(0.0);
    float influence = modifier_factor.factor;
    if (influence != 0.0)
    {
        vec3 n = vtx.norm;
        vec3 p = vtx.pos;
        p += ((params.displace_base * params.displace_base_modifier_factor) * influence);
        p += (((n * params.displace_normal) * params.displace_normal_modifier_factor) * influence);
        vtx.pos = p;
    }
}

void vertex_modifier_displace_apply(VertexModifierDisplaceParams params, inout ModifierFactor modifier_factor, inout VertexInput vtx, CoordinateSystemTrasforms cs_transforms)
{
    VertexModifierDisplaceParams param = params;
    ModifierFactor param_1 = modifier_factor;
    VertexInput param_2 = vtx;
    CoordinateSystemTrasforms param_3 = cs_transforms;
    _vertex_modifier_displace_apply(param, param_1, param_2, param_3);
    modifier_factor = param_1;
    vtx = param_2;
}

VertexInput apply_vertex_modifier_for_vtx(uint i0, inout VertexInput vtx_input, out float factor)
{
    mat4 mat_instance_model = mat_identity();
    mat4 mat_instance_model_inv = mat_instance_model;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = i0;
    modifier_factor.id = i0;
    modifier_factor.instance_id = 0u;
    modifier_factor.position = vtx_input.pos;
    modifier_factor.normal = vtx_input.norm;
    if ((_373.input_geometry_information.builtin_attribute_mask & 64u) != 0u)
    {
        uint param = i0;
        uint _1273 = get_custom0(param);
        modifier_factor.custom0 = _1273;
    }
    if ((_373.input_geometry_information.builtin_attribute_mask & 4u) != 0u)
    {
        uint param_1 = i0;
        vec3 _1283 = get_albedo(param_1);
        modifier_factor.color.x = _1283.x;
        modifier_factor.color.y = _1283.y;
        modifier_factor.color.z = _1283.z;
    }
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ModifierFactorDistanceRadial_Params _1306;
    _1306.transform_local_to_gizmo = _1301.VM0_params.transform_local_to_gizmo;
    _1306.falloff_curve_idx = _1301.VM0_params.falloff_curve_idx;
    _1306.falloff_inverse = _1301.VM0_params.falloff_inverse;
    _1306.domain_repeat_x = _1301.VM0_params.domain_repeat_x;
    _1306.domain_repeat_y = _1301.VM0_params.domain_repeat_y;
    _1306.domain_repeat_z = _1301.VM0_params.domain_repeat_z;
    _1306.influence_scope = _1301.VM0_params.influence_scope;
    _1306.modifier_function = _1301.VM0_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_2 = _1306;
    ModifierFactor param_3 = modifier_factor;
    CoordinateSystemTrasforms param_4 = cs_transforms;
    modifier_factor_distance_radial(param_2, param_3, param_4);
    modifier_factor = param_3;
    ModifierFactorNoise_Params _1321;
    _1321.transform_local_to_gizmo = _1316.VM1_params.transform_local_to_gizmo;
    _1321.noise_domain_scale = _1316.VM1_params.noise_domain_scale;
    _1321.modifier_function = _1316.VM1_params.modifier_function;
    _1321.noise_domain_offset = _1316.VM1_params.noise_domain_offset;
    _1321.noise_value_scale = _1316.VM1_params.noise_value_scale;
    _1321.noise_value_offset = _1316.VM1_params.noise_value_offset;
    _1321.influence_scope = _1316.VM1_params.influence_scope;
    _1321._pad0 = _1316.VM1_params._pad0;
    _1321._pad1 = _1316.VM1_params._pad1;
    ModifierFactorNoise_Params param_5 = _1321;
    ModifierFactor param_6 = modifier_factor;
    CoordinateSystemTrasforms param_7 = cs_transforms;
    modifier_factor_noise_simplex2(param_5, param_6, param_7);
    modifier_factor = param_6;
    modifier_factor.factor = abs(modifier_factor.factor);
    ModifierFactorMulAdd_Params _1340;
    _1340.multiply_value = _1335.VM2_params.multiply_value;
    _1340.add_value = _1335.VM2_params.add_value;
    ModifierFactorMulAdd_Params param_8 = _1340;
    ModifierFactor param_9 = modifier_factor;
    modifier_factor_mul_add(param_8, param_9);
    modifier_factor = param_9;
    ModifierFactorDistanceRadial_Params _1351;
    _1351.transform_local_to_gizmo = _1347.VM3_params.transform_local_to_gizmo;
    _1351.falloff_curve_idx = _1347.VM3_params.falloff_curve_idx;
    _1351.falloff_inverse = _1347.VM3_params.falloff_inverse;
    _1351.domain_repeat_x = _1347.VM3_params.domain_repeat_x;
    _1351.domain_repeat_y = _1347.VM3_params.domain_repeat_y;
    _1351.domain_repeat_z = _1347.VM3_params.domain_repeat_z;
    _1351.influence_scope = _1347.VM3_params.influence_scope;
    _1351.modifier_function = _1347.VM3_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_10 = _1351;
    ModifierFactor param_11 = modifier_factor;
    CoordinateSystemTrasforms param_12 = cs_transforms;
    modifier_factor_distance_radial(param_10, param_11, param_12);
    modifier_factor = param_11;
    VertexModifierDisplaceParams _1366;
    _1366.displace_normal = _1361.VM4_params.displace_normal;
    _1366.displace_normal_modifier_factor = _1361.VM4_params.displace_normal_modifier_factor;
    _1366.displace_base = _1361.VM4_params.displace_base;
    _1366.displace_base_modifier_factor = _1361.VM4_params.displace_base_modifier_factor;
    _1366.influence_scope = _1361.VM4_params.influence_scope;
    VertexModifierDisplaceParams param_13 = _1366;
    ModifierFactor param_14 = modifier_factor;
    VertexInput param_15 = vtx_input;
    CoordinateSystemTrasforms param_16 = cs_transforms;
    vertex_modifier_displace_apply(param_13, param_14, param_15, param_16);
    modifier_factor = param_14;
    vtx_input = param_15;
    factor = modifier_factor.factor;
    return vtx_input;
}

void put_coords(inout uint idx, vec3 v)
{
    idx *= _260.output_geometry_information.attributes[0].stride;
    idx += _260.output_geometry_information.attributes[0].offset;
    out_vtx_coords.data[idx + 0u] = v.x;
    out_vtx_coords.data[idx + 1u] = v.y;
    out_vtx_coords.data[idx + 2u] = v.z;
}

void put_normal(inout uint idx, vec3 v)
{
    idx *= _260.output_geometry_information.attributes[1].stride;
    idx += _260.output_geometry_information.attributes[1].offset;
    out_vtx_normals.data[idx + 0u] = v.x;
    out_vtx_normals.data[idx + 1u] = v.y;
    out_vtx_normals.data[idx + 2u] = v.z;
}

void put_albedo(inout uint idx, vec3 v)
{
    idx *= _260.output_geometry_information.attributes[2].stride;
    idx += _260.output_geometry_information.attributes[2].offset;
    out_vtx_albedo.data[idx + 0u] = v.x;
    out_vtx_albedo.data[idx + 1u] = v.y;
    out_vtx_albedo.data[idx + 2u] = v.z;
}

void put_custom0(inout uint idx, uint v)
{
    idx *= _260.output_geometry_information.attributes[6].stride;
    idx += _260.output_geometry_information.attributes[6].offset;
    out_vtx_custom0.data[idx + 0u] = v;
}

void main()
{
    uint thread_idx = gl_GlobalInvocationID.x;
    uint surface_idx = uint(_1392.geometry_copy_deform_params.surface_idx);
    uint src_faces_num = _373.input_geometry_information.faces_num_per_surface[surface_idx];
    uint src_face_idx = thread_idx;
    for (;;)
    {
        if (src_face_idx < src_faces_num)
        {
            uint param = (src_face_idx * 3u) + 0u;
            uint _1416 = get_idx(param);
            uint i0 = _1416;
            uint param_1 = (src_face_idx * 3u) + 1u;
            uint _1422 = get_idx(param_1);
            uint i1 = _1422;
            uint param_2 = (src_face_idx * 3u) + 2u;
            uint _1428 = get_idx(param_2);
            uint i2 = _1428;
            uint dst_face_idx = src_face_idx;
            uint param_3 = (dst_face_idx * 3u) + 0u;
            uint param_4 = i0;
            put_idx(param_3, param_4);
            uint param_5 = (dst_face_idx * 3u) + 1u;
            uint param_6 = i1;
            put_idx(param_5, param_6);
            uint param_7 = (dst_face_idx * 3u) + 2u;
            uint param_8 = i2;
            put_idx(param_7, param_8);
            src_face_idx += 131072u;
            continue;
        }
        else
        {
            break;
        }
    }
    _260.output_geometry_information.faces_num_per_surface[surface_idx] = src_faces_num;
    if (surface_idx == 0u)
    {
        uint src_vtx_num = _373.input_geometry_information.vtx_num;
        VertexInput vtx_input;
        float param_15;
        uint src_vtx_idx = thread_idx;
        for (;;)
        {
            if (src_vtx_idx < src_vtx_num)
            {
                uint i0_1 = src_vtx_idx;
                uint i0_remapped = vtx_copy_flag_data.data[i0_1];
                bool i0_copy = i0_remapped != 0u;
                i0_remapped--;
                if (i0_copy)
                {
                    uint param_9 = i0_1;
                    vec3 _1496 = get_coords(param_9);
                    vec3 v0_coords = _1496;
                    vec3 v0_normal = vec3(0.0, 0.0, 1.0);
                    if ((_373.input_geometry_information.builtin_attribute_mask & 2u) != 0u)
                    {
                        uint param_10 = i0_1;
                        vec3 _1507 = get_normal(param_10);
                        v0_normal = _1507;
                    }
                    vec3 v0_albedo = vec3(1.0);
                    if ((_373.input_geometry_information.builtin_attribute_mask & 4u) != 0u)
                    {
                        uint param_11 = i0_1;
                        vec3 _1517 = get_albedo(param_11);
                        v0_albedo = _1517;
                    }
                    uint v0_custom0 = 0u;
                    if ((_373.input_geometry_information.builtin_attribute_mask & 64u) != 0u)
                    {
                        uint param_12 = i0_1;
                        uint _1527 = get_custom0(param_12);
                        v0_custom0 = _1527;
                    }
                    vtx_input.pos = v0_coords;
                    vtx_input.norm = v0_normal;
                    vtx_input.color.x = v0_albedo.x;
                    vtx_input.color.y = v0_albedo.y;
                    vtx_input.color.z = v0_albedo.z;
                    uint param_13 = i0_1;
                    VertexInput param_14 = vtx_input;
                    VertexInput _1546 = apply_vertex_modifier_for_vtx(param_13, param_14, param_15);
                    float modifier_factor = param_15;
                    vtx_input = _1546;
                    if (_1392.geometry_copy_deform_params.export_factor_as_custom0 != 0)
                    {
                        v0_custom0 = floatBitsToUint(modifier_factor);
                    }
                    uint param_16 = i0_remapped;
                    vec3 param_17 = vtx_input.pos;
                    put_coords(param_16, param_17);
                    if ((_260.output_geometry_information.builtin_attribute_mask & 2u) != 0u)
                    {
                        uint param_18 = i0_remapped;
                        vec3 param_19 = vtx_input.norm;
                        put_normal(param_18, param_19);
                    }
                    if ((_260.output_geometry_information.builtin_attribute_mask & 4u) != 0u)
                    {
                        uint param_20 = i0_remapped;
                        vec3 param_21 = v0_albedo;
                        put_albedo(param_20, param_21);
                    }
                    if ((_260.output_geometry_information.builtin_attribute_mask & 64u) != 0u)
                    {
                        uint param_22 = i0_remapped;
                        uint param_23 = v0_custom0;
                        put_custom0(param_22, param_23);
                    }
                }
                src_vtx_idx += 131072u;
                continue;
            }
            else
            {
                break;
            }
        }
    }
}

 