#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_ARB_gpu_shader_int64)
#extension GL_ARB_gpu_shader_int64 : require
#else
#error No extension available for 64-bit integers.
#endif
layout(local_size_x = 1, local_size_y = 1, local_size_z = 1) in;

struct GPUHashMapHeader
{
    uint capacity;
    uint _pad0;
    uint _pad1;
    uint _pad2;
};

layout(set = 0, binding = 1, std430) buffer GPUHashMapHeaderBuffer
{
    GPUHashMapHeader header;
} gpu_hashmap;

layout(set = 0, binding = 2, std140) uniform GPUHashMapSetupParamsBuffer
{
    uint capacity;
    uint _pad0;
    uint _pad1;
    uint _pad2;
} setup_params;

void main()
{
    gpu_hashmap.header.capacity = setup_params.capacity;
}

 