#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct InstancingGeneratorParams
{
    uvec3 resolution;
    vec3 bbox_position;
    vec3 bbox_dimensions;
    vec3 instance_scale_base;
    vec3 instance_scale_factor;
    float function_scale;
    float function_threshold;
    float orientation_blend;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer InstanceParamsBuffer
{
    InstanceParams instance_params;
} _87;

layout(set = 0, binding = 6, scalar) uniform InstancingGeneratorParamsBuffer
{
    InstancingGeneratorParams instancing_generator_params;
} _105;

layout(set = 0, binding = 2, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _426;

layout(set = 0, binding = 3, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _450;

layout(set = 0, binding = 4, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _471;

layout(set = 0, binding = 5, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _479;

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    if (_87.instance_params.instance_count >= _87.instance_params.buffer_capacity)
    {
        return;
    }
    uint instance_position_id = id;
    uvec3 instance_position_int;
    instance_position_int.z = instance_position_id / (_105.instancing_generator_params.resolution.x * _105.instancing_generator_params.resolution.y);
    instance_position_id -= (instance_position_int.z * (_105.instancing_generator_params.resolution.x * _105.instancing_generator_params.resolution.y));
    instance_position_int.y = instance_position_id / _105.instancing_generator_params.resolution.x;
    instance_position_id -= (instance_position_int.y * _105.instancing_generator_params.resolution.x);
    instance_position_int.x = instance_position_id;
    vec3 instancing_bbox_origin = _105.instancing_generator_params.bbox_position;
    vec3 instancing_bbox_size = _105.instancing_generator_params.bbox_dimensions;
    vec3 instance_position = ((vec3(instance_position_int) / vec3(_105.instancing_generator_params.resolution)) * instancing_bbox_size) + instancing_bbox_origin;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    modifier_factor.position = instance_position;
    modifier_factor.is_spawned = true;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    float mf = (modifier_factor.factor * _105.instancing_generator_params.function_scale) - _105.instancing_generator_params.function_threshold;
    if ((mf <= 0.0) || modifier_factor.is_discarded)
    {
        return;
    }
    vec3 instance_scale = _105.instancing_generator_params.instance_scale_base + (_105.instancing_generator_params.instance_scale_factor * mf);
    float modifier_factor_v = modifier_factor.factor;
    float modifier_factor_v_dx = modifier_factor.factor;
    float modifier_factor_v_dy = modifier_factor.factor;
    float modifier_factor_v_dz = modifier_factor.factor;
    ModifierFactor modifier_factor_1 = modifier_factor_defaults();
    modifier_factor_1.factor = 1.0;
    modifier_factor_1.hash = id;
    modifier_factor_1.id = id;
    modifier_factor_1.instance_id = id;
    modifier_factor_1.position = instance_position + vec3(instancing_bbox_size.x / float(_105.instancing_generator_params.resolution.x), 0.0, 0.0);
    modifier_factor_1.is_spawned = true;
    modifier_factor_v_dx = modifier_factor_1.factor;
    ModifierFactor modifier_factor_2 = modifier_factor_defaults();
    modifier_factor_2.factor = 1.0;
    modifier_factor_2.hash = id;
    modifier_factor_2.id = id;
    modifier_factor_2.instance_id = id;
    modifier_factor_2.position = instance_position + vec3(0.0, instancing_bbox_size.y / float(_105.instancing_generator_params.resolution.y), 0.0);
    modifier_factor_2.is_spawned = true;
    modifier_factor_v_dy = modifier_factor_2.factor;
    ModifierFactor modifier_factor_3 = modifier_factor_defaults();
    modifier_factor_3.factor = 1.0;
    modifier_factor_3.hash = id;
    modifier_factor_3.id = id;
    modifier_factor_3.instance_id = id;
    modifier_factor_3.position = instance_position + vec3(0.0, 0.0, instancing_bbox_size.z / float(_105.instancing_generator_params.resolution.z));
    modifier_factor_3.is_spawned = true;
    modifier_factor_v_dz = modifier_factor_3.factor;
    vec3 n;
    n.x = modifier_factor_v_dx - modifier_factor_v;
    n.y = modifier_factor_v_dy - modifier_factor_v;
    n.z = modifier_factor_v_dz - modifier_factor_v;
    n = mix(vec3(0.0, 0.0, 1.0), n, vec3(_105.instancing_generator_params.orientation_blend));
    n = normalize(n);
    mat3 r;
    r[2] = n;
    r[1] = cross(vec3(0.0, 1.0, 0.0), r[2]);
    r[0] = cross(r[2], r[1]);
    r[1] = cross(r[2], r[0]);
    mat3 s;
    s[0] = vec3(instance_scale.x, 0.0, 0.0);
    s[1] = vec3(0.0, instance_scale.y, 0.0);
    s[2] = vec3(0.0, 0.0, instance_scale.z);
    mat3 transform = r * s;
    transform = s * r;
    transform = transpose(transform);
    Instance instance;
    instance.m0 = vec4(transform[0], instance_position.x);
    instance.m1 = vec4(transform[1], instance_position.y);
    instance.m2 = vec4(transform[2], instance_position.z);
    instance.hash = modifier_factor.hash;
    instance.c = vec4(1.0);
    instance.flipbook_card = 0u;
    bool _389 = length(instance.m0.xyz) <= 0.0;
    bool _398;
    if (!_389)
    {
        _398 = length(instance.m1.xyz) <= 0.0;
    }
    else
    {
        _398 = _389;
    }
    bool _407;
    if (!_398)
    {
        _407 = length(instance.m1.xyz) <= 0.0;
    }
    else
    {
        _407 = _398;
    }
    if (_407)
    {
        return;
    }
    int _413 = atomicAdd(_87.instance_params.instance_count, 1);
    uint instance_id = uint(_413);
    if (instance_id >= uint(_87.instance_params.buffer_capacity))
    {
        return;
    }
    _426.instance_transform[(instance_id * 3u) + 0u] = instance.m0;
    _426.instance_transform[(instance_id * 3u) + 1u] = instance.m1;
    _426.instance_transform[(instance_id * 3u) + 2u] = instance.m2;
    _450.instance_color[(instance_id * 2u) + 0u] = packHalf2x16(instance.c.xy);
    _450.instance_color[(instance_id * 2u) + 1u] = packHalf2x16(instance.c.zw);
    _471.instance_hash[instance_id] = instance.hash;
    _479.instance_flipbook_card[instance_id] = instance.flipbook_card;
}

 