#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorCurveTransfer_Params
{
    int curve_idx;
    float input_range_min;
    float input_range_max;
    float amplitude;
    float base;
};

struct ModifierFactorClamp_Params
{
    float clamp_min;
    float clamp_max;
    int clamp_min_enable;
    int clamp_max_enable;
};

struct ModifierFactorFrustumCull_Params
{
    mat4 transform_local_to_gizmo;
    mat4 transform_world_to_view;
    mat4 transform_projection;
    float instance_radius;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct InstancingGeneratorParams
{
    float color_lod;
    float occupancy_lod;
    float occupancy_threshold;
    int bbox_from_voxelizer;
    uvec3 resolution;
    int _pad2;
    vec3 bbox_position;
    int _pad3;
    vec3 bbox_dimensions;
    int _pad4;
    vec3 instance_scale_base;
    int _pad7;
    vec3 instance_scale_factor;
    int _pad8;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 1, std430) buffer InstanceParamsBuffer
{
    InstanceParams instance_params;
} _814;

layout(set = 0, binding = 7, std140) uniform InstancingGeneratorParamsBuffer
{
    InstancingGeneratorParams instancing_generator_params;
} _832;

layout(set = 0, binding = 2, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_raytrace_recip;
    vec4 grid_size_voxelize;
    vec4 grid_size_voxelize_recip;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 0, binding = 8, std140) uniform VM0
{
    layout(row_major) ModifierFactorNoise_Params VM0_params;
} _1011;

layout(set = 0, binding = 9, std140) uniform VM1
{
    ModifierFactorCurveTransfer_Params VM1_params;
} _1026;

layout(set = 0, binding = 10, std140) uniform VM2
{
    ModifierFactorClamp_Params VM2_params;
} _1039;

layout(set = 0, binding = 11, std140) uniform VM3
{
    layout(row_major) ModifierFactorFrustumCull_Params VM3_params;
} _1052;

layout(set = 0, binding = 3, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1213;

layout(set = 0, binding = 4, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _1235;

layout(set = 0, binding = 5, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _1256;

layout(set = 0, binding = 6, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _1264;

layout(set = 0, binding = 12) uniform sampler2D s_Curves;
layout(set = 0, binding = 13) uniform sampler3D s_voxel_colors_filtered;
layout(set = 0, binding = 14) uniform sampler3D s_voxel_occupancy_filtered;

vec3 color_convert_rgbm_rgb(inout vec4 v)
{
    vec4 _105 = v;
    float _109 = v.w;
    vec3 _112 = (_105.xyz * _109) * 128.0;
    v.x = _112.x;
    v.y = _112.y;
    v.z = _112.z;
    return v.xyz * v.xyz;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise_default(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _608 = vector_transform_by_mat43(param, param_1);
        coords = _608;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _615 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _615;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_factor_curve_transfer(ModifierFactorCurveTransfer_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v - modifier_params.input_range_min) / (modifier_params.input_range_max - modifier_params.input_range_min);
    v = clamp(v, 0.0, 1.0);
    int param = modifier_params.curve_idx;
    float param_1 = v;
    v = curve_sample(param, param_1);
    v = (v * modifier_params.amplitude) + modifier_params.base;
    modifier_factor.factor = v;
}

void modifier_factor_clamp(ModifierFactorClamp_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    if (modifier_params.clamp_min_enable != 0)
    {
        v = max(v, modifier_params.clamp_min);
    }
    if (modifier_params.clamp_max_enable != 0)
    {
        v = min(v, modifier_params.clamp_max);
    }
    modifier_factor.factor = v;
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    return m * vec4(v, 1.0);
}

void modifier_factor_frustum_cull(ModifierFactorFrustumCull_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    vec3 param = coords;
    mat4 param_1 = cs_transforms.mat_local_to_model;
    vec3 _725 = vector_transform_by_mat43(param, param_1);
    coords = _725;
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_world_to_view;
    vec3 _731 = vector_transform_by_mat43(param_2, param_3);
    coords = _731;
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 _738 = vector_transform_by_mat43(param_4, param_5);
    vec3 rel_coords = _738;
    vec3 param_6 = rel_coords;
    mat4 param_7 = modifier_params.transform_projection;
    vec4 _745 = vector_transform_by_mat_projection(param_6, param_7);
    vec4 projected = _745;
    float margin = 0.100000001490116119384765625;
    vec4 _750 = projected;
    vec2 _752 = _750.xy * (1.0 - margin);
    projected.x = _752.x;
    projected.y = _752.y;
    bool _762 = projected.x < (-projected.w);
    bool _771;
    if (!_762)
    {
        _771 = projected.x > projected.w;
    }
    else
    {
        _771 = _762;
    }
    bool _781;
    if (!_771)
    {
        _781 = projected.y < (-projected.w);
    }
    else
    {
        _781 = _771;
    }
    bool _790;
    if (!_781)
    {
        _790 = projected.y > projected.w;
    }
    else
    {
        _790 = _781;
    }
    bool _799;
    if (!_790)
    {
        _799 = projected.z < (-margin);
    }
    else
    {
        _799 = _790;
    }
    if (_799)
    {
        modifier_factor.is_discarded = true;
    }
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    if (_814.instance_params.instance_count >= _814.instance_params.buffer_capacity)
    {
        return;
    }
    uint instance_position_id = id;
    uvec3 instance_position_int;
    instance_position_int.z = instance_position_id / (_832.instancing_generator_params.resolution.x * _832.instancing_generator_params.resolution.y);
    instance_position_id -= (instance_position_int.z * (_832.instancing_generator_params.resolution.x * _832.instancing_generator_params.resolution.y));
    instance_position_int.y = instance_position_id / _832.instancing_generator_params.resolution.x;
    instance_position_id -= (instance_position_int.y * _832.instancing_generator_params.resolution.x);
    instance_position_int.x = instance_position_id;
    vec3 instancing_bbox_origin = in_bbox_data.bbox_voxelize_min.xyz;
    vec3 instancing_bbox_size = in_bbox_data.grid_size_voxelize.xyz * 256.0;
    if (_832.instancing_generator_params.bbox_from_voxelizer == 0)
    {
        instancing_bbox_origin = _832.instancing_generator_params.bbox_position;
        instancing_bbox_size = _832.instancing_generator_params.bbox_dimensions;
    }
    vec3 instance_position = ((vec3(instance_position_int) / vec3(_832.instancing_generator_params.resolution)) * instancing_bbox_size) + instancing_bbox_origin;
    vec3 voxelizer_bbox_origin = in_bbox_data.bbox_voxelize_min.xyz;
    vec3 voxelizer_bbox_size = in_bbox_data.grid_size_voxelize.xyz * 256.0;
    vec3 source_voxel_position = (instance_position - voxelizer_bbox_origin) / voxelizer_bbox_size;
    bool _918 = source_voxel_position.x < 0.0;
    bool _925;
    if (!_918)
    {
        _925 = source_voxel_position.y < 0.0;
    }
    else
    {
        _925 = _918;
    }
    bool _932;
    if (!_925)
    {
        _932 = source_voxel_position.z < 0.0;
    }
    else
    {
        _932 = _925;
    }
    bool _939;
    if (!_932)
    {
        _939 = source_voxel_position.x >= 1.0;
    }
    else
    {
        _939 = _932;
    }
    bool _946;
    if (!_939)
    {
        _946 = source_voxel_position.y >= 1.0;
    }
    else
    {
        _946 = _939;
    }
    bool _953;
    if (!_946)
    {
        _953 = source_voxel_position.z >= 1.0;
    }
    else
    {
        _953 = _946;
    }
    if (_953)
    {
        return;
    }
    vec4 param = textureLod(s_voxel_colors_filtered, source_voxel_position, _832.instancing_generator_params.color_lod);
    vec3 _969 = color_convert_rgbm_rgb(param);
    vec3 voxel_color = _969;
    float voxel_occupancy = textureLod(s_voxel_occupancy_filtered, source_voxel_position, _832.instancing_generator_params.occupancy_lod).x;
    if (voxel_occupancy <= _832.instancing_generator_params.occupancy_threshold)
    {
        return;
    }
    voxel_occupancy -= _832.instancing_generator_params.occupancy_threshold;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    modifier_factor.position = instance_position;
    modifier_factor.is_spawned = true;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ModifierFactorNoise_Params _1016;
    _1016.transform_local_to_gizmo = _1011.VM0_params.transform_local_to_gizmo;
    _1016.noise_domain_scale = _1011.VM0_params.noise_domain_scale;
    _1016.modifier_function = _1011.VM0_params.modifier_function;
    _1016.noise_domain_offset = _1011.VM0_params.noise_domain_offset;
    _1016.noise_value_scale = _1011.VM0_params.noise_value_scale;
    _1016.noise_value_offset = _1011.VM0_params.noise_value_offset;
    _1016.influence_scope = _1011.VM0_params.influence_scope;
    _1016._pad0 = _1011.VM0_params._pad0;
    _1016._pad1 = _1011.VM0_params._pad1;
    ModifierFactorNoise_Params param_1 = _1016;
    ModifierFactor param_2 = modifier_factor;
    CoordinateSystemTrasforms param_3 = cs_transforms;
    modifier_factor_noise_default(param_1, param_2, param_3);
    modifier_factor = param_2;
    ModifierFactorCurveTransfer_Params _1031;
    _1031.curve_idx = _1026.VM1_params.curve_idx;
    _1031.input_range_min = _1026.VM1_params.input_range_min;
    _1031.input_range_max = _1026.VM1_params.input_range_max;
    _1031.amplitude = _1026.VM1_params.amplitude;
    _1031.base = _1026.VM1_params.base;
    ModifierFactorCurveTransfer_Params param_4 = _1031;
    ModifierFactor param_5 = modifier_factor;
    modifier_factor_curve_transfer(param_4, param_5);
    modifier_factor = param_5;
    ModifierFactorClamp_Params _1044;
    _1044.clamp_min = _1039.VM2_params.clamp_min;
    _1044.clamp_max = _1039.VM2_params.clamp_max;
    _1044.clamp_min_enable = _1039.VM2_params.clamp_min_enable;
    _1044.clamp_max_enable = _1039.VM2_params.clamp_max_enable;
    ModifierFactorClamp_Params param_6 = _1044;
    ModifierFactor param_7 = modifier_factor;
    modifier_factor_clamp(param_6, param_7);
    modifier_factor = param_7;
    ModifierFactorFrustumCull_Params _1057;
    _1057.transform_local_to_gizmo = _1052.VM3_params.transform_local_to_gizmo;
    _1057.transform_world_to_view = _1052.VM3_params.transform_world_to_view;
    _1057.transform_projection = _1052.VM3_params.transform_projection;
    _1057.instance_radius = _1052.VM3_params.instance_radius;
    ModifierFactorFrustumCull_Params param_8 = _1057;
    ModifierFactor param_9 = modifier_factor;
    CoordinateSystemTrasforms param_10 = cs_transforms;
    modifier_factor_frustum_cull(param_8, param_9, param_10);
    modifier_factor = param_9;
    bool _1067 = modifier_factor.factor <= 9.9999997473787516355514526367188e-05;
    bool _1074;
    if (!_1067)
    {
        _1074 = modifier_factor.is_discarded == true;
    }
    else
    {
        _1074 = _1067;
    }
    if (_1074)
    {
        return;
    }
    vec3 instance_scale = _832.instancing_generator_params.instance_scale_base + (_832.instancing_generator_params.instance_scale_factor * (voxel_occupancy * modifier_factor.factor));
    bool _1091 = instance_scale.x <= 0.0;
    bool _1098;
    if (!_1091)
    {
        _1098 = instance_scale.y <= 0.0;
    }
    else
    {
        _1098 = _1091;
    }
    bool _1105;
    if (!_1098)
    {
        _1105 = instance_scale.z <= 0.0;
    }
    else
    {
        _1105 = _1098;
    }
    if (_1105)
    {
        return;
    }
    voxel_color += vec3(voxel_occupancy * 0.00999999977648258209228515625);
    mat3 transform;
    transform[0] = vec3(instance_scale.x, 0.0, 0.0);
    transform[1] = vec3(0.0, instance_scale.y, 0.0);
    transform[2] = vec3(0.0, 0.0, instance_scale.z);
    transform = transpose(transform);
    Instance instance;
    instance.m0 = vec4(transform[0], instance_position.x);
    instance.m1 = vec4(transform[1], instance_position.y);
    instance.m2 = vec4(transform[2], instance_position.z);
    instance.hash = modifier_factor.hash;
    instance.c = vec4(voxel_color, 1.0);
    instance.flipbook_card = 0u;
    bool _1176 = length(instance.m0.xyz) < 9.9999997473787516355514526367188e-05;
    bool _1185;
    if (!_1176)
    {
        _1185 = length(instance.m1.xyz) < 9.9999997473787516355514526367188e-05;
    }
    else
    {
        _1185 = _1176;
    }
    bool _1194;
    if (!_1185)
    {
        _1194 = length(instance.m1.xyz) < 9.9999997473787516355514526367188e-05;
    }
    else
    {
        _1194 = _1185;
    }
    if (_1194)
    {
        return;
    }
    int _1200 = atomicAdd(_814.instance_params.instance_count, 1);
    uint instance_id = uint(_1200);
    if (instance_id >= uint(_814.instance_params.buffer_capacity))
    {
        return;
    }
    _1213.instance_transform[(instance_id * 3u) + 0u] = instance.m0;
    _1213.instance_transform[(instance_id * 3u) + 1u] = instance.m1;
    _1213.instance_transform[(instance_id * 3u) + 2u] = instance.m2;
    _1235.instance_color[(instance_id * 2u) + 0u] = packHalf2x16(instance.c.xy);
    _1235.instance_color[(instance_id * 2u) + 1u] = packHalf2x16(instance.c.zw);
    _1256.instance_hash[instance_id] = instance.hash;
    _1264.instance_flipbook_card[instance_id] = instance.flipbook_card;
}

 