#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ModifierFactorDistanceRadial_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_repeat_x;
    int domain_repeat_y;
    int domain_repeat_z;
    int influence_scope;
    int modifier_function;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct VertexModifierGerstnerWavesParams
{
    mat4 transform_world_to_local;
    mat4 transform_local_to_world;
    mat4 transform_local;
    mat4 transform_local_inv;
    mat4 transform_parent;
    mat4 transform_parent_inv;
    uvec4 wave_directions[16];
    vec4 noise_phase;
    vec3 domain_scale;
    int _pad0;
    vec3 strength;
    int _pad1;
    vec3 position;
    int noise_relative_to_modifier;
    int displacement_mode;
    float noise_value_base;
    int noise_value_absolute;
    float wave_length;
    float wave_steepness;
    int wave_octaves;
    float wave_octave_scale;
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct VertexModifierDisplaceParams
{
    vec3 displace_normal;
    float displace_normal_modifier_factor;
    vec3 displace_base;
    float displace_base_modifier_factor;
    int influence_scope;
};

struct VertexModifierUVParams
{
    mat4 transform;
    bool override;
    int override_mode;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct VertexModifierUVParams_1
{
    mat4 transform;
    uint override;
    int override_mode;
};

struct _1474
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 10, scalar) uniform GeometryInformationBuffer
{
    GeometryInformation geometry_information;
} _268;

layout(set = 0, binding = 1, std430) readonly buffer VTXCoords
{
    float coords[];
} vtx_coords;

layout(set = 0, binding = 2, std430) readonly buffer VTXNormals
{
    float normals[];
} vtx_normals;

layout(set = 0, binding = 3, std430) readonly buffer VTXAlbedo
{
    float albedo[];
} vtx_albedo;

layout(set = 0, binding = 4, std430) readonly buffer VTXUV0
{
    float uv0[];
} vtx_uv0;

layout(set = 0, binding = 5, std430) readonly buffer VTXCustom0
{
    uint custom0[];
} vtx_custom0;

layout(set = 0, binding = 11, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1063;

layout(set = 0, binding = 6, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _1074;

layout(set = 0, binding = 7, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1162;

layout(set = 0, binding = 8, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _1354;

layout(set = 0, binding = 12, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _1395;

layout(set = 0, binding = 13, std140) uniform VM0
{
    layout(row_major) ModifierFactorDistanceRadial_Params VM0_params;
} _1408;

layout(set = 0, binding = 14, std140) uniform VM1
{
    layout(row_major) VertexModifierGerstnerWavesParams VM1_params;
} _1424;

layout(set = 0, binding = 15, std140) uniform VM2
{
    VertexModifierDisplaceParams VM2_params;
} _1440;

layout(set = 0, binding = 16, std140) uniform VM3
{
    layout(row_major) VertexModifierUVParams_1 VM3_params;
} _1458;

layout(set = 0, binding = 9, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _1569;

layout(set = 0, binding = 17) uniform sampler2D s_Curves;

layout(location = 1) out _1474 vtx_output;
layout(location = 0) out uint instanceID;

vec3 vtx_coords_load(inout uint idx)
{
    idx *= _268.geometry_information.attributes[0].stride;
    idx += _268.geometry_information.attributes[0].offset;
    return vec3(vtx_coords.coords[idx + 0u], vtx_coords.coords[idx + 1u], vtx_coords.coords[idx + 2u]);
}

vec3 vtx_albedo_load(inout uint idx)
{
    idx *= _268.geometry_information.attributes[2].stride;
    idx += _268.geometry_information.attributes[2].offset;
    return vec3(vtx_albedo.albedo[idx + 0u], vtx_albedo.albedo[idx + 1u], vtx_albedo.albedo[idx + 2u]);
}

vec3 vtx_normals_load(inout uint idx)
{
    idx *= _268.geometry_information.attributes[1].stride;
    idx += _268.geometry_information.attributes[1].offset;
    return vec3(vtx_normals.normals[idx + 0u], vtx_normals.normals[idx + 1u], vtx_normals.normals[idx + 2u]);
}

vec2 vtx_uv0_load(inout uint idx)
{
    idx *= _268.geometry_information.attributes[3].stride;
    idx += _268.geometry_information.attributes[3].offset;
    return vec2(vtx_uv0.uv0[idx + 0u], vtx_uv0.uv0[idx + 1u]);
}

float det(mat2 matrix)
{
    return (matrix[0].x * matrix[1].y) - (matrix[0].y * matrix[1].x);
}

mat3 transpose_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat3 result = mat3(vec3(vec3(row0.x, row1.x, row2.x)), vec3(vec3(row0.y, row1.y, row2.y)), vec3(vec3(row0.z, row1.z, row2.z)));
    return result;
}

mat3 inverse_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat2 param = mat2(vec2(row1.y, row1.z), vec2(row2.y, row2.z));
    mat2 param_1 = mat2(vec2(row1.z, row1.x), vec2(row2.z, row2.x));
    mat2 param_2 = mat2(vec2(row1.x, row1.y), vec2(row2.x, row2.y));
    vec3 minors0 = vec3(det(param), det(param_1), det(param_2));
    mat2 param_3 = mat2(vec2(row2.y, row2.z), vec2(row0.y, row0.z));
    mat2 param_4 = mat2(vec2(row2.z, row2.x), vec2(row0.z, row0.x));
    mat2 param_5 = mat2(vec2(row2.x, row2.y), vec2(row0.x, row0.y));
    vec3 minors1 = vec3(det(param_3), det(param_4), det(param_5));
    mat2 param_6 = mat2(vec2(row0.y, row0.z), vec2(row1.y, row1.z));
    mat2 param_7 = mat2(vec2(row0.z, row0.x), vec2(row1.z, row1.x));
    mat2 param_8 = mat2(vec2(row0.x, row0.y), vec2(row1.x, row1.y));
    vec3 minors2 = vec3(det(param_6), det(param_7), det(param_8));
    mat3 param_9 = mat3(vec3(minors0), vec3(minors1), vec3(minors2));
    mat3 adj = transpose_mat3(param_9);
    return adj * (1.0 / dot(row0, minors0));
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

uint vtx_custom0_load(inout uint idx)
{
    idx *= _268.geometry_information.attributes[6].stride;
    idx += _268.geometry_information.attributes[6].offset;
    return vtx_custom0.custom0[idx + 0u];
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_distance_radial(ModifierFactorDistanceRadial_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_factor.has_world_position == false)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_model;
        vec3 _426 = vector_transform_by_mat43(param, param_1);
        coords = _426;
        if (modifier_params.influence_scope == 1)
        {
            vec3 param_2 = coords;
            mat4 param_3 = cs_transforms.mat_local_to_instance;
            vec3 _437 = vector_transform_by_mat43(param_2, param_3);
            coords = _437;
        }
    }
    else
    {
        coords = modifier_factor.world_position;
    }
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 _447 = vector_transform_by_mat43(param_4, param_5);
    vec3 rel_coords = _447;
    if (modifier_params.domain_repeat_x != 0)
    {
        rel_coords.x = (fract(rel_coords.x * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_y != 0)
    {
        rel_coords.y = (fract(rel_coords.y * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_z != 0)
    {
        rel_coords.z = (fract(rel_coords.z * 2.0) - 0.5) * 2.0;
    }
    float influence = length(rel_coords);
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_6 = modifier_params.falloff_curve_idx;
    float param_7 = influence;
    influence = curve_sample(param_6, param_7);
    float v = influence;
    ModifierFactor param_8 = modifier_factor;
    uint param_9 = uint(modifier_params.modifier_function);
    float param_10 = v;
    modifier_process_modifier_factor(param_8, param_9, param_10);
    modifier_factor = param_8;
}

vec2 gerstner_evaluate_single(vec2 p, float t, float steepness, float wave_length, vec2 wave_direction)
{
    float k = 6.283185482025146484375 / wave_length;
    float c = sqrt(9.80000019073486328125 / k);
    float f = k * (dot(wave_direction, p) - (c * t));
    float a = steepness / k;
    return vec2(a * cos(f), a * sin(f));
}

void vertex_modifier_gerstner_waves_apply(VertexModifierGerstnerWavesParams params, ModifierFactor modifier_factor, inout VertexInput vtx)
{
    vec3 modifier_position = vec3(0.0);
    vec3 base_pos = vtx.pos;
    vec3 influence_pos = vtx.pos;
    vec3 noise_pos = influence_pos;
    if (params.noise_relative_to_modifier == 0)
    {
        vec3 param = noise_pos;
        mat4 param_1 = params.transform_local;
        vec3 _569 = vector_transform_by_mat43(param, param_1);
        noise_pos = _569;
    }
    float influence = modifier_factor.factor;
    if (influence > 0.0)
    {
        vec2 wave = vec2(0.0);
        float wave_length = params.wave_length;
        vec2 wave_direction;
        int wi = 0;
        for (;;)
        {
            if (wi < params.wave_octaves)
            {
                if ((wi & 3) == 0)
                {
                    wave_direction = unpackHalf2x16(params.wave_directions[wi >> 2].x);
                }
                if ((wi & 3) == 1)
                {
                    wave_direction = unpackHalf2x16(params.wave_directions[wi >> 2].y);
                }
                if ((wi & 3) == 2)
                {
                    wave_direction = unpackHalf2x16(params.wave_directions[wi >> 2].z);
                }
                if ((wi & 3) == 3)
                {
                    wave_direction = unpackHalf2x16(params.wave_directions[wi >> 2].w);
                }
                float steepness_modulated_by_strength = params.wave_steepness / params.strength.x;
                vec2 param_2 = (noise_pos.xz * params.domain_scale.xy) + (params.domain_scale.xy * float(wi));
                float param_3 = params.noise_phase.x;
                float param_4 = steepness_modulated_by_strength;
                float param_5 = wave_length;
                vec2 param_6 = wave_direction;
                wave += gerstner_evaluate_single(param_2, param_3, param_4, param_5, param_6);
                wave_length *= params.wave_octave_scale;
                wi++;
                continue;
            }
            else
            {
                break;
            }
        }
        wave += vec2(params.noise_value_base);
        vec3 local_norm = vtx.norm;
        if (params.displacement_mode == 1)
        {
            vec3 param_7 = modifier_position;
            mat4 param_8 = params.transform_local;
            vec3 _695 = vector_transform_by_mat43(param_7, param_8);
            local_norm = normalize(base_pos - _695);
        }
        vec3 new_pos = base_pos;
        new_pos.x += (wave.x * params.strength.x);
        new_pos.y += (wave.y * params.strength.y);
        new_pos = mix(base_pos, new_pos, vec3(influence));
        vtx.pos = new_pos;
    }
    if (false)
    {
        vtx.color.x = 0.0;
        vtx.color.y = 0.0;
        vtx.color.z = 0.0;
        vtx.color.x = max(0.0, influence);
    }
}

void _vertex_modifier_displace_apply(VertexModifierDisplaceParams params, ModifierFactor modifier_factor, inout VertexInput vtx, CoordinateSystemTrasforms cs_transforms)
{
    vec3 modifier_position = vec3(0.0);
    float influence = modifier_factor.factor;
    if (influence != 0.0)
    {
        vec3 n = vtx.norm;
        vec3 p = vtx.pos;
        p += ((params.displace_base * params.displace_base_modifier_factor) * influence);
        p += (((n * params.displace_normal) * params.displace_normal_modifier_factor) * influence);
        vtx.pos = p;
    }
}

void vertex_modifier_displace_apply(VertexModifierDisplaceParams params, inout ModifierFactor modifier_factor, inout VertexInput vtx, CoordinateSystemTrasforms cs_transforms)
{
    VertexModifierDisplaceParams param = params;
    ModifierFactor param_1 = modifier_factor;
    VertexInput param_2 = vtx;
    CoordinateSystemTrasforms param_3 = cs_transforms;
    _vertex_modifier_displace_apply(param, param_1, param_2, param_3);
    modifier_factor = param_1;
    vtx = param_2;
}

void vertex_modifier_uv_apply(VertexModifierUVParams params, inout VertexInput vtx_input)
{
    vec2 uv = vtx_input.uv0;
    if (params.override)
    {
        if (params.override_mode == 0)
        {
            uv = vtx_input.pos.xy;
        }
        if (params.override_mode == 1)
        {
            uv = vtx_input.pos.yz;
        }
        if (params.override_mode == 2)
        {
            uv = vtx_input.pos.xz;
        }
        if (params.override_mode == 3)
        {
            uv.x = length(vtx_input.pos);
            uv.y = 0.0;
        }
    }
    uv = (params.transform * vec4(uv, 0.0, 1.0)).xy;
    vtx_input.uv0 = uv;
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    return m * vec4(v, 1.0);
}

void main()
{
    uint load_vertex_idx = uint(gl_VertexIndex);
    if (_1063.instance_params.stride > 0)
    {
        uint flipbook_card = _1074.instance_flipbook_card[gl_InstanceIndex];
        flipbook_card = min(flipbook_card, (_268.geometry_information.flipbook_cards_num - 1u));
        load_vertex_idx += (_268.geometry_information.vtx_num * flipbook_card);
    }
    VertexInput vtx_input;
    vtx_input.id = uint(gl_VertexIndex);
    uint param = load_vertex_idx;
    vec3 _1096 = vtx_coords_load(param);
    vtx_input.pos = _1096;
    vtx_input.norm = vec3(1.0, 0.0, 0.0);
    vtx_input.color = vec4(1.0);
    vtx_input.uv0 = vtx_input.pos.xy;
    if ((_268.geometry_information.builtin_attribute_mask & 4u) != 0u)
    {
        uint param_1 = uint(gl_VertexIndex);
        vec3 _1114 = vtx_albedo_load(param_1);
        vtx_input.color.x = _1114.x;
        vtx_input.color.y = _1114.y;
        vtx_input.color.z = _1114.z;
    }
    if ((_268.geometry_information.builtin_attribute_mask & 2u) != 0u)
    {
        uint param_2 = load_vertex_idx;
        vec3 _1129 = vtx_normals_load(param_2);
        vtx_input.norm = _1129;
    }
    if ((_268.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_3 = uint(gl_VertexIndex);
        vec2 _1140 = vtx_uv0_load(param_3);
        vtx_input.uv0 = _1140;
    }
    mat4 mat_instance_model;
    mat_instance_model[0] = vec4(1.0, 0.0, 0.0, 0.0);
    mat_instance_model[1] = vec4(0.0, 1.0, 0.0, 0.0);
    mat_instance_model[2] = vec4(0.0, 0.0, 1.0, 0.0);
    mat_instance_model[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 mat_instance_model_inv = mat_instance_model;
    if (_1063.instance_params.stride > 0)
    {
        vec4 inst_m0 = _1162.instance_transform[(gl_InstanceIndex * _1063.instance_params.stride) + 0];
        vec4 inst_m1 = _1162.instance_transform[(gl_InstanceIndex * _1063.instance_params.stride) + 1];
        vec4 inst_m2 = _1162.instance_transform[(gl_InstanceIndex * _1063.instance_params.stride) + 2];
        vec3 _1193 = vec3(inst_m0.x, inst_m1.x, inst_m2.x);
        mat_instance_model[0].x = _1193.x;
        mat_instance_model[0].y = _1193.y;
        mat_instance_model[0].z = _1193.z;
        vec3 _1206 = vec3(inst_m0.y, inst_m1.y, inst_m2.y);
        mat_instance_model[1].x = _1206.x;
        mat_instance_model[1].y = _1206.y;
        mat_instance_model[1].z = _1206.z;
        vec3 _1219 = vec3(inst_m0.z, inst_m1.z, inst_m2.z);
        mat_instance_model[2].x = _1219.x;
        mat_instance_model[2].y = _1219.y;
        mat_instance_model[2].z = _1219.z;
        vec3 _1232 = vec3(inst_m0.w, inst_m1.w, inst_m2.w);
        mat_instance_model[3].x = _1232.x;
        mat_instance_model[3].y = _1232.y;
        mat_instance_model[3].z = _1232.z;
        mat_instance_model_inv = mat_instance_model;
        mat3 param_4 = mat3(mat_instance_model_inv[0].xyz, mat_instance_model_inv[1].xyz, mat_instance_model_inv[2].xyz);
        mat3 inv = inverse_mat3(param_4);
        mat_instance_model_inv[0].x = inv[0].x;
        mat_instance_model_inv[0].y = inv[0].y;
        mat_instance_model_inv[0].z = inv[0].z;
        mat_instance_model_inv[1].x = inv[1].x;
        mat_instance_model_inv[1].y = inv[1].y;
        mat_instance_model_inv[1].z = inv[1].z;
        mat_instance_model_inv[2].x = inv[2].x;
        mat_instance_model_inv[2].y = inv[2].y;
        mat_instance_model_inv[2].z = inv[2].z;
        mat_instance_model_inv[3].x = -(((inv[0].x * mat_instance_model[3].x) + (inv[1].x * mat_instance_model[3].y)) + (inv[2].x * mat_instance_model[3].z));
        mat_instance_model_inv[3].y = -(((inv[0].y * mat_instance_model[3].x) + (inv[1].y * mat_instance_model[3].y)) + (inv[2].y * mat_instance_model[3].z));
        mat_instance_model_inv[3].z = -(((inv[0].z * mat_instance_model[3].x) + (inv[1].z * mat_instance_model[3].y)) + (inv[2].z * mat_instance_model[3].z));
    }
    VertexInput vtx_modifier_input_base = vtx_input;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = uint(gl_VertexIndex);
    modifier_factor.id = uint(gl_VertexIndex);
    modifier_factor.instance_id = uint(gl_InstanceIndex);
    if (_1063.instance_params.stride > 0)
    {
        modifier_factor.instance_id = _1354.instance_hash[gl_InstanceIndex];
    }
    modifier_factor.position = vtx_input.pos;
    modifier_factor.normal = vtx_input.norm;
    modifier_factor.color = vtx_input.color;
    if ((_268.geometry_information.builtin_attribute_mask & 64u) != 0u)
    {
        uint param_5 = uint(gl_VertexIndex);
        uint _1377 = vtx_custom0_load(param_5);
        modifier_factor.custom0 = _1377;
    }
    if ((_268.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_6 = uint(gl_VertexIndex);
        vec2 _1388 = vtx_uv0_load(param_6);
        modifier_factor.uv0 = _1388;
    }
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _1395.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_instance_model;
    cs_transforms.mat_local_to_model_inv = _1395.transform_params.mModelInv;
    ModifierFactorDistanceRadial_Params _1413;
    _1413.transform_local_to_gizmo = _1408.VM0_params.transform_local_to_gizmo;
    _1413.falloff_curve_idx = _1408.VM0_params.falloff_curve_idx;
    _1413.falloff_inverse = _1408.VM0_params.falloff_inverse;
    _1413.domain_repeat_x = _1408.VM0_params.domain_repeat_x;
    _1413.domain_repeat_y = _1408.VM0_params.domain_repeat_y;
    _1413.domain_repeat_z = _1408.VM0_params.domain_repeat_z;
    _1413.influence_scope = _1408.VM0_params.influence_scope;
    _1413.modifier_function = _1408.VM0_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_7 = _1413;
    ModifierFactor param_8 = modifier_factor;
    CoordinateSystemTrasforms param_9 = cs_transforms;
    modifier_factor_distance_radial(param_7, param_8, param_9);
    modifier_factor = param_8;
    VertexModifierGerstnerWavesParams _1429;
    _1429.transform_world_to_local = _1424.VM1_params.transform_world_to_local;
    _1429.transform_local_to_world = _1424.VM1_params.transform_local_to_world;
    _1429.transform_local = _1424.VM1_params.transform_local;
    _1429.transform_local_inv = _1424.VM1_params.transform_local_inv;
    _1429.transform_parent = _1424.VM1_params.transform_parent;
    _1429.transform_parent_inv = _1424.VM1_params.transform_parent_inv;
    _1429.wave_directions[0] = _1424.VM1_params.wave_directions[0];
    _1429.wave_directions[1] = _1424.VM1_params.wave_directions[1];
    _1429.wave_directions[2] = _1424.VM1_params.wave_directions[2];
    _1429.wave_directions[3] = _1424.VM1_params.wave_directions[3];
    _1429.wave_directions[4] = _1424.VM1_params.wave_directions[4];
    _1429.wave_directions[5] = _1424.VM1_params.wave_directions[5];
    _1429.wave_directions[6] = _1424.VM1_params.wave_directions[6];
    _1429.wave_directions[7] = _1424.VM1_params.wave_directions[7];
    _1429.wave_directions[8] = _1424.VM1_params.wave_directions[8];
    _1429.wave_directions[9] = _1424.VM1_params.wave_directions[9];
    _1429.wave_directions[10] = _1424.VM1_params.wave_directions[10];
    _1429.wave_directions[11] = _1424.VM1_params.wave_directions[11];
    _1429.wave_directions[12] = _1424.VM1_params.wave_directions[12];
    _1429.wave_directions[13] = _1424.VM1_params.wave_directions[13];
    _1429.wave_directions[14] = _1424.VM1_params.wave_directions[14];
    _1429.wave_directions[15] = _1424.VM1_params.wave_directions[15];
    _1429.noise_phase = _1424.VM1_params.noise_phase;
    _1429.domain_scale = _1424.VM1_params.domain_scale;
    _1429._pad0 = _1424.VM1_params._pad0;
    _1429.strength = _1424.VM1_params.strength;
    _1429._pad1 = _1424.VM1_params._pad1;
    _1429.position = _1424.VM1_params.position;
    _1429.noise_relative_to_modifier = _1424.VM1_params.noise_relative_to_modifier;
    _1429.displacement_mode = _1424.VM1_params.displacement_mode;
    _1429.noise_value_base = _1424.VM1_params.noise_value_base;
    _1429.noise_value_absolute = _1424.VM1_params.noise_value_absolute;
    _1429.wave_length = _1424.VM1_params.wave_length;
    _1429.wave_steepness = _1424.VM1_params.wave_steepness;
    _1429.wave_octaves = _1424.VM1_params.wave_octaves;
    _1429.wave_octave_scale = _1424.VM1_params.wave_octave_scale;
    VertexModifierGerstnerWavesParams param_10 = _1429;
    ModifierFactor param_11 = modifier_factor;
    VertexInput param_12 = vtx_input;
    vertex_modifier_gerstner_waves_apply(param_10, param_11, param_12);
    modifier_factor = param_11;
    vtx_input = param_12;
    VertexModifierDisplaceParams _1445;
    _1445.displace_normal = _1440.VM2_params.displace_normal;
    _1445.displace_normal_modifier_factor = _1440.VM2_params.displace_normal_modifier_factor;
    _1445.displace_base = _1440.VM2_params.displace_base;
    _1445.displace_base_modifier_factor = _1440.VM2_params.displace_base_modifier_factor;
    _1445.influence_scope = _1440.VM2_params.influence_scope;
    VertexModifierDisplaceParams param_13 = _1445;
    ModifierFactor param_14 = modifier_factor;
    VertexInput param_15 = vtx_input;
    CoordinateSystemTrasforms param_16 = cs_transforms;
    vertex_modifier_displace_apply(param_13, param_14, param_15, param_16);
    modifier_factor = param_14;
    vtx_input = param_15;
    VertexModifierUVParams param_17;
    param_17.transform = _1458.VM3_params.transform;
    param_17.override = _1458.VM3_params.override != 0u;
    param_17.override_mode = _1458.VM3_params.override_mode;
    VertexInput param_18 = vtx_input;
    vertex_modifier_uv_apply(param_17, param_18);
    vtx_input = param_18;
    vtx_output.vLocalPos = vtx_input.pos;
    instanceID = uint(gl_InstanceIndex);
    if (_1063.instance_params.stride > 0)
    {
        vec4 inst_m0_1 = _1162.instance_transform[(gl_InstanceIndex * _1063.instance_params.stride) + 0];
        vec4 inst_m1_1 = _1162.instance_transform[(gl_InstanceIndex * _1063.instance_params.stride) + 1];
        vec4 inst_m2_1 = _1162.instance_transform[(gl_InstanceIndex * _1063.instance_params.stride) + 2];
        vec4 v = vec4(vtx_input.pos, 1.0);
        vtx_input.pos.x = dot(inst_m0_1, v);
        vtx_input.pos.y = dot(inst_m1_1, v);
        vtx_input.pos.z = dot(inst_m2_1, v);
        vec3 param_19 = vtx_input.norm;
        mat4 param_20 = transpose(mat4(vec4(inst_m0_1), vec4(inst_m1_1), vec4(inst_m2_1), vec4(0.0, 0.0, 0.0, 1.0)));
        vtx_input.norm = normalize(vector_transform_by_mat33(param_19, param_20));
        vec2 _1575 = unpackHalf2x16(_1569.instance_color[(gl_InstanceIndex * 2) + 0]);
        vec4 inst_c;
        inst_c.x = _1575.x;
        inst_c.y = _1575.y;
        vec2 _1585 = unpackHalf2x16(_1569.instance_color[(gl_InstanceIndex * 2) + 1]);
        inst_c.z = _1585.x;
        inst_c.w = _1585.y;
        vec4 _1591 = vtx_input.color;
        vec3 _1595 = _1591.xyz * inst_c.xyz;
        vtx_input.color.x = _1595.x;
        vtx_input.color.y = _1595.y;
        vtx_input.color.z = _1595.z;
        vtx_input.color.w *= inst_c.w;
    }
    vec3 param_21 = vtx_input.pos;
    mat4 param_22 = _1395.transform_params.mModel;
    vec3 _1615 = vector_transform_by_mat43(param_21, param_22);
    vec3 vPosModel = _1615;
    vec3 param_23 = vtx_input.norm;
    mat4 param_24 = _1395.transform_params.mModelNormal;
    vtx_output.vWorldNorm = vector_transform_by_mat33(param_23, param_24);
    vec3 param_25 = vPosModel;
    mat4 param_26 = _1395.transform_params.mView;
    vec3 _1630 = vector_transform_by_mat43(param_25, param_26);
    vec3 vPosModelView = _1630;
    vtx_output.vCoords = vPosModelView;
    vtx_output.vCameraRelativeWorldPos = vPosModel - _1395.transform_params.vCameraPosition;
    vtx_output.vNorm.x = dot(_1395.transform_params.mModelViewInvTrans[0].xyz, vtx_input.norm);
    vtx_output.vNorm.y = dot(_1395.transform_params.mModelViewInvTrans[1].xyz, vtx_input.norm);
    vtx_output.vNorm.z = dot(_1395.transform_params.mModelViewInvTrans[2].xyz, vtx_input.norm);
    vtx_output.vNorm = vtx_input.norm;
    vtx_output.vColor = vtx_input.color;
    vtx_output.vUV0 = vtx_input.uv0;
    vec3 param_27 = vtx_output.vCoords;
    mat4 param_28 = _1395.transform_params.mProjection;
    vec4 _1683 = vector_transform_by_mat_projection(param_27, param_28);
    gl_Position = _1683;
}

 