#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct InstanceModifierRandomizerV2_Params
{
    int replace_previous_rotation_scale;
    int randomness_seed;
    int replace_previous_position;
    int randomization_input;
    vec3 position_modifier_base;
    float position_modifier_base_modifier_factor;
    vec3 position_modifier_range;
    float position_modifier_range_modifier_factor;
    vec3 rotation_modifier_base;
    float rotation_modifier_base_modifier_factor;
    vec3 rotation_modifier_range;
    float rotation_modifier_range_modifier_factor;
    vec3 scale_modifier_base;
    float scale_modifier_base_modifier_factor;
    vec3 scale_modifier_range;
    float scale_modifier_range_modifier_factor;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct InstanceModifierLookAt_Params
{
    vec3 ref_position;
    int look_away;
    int axis;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ProcessInstanceModifiersParams
{
    int buffer_capacity;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 5, std140) uniform ProcessInstanceModifiersParamsBuffer
{
    ProcessInstanceModifiersParams process_modifiers_params;
} _1637;

layout(set = 0, binding = 6, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1650;

layout(set = 0, binding = 1, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1662;

layout(set = 0, binding = 2, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _1685;

layout(set = 0, binding = 3, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _1710;

layout(set = 0, binding = 4, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _1718;

layout(set = 0, binding = 7, std140) uniform VM0
{
    InstanceModifierRandomizerV2_Params VM0_params;
} _1752;

layout(set = 0, binding = 8, std140) uniform VM1
{
    InstanceModifierLookAt_Params VM1_params;
} _1770;

layout(set = 0, binding = 9, std140) uniform VM2
{
    layout(row_major) ModifierFactorNoise_Params VM2_params;
} _1796;

layout(set = 0, binding = 10, std140) uniform VM3
{
    InstanceModifierRandomizerV2_Params VM3_params;
} _1810;

layout(set = 0, binding = 11, std140) uniform VM4
{
    layout(row_major) ModifierFactorNoise_Params VM4_params;
} _1834;

layout(set = 0, binding = 12, std140) uniform VM5
{
    InstanceModifierRandomizerV2_Params VM5_params;
} _1847;

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

uint hash(uvec3 v)
{
    uint param = v.y;
    uint _262 = hash(param);
    uint param_1 = v.z;
    uint _267 = hash(param_1);
    uint param_2 = (v.x ^ _262) ^ _267;
    uint _270 = hash(param_2);
    return _270;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(vec3 v)
{
    uvec3 param = floatBitsToUint(v);
    uint param_1 = hash(param);
    float _299 = floatConstruct(param_1);
    return _299;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _289 = hash(param);
    uint param_1 = _289;
    float _291 = floatConstruct(param_1);
    return _291;
}

void instance_modifier_randomizer_v2(InstanceModifierRandomizerV2_Params modifier_params, ModifierFactor modifier_factor, inout Instance instance, uint id)
{
    float influence = modifier_factor.factor;
    float fid = float(id);
    if (modifier_params.randomization_input == 0)
    {
        fid = float(id);
    }
    if (modifier_params.randomization_input == 1)
    {
        vec3 param = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
        fid = random(param);
    }
    if (modifier_params.randomization_input == 2)
    {
        float param_1 = uintBitsToFloat(instance.hash);
        fid = random(param_1);
    }
    float param_2 = fid;
    vec3 angles;
    angles.x = random(param_2);
    float param_3 = fid + 123.3000030517578125;
    angles.y = random(param_3);
    float param_4 = (fid * 2.131700038909912109375) + 13.4137096405029296875;
    angles.z = random(param_4);
    if (modifier_params.randomization_input == 3)
    {
        angles = vec3(1.0);
    }
    angles = (modifier_params.rotation_modifier_base * (modifier_params.rotation_modifier_base_modifier_factor * influence)) + ((angles * modifier_params.rotation_modifier_range) * (modifier_params.rotation_modifier_range_modifier_factor * influence));
    float param_5 = fid;
    vec3 scales;
    scales.x = random(param_5);
    scales.y = scales.x;
    scales.z = scales.x;
    if (modifier_params.randomization_input == 3)
    {
        scales = vec3(1.0);
    }
    scales = mix(vec3(1.0), modifier_params.scale_modifier_base, vec3(modifier_params.scale_modifier_base_modifier_factor * influence)) + ((scales * modifier_params.scale_modifier_range) * (modifier_params.scale_modifier_range_modifier_factor * influence));
    float param_6 = fid;
    vec3 translations;
    translations.x = random(param_6);
    float param_7 = fid + 123.73169708251953125;
    translations.y = random(param_7);
    float param_8 = (fid * 2.131700038909912109375) + 13.71000003814697265625;
    translations.z = random(param_8);
    if (modifier_params.randomization_input == 3)
    {
        translations = vec3(1.0);
    }
    else
    {
        translations = normalize(translations);
    }
    translations = (modifier_params.position_modifier_base * (modifier_params.position_modifier_base_modifier_factor * influence)) + ((translations * modifier_params.position_modifier_range) * (modifier_params.position_modifier_range_modifier_factor * influence));
    float cosb = cos(angles.z);
    float sinb = sin(angles.z);
    float cosp = cos(angles.x);
    float sinp = sin(angles.x);
    float _cosh = cos(angles.y);
    float _sinh = sin(angles.y);
    vec3 mx;
    mx.x = (_cosh * cosb) + ((_sinh * sinp) * sinb);
    mx.y = ((_sinh * sinp) * cosb) - (_cosh * sinb);
    mx.z = _sinh * cosp;
    vec3 my;
    my.x = cosp * sinb;
    my.y = cosp * cosb;
    my.z = -sinp;
    vec3 mz;
    mz.x = ((_cosh * sinp) * sinb) - (_sinh * cosb);
    mz.y = (_sinh * sinb) + ((_cosh * sinp) * cosb);
    mz.z = _cosh * cosp;
    mat4 tm_rot;
    tm_rot[0] = vec4(mx.x, my.x, mz.x, translations.x);
    tm_rot[1] = vec4(mx.y, my.y, mz.y, translations.y);
    tm_rot[2] = vec4(mx.z, my.z, mz.z, translations.z);
    tm_rot[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 tm_sc;
    tm_sc[0] = vec4(scales.x, 0.0, 0.0, 0.0);
    tm_sc[1] = vec4(0.0, scales.y, 0.0, 0.0);
    tm_sc[2] = vec4(0.0, 0.0, scales.z, 0.0);
    tm_sc[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 m;
    m[0] = instance.m0;
    m[1] = instance.m1;
    m[2] = instance.m2;
    m[3] = vec4(0.0, 0.0, 0.0, 1.0);
    if (modifier_params.replace_previous_rotation_scale == 0)
    {
        m = (tm_sc * tm_rot) * m;
    }
    else
    {
        mat4 lm = tm_sc * tm_rot;
        m = (tm_sc * tm_rot) * m;
        m[0].x = lm[0].xyz.x;
        m[0].y = lm[0].xyz.y;
        m[0].z = lm[0].xyz.z;
        m[1].x = lm[1].xyz.x;
        m[1].y = lm[1].xyz.y;
        m[1].z = lm[1].xyz.z;
        m[2].x = lm[2].xyz.x;
        m[2].y = lm[2].xyz.y;
        m[2].z = lm[2].xyz.z;
    }
    instance.m0 = m[0];
    instance.m1 = m[1];
    instance.m2 = m[2];
}

vec4 _mat3ToQuaternion(mat3 r)
{
    float trace = (r[0].x + r[1].y) + r[2].z;
    vec4 q;
    if (trace > 0.0)
    {
        float s = sqrt(trace + 1.0) * 2.0;
        q.w = 0.25 * s;
        q.x = (r[2].y - r[1].z) / s;
        q.y = (r[0].z - r[2].x) / s;
        q.z = (r[1].x - r[0].y) / s;
    }
    else
    {
        bool _715 = r[0].x > r[1].y;
        bool _723;
        if (_715)
        {
            _723 = r[0].x > r[2].z;
        }
        else
        {
            _723 = _715;
        }
        if (_723)
        {
            float s_1 = sqrt(((1.0 + r[0].x) - r[1].y) - r[2].z) * 2.0;
            q.w = (r[2].y - r[1].z) / s_1;
            q.x = 0.25 * s_1;
            q.y = (r[0].y + r[1].x) / s_1;
            q.z = (r[0].z + r[2].x) / s_1;
        }
        else
        {
            if (r[1].y > r[2].z)
            {
                float s_2 = sqrt(((1.0 + r[1].y) - r[0].x) - r[2].z) * 2.0;
                q.w = (r[0].z - r[2].x) / s_2;
                q.x = (r[0].y + r[1].x) / s_2;
                q.y = 0.25 * s_2;
                q.z = (r[1].z + r[2].y) / s_2;
            }
            else
            {
                float s_3 = sqrt(((1.0 + r[2].z) - r[0].x) - r[1].y) * 2.0;
                q.w = (r[1].x - r[0].y) / s_3;
                q.x = (r[0].z + r[2].x) / s_3;
                q.y = (r[1].z + r[2].y) / s_3;
                q.z = 0.25 * s_3;
            }
        }
    }
    return q;
}

vec4 _slerp(inout vec4 q1, inout vec4 q2, float t)
{
    q1 = normalize(q1);
    q2 = normalize(q2);
    float _dot = dot(q1, q2);
    if (_dot < 0.0)
    {
        q2 = -q2;
        _dot = -_dot;
    }
    if (_dot > 0.999499976634979248046875)
    {
        vec4 result = mix(q1, q2, vec4(t));
        return normalize(result);
    }
    float theta_0 = acos(_dot);
    float theta = theta_0 * t;
    float sin_theta = sin(theta);
    float sin_theta_0 = sin(theta_0);
    float s1 = cos(theta) - ((_dot * sin_theta) / sin_theta_0);
    float s2 = sin_theta / sin_theta_0;
    return (q1 * s1) + (q2 * s2);
}

mat3 _quaternionToMat3(inout vec4 q)
{
    q = normalize(q);
    float xx = q.x * q.x;
    float yy = q.y * q.y;
    float zz = q.z * q.z;
    float xy = q.x * q.y;
    float xz = q.x * q.z;
    float yz = q.y * q.z;
    float wx = q.w * q.x;
    float wy = q.w * q.y;
    float wz = q.w * q.z;
    mat3 m;
    m[0].x = 1.0 - (2.0 * (yy + zz));
    m[0].y = 2.0 * (xy - wz);
    m[0].z = 2.0 * (xz + wy);
    m[1].x = 2.0 * (xy + wz);
    m[1].y = 1.0 - (2.0 * (xx + zz));
    m[1].z = 2.0 * (yz - wx);
    m[2].x = 2.0 * (xz - wy);
    m[2].y = 2.0 * (yz + wx);
    m[2].z = 1.0 - (2.0 * (xx + yy));
    return m;
}

void instance_modifier_look_at(InstanceModifierLookAt_Params modifier_params, ModifierFactor modifier_factor, inout Instance instance, uint id)
{
    vec3 ref_position = modifier_params.ref_position;
    vec3 pos = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
    vec3 nx = vec3(instance.m0.x, instance.m1.x, instance.m2.x);
    vec3 ny = vec3(instance.m0.y, instance.m1.y, instance.m2.y);
    vec3 nz = vec3(instance.m0.z, instance.m1.z, instance.m2.z);
    vec3 dir = normalize(pos - ref_position);
    if (modifier_params.look_away != 0)
    {
        dir *= (-1.0);
    }
    vec3 nnx;
    vec3 nny;
    vec3 nnz;
    if (modifier_params.axis == 0)
    {
        nnx = dir;
        nny = normalize(ny);
        nnz = normalize(cross(nnx, nny));
        nny = cross(nnx, nnz);
    }
    else
    {
        if (modifier_params.axis == 1)
        {
            nny = dir;
            nnx = normalize(nx);
            nnz = normalize(cross(nny, nnx));
            nnx = cross(nny, nnz);
        }
        else
        {
            nnz = dir;
            nnx = normalize(nx);
            nny = normalize(cross(nnz, nnx));
            nnx = cross(nny, nnz);
        }
    }
    float nx_length = length(nx);
    float ny_length = length(ny);
    float nz_length = length(nz);
    mat3 m_src;
    m_src[0] = nx / vec3(nx_length);
    m_src[1] = ny / vec3(ny_length);
    m_src[2] = nz / vec3(nz_length);
    mat3 m_dst;
    m_dst[0] = nnx;
    m_dst[1] = nny;
    m_dst[2] = nnz;
    mat3 param = m_src;
    vec4 q_src = _mat3ToQuaternion(param);
    mat3 param_1 = m_dst;
    vec4 q_dst = _mat3ToQuaternion(param_1);
    vec4 param_2 = q_src;
    vec4 param_3 = q_dst;
    float param_4 = modifier_factor.factor;
    vec4 _1169 = _slerp(param_2, param_3, param_4);
    vec4 q_slerp = _1169;
    vec4 param_5 = q_slerp;
    mat3 _1173 = _quaternionToMat3(param_5);
    mat3 m_slerp = _1173;
    m_slerp[0] *= nx_length;
    m_slerp[1] *= ny_length;
    m_slerp[2] *= nz_length;
    vec3 _1195 = vec3(m_slerp[0].x, m_slerp[1].x, m_slerp[2].x);
    instance.m0.x = _1195.x;
    instance.m0.y = _1195.y;
    instance.m0.z = _1195.z;
    vec3 _1208 = vec3(m_slerp[0].y, m_slerp[1].y, m_slerp[2].y);
    instance.m1.x = _1208.x;
    instance.m1.y = _1208.y;
    instance.m1.z = _1208.z;
    vec3 _1221 = vec3(m_slerp[0].z, m_slerp[1].z, m_slerp[2].z);
    instance.m2.x = _1221.x;
    instance.m2.y = _1221.y;
    instance.m2.z = _1221.z;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise_default(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1591 = vector_transform_by_mat43(param, param_1);
        coords = _1591;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1598 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1598;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    if (id >= uint(_1637.process_modifiers_params.buffer_capacity))
    {
        return;
    }
    if (id >= uint(_1650.instance_params.instance_count))
    {
        return;
    }
    Instance instance;
    instance.m0 = _1662.instance_transform[(id * 3u) + 0u];
    instance.m1 = _1662.instance_transform[(id * 3u) + 1u];
    instance.m2 = _1662.instance_transform[(id * 3u) + 2u];
    vec2 _1692 = unpackHalf2x16(_1685.instance_color[(id * 2u) + 0u]);
    instance.c.x = _1692.x;
    instance.c.y = _1692.y;
    vec2 _1702 = unpackHalf2x16(_1685.instance_color[(id * 2u) + 1u]);
    instance.c.z = _1702.x;
    instance.c.w = _1702.y;
    instance.flipbook_card = _1710.instance_flipbook_card[id];
    instance.hash = _1718.instance_hash[id];
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = instance.hash;
    modifier_factor.id = id;
    modifier_factor.position = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
    modifier_factor.is_spawned = false;
    modifier_factor.instance_id = id;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    InstanceModifierRandomizerV2_Params _1757;
    _1757.replace_previous_rotation_scale = _1752.VM0_params.replace_previous_rotation_scale;
    _1757.randomness_seed = _1752.VM0_params.randomness_seed;
    _1757.replace_previous_position = _1752.VM0_params.replace_previous_position;
    _1757.randomization_input = _1752.VM0_params.randomization_input;
    _1757.position_modifier_base = _1752.VM0_params.position_modifier_base;
    _1757.position_modifier_base_modifier_factor = _1752.VM0_params.position_modifier_base_modifier_factor;
    _1757.position_modifier_range = _1752.VM0_params.position_modifier_range;
    _1757.position_modifier_range_modifier_factor = _1752.VM0_params.position_modifier_range_modifier_factor;
    _1757.rotation_modifier_base = _1752.VM0_params.rotation_modifier_base;
    _1757.rotation_modifier_base_modifier_factor = _1752.VM0_params.rotation_modifier_base_modifier_factor;
    _1757.rotation_modifier_range = _1752.VM0_params.rotation_modifier_range;
    _1757.rotation_modifier_range_modifier_factor = _1752.VM0_params.rotation_modifier_range_modifier_factor;
    _1757.scale_modifier_base = _1752.VM0_params.scale_modifier_base;
    _1757.scale_modifier_base_modifier_factor = _1752.VM0_params.scale_modifier_base_modifier_factor;
    _1757.scale_modifier_range = _1752.VM0_params.scale_modifier_range;
    _1757.scale_modifier_range_modifier_factor = _1752.VM0_params.scale_modifier_range_modifier_factor;
    InstanceModifierRandomizerV2_Params param = _1757;
    ModifierFactor param_1 = modifier_factor;
    Instance param_2 = instance;
    uint param_3 = id;
    instance_modifier_randomizer_v2(param, param_1, param_2, param_3);
    modifier_factor = param_1;
    instance = param_2;
    InstanceModifierLookAt_Params _1775;
    _1775.ref_position = _1770.VM1_params.ref_position;
    _1775.look_away = _1770.VM1_params.look_away;
    _1775.axis = _1770.VM1_params.axis;
    InstanceModifierLookAt_Params param_4 = _1775;
    ModifierFactor param_5 = modifier_factor;
    Instance param_6 = instance;
    uint param_7 = id;
    instance_modifier_look_at(param_4, param_5, param_6, param_7);
    modifier_factor = param_5;
    instance = param_6;
    modifier_factor.position = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
    ModifierFactorNoise_Params _1801;
    _1801.transform_local_to_gizmo = _1796.VM2_params.transform_local_to_gizmo;
    _1801.noise_domain_scale = _1796.VM2_params.noise_domain_scale;
    _1801.modifier_function = _1796.VM2_params.modifier_function;
    _1801.noise_domain_offset = _1796.VM2_params.noise_domain_offset;
    _1801.noise_value_scale = _1796.VM2_params.noise_value_scale;
    _1801.noise_value_offset = _1796.VM2_params.noise_value_offset;
    _1801.influence_scope = _1796.VM2_params.influence_scope;
    _1801._pad0 = _1796.VM2_params._pad0;
    _1801._pad1 = _1796.VM2_params._pad1;
    ModifierFactorNoise_Params param_8 = _1801;
    ModifierFactor param_9 = modifier_factor;
    CoordinateSystemTrasforms param_10 = cs_transforms;
    modifier_factor_noise_default(param_8, param_9, param_10);
    modifier_factor = param_9;
    InstanceModifierRandomizerV2_Params _1814;
    _1814.replace_previous_rotation_scale = _1810.VM3_params.replace_previous_rotation_scale;
    _1814.randomness_seed = _1810.VM3_params.randomness_seed;
    _1814.replace_previous_position = _1810.VM3_params.replace_previous_position;
    _1814.randomization_input = _1810.VM3_params.randomization_input;
    _1814.position_modifier_base = _1810.VM3_params.position_modifier_base;
    _1814.position_modifier_base_modifier_factor = _1810.VM3_params.position_modifier_base_modifier_factor;
    _1814.position_modifier_range = _1810.VM3_params.position_modifier_range;
    _1814.position_modifier_range_modifier_factor = _1810.VM3_params.position_modifier_range_modifier_factor;
    _1814.rotation_modifier_base = _1810.VM3_params.rotation_modifier_base;
    _1814.rotation_modifier_base_modifier_factor = _1810.VM3_params.rotation_modifier_base_modifier_factor;
    _1814.rotation_modifier_range = _1810.VM3_params.rotation_modifier_range;
    _1814.rotation_modifier_range_modifier_factor = _1810.VM3_params.rotation_modifier_range_modifier_factor;
    _1814.scale_modifier_base = _1810.VM3_params.scale_modifier_base;
    _1814.scale_modifier_base_modifier_factor = _1810.VM3_params.scale_modifier_base_modifier_factor;
    _1814.scale_modifier_range = _1810.VM3_params.scale_modifier_range;
    _1814.scale_modifier_range_modifier_factor = _1810.VM3_params.scale_modifier_range_modifier_factor;
    InstanceModifierRandomizerV2_Params param_11 = _1814;
    ModifierFactor param_12 = modifier_factor;
    Instance param_13 = instance;
    uint param_14 = id;
    instance_modifier_randomizer_v2(param_11, param_12, param_13, param_14);
    modifier_factor = param_12;
    instance = param_13;
    modifier_factor.position = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
    ModifierFactorNoise_Params _1838;
    _1838.transform_local_to_gizmo = _1834.VM4_params.transform_local_to_gizmo;
    _1838.noise_domain_scale = _1834.VM4_params.noise_domain_scale;
    _1838.modifier_function = _1834.VM4_params.modifier_function;
    _1838.noise_domain_offset = _1834.VM4_params.noise_domain_offset;
    _1838.noise_value_scale = _1834.VM4_params.noise_value_scale;
    _1838.noise_value_offset = _1834.VM4_params.noise_value_offset;
    _1838.influence_scope = _1834.VM4_params.influence_scope;
    _1838._pad0 = _1834.VM4_params._pad0;
    _1838._pad1 = _1834.VM4_params._pad1;
    ModifierFactorNoise_Params param_15 = _1838;
    ModifierFactor param_16 = modifier_factor;
    CoordinateSystemTrasforms param_17 = cs_transforms;
    modifier_factor_noise_default(param_15, param_16, param_17);
    modifier_factor = param_16;
    InstanceModifierRandomizerV2_Params _1851;
    _1851.replace_previous_rotation_scale = _1847.VM5_params.replace_previous_rotation_scale;
    _1851.randomness_seed = _1847.VM5_params.randomness_seed;
    _1851.replace_previous_position = _1847.VM5_params.replace_previous_position;
    _1851.randomization_input = _1847.VM5_params.randomization_input;
    _1851.position_modifier_base = _1847.VM5_params.position_modifier_base;
    _1851.position_modifier_base_modifier_factor = _1847.VM5_params.position_modifier_base_modifier_factor;
    _1851.position_modifier_range = _1847.VM5_params.position_modifier_range;
    _1851.position_modifier_range_modifier_factor = _1847.VM5_params.position_modifier_range_modifier_factor;
    _1851.rotation_modifier_base = _1847.VM5_params.rotation_modifier_base;
    _1851.rotation_modifier_base_modifier_factor = _1847.VM5_params.rotation_modifier_base_modifier_factor;
    _1851.rotation_modifier_range = _1847.VM5_params.rotation_modifier_range;
    _1851.rotation_modifier_range_modifier_factor = _1847.VM5_params.rotation_modifier_range_modifier_factor;
    _1851.scale_modifier_base = _1847.VM5_params.scale_modifier_base;
    _1851.scale_modifier_base_modifier_factor = _1847.VM5_params.scale_modifier_base_modifier_factor;
    _1851.scale_modifier_range = _1847.VM5_params.scale_modifier_range;
    _1851.scale_modifier_range_modifier_factor = _1847.VM5_params.scale_modifier_range_modifier_factor;
    InstanceModifierRandomizerV2_Params param_18 = _1851;
    ModifierFactor param_19 = modifier_factor;
    Instance param_20 = instance;
    uint param_21 = id;
    instance_modifier_randomizer_v2(param_18, param_19, param_20, param_21);
    modifier_factor = param_19;
    instance = param_20;
    _1662.instance_transform[(id * 3u) + 0u] = instance.m0;
    _1662.instance_transform[(id * 3u) + 1u] = instance.m1;
    _1662.instance_transform[(id * 3u) + 2u] = instance.m2;
    _1685.instance_color[(id * 2u) + 0u] = packHalf2x16(instance.c.xy);
    _1685.instance_color[(id * 2u) + 1u] = packHalf2x16(instance.c.zw);
    _1710.instance_flipbook_card[id] = instance.flipbook_card;
}

 