Demo.prototype.addSkysphere = function (angle = 0) {
  const skyColor = 0.35;
  this.loader.addAnimation({
    object: 'multiSceneEffects/tex_milky_way.png',
    shape: { type: 'SKYSPHERE' },
    color: [{ r: skyColor, g: skyColor, b: skyColor }],
    "angle":[{
      "degreesX":angle
      }],
    shader:{
      // extend generated material shader
      vertexShaderPrefix:`
        uniform float time;
      `,
      vertexShaderSuffix:`
        vMapUv.x = vMapUv.x - time * 0.002;
      `,
    }
  });
}

Demo.prototype.addGodsBackground = function () {
  //this.loader.addAnimation({ image: '_embedded/defaultWhite.png', color: [{ r: 1, g: 0, b: 0 }] });

  this.addSkysphere();

  this.addEffectStarfield(0,300, 300, "multiSceneEffects/tex_basicParticle.png", 450,450,500, 0.4, null, 0,0,0, 0.15);
}

Demo.prototype.sceneAgod = function () {
  this.setScene('agod');

  this.addGodsBackground();

    this.loader.addAnimation([{
      object:{
        name:"3d_models/obj_allseeing.obj"
        }
      ,position:[{
        x:0,
        y:()=>.6+.25*Math.sin(3*getSceneTimeFromStart()),
        z:0
      }]
      ,scale:[{"uniform3d":2.0}]
      ,angle:[{              
        degreesY:()=>25*getSceneTimeFromStart(),
      }]
    }]);

      this.loader.addAnimation({
    image: 'images/textbox_god.png',
    perspective:"3d",
    position:[{x:0, y:()=>Sync.get('Misc:GodTextBoxY'), z:3.2}],
    angle:[{degreesZ:0}],
    scale: [{ x: ()=>Sync.get('Misc:GodTextBoxScaleX')+.025*Math.sin(5*getSceneTimeFromStart()),y: ()=>Sync.get('Misc:GodTextBoxScaleY')+.025*Math.sin(5*getSceneTimeFromStart()) }],
    material:{
      blending: 'NormalBlending',
      transparent:true,
      alphaTest:0.01,
      depthWrite:false,
    }
  });

  this.addTrailerText({text:"Abrahamic God:",x:()=>Sync.get('Misc:GodTopTextyX'),y:()=>Sync.get('Misc:GodTopTestY'),scale:1.5, monoSpace:true});
  this.addTrailerText({text:"Thou shall feel my WRATH",x:()=>Sync.get('Misc:GodBotTesxyX'),y:()=>Sync.get('Misc:GodBotTesxyY'),scale:1.5, monoSpace:true});
}