import QtQuick 2.4

import "./"
import "./_SharedQML"


Item {

  Rectangle {
    anchors.fill: parent
    color: "black"
    border.width: 1
    border.color: "white"
  }
  Text {
    anchors.top: parent.top
    anchors.left: parent.left
    anchors.right: parent.right
    anchors.margins: 10
    text: "Meshes"
    horizontalAlignment: Text.AlignHCenter
    color: "white"
    font.pixelSize: 12
  }

  MeshList {
    id: ml
  }

  signal allMeshesLoaded();

  property bool bAllMeshesLoaded: false

  onAllMeshesLoaded: {
    bAllMeshesLoaded = true;
  }

  Flickable {
    id: meshViewFlick
    anchors.fill: parent
    contentHeight: meshLists.height
    anchors.margins: 10
    anchors.topMargin: 32

    onContentYChanged: {
//      if (bAllMeshesLoaded) {
//        meshThumbsUpdated(contentY);
//      } else {
//        contentY = 0;
//      }

      meshThumbsUpdated(contentY);
      rocket.markUpdateFrequent();
    }

    function updateMeshThumbs() {
      meshThumbsUpdated(meshViewFlick.contentY);
      rocket.markUpdateFrequent();
    }

    clip: true

    Column {
      id: meshLists
      anchors.top: parent.top
      anchors.left: parent.left
      anchors.right: parent.right

      MeshesViewSingleList {
        title: "meshIndex 0-999"
        baseIndex: 0
        meshList: ml.content0
      }
      MeshesViewSingleList {
        title: "meshIndex 1000-1999"
        baseIndex: 1000
        meshList: ml.content1
      }
      MeshesViewSingleList {
        title: "meshIndex 2000-2999"
        baseIndex: 2000
        meshList: ml.content2
      }
      MeshesViewSingleList {
        title: "meshIndex 3000-3999"
        baseIndex: 3000
        meshList: ml.content3
      }
      MeshesViewSingleList {
        title: "meshIndex 4000-3999"
        baseIndex: 4000
        meshList: ml.content4
      }
      MeshesViewSingleList {
        title: "meshIndex 5000-5999"
        baseIndex: 5000
        meshList: ml.content5
      }
    }
  }


}
