import QtQuick 2.3
import AdaptDemoSystem 1.0

Effect {
  id: blur
  name: "blurRt"
  effectName: "BlurRt"
  enabled: syncRootOn(blur.name, effectName)
  property string shader: "fx/_SharedQML/blur"
  property string textureRT
  property string targetTextureRT: textureRT

  property string textureWrap: "clamp"

  property real posX: 0.0
  property real posY: 0.0

  property int blurLoopsInt: sync(blur.name+".blurLoops")

  RenderTarget {
    RenderTargetLayer {
      textureRT: "blurBuffer1"
      format: "RGBA32F"
      width: demo.windowWidth
      height: demo.windowHeight
      Clear { cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
    }
    Texture {
      textureUnit: 0
      textureRT: blur.textureRT
    }
    Shader {
      file: "fx/_SharedQML/drawRtTexel"
    }
    DrawVB {
      type: "quad"
      depthTest: false
      depthWrite: false
      ShaderParam {
        paramName: "flip"
        paramValue: 1.0
      }
      blendMode: "off"
      drawBuffers: 1
    }
  }

  property real strengthAddPerLoop: sync(blur.name+".strength.addPerLoop", 1.0)
  property real strength: syncFFT(blur.name+".strength", 1.0)
  property real screenSize: sync(blur.name+".screenSize", 1.0)

  Shader {
    file: shader
    ShaderParam { paramName: "kernel_wm"; paramValue: s("kernel.wm", 4.0) }
    ShaderParam { paramName: "kernel_ws"; paramValue: s("kernel.ws", 2.0) }
    ShaderParam { paramName: "kernel_wc"; paramValue: s("kernel.wc", 1.0) }
    ShaderParam { paramName: "kernelSX"; paramValue: s("kernel.scaleX", 1.0) }
    ShaderParam { paramName: "kernelSY"; paramValue: s("kernel.scaleY", 1.0) }
    ShaderParam { paramName: "kernelRot"; paramValue: s("kernel.rot", 0.0) }
    ShaderParam { paramName: "kernelRotX"; paramValue: s("kernel.rotX", 0.0) }
    ShaderParam { paramName: "kernelRotY"; paramValue: s("kernel.rotY", 0.0) }
    ShaderParam { paramName: "g_screenSize"; paramValue: screenSize }
  }


  Repeater {
    model: blurLoopsInt
    delegate: GroupBase {
      RenderTarget {
        RenderTargetLayer {
          textureRT: ((index&1)===0) ? "blurBuffer2" : "blurBuffer1"
          format: "RGBA32F"
          width: demo.windowWidth
          height: demo.windowHeight
          Clear { cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
        }
        Texture {
          textureUnit: 0
          textureRT: ((index&1)===0) ? "blurBuffer1" : "blurBuffer2"
          textureWrap: blur.textureWrap
        }
        DrawVB {
          type: "quad"
          depthTest: false
          depthWrite: false
          blendMode: "off"
          drawBuffers: 1
          ShaderParam { paramName: "g_blurStrength"; paramValue: strength*(Math.pow(2, index)*strengthAddPerLoop) }
          ShaderParam { paramName: "g_readSize"; paramValue: index===0 ? 1.0 : screenSize }
        }
      }
    }
  }

  RenderTarget {
    RenderTargetLayer {
      textureRT: blur.targetTextureRT
      format: "RGBA32F"
      width: demo.windowWidth
      height: demo.windowHeight
    }
    // mix original and result
    Shader {
      file: "fx/_SharedQML/drawRt"
    }
    Texture {
      textureUnit: 0
      textureRT: (blurLoopsInt&1) === 0 ? "blurBuffer2" : "blurBuffer1"
    }
    DrawVB {
      ShaderParam {
        paramName: "flip"
        paramValue: 1.0
      }
      ShaderParam { paramName: "g_overlayScale"; paramValue: sync(blur.name+".screenSize") }
      type: "quad"
      depthTest: false
      depthWrite: false
      blendMode: "off"
      drawBuffers: 1
    }
  }


}
