#version 430

in vec2 uv;

layout(location = 0) out vec4 frag;
// layout(location = 1) out vec4 frag2;

uniform float g_time;


float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}


uniform float flip=1.0;

uniform float overlayAlpha=1.0;


layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D texNoise;

uniform float g_currentAmount = 1.0;
uniform float g_prevAmount = 1.0;

uniform float pixelSize;

uniform vec4 moveAmp;
uniform vec4 moveFreq;
uniform vec4 movePhase;
uniform float moveRand;

void main() {

    vec2 uvS = uv;
    uvS.y = 1.0-uvS.y;
    // vec4 screen = texture2D(tex, uvS+vec2(0.0, 0.0));

    vec2 vc = gl_FragCoord.xy;
    vec2 vco = vc;

    vec2 ts = textureSize(tex, 0);

    vc -= ts*0.5;

    vc /= pixelSize;
    vc = vec2(ivec2(vc)*pixelSize);

    vc += ts*0.5;

    vec2 bo = vec2(sin((vc.xy)*moveFreq.xy*rand(vc.xy)+movePhase.xy)*moveRand+sin((vc.xy)*moveFreq.x+movePhase.xy)*(1.0-moveRand))*moveAmp.xy;

    vec4 screen = texelFetch(tex, ivec2(vco+bo), 0);

    screen.a = 1.0;
    frag = screen;
}

