import QtQuick 2.3
import QtQuick.Window 2.2

import SystemTime 1.0

import Qt.labs.settings 1.0

import AdaptDemoSystem 1.0

DemoRoot {
    id: root
    visible: true
    width: windowWidth
    height: windowHeight
    focus: true

    property bool bReleaseVer: true
    property string loaderImageFile: "../images/system/loader.png"
    property real exitDemoTime: 356.0
    property bool bExitDemo: true
    // property int demoStartRow: 0
    property int demoStartRow: 0

    property bool demoIsLoaded: false
    signal demoLoaded();
    signal startLoading();

    // not used in release version, but declared to avoid internal errors
    signal rocketTrackFocused(string trackName, string trackValue);
    signal rocketFocusedTrackValueChanged(string trackName, string trackValue);
    signal focusedToEffectBaseName(string effectBaseName);

    property bool bEnableCoordsAxis: true
    property bool bEnableCoordsPlaneXY: true
    property bool bEnableCoordsPlaneXZ: true
    property bool bEnableCoordsPlaneYZ: true

    property bool bShowingSubTool: false

    property var fxInstancesPerType

    signal keyLeft()
    signal keyRight()
    signal keyUp()
    signal keyDown()

    signal keyR()
    signal keyC()

    signal keyPressed(int keyCode, bool autoRepeat)
    signal keyReleased(int keyCode)

    signal mouseMove(int mouseX, int mouseY)
    signal mousePress(int mouseX, int mouseY)
    signal mouseRelease(int mouseX, int mouseY)

    signal showEditor()

    signal customTextGroupShowToggled(string groupId)
    function toggleCustomTextGroupShow(groupId) {
        customTextGroupShowToggled(groupId)
        console.log("toggleCustomTextGroupShow", groupId);
    }

    signal customTextSet(string groupId, string textId, string customText)
    function setCustomText(groupId, textId, customText) {
        customTextSet(groupId, textId, customText);
    }

    Rocket {
        id: rocket
        onMeshesPreloaded: {
            demoDelayedReady.start();
        }
    }

    property real time: 0.0

    Component.onCompleted: {
        time = 10000.0
    }
    Behavior on time {
        NumberAnimation { duration: 10000*1000 }
    }

    Timer {
        interval: 200
        repeat: false
        running: true
        onTriggered: {
            demoLoader.source = "Skenes.qml"
        }
    }

    Timer {
        id: delayedSetDemoLoaderSource
        interval: 200
        running: false
        repeat: false
        onTriggered: {
            demoLoader.source = "Skenes.qml";
        }
    }

    Connections {
        target: demoLoader.item
        onFileMissing: {
            console.log("QML received file not found:"+fName+" skene:"+sName);
        }
    }

    Timer {
        id: demoDelayedReady
        interval: 2000
        repeat: false
        onTriggered: {
            loaderImageMain.visible = false;
            demoIsLoaded = true;
            rocket.markDemoLoaded();
            demoLoaded();

          //  loaderImage.visible = false;
        }
    }

    MeshLoadList {
        id: meshLoad
    }

    Loader {
        id: demoLoader
        anchors.fill: parent
        asynchronous: true
        onStatusChanged: {
            if (demoLoader.status === Loader.Ready) {
                console.log("xxxxxxxxxxxxxxx DEMO LOADER is ready xxxxxxxxxxxxxxxx")

                var meshIndex = 0;
                for (meshIndex=0; meshIndex < meshLoad.list.length; meshIndex++) {
                    console.log("preloading mesh:"+meshIndex, meshLoad.list[meshIndex]["file"]);
                    var file2 = meshLoad.list[meshIndex]["file2"];
                    rocket.preLoadMesh("mesh/"+meshLoad.list[meshIndex]["file"],
                                       file2 !== undefined ? "mesh/"+file2 : "",
                                                             meshLoad.list[meshIndex]["smoothNormals"]===true,
                                                             meshLoad.list[meshIndex]["normalSmoothAngle"],
                                                             meshLoad.list[meshIndex]["flipNormals"]===true,
                                                             meshLoad.list[meshIndex]["autoCenter"]===true,
                                                             meshLoad.list[meshIndex]["autoScale"]===true,
                                                             meshLoad.list[meshIndex]["halfFloats"]===true,
                                                             meshLoad.list[meshIndex]["meshTexture"]===true);
                }


                if (demoStartRow >= 0) {
                    rocket.setDemoStartRow(demoStartRow);
                }
                demoDelayedReady.start();
            }
        }
    }

    Timer {
        interval: 200
        repeat: true
        running: true
        onTriggered: {
            if (rocket.getTime() > exitDemoTime && (rocket.getTime() > 0.0) && (rocket.getTime() < 10000.0) && bExitDemo) {
                rocket.exitDemo();
            }
        }
    }
    Item {
        id: loaderImageMain
        anchors.fill: parent
        Image {
            anchors.fill: parent
            source: loaderImageFile
        }
    }
    Keys.onEscapePressed: {
        rocket.exitDemo();
    }

    Keys.onReleased: {
        keyReleased(event.key);
    }

    Keys.onPressed: {
    }

}
