
Demo.prototype.sceneFarjan = function () {
  this.setScene('farjan');

  this.loader.addAnimation({ image: '_embedded/defaultWhite.png', color: [{ r: 0, g: 0, b: 0 }] });


  this.loader.addAnimation({
    image: { name: "images/aha-farjan.mp4", video: { time: 0.0, speed: 1.15, loop: true } },
    scale: [{ uniform3d: 1.5 }],
    color: [{r:.9,g:.9,b:.9,"a":1}],
    position: [{ x: 0, y: 0 }]
  });

  this.loader.addAnimation({
    image: 'images/viivasto.png',
    color: [{r:0,g:0,b:0,"a":1}],
    perspective:"2d",
    position:[{z:2,x:.025, y:()=>.025*Math.sin(12*getSceneTimeFromStart())}],
    scale: [{ x: 1.65, y:1.65 }]
    });

    for(let i=1;i<9;i++)
    {
      this.marker(i);
    }

    this.loader.addAnimation([{
      object:{
          "name":"3d_models/airhorn.obj"
        }
      ,position:[{
        x:()=>Sync.get('Airhorn:X1'),
        y:()=>Sync.get('Airhorn:Y1'),
        z:()=>Sync.get('Airhorn:Z1')
      }]
      ,scale:[{"uniform3d":()=>Sync.get('Airhorn:scale1')}]
      ,angle:[{             
        degreesX:()=>Sync.get('Airhorn:rotX1') ,      
        degreesY:()=>Sync.get('Airhorn:rotY1') ,    
        degreesZ:()=>Sync.get('Airhorn:rotZ1') ,             
      }]
    }]);


    this.loader.addAnimation({
      image: 'images/jamalauta.png',
      color: [{r:1,g:1,b:1,"a":1}],
      perspective:"2d",
      position:[{z:2,x:-.3, y:()=>.25+.015*Math.sin(3*getSceneTimeFromStart())}],
      scale: [{ x: 1.85, y:1.85 }]
      ,angle:[{             
 
        degreesZ:()=>15+10*Math.sin(5*getSceneTimeFromStart()) ,             
      }]

      });
    this.addTrailerText({text:"FINLANDSFÄRJAN",r:()=>Math.random(),g:()=>Math.random(),b:()=>Math.random(),x:.12,y:()=>.021*Math.sin(getSceneTimeFromStart()*9)+.24,scale:2.6,monoSpace:true, start:0, duration: .5*window.pattern, offset:1});

    this.addTrailerText({text:"ROCK FOR METAL",r:()=>Math.random(),g:()=>Math.random(),b:()=>Math.random(),x:.12,y:()=>.021*Math.sin(getSceneTimeFromStart()*9)+.24,scale:2.6,monoSpace:true, start:.5*window.pattern, duration: .5*window.pattern, offset:0.0025});

    this.addTrailerText({text:"UHKA IDÄSTÄ",r:()=>Math.random(),g:()=>Math.random(),b:()=>Math.random(),x:.12,y:()=>.021*Math.sin(getSceneTimeFromStart()*9)+.24,scale:2.6,monoSpace:true, start:1*window.pattern, duration: .5*window.pattern, offset:0.0025});

    this.addTrailerText({text:"BEETHOVEN",r:()=>Math.random(),g:()=>Math.random(),b:()=>Math.random(),x:.12,y:()=>.021*Math.sin(getSceneTimeFromStart()*9)+.24,scale:2.6,monoSpace:true, start:1.5*window.pattern, duration: .5*window.pattern, offset:0.0025});

    this.addTrailerText({text:"AND MORE!",r:()=>Math.random(),g:()=>Math.random(),b:()=>Math.random(),x:.12,y:()=>.021*Math.sin(getSceneTimeFromStart()*9)+.24,scale:2.6,monoSpace:true, start:2*window.pattern, duration: 1*window.pattern, offset:0.125});

    this.addTrailerText({text:"(NOT LEGALLY BINDING)",r:()=>Math.random(),g:()=>Math.random(),b:()=>Math.random(),x:.10,y:()=>.021*Math.sin(getSceneTimeFromStart()*9)+.14,scale:1.6,monoSpace:true, start:2.5*window.pattern, duration: .5*window.pattern, offset:0.0025});

    this.addTrailerText({text:"(NON IN-GAME FOOTAGE)",r:()=>Math.random(),g:()=>Math.random(),b:()=>Math.random(),x:0.05,y:-.24,scale:1.6,monoSpace:true, start:window.pattern, duration: 4*window.pattern, offset:0.0025});
}

Demo.prototype.marker = function (markernumber)
{
  let markerString = "Markers:X"+markernumber;
  this.loader.addAnimation({
    image: 'images/marker.png',
    color: [{r:()=>Math.random(),g:()=>Math.random(),b:()=>Math.random(),"a":1}],
    perspective:"2d",
    position:[{z:2,y:()=>.05*Math.sin(markernumber*.5+4*getSceneTimeFromStart()),x:()=>Sync.get(markerString)}],
    scale: [{"uniform2d":.86 }],
    angle: [
      {
        degreesZ: () => 25*Math.sin(markernumber*5+15*getSceneTimeFromStart()),
      }
    ],
    });
}