uniform float iTime;

//rotate 2D-vector
mat2 rotate2D(float angle) {
    float s = sin(angle);
    float c = cos(angle);
    return mat2(c, -s, s, c);
}

void main()
{

    vec2 iResolution = vec2(1920., 1080.);

    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = gl_TexCoord[0].xy; // fragCoord/iResolution.xy;
    vec2 uv2 = gl_TexCoord[0].xy; // fragCoord/iResolution.xy;
    uv = uv * 2.0 - 1.0;                   // (from -1 to 1)
    uv *= iResolution.x / iResolution.y;     // aspect ratio-fix
    
    float aspect = iResolution.x / iResolution.y;
    uv.x *= aspect;

    //sky palette
    vec3 sky = vec3(205./255.,225./255.,255./255.);
    vec3 shine = vec3(240./255.,245./255.,255./255.);

    //shine gradient
    float wave = 1.+(sin(iTime/3.)+1.);
    float grad = float(wave*(uv2.x*uv2.y));

    float size = grad*.1;         //circle size
    vec3 baseColor = shine;  //circle color
    float rotationSpeed = .02;  //circle rotation speed

   
    // pattern rotation
    float time = mod(iTime * rotationSpeed, 6.28318);
    uv = rotate2D(time) * uv;
    
    // Skapa ett regelbundet gridmönster
    float patternScale = 0.2;                 // Avstånd mellan cirklarna
    vec2 grid = vec2(1.0) * patternScale;     // Bas för gridmönstret
    vec2 index = floor(uv / grid + 0.5);      // Index för varje cirkel
    vec2 center = index * grid;               // Centrum för varje cirkel
    float dist = length(uv - center);         // Beräkna avståndet från pixeln till cirkelns centrum

    // Maska för att rita cirklar
    float circleMask = smoothstep(size, size - 0.01, dist);

    // Sätt den slutliga färgen baserat på om vi är i en cirkel eller inte
    vec3 finalColor = mix(sky, baseColor, circleMask);


    vec3 groundcolor = vec3(169./255., 226./255., 168./255.);   // Green ground
    vec3 bg_groundcolor = vec3(205./255., 238./255., 220./255.);   // background Green ground
    float frequency = .5;                     // Number of sine wave cycles
    float amplitude = 0.1;                     // Amplitude of the sine wave
    float speed = -0.2;                         // Speed of the sine wave's movement

    // Calculate the sine wave's y value at the current x position
    float sine_wave = amplitude * sin(2.0 * 3.14159 * frequency * (uv2.x - iTime * speed));
    float bgsine_wave = (amplitude/1.3) * sin(2.0 * 3.14159 * (frequency/2.) * (uv2.x - iTime * (speed/3.)));
    
    bg_groundcolor = mix(vec3(1.0), bg_groundcolor, step(uv2.y, 0.49 + bgsine_wave));
    finalColor = mix(finalColor, bg_groundcolor, step(uv2.y, 0.5 + bgsine_wave));
    
    groundcolor = mix(vec3(1.0), groundcolor, step(uv2.y, 0.34 + sine_wave));
    vec3 color = mix(finalColor, groundcolor, step(uv2.y, 0.35 + sine_wave));

    // Output to screen
    gl_FragColor = vec4(color,1.0);
}