uniform vec3 fractalColor = vec3(1, 0, 1);   // Uniform to control the color of the fractal (RGB)
uniform float fractalState;  // Uniform to control the state of the fractal (0.0 = start, 1.0 = end)
float autoAnimate = 0.0f;   // Uniform to toggle automatic animation (1.0 = automatic, 0.0 = manual)
float uniform iTime;

void main()
{

    vec2 iResolution = vec2(1920, 1080);

    // Set up the UV coordinates (from -1 to 1 for centering)
    vec2 uv = gl_TexCoord[0].xy; // / iResolution.xy;
    //vec2 uv = fragCoord.xy / iResolution.xy;
    uv = uv * 2.0 - 1.0;
    //uv.x *= iResolution.x / iResolution.y; // Adjust for aspect ratio

    // Calculate the fractal state based on auto-animate and iTime
    float state;
    if (false && autoAnimate > 0.0) {
        // Oscillate fractalState between 0.0 and 1.0 over time
        state = 0.5 * (1.0 + sin(iTime));
    } else {
        // Use the manual fractalState uniform if auto-animate is off
        state = fractalState;
    }

    // Complex number for the Julia set, changes based on state
    vec2 c = vec2(mix(-0.7, 0.7, state), mix(0.27015, -0.27015, state));

    // Initialize the point z with the UV coordinates
    vec2 z = uv;

    // Parameters for fractal computation
    int maxIterations = 300;  // Maximum number of iterations
    float escapeRadius = 3.0; // Escape radius for the fractal

    // Iterate the fractal equation: z = z^2 + c
    float iteration = 0.0;
    for(int i = 0; i < maxIterations; i++) {
        float x = (z.x * z.x - z.y * z.y) + c.x;
        float y = (2.0 * z.x * z.y) + c.y;

        z = vec2(x, y);

        // If the point escapes the radius, break the loop
        if(dot(z, z) > escapeRadius) {
            iteration = float(i) / float(maxIterations);
            break;
        }
    }

    // Smooth color interpolation based on the number of iterations
    float colorFactor = sqrt(iteration);

    // Apply the fractalColor to the final color
    vec3 finalColor = fractalColor * colorFactor;

    // Output the final color
    gl_FragColor = vec4(finalColor, 1.0);
}
