#define PI 3.14159265359

uniform float iTime;      // Time uniform passed from SFML
uniform float effect = 1;

uniform float zoomFactorEx = 14.;

// Function to create smooth rainbow-like color cycling
vec3 rainbowColor(float t) {
    t = fract(t);  // Wrap around [0,1]
    return 0.5 + 0.5 * cos(2.0 * PI * (vec3(0.0, 0.33, 0.67) + t));
}

void main() {

    vec2 iResolution = vec2(1920., 1080.);

    vec2 fragCoord = gl_FragCoord.xy;  // SFML provides fragment coordinates
    vec2 uv = fragCoord.xy / iResolution.xy;
    uv = uv * 2.0 - 1.0;  // Center coordinates around (0,0)
    uv.x *= iResolution.x / iResolution.y;  // Maintain aspect ratio

    float time = iTime;  // Slow down time for smoother animation

    // Add a subtle zoom effect to create forward movement
    float zoomFactor = 1.0 + 0.1 * time;  // Small zoom factor for smooth motion
    vec2 zoomedUV = uv * zoomFactor;

    // First tunnel
    float angle1 = atan(zoomedUV.y, zoomedUV.x);
    float radius1 = length(zoomedUV);
    float tunnel1 = sin(radius1 * 10.0 - time * 5.0) * 0.5 + 0.5;

    // Second tunnel, rotated and scaled slightly differently for a psychedelic overlap
    uv = mat2(cos(PI / 4.0), -sin(PI / 4.0), sin(PI / 4.0), cos(PI / 4.0)) * uv;  // Rotate second tunnel
    vec2 zoomedUV2 = uv * zoomFactor * zoomFactorEx;  // Adjust zoom slightly for variation
    float angle2 = atan(zoomedUV2.y, zoomedUV2.x);
    float radius2 = length(zoomedUV2);
    float tunnel2 = cos(radius2 * 12.0 + time * 4.0) * 0.5 + 0.5;

    // Combine the two tunnels with a balanced blending
    float combinedTunnels = mix(tunnel1, tunnel2, effect);

    // Color cycling based on angle
    vec3 color = rainbowColor(angle1 / PI + time) * combinedTunnels;

    gl_FragColor = vec4(color, 1.0);
}
