/**************************
***** Compiler Parameters *****
***************************
@P EffectName: TextureFXEffect
@P   - EffectNodeBase.EffectNodeBaseShader: mixin Liquish_TextureFX [{ColorA = mixin DoFloat4 [{Before = mixin ComputeOrder [{Computes = [mixin AssignVarFloat4<Default_2> [{Value = InputFloat4<ShaderFX.InputValueFloat4_Color,PerUpdate>}]]}]}, {Value = GetVarFloat4<Default_2>}]}, {ColorB = mixin DoFloat4 [{Before = mixin ComputeOrder [{Computes = [mixin AssignVarFloat4<Input_3> [{Value = InputFloat4<ShaderFX.InputValueFloat4_Color.i1,PerUpdate>}]]}]}, {Value = GetVarFloat4<Input_3>}]}, {ColorC = mixin DoFloat4 [{Before = mixin ComputeOrder [{Computes = [mixin AssignVarFloat4<Default_4> [{Value = InputFloat4<ShaderFX.InputValueFloat4_Color.i2,PerUpdate>}]]}]}, {Value = GetVarFloat4<Default_4>}]}, {Scale = mixin DoFloat2 [{Before = mixin ComputeOrder [{Computes = [mixin AssignVarFloat2<Default_1> [{Value = InputFloat2<ShaderFX.InputValueFloat2,PerUpdate>}]]}]}, {Value = GetVarFloat2<Default_1>}]}, {Time = mixin DoFloat [{Before = mixin ComputeOrder [{Computes = [mixin AssignVarFloat<Input_0> [{Value = InputFloat<ShaderFX.InputValueFloat,PerUpdate>}]]}]}, {Value = GetVarFloat<Input_0>}]}]
@P Time: mixin DoFloat [{Before = mixin ComputeOrder [{Computes = [mixin AssignVarFloat<Input_0> [{Value = InputFloat<ShaderFX.InputValueFloat,PerUpdate>}]]}]}, {Value = GetVarFloat<Input_0>}]
@P Scale: mixin DoFloat2 [{Before = mixin ComputeOrder [{Computes = [mixin AssignVarFloat2<Default_1> [{Value = InputFloat2<ShaderFX.InputValueFloat2,PerUpdate>}]]}]}, {Value = GetVarFloat2<Default_1>}]
@P ColorA: mixin DoFloat4 [{Before = mixin ComputeOrder [{Computes = [mixin AssignVarFloat4<Default_2> [{Value = InputFloat4<ShaderFX.InputValueFloat4_Color,PerUpdate>}]]}]}, {Value = GetVarFloat4<Default_2>}]
@P ColorB: mixin DoFloat4 [{Before = mixin ComputeOrder [{Computes = [mixin AssignVarFloat4<Input_3> [{Value = InputFloat4<ShaderFX.InputValueFloat4_Color.i1,PerUpdate>}]]}]}, {Value = GetVarFloat4<Input_3>}]
@P ColorC: mixin DoFloat4 [{Before = mixin ComputeOrder [{Computes = [mixin AssignVarFloat4<Default_4> [{Value = InputFloat4<ShaderFX.InputValueFloat4_Color.i2,PerUpdate>}]]}]}, {Value = GetVarFloat4<Default_4>}]
***************************
****  ConstantBuffers  ****
***************************
cbuffer PerDraw [Size: 64]
@C    MatrixTransform_id73 => SpriteBase.MatrixTransform
cbuffer PerUpdate [Size: 64]
@C    InputValue_id93 => ShaderFX.InputValueFloat4_Color
@C    InputValue_id99 => ShaderFX.InputValueFloat4_Color.i1
@C    InputValue_id105 => ShaderFX.InputValueFloat4_Color.i2
@C    InputValue_id111 => ShaderFX.InputValueFloat2
@C    InputValue_id117 => ShaderFX.InputValueFloat
***************************
******  Resources    ******
***************************
@R    PerDraw => PerDraw [Stage: Vertex, Slot: (0-0)]
@R    PerUpdate => PerUpdate [Stage: Pixel, Slot: (0-0)]
***************************
*****     Sources     *****
***************************
@S    Liquish_TextureFX => 3d4f3788afdb39797d42cab3accbccaf
@S    TextureFX => 27bb4f1f808a5eedf6dfeaa75c669c29
@S    ImageEffectShader => 8064e30cc02e5eb4052f420259dbf05e
@S    SpriteBase => 5a7aa9dfd5b5c7613053f4f66c79ca0d
@S    ShaderBase => 4ecbcd2528b64a79eebe81a863892d8c
@S    ShaderBaseStream => b705b699a7385d39c7de52a8d13f3978
@S    Texturing => 91ef3011c1071c2e5d41cd3ee0418b18
@S    Camera => f5d1a113ef7a27319900e8cc2e11ae0d
@S    ShaderUtils => 27e27e08e991883f970444d1aebe3b58
@S    ComputeFloat => 3607bb1fa125ec30a7afa60be79c4817
@S    ComputeFloat2 => 4826dbf2e774b7283c93b6121c851c5d
@S    ComputeColor => c875a0e093379dd74cd9a5a73aca830f
@S    DoFloat4 => 312f1c610231ffe618620ce43634d0aa
@S    ComputeFloat4 => f871947e9f604da432ea9fc3c9cb4363
@S    ComputeVoid => b62583a94b8503c79e9107f4b5bc9392
@S    ComputeOrder => 1d9b1cd3f5e3ad3f3f10e4fc88326cc7
@S    AssignVarFloat4 => 3a0c495ce724365e837c33156190acbe
@S    StreamVariableFloat4 => 2bfe58666cb67eed05b9410465550725
@S    InputFloat4 => f6891eacc9ea2d912dcfded49ea96a71
@S    DeclFloat4 => 03cb445d0e450d0a37ad5f24c8a93feb
@S    GetVarFloat4 => 2805d4f95c82389ce488a02bbf6e99f5
@S    DoFloat2 => b207f0fa9d0cd61a1d39ecf52b0ad5e7
@S    AssignVarFloat2 => 699f4c08337c8b521fbfc3addc632e47
@S    StreamVariableFloat2 => d633ab2389d7e4851bffedb923306575
@S    InputFloat2 => d6238a7d677592382c8158617d803399
@S    DeclFloat2 => d5fe6f879293db53179d13cf4b1d1f3d
@S    GetVarFloat2 => c81daf64c13be1d5e33c36d93f54279b
@S    DoFloat => 6cd1241010567bf9b5fdfccc1367f0fd
@S    AssignVarFloat => bdbba6e547b89ed4fc75c07ceb551948
@S    StreamVariableFloat => 247690c18e04365d061235ca1cb870ff
@S    InputFloat => f487ac725dafb0434d14d0273ee628a8
@S    DeclFloat => 75bf7e6f5246ed3d7aa33ab3c7183aa4
@S    GetVarFloat => 959a28f1937e5e493bc7459164561cc0
***************************
*****     Stages      *****
***************************
@G    Vertex => 79eb7ff071584feaa45b858a38e87b6a
//
// Generated by Microsoft (R) HLSL Shader Compiler 10.1
//
//
// Buffer Definitions: 
//
// cbuffer PerDraw
// {
//
//   float4x4 MatrixTransform_id73;     // Offset:    0 Size:    64
//
// }
//
//
// Resource Bindings:
//
// Name                                 Type  Format         Dim      HLSL Bind  Count
// ------------------------------ ---------- ------- ----------- -------------- ------
// PerDraw                           cbuffer      NA          NA            cb0      1 
//
//
//
// Input signature:
//
// Name                 Index   Mask Register SysValue  Format   Used
// -------------------- ----- ------ -------- -------- ------- ------
// POSITION                 0   xyzw        0     NONE   float   xyzw
// TEXCOORD                 0   xy          1     NONE   float   xy  
//
//
// Output signature:
//
// Name                 Index   Mask Register SysValue  Format   Used
// -------------------- ----- ------ -------- -------- ------- ------
// SV_Position              0   xyzw        0      POS   float   xyzw
// TEXCOORD                 0   xy          1     NONE   float   xy  
//
vs_5_0
dcl_globalFlags refactoringAllowed
dcl_constantbuffer CB0[4], immediateIndexed
dcl_input v0.xyzw
dcl_input v1.xy
dcl_output_siv o0.xyzw, position
dcl_output o1.xy
//
// Initial variable locations:
//   v0.x <- __input__.Position_id72.x; v0.y <- __input__.Position_id72.y; v0.z <- __input__.Position_id72.z; v0.w <- __input__.Position_id72.w; 
//   v1.x <- __input__.TexCoord_id62.x; v1.y <- __input__.TexCoord_id62.y; 
//   o1.x <- <VSMain return value>.TexCoord_id62.x; o1.y <- <VSMain return value>.TexCoord_id62.y; 
//   o0.x <- <VSMain return value>.ShadingPosition_id0.x; o0.y <- <VSMain return value>.ShadingPosition_id0.y; o0.z <- <VSMain return value>.ShadingPosition_id0.z; o0.w <- <VSMain return value>.ShadingPosition_id0.w
//
#line 341 "C:\Users\alex\Documents\vvvv\gamma\Exports\5sun2\log\shader_TextureFXEffect_0698f6369376efed4ed3d5b94f6b08bd.hlsl"
dp4 o0.x, v0.xyzw, cb0[0].xyzw
dp4 o0.y, v0.xyzw, cb0[1].xyzw
dp4 o0.z, v0.xyzw, cb0[2].xyzw
dp4 o0.w, v0.xyzw, cb0[3].xyzw

#line 345
mov o1.xy, v1.xyxx
ret 
// Approximately 6 instruction slots used
@G    Pixel => b2a7ab526253ca68245d013d1c62004a
//
// Generated by Microsoft (R) HLSL Shader Compiler 10.1
//
//
// Buffer Definitions: 
//
// cbuffer PerUpdate
// {
//
//   float4 InputValue_id93;            // Offset:    0 Size:    16
//   float4 InputValue_id99;            // Offset:   16 Size:    16
//   float4 InputValue_id105;           // Offset:   32 Size:    16
//   float2 InputValue_id111;           // Offset:   48 Size:     8
//   float InputValue_id117;            // Offset:   56 Size:     4
//
// }
//
//
// Resource Bindings:
//
// Name                                 Type  Format         Dim      HLSL Bind  Count
// ------------------------------ ---------- ------- ----------- -------------- ------
// PerUpdate                         cbuffer      NA          NA            cb0      1 
//
//
//
// Input signature:
//
// Name                 Index   Mask Register SysValue  Format   Used
// -------------------- ----- ------ -------- -------- ------- ------
// SV_Position              0   xyzw        0      POS   float       
// TEXCOORD                 0   xy          1     NONE   float   xy  
//
//
// Output signature:
//
// Name                 Index   Mask Register SysValue  Format   Used
// -------------------- ----- ------ -------- -------- ------- ------
// SV_Target                0   xyzw        0   TARGET   float   xyzw
//
ps_5_0
dcl_globalFlags refactoringAllowed
dcl_constantbuffer CB0[4], immediateIndexed
dcl_input_ps linear v1.xy
dcl_output o0.xyzw
dcl_temps 6
//
// Initial variable locations:
//   v0.x <- __input__.ShadingPosition_id0.x; v0.y <- __input__.ShadingPosition_id0.y; v0.z <- __input__.ShadingPosition_id0.z; v0.w <- __input__.ShadingPosition_id0.w; 
//   v1.x <- __input__.TexCoord_id62.x; v1.y <- __input__.TexCoord_id62.y; 
//   o0.x <- <PSMain return value>.ColorTarget_id2.x; o0.y <- <PSMain return value>.ColorTarget_id2.y; o0.z <- <PSMain return value>.ColorTarget_id2.z; o0.w <- <PSMain return value>.ColorTarget_id2.w
//
#line 305 "C:\Users\alex\Documents\vvvv\gamma\Exports\5sun2\log\shader_TextureFXEffect_0698f6369376efed4ed3d5b94f6b08bd.hlsl"
mul r0.xy, v1.xyxx, cb0[3].xyxx  // r0.x <- c.x; r0.y <- c.y

#line 237
mov r0.zw, r0.xxxy  // r0.z <- c.x; r0.w <- c.y
mov r1.xzw, l(0,0,1.000000,0)  // r1.x <- f; r1.z <- w; r1.w <- i
loop 
  ige r2.x, r1.w, l(4)
  breakc_nz r2.x

#line 185
  round_ni r2.xy, r0.zwzz  // r2.x <- ip.x; r2.y <- ip.y

#line 186
  frc r2.zw, r0.zzzw  // r2.z <- u.x; r2.w <- u.y

#line 187
  mul r3.xy, r2.zwzz, r2.zwzz
  mad r2.zw, -r2.zzzw, l(0.000000, 0.000000, 2.000000, 2.000000), l(0.000000, 0.000000, 3.000000, 3.000000)
  mul r2.zw, r2.zzzw, r3.xxxy  // r2.z <- u.x; r2.w <- u.y

#line 161
  dp2 r3.x, r2.xyxx, l(12.989800, 78.233002, 0.000000, 0.000000)
  sincos r3.x, null, r3.x
  mul r3.x, r3.x, l(43758.546875)

#line 188
  add r4.xyzw, r2.xyxy, l(1.000000, 0.000000, 0.000000, 1.000000)  // r4.z <- co.x; r4.w <- co.y

#line 161
  dp2 r3.y, r4.xyxx, l(12.989800, 78.233002, 0.000000, 0.000000)
  sincos r3.y, null, r3.y
  mul r3.y, r3.y, l(43758.546875)
  frc r3.xy, r3.xyxx  // r3.y <- <rand_id28 return value>

#line 188
  add r3.y, -r3.x, r3.y
  mad r3.x, r2.z, r3.y, r3.x

#line 161
  dp2 r3.y, r4.zwzz, l(12.989800, 78.233002, 0.000000, 0.000000)
  sincos r3.y, null, r3.y
  mul r3.y, r3.y, l(43758.546875)
  frc r3.y, r3.y  // r3.y <- <rand_id28 return value>

#line 188
  add r2.xy, r2.xyxx, l(1.000000, 1.000000, 0.000000, 0.000000)

#line 161
  dp2 r2.x, r2.xyxx, l(12.989800, 78.233002, 0.000000, 0.000000)
  sincos r2.x, null, r2.x
  mul r2.x, r2.x, l(43758.546875)
  frc r2.x, r2.x  // r2.x <- <rand_id28 return value>

#line 188
  add r2.x, -r3.y, r2.x
  mad r2.x, r2.z, r2.x, r3.y
  add r2.x, -r3.x, r2.x
  mad r2.x, r2.w, r2.x, r3.x  // r2.x <- res

#line 189
  mul r2.x, r2.x, r2.x  // r2.x <- <noise2f_id29 return value>

#line 239
  mad r1.x, r1.z, r2.x, r1.x

#line 240
  add r0.zw, r0.zzzw, r0.zzzw

#line 241
  mul r1.z, r1.z, l(0.500000)

#line 242
  iadd r1.w, r1.w, l(1)
endloop 

#line 285
mad r0.xy, v1.xyxx, cb0[3].xyxx, l(1.000000, 1.000000, 0.000000, 0.000000)

#line 237
mov r0.zw, r0.xxxy  // r0.z <- c.x; r0.w <- c.y
mov r1.yzw, l(0,0,1.000000,0)  // r1.y <- f; r1.z <- w; r1.w <- i
loop 
  ige r2.x, r1.w, l(4)
  breakc_nz r2.x

#line 185
  round_ni r2.xy, r0.zwzz  // r2.x <- ip.x; r2.y <- ip.y

#line 186
  frc r2.zw, r0.zzzw  // r2.z <- u.x; r2.w <- u.y

#line 187
  mul r3.xy, r2.zwzz, r2.zwzz
  mad r2.zw, -r2.zzzw, l(0.000000, 0.000000, 2.000000, 2.000000), l(0.000000, 0.000000, 3.000000, 3.000000)
  mul r2.zw, r2.zzzw, r3.xxxy  // r2.z <- u.x; r2.w <- u.y

#line 161
  dp2 r3.x, r2.xyxx, l(12.989800, 78.233002, 0.000000, 0.000000)
  sincos r3.x, null, r3.x
  mul r3.x, r3.x, l(43758.546875)

#line 188
  add r4.xyzw, r2.xyxy, l(1.000000, 0.000000, 0.000000, 1.000000)  // r4.z <- co.x; r4.w <- co.y

#line 161
  dp2 r3.y, r4.xyxx, l(12.989800, 78.233002, 0.000000, 0.000000)
  sincos r3.y, null, r3.y
  mul r3.y, r3.y, l(43758.546875)
  frc r3.xy, r3.xyxx  // r3.y <- <rand_id28 return value>

#line 188
  add r3.y, -r3.x, r3.y
  mad r3.x, r2.z, r3.y, r3.x

#line 161
  dp2 r3.y, r4.zwzz, l(12.989800, 78.233002, 0.000000, 0.000000)
  sincos r3.y, null, r3.y
  mul r3.y, r3.y, l(43758.546875)
  frc r3.y, r3.y  // r3.y <- <rand_id28 return value>

#line 188
  add r2.xy, r2.xyxx, l(1.000000, 1.000000, 0.000000, 0.000000)

#line 161
  dp2 r2.x, r2.xyxx, l(12.989800, 78.233002, 0.000000, 0.000000)
  sincos r2.x, null, r2.x
  mul r2.x, r2.x, l(43758.546875)
  frc r2.x, r2.x  // r2.x <- <rand_id28 return value>

#line 188
  add r2.x, -r3.y, r2.x
  mad r2.x, r2.z, r2.x, r3.y
  add r2.x, -r3.x, r2.x
  mad r2.x, r2.w, r2.x, r3.x  // r2.x <- res

#line 189
  mul r2.x, r2.x, r2.x  // r2.x <- <noise2f_id29 return value>

#line 239
  mad r1.y, r1.z, r2.x, r1.y

#line 240
  add r0.zw, r0.zzzw, r0.zzzw

#line 241
  mul r1.z, r1.z, l(0.500000)

#line 242
  iadd r1.w, r1.w, l(1)
endloop 

#line 286
mad r0.xyzw, v1.xyxy, cb0[3].xyxy, r1.xyxy

#line 287
add r0.xyzw, r0.xyzw, l(1.700000, 9.200000, 8.300000, 2.800000)
mad r0.xyzw, cb0[3].zzzz, l(0.150000, 0.150000, 0.126000, 0.126000), r0.xyzw

#line 237
mov r1.zw, r0.xxxy  // r1.z <- c.x; r1.w <- c.y
mov r2.xzw, l(0,0,1.000000,0)  // r2.x <- f; r2.z <- w; r2.w <- i
loop 
  ige r3.x, r2.w, l(4)
  breakc_nz r3.x

#line 185
  round_ni r3.xy, r1.zwzz  // r3.x <- ip.x; r3.y <- ip.y

#line 186
  frc r3.zw, r1.zzzw  // r3.z <- u.x; r3.w <- u.y

#line 187
  mul r4.xy, r3.zwzz, r3.zwzz
  mad r3.zw, -r3.zzzw, l(0.000000, 0.000000, 2.000000, 2.000000), l(0.000000, 0.000000, 3.000000, 3.000000)
  mul r3.zw, r3.zzzw, r4.xxxy  // r3.z <- u.x; r3.w <- u.y

#line 161
  dp2 r4.x, r3.xyxx, l(12.989800, 78.233002, 0.000000, 0.000000)
  sincos r4.x, null, r4.x
  mul r4.x, r4.x, l(43758.546875)

#line 188
  add r5.xyzw, r3.xyxy, l(1.000000, 0.000000, 0.000000, 1.000000)  // r5.z <- co.x; r5.w <- co.y

#line 161
  dp2 r4.y, r5.xyxx, l(12.989800, 78.233002, 0.000000, 0.000000)
  sincos r4.y, null, r4.y
  mul r4.y, r4.y, l(43758.546875)
  frc r4.xy, r4.xyxx  // r4.y <- <rand_id28 return value>

#line 188
  add r4.y, -r4.x, r4.y
  mad r4.x, r3.z, r4.y, r4.x

#line 161
  dp2 r4.y, r5.zwzz, l(12.989800, 78.233002, 0.000000, 0.000000)
  sincos r4.y, null, r4.y
  mul r4.y, r4.y, l(43758.546875)
  frc r4.y, r4.y  // r4.y <- <rand_id28 return value>

#line 188
  add r3.xy, r3.xyxx, l(1.000000, 1.000000, 0.000000, 0.000000)

#line 161
  dp2 r3.x, r3.xyxx, l(12.989800, 78.233002, 0.000000, 0.000000)
  sincos r3.x, null, r3.x
  mul r3.x, r3.x, l(43758.546875)
  frc r3.x, r3.x  // r3.x <- <rand_id28 return value>

#line 188
  add r3.x, -r4.y, r3.x
  mad r3.x, r3.z, r3.x, r4.y
  add r3.x, -r4.x, r3.x
  mad r3.x, r3.w, r3.x, r4.x  // r3.x <- res

#line 189
  mul r3.x, r3.x, r3.x  // r3.x <- <noise2f_id29 return value>

#line 239
  mad r2.x, r2.z, r3.x, r2.x

#line 240
  add r1.zw, r1.zzzw, r1.zzzw

#line 241
  mul r2.z, r2.z, l(0.500000)

#line 242
  iadd r2.w, r2.w, l(1)
endloop 

#line 237
mov r0.xy, r0.zwzz  // r0.x <- c.x; r0.y <- c.y
mov r2.y, l(0)  // r2.y <- f
mov r1.zw, l(0,0,1.000000,0)  // r1.z <- w; r1.w <- i
loop 
  ige r2.z, r1.w, l(4)
  breakc_nz r2.z

#line 185
  round_ni r2.zw, r0.xxxy  // r2.z <- ip.x; r2.w <- ip.y

#line 186
  frc r3.xy, r0.xyxx  // r3.x <- u.x; r3.y <- u.y

#line 187
  mul r3.zw, r3.xxxy, r3.xxxy
  mad r3.xy, -r3.xyxx, l(2.000000, 2.000000, 0.000000, 0.000000), l(3.000000, 3.000000, 0.000000, 0.000000)
  mul r3.xy, r3.xyxx, r3.zwzz  // r3.x <- u.x; r3.y <- u.y

#line 161
  dp2 r3.z, r2.zwzz, l(12.989800, 78.233002, 0.000000, 0.000000)
  sincos r3.z, null, r3.z
  mul r3.z, r3.z, l(43758.546875)

#line 188
  add r4.xyzw, r2.zwzw, l(1.000000, 0.000000, 0.000000, 1.000000)  // r4.z <- co.x; r4.w <- co.y

#line 161
  dp2 r3.w, r4.xyxx, l(12.989800, 78.233002, 0.000000, 0.000000)
  sincos r3.w, null, r3.w
  mul r3.w, r3.w, l(43758.546875)
  frc r3.zw, r3.zzzw  // r3.w <- <rand_id28 return value>

#line 188
  add r3.w, -r3.z, r3.w
  mad r3.z, r3.x, r3.w, r3.z

#line 161
  dp2 r3.w, r4.zwzz, l(12.989800, 78.233002, 0.000000, 0.000000)
  sincos r3.w, null, r3.w
  mul r3.w, r3.w, l(43758.546875)
  frc r3.w, r3.w  // r3.w <- <rand_id28 return value>

#line 188
  add r2.zw, r2.zzzw, l(0.000000, 0.000000, 1.000000, 1.000000)

#line 161
  dp2 r2.z, r2.zwzz, l(12.989800, 78.233002, 0.000000, 0.000000)
  sincos r2.z, null, r2.z
  mul r2.z, r2.z, l(43758.546875)
  frc r2.z, r2.z  // r2.z <- <rand_id28 return value>

#line 188
  add r2.z, -r3.w, r2.z
  mad r2.z, r3.x, r2.z, r3.w
  add r2.z, -r3.z, r2.z
  mad r2.z, r3.y, r2.z, r3.z  // r2.z <- res

#line 189
  mul r2.z, r2.z, r2.z  // r2.z <- <noise2f_id29 return value>

#line 239
  mad r2.y, r1.z, r2.z, r2.y

#line 240
  add r0.xy, r0.xyxx, r0.xyxx

#line 241
  mul r1.z, r1.z, l(0.500000)

#line 242
  iadd r1.w, r1.w, l(1)
endloop 

#line 288
mad r0.xy, v1.xyxx, cb0[3].xyxx, r2.xyxx

#line 237
mov r0.zw, r0.xxxy  // r0.z <- c.x; r0.w <- c.y
mov r1.zw, l(0,0,0,1.000000)  // r1.z <- f; r1.w <- w
mov r2.y, l(0)  // r2.y <- i
loop 
  ige r2.z, r2.y, l(4)
  breakc_nz r2.z

#line 185
  round_ni r2.zw, r0.zzzw  // r2.z <- ip.x; r2.w <- ip.y

#line 186
  frc r3.xy, r0.zwzz  // r3.x <- u.x; r3.y <- u.y

#line 187
  mul r3.zw, r3.xxxy, r3.xxxy
  mad r3.xy, -r3.xyxx, l(2.000000, 2.000000, 0.000000, 0.000000), l(3.000000, 3.000000, 0.000000, 0.000000)
  mul r3.xy, r3.xyxx, r3.zwzz  // r3.x <- u.x; r3.y <- u.y

#line 161
  dp2 r3.z, r2.zwzz, l(12.989800, 78.233002, 0.000000, 0.000000)
  sincos r3.z, null, r3.z
  mul r3.z, r3.z, l(43758.546875)

#line 188
  add r4.xyzw, r2.zwzw, l(1.000000, 0.000000, 0.000000, 1.000000)  // r4.z <- co.x; r4.w <- co.y

#line 161
  dp2 r3.w, r4.xyxx, l(12.989800, 78.233002, 0.000000, 0.000000)
  sincos r3.w, null, r3.w
  mul r3.w, r3.w, l(43758.546875)
  frc r3.zw, r3.zzzw  // r3.w <- <rand_id28 return value>

#line 188
  add r3.w, -r3.z, r3.w
  mad r3.z, r3.x, r3.w, r3.z

#line 161
  dp2 r3.w, r4.zwzz, l(12.989800, 78.233002, 0.000000, 0.000000)
  sincos r3.w, null, r3.w
  mul r3.w, r3.w, l(43758.546875)
  frc r3.w, r3.w  // r3.w <- <rand_id28 return value>

#line 188
  add r2.zw, r2.zzzw, l(0.000000, 0.000000, 1.000000, 1.000000)

#line 161
  dp2 r2.z, r2.zwzz, l(12.989800, 78.233002, 0.000000, 0.000000)
  sincos r2.z, null, r2.z
  mul r2.z, r2.z, l(43758.546875)
  frc r2.z, r2.z  // r2.z <- <rand_id28 return value>

#line 188
  add r2.z, -r3.w, r2.z
  mad r2.z, r3.x, r2.z, r3.w
  add r2.z, -r3.z, r2.z
  mad r2.z, r3.y, r2.z, r3.z  // r2.z <- res

#line 189
  mul r2.z, r2.z, r2.z  // r2.z <- <noise2f_id29 return value>

#line 239
  mad r1.z, r1.w, r2.z, r1.z

#line 240
  add r0.zw, r0.zzzw, r0.zzzw

#line 241
  mul r1.w, r1.w, l(0.500000)

#line 242
  iadd r2.y, r2.y, l(1)
endloop 

#line 315
mul r0.x, r1.z, r1.z

#line 325
mul r0.yz, r0.xxxx, l(0.000000, 4.000000, 0.600000, 0.000000)

#line 315
min r0.y, r0.y, l(1.000000)

#line 322
add r3.xyzw, -cb0[0].xyzw, cb0[1].xyzw
mad r3.xyzw, r0.yyyy, r3.xyzw, cb0[0].xyzw  // r3.x <- col.x; r3.y <- col.y; r3.z <- col.z; r3.w <- alph

#line 316
dp2 r0.y, r1.xyxx, r1.xyxx
sqrt r0.y, r0.y
min r0.y, r0.y, l(1.000000)

#line 323
add r4.xyzw, -r3.xyzw, cb0[1].xyzw
mad r3.xyzw, r0.yyyy, r4.xyzw, r3.xyzw

#line 317
min r0.y, r2.x, l(1.000000)

#line 324
add r2.xyzw, -r3.xyzw, cb0[2].xyzw

#line 317
mad r1.xyw, r0.yyyy, r2.xyxz, r3.xyxz  // r1.x <- col.x; r1.y <- col.y; r1.w <- col.z

#line 324
mad o0.w, r0.y, r2.w, r3.w

#line 325
mul r0.x, r1.z, r0.x
mad r0.x, r0.x, l(0.200000), r0.z
mad r0.x, r1.z, l(0.500000), r0.x
min r0.yzw, |r1.xxyw|, l(0.000000, 1.000000, 1.000000, 1.000000)
max r2.xyz, |r1.xywx|, l(1.000000, 1.000000, 1.000000, 0.000000)
div r2.xyz, l(1.000000, 1.000000, 1.000000, 1.000000), r2.xyzx
mul r0.yzw, r0.yyzw, r2.xxyz
mul r2.xyz, r0.yzwy, r0.yzwy
mad r3.xyz, r2.xyzx, l(0.020835, 0.020835, 0.020835, 0.000000), l(-0.085133, -0.085133, -0.085133, 0.000000)
mad r3.xyz, r2.xyzx, r3.xyzx, l(0.180141, 0.180141, 0.180141, 0.000000)
mad r3.xyz, r2.xyzx, r3.xyzx, l(-0.330299, -0.330299, -0.330299, 0.000000)
mad r2.xyz, r2.xyzx, r3.xyzx, l(0.999866, 0.999866, 0.999866, 0.000000)
mul r3.xyz, r0.yzwy, r2.xyzx
lt r4.xyz, l(1.000000, 1.000000, 1.000000, 0.000000), |r1.xywx|
mad r3.xyz, r3.xyzx, l(-2.000000, -2.000000, -2.000000, 0.000000), l(1.570796, 1.570796, 1.570796, 0.000000)
and r3.xyz, r4.xyzx, r3.xyzx
mad r0.yzw, r0.yyzw, r2.xxyz, r3.xxyz
min r1.xyz, r1.xywx, l(1.000000, 1.000000, 1.000000, 0.000000)
lt r1.xyz, r1.xyzx, -r1.xyzx
movc r0.yzw, r1.xxyz, -r0.yyzw, r0.yyzw
mul o0.xyz, r0.yzwy, r0.xxxx

#line 334
ret 
// Approximately 239 instruction slots used
***************************
*************************/
struct PS_STREAMS 
{
    float2 TexCoord_id62;
    float2 Default_1_id110;
    float Input_0_id116;
    float4 Default_2_id92;
    float4 Input_3_id98;
    float4 Default_4_id104;
    float4 ColorTarget_id2;
};
struct PS_OUTPUT 
{
    float4 ColorTarget_id2 : SV_Target0;
};
struct PS_INPUT 
{
    float4 ShadingPosition_id0 : SV_Position;
    float2 TexCoord_id62 : TEXCOORD0;
};
struct VS_STREAMS 
{
    float4 Position_id72;
    float2 TexCoord_id62;
    float4 ShadingPosition_id0;
};
struct VS_OUTPUT 
{
    float4 ShadingPosition_id0 : SV_Position;
    float2 TexCoord_id62 : TEXCOORD0;
};
struct VS_INPUT 
{
    float4 Position_id72 : POSITION;
    float2 TexCoord_id62 : TEXCOORD0;
};
cbuffer PerDraw 
{
    float4x4 MatrixTransform_id73;
};
cbuffer PerUpdate 
{
    float4 InputValue_id93;
    float4 InputValue_id99;
    float4 InputValue_id105;
    float2 InputValue_id111;
    float InputValue_id117;
};
cbuffer PerView 
{
    float NearClipPlane_id74 = 1.0f;
    float FarClipPlane_id75 = 100.0f;
    float2 ZProjection_id76;
    float2 ViewSize_id77;
    float AspectRatio_id78;
};
cbuffer Globals 
{
    float2 Texture0TexelSize_id15;
    float2 Texture1TexelSize_id17;
    float2 Texture2TexelSize_id19;
    float2 Texture3TexelSize_id21;
    float2 Texture4TexelSize_id23;
    float2 Texture5TexelSize_id25;
    float2 Texture6TexelSize_id27;
    float2 Texture7TexelSize_id29;
    float2 Texture8TexelSize_id31;
    float2 Texture9TexelSize_id33;
};
Texture2D Texture0_id14;
Texture2D Texture1_id16;
Texture2D Texture2_id18;
Texture2D Texture3_id20;
Texture2D Texture4_id22;
Texture2D Texture5_id24;
Texture2D Texture6_id26;
Texture2D Texture7_id28;
Texture2D Texture8_id30;
Texture2D Texture9_id32;
TextureCube TextureCube0_id34;
TextureCube TextureCube1_id35;
TextureCube TextureCube2_id36;
TextureCube TextureCube3_id37;
Texture3D Texture3D0_id38;
Texture3D Texture3D1_id39;
Texture3D Texture3D2_id40;
Texture3D Texture3D3_id41;
SamplerState Sampler_id42;
SamplerState PointSampler_id43 
{
    Filter = MIN_MAG_MIP_POINT;
};
SamplerState LinearSampler_id44 
{
    Filter = MIN_MAG_MIP_LINEAR;
};
SamplerState LinearBorderSampler_id45 
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Border;
    AddressV = Border;
};
SamplerComparisonState LinearClampCompareLessEqualSampler_id46 
{
    Filter = COMPARISON_MIN_MAG_LINEAR_MIP_POINT;
    AddressU = Clamp;
    AddressV = Clamp;
    ComparisonFunc = LessEqual;
};
SamplerState AnisotropicSampler_id47 
{
    Filter = ANISOTROPIC;
};
SamplerState AnisotropicRepeatSampler_id48 
{
    Filter = ANISOTROPIC;
    AddressU = Wrap;
    AddressV = Wrap;
    MaxAnisotropy = 16;
};
SamplerState PointRepeatSampler_id49 
{
    Filter = MIN_MAG_MIP_POINT;
    AddressU = Wrap;
    AddressV = Wrap;
};
SamplerState LinearRepeatSampler_id50 
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};
SamplerState RepeatSampler_id51 
{
    AddressU = Wrap;
    AddressV = Wrap;
};
SamplerState Sampler0_id52;
SamplerState Sampler1_id53;
SamplerState Sampler2_id54;
SamplerState Sampler3_id55;
SamplerState Sampler4_id56;
SamplerState Sampler5_id57;
SamplerState Sampler6_id58;
SamplerState Sampler7_id59;
SamplerState Sampler8_id60;
SamplerState Sampler9_id61;
float4 Compute_id57()
{
    return InputValue_id105;
}
float4 Compute_id48()
{
    return InputValue_id99;
}
float4 Compute_id39()
{
    return InputValue_id93;
}
float rand_id28(float2 co)
{
    return frac(sin(dot(co.xy, float2(12.9898, 78.233))) * 43758.5453);
}
float Compute_id75()
{
    return InputValue_id117;
}
float2 Compute_id66()
{
    return InputValue_id111;
}
void Compute_id60(inout PS_STREAMS streams)
{
    streams.Default_4_id104 = Compute_id57();
}
void Compute_id51(inout PS_STREAMS streams)
{
    streams.Input_3_id98 = Compute_id48();
}
void Compute_id42(inout PS_STREAMS streams)
{
    streams.Default_2_id92 = Compute_id39();
}
float noise2f_id29(in float2 p)
{
    float2 ip = float2(floor(p));
    float2 u = frac(p);
    u = u * u * (3.0 - 2.0 * u);
    float res = lerp(lerp(rand_id28(ip), rand_id28(ip + float2(1.0, 0.0)), u.x), lerp(rand_id28(ip + float2(0.0, 1.0)), rand_id28(ip + float2(1.0, 1.0)), u.x), u.y);
    return res * res;
}
void Compute_id78(inout PS_STREAMS streams)
{
    streams.Input_0_id116 = Compute_id75();
}
void Compute_id69(inout PS_STREAMS streams)
{
    streams.Default_1_id110 = Compute_id66();
}
float4 Compute_id63(inout PS_STREAMS streams)
{
    return streams.Default_4_id104;
}
void Compute_id62(inout PS_STREAMS streams)
{

    {
        Compute_id60(streams);
    }
}
float4 Compute_id54(inout PS_STREAMS streams)
{
    return streams.Input_3_id98;
}
void Compute_id53(inout PS_STREAMS streams)
{

    {
        Compute_id51(streams);
    }
}
float4 Compute_id45(inout PS_STREAMS streams)
{
    return streams.Default_2_id92;
}
void Compute_id44(inout PS_STREAMS streams)
{

    {
        Compute_id42(streams);
    }
}
float fbm_id30(float2 c)
{
    float f = 0.0;
    float w = 1.0;

    for (int i = 0; i < 4; i++)
    {
        f += w * noise2f_id29(c);
        c *= 2.0;
        w *= 0.5;
    }
    return f;
}
float Compute_id81(inout PS_STREAMS streams)
{
    return streams.Input_0_id116;
}
void Compute_id80(inout PS_STREAMS streams)
{

    {
        Compute_id78(streams);
    }
}
float2 Compute_id72(inout PS_STREAMS streams)
{
    return streams.Default_1_id110;
}
void Compute_id71(inout PS_STREAMS streams)
{

    {
        Compute_id69(streams);
    }
}
float4 Compute_id38(inout PS_STREAMS streams)
{
    Compute_id62(streams);
    return Compute_id63(streams);
}
float4 Compute_id37(inout PS_STREAMS streams)
{
    Compute_id53(streams);
    return Compute_id54(streams);
}
float4 Compute_id36(inout PS_STREAMS streams)
{
    Compute_id44(streams);
    return Compute_id45(streams);
}
float pattern_id32(float time, float2 p, out float2 q, out float2 r)
{
    q.x = fbm_id30(p + 0.00 * time);
    q.y = fbm_id30(p + float2(1.0, 1.0));
    r.x = fbm_id30(p + 1.0 * q + float2(1.7, 9.2) + 0.15 * time);
    r.y = fbm_id30(p + 1.0 * q + float2(8.3, 2.8) + 0.126 * time);
    return fbm_id30(p + 1.0 * r + 0.0 * time);
}
float Compute_id35(inout PS_STREAMS streams)
{
    Compute_id80(streams);
    return Compute_id81(streams);
}
float2 Compute_id34(inout PS_STREAMS streams)
{
    Compute_id71(streams);
    return Compute_id72(streams);
}
float4 Shading_id33(inout PS_STREAMS streams)
{
    float2 uv = streams.TexCoord_id62;
    float2 q;
    float2 r;
    float2 c = uv.xy * Compute_id34(streams);
    float t = Compute_id35(streams);
    float f = pattern_id32(t, c, q, r);
    float4 cA = Compute_id36(streams);
    float4 cB = Compute_id37(streams);
    float4 cC = Compute_id38(streams);
    float3 colors[3];
    colors[0] = float3(cA.r, cA.g, cA.b);
    colors[1] = float3(cB.r, cB.g, cB.b);
    colors[2] = float3(cC.r, cC.g, cC.b);
    float3 col = lerp(colors[0], colors[1], clamp((f * f) * 4.0, 0.0, 1.0));
    col = lerp(col, colors[1], clamp(length(q), 0.0, 1.0));
    col = lerp(col, colors[2], clamp(length(r.x), 0.0, 1.0));
    float alphas[3];
    alphas[0] = float(cA.a);
    alphas[1] = float(cB.a);
    alphas[2] = float(cC.a);
    float alph = lerp(alphas[0], alphas[1], clamp((f * f) * 4.0, 0.0, 1.0));
    alph = lerp(alph, alphas[1], clamp(length(q), 0.0, 1.0));
    alph = lerp(alph, alphas[2], clamp(length(r.x), 0.0, 1.0));
    return float4((0.2 * f * f * f + 0.6 * f * f + 0.5 * f) * atan(col), alph);
}
PS_OUTPUT PSMain(PS_INPUT __input__)
{
    PS_STREAMS streams = (PS_STREAMS)0;
    streams.TexCoord_id62 = __input__.TexCoord_id62;
    streams.ColorTarget_id2 = Shading_id33(streams);
    PS_OUTPUT __output__ = (PS_OUTPUT)0;
    __output__.ColorTarget_id2 = streams.ColorTarget_id2;
    return __output__;
}
VS_OUTPUT VSMain(VS_INPUT __input__)
{
    VS_STREAMS streams = (VS_STREAMS)0;
    streams.Position_id72 = __input__.Position_id72;
    streams.TexCoord_id62 = __input__.TexCoord_id62;
    streams.ShadingPosition_id0 = mul(streams.Position_id72, MatrixTransform_id73);
    VS_OUTPUT __output__ = (VS_OUTPUT)0;
    __output__.ShadingPosition_id0 = streams.ShadingPosition_id0;
    __output__.TexCoord_id62 = streams.TexCoord_id62;
    return __output__;
}
