import asyncio

wled_host = '127.0.0.1'
wled_port = 3413


async def main():
    loop = asyncio.get_running_loop()
    transport, protocol = await loop.create_datagram_endpoint(
        lambda: asyncio.DatagramProtocol(),
        remote_addr=(wled_host, wled_port),
    )
    led_map = {}
    running = True
    step = 0
    frames = 500
    while running:
        try:
            fileName = "frames/frame-%04d.dat" % step
            with open(fileName, mode='rb') as file: # b is important -> binary
                fileContent = file.read()
                transport.sendto(fileContent)
            await asyncio.sleep(0.1)
        except KeyboardInterrupt:
            running = False
        step = (step + 1) % frames
    transport.close()
    print("Gone.")


if __name__ == "__main__":
    asyncio.run(main())
