/*
 * Decompiled with CFR 0.152.
 */
package org.kd.common;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import org.kd.common.C64Colors;
import org.kd.common.C64Helper;
import org.kd.common.Scene;

public class BasicC64Screen
extends Scene {
    protected static final int LEFT_EDGE = 82;
    SpriteBatch batch;
    ShapeRenderer shapeRenderer;
    public Texture backgroundTexture;
    protected C64Colors borderColor;
    protected boolean blinkingCursor = true;
    protected String backgroundScreenPng = "c64.png";
    protected BitmapFont whiteFont;
    protected BitmapFont standardFont;
    protected float x;
    protected float y;
    protected final float scale = 2.0f;

    public BasicC64Screen(String id) {
        super(id);
    }

    @Override
    public void create() {
        Gdx.input.setCursorPosition(Gdx.graphics.getWidth(), Gdx.graphics.getWidth());
        this.batch = new SpriteBatch();
        this.shapeRenderer = new ShapeRenderer();
        this.shapeRenderer.setAutoShapeType(true);
        this.backgroundTexture = new Texture(Gdx.files.internal(this.backgroundScreenPng));
        this.borderColor = C64Colors.LIGHT_BLUE;
        this.whiteFont = C64Helper.createFont(15, "C64_Pro_Mono-STYLE.ttf");
        this.standardFont = C64Helper.createFont(15, C64Colors.LIGHT_BLUE, "C64_Pro_Mono-STYLE.ttf");
        float scaledWidth = (float)this.backgroundTexture.getWidth() * this.scale;
        float scaledHeight = (float)this.backgroundTexture.getHeight() * this.scale;
        this.x = ((float)Gdx.graphics.getWidth() - scaledWidth) / 2.0f;
        this.y = ((float)Gdx.graphics.getHeight() - scaledHeight) / 2.0f;
    }

    @Override
    public void update(float delta) {
    }

    @Override
    public void render() {
        C64Colors lb = this.borderColor;
        Gdx.gl.glClearColor(lb.getR(), lb.getG(), lb.getB(), 1.0f);
        Gdx.gl.glClear(16384);
        long frame = Gdx.graphics.getFrameId();
        this.drawC64(frame);
    }

    private void drawC64(long frame) {
        float scaledWidth = (float)this.backgroundTexture.getWidth() * this.scale;
        float scaledHeight = (float)this.backgroundTexture.getHeight() * this.scale;
        this.batch.begin();
        this.batch.draw(this.backgroundTexture, this.x, this.y, scaledWidth, scaledHeight);
        this.batch.end();
        if (this.blinkingCursor) {
            C64Helper.blinkCursor(frame, this.shapeRenderer);
        }
    }

    @Override
    public void dispose() {
        System.out.println("Disposing Scene1Tiles");
        this.batch.dispose();
        this.backgroundTexture.dispose();
    }
}

