/*
 * Decompiled with CFR 0.152.
 */
package org.kd.xmas25;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import java.util.Arrays;
import org.kd.common.AnimationManager;
import org.kd.common.C64Colors;
import org.kd.common.Scene;
import org.kd.common.TravellingLogo;
import org.kd.xmas25.Scene1;
import org.kd.xmas25.Scene2;

public class DreamAnimationMgr
extends AnimationManager {
    private TravellingLogo logoMerry;
    private TravellingLogo logoChristmas;

    @Override
    public void create() {
        super.create();
        this.createMusic("dream210/przybiezeli.mp3");
        this.logoMerry = this.initLogo("dream210/merry.png", 521.0f);
        this.logoChristmas = this.initLogo("dream210/christmas.png", 39.0f);
        Scene1 scene1 = new Scene1("scene1");
        Scene2 scene2 = new Scene2("scene2");
        Arrays.asList(scene1, scene2).forEach(s -> {
            s.create();
            this.sceneManager.addScene(s.id, (Scene)s);
        });
        this.sceneManager.switchScene("scene1");
    }

    private TravellingLogo initLogo(String path, float y) {
        Texture logoTxtr = new Texture(Gdx.files.internal(path));
        TravellingLogo logo = new TravellingLogo(logoTxtr, 800.0f, y, 1000.0f, 50.0f);
        logo.colorize(C64Colors.LIGHT_BLUE);
        logo.spriteSpeed = 325.0f;
        return logo;
    }

    @Override
    public void render() {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        float delta = Gdx.graphics.getDeltaTime();
        long frame = Gdx.graphics.getFrameId();
        this.sceneManager.update(delta);
        this.sceneManager.render();
        this.batch.begin();
        if (frame > 1900L) {
            this.logoMerry.draw(this.batch, 800, 600);
            this.logoChristmas.draw(this.batch, 800, 600);
        }
        this.batch.end();
        if (frame == 400L) {
            this.tune.play();
        }
        if (frame > 1900L) {
            this.moveBannerMerry(delta);
        }
        if (frame > 9350L) {
            this.centerMerryChristmas();
        }
        if (frame > 9670L) {
            this.volumeDown();
            if (frame > 9981L) {
                Gdx.app.exit();
                System.out.println("\n".repeat(50) + "Herzliche Gruesse an Team210! Danke, dass sie den Drem210 organisiert haben!");
                System.exit(0);
            }
        }
        if (frame == 2800L) {
            this.sceneManager.switchScene("scene2");
        }
    }

    private void volumeDown() {
        float vol = this.tune.getVolume();
        if (vol >= 0.01f) {
            this.tune.setVolume(vol - 0.003f);
        } else {
            this.tune.stop();
        }
    }

    private void centerMerryChristmas() {
        float lmY;
        float lchY = this.logoChristmas.getSprite().getY() + 1.0f;
        if (lchY < 260.0f) {
            this.logoChristmas.getSprite().setY(lchY);
        }
        if ((lmY = this.logoMerry.getSprite().getY() - 1.0f) > 320.0f) {
            this.logoMerry.getSprite().setY(lmY);
        }
    }

    private void moveBannerMerry(float delta) {
        long initFrame;
        long frame = Gdx.graphics.getFrameId();
        if (frame == 7700L) {
            this.logoMerry.getSprite().setColor(Color.GOLD);
            this.logoChristmas.getSprite().setColor(Color.FIREBRICK);
        }
        if (frame >= (initFrame = 1900L)) {
            this.logoMerry.move(delta, 800);
            if (frame > initFrame + 50L) {
                this.logoChristmas.move(delta, 800);
            }
            if (frame >= initFrame + 500L) {
                Arrays.asList(this.logoMerry, this.logoChristmas).forEach(logo -> {
                    if (logo.getX() < -355.0f || logo.getX() > 260.0f) {
                        logo.changeDirection();
                    }
                });
            }
        }
    }

    @Override
    public void dispose() {
        this.batch.dispose();
        this.tune.dispose();
        this.sceneManager.disposeScenes();
    }
}

