/*
 * Decompiled with CFR 0.152.
 */
package org.kd.xmas25;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import java.util.List;
import org.kd.common.BasicC64Screen;
import org.kd.common.C64Colors;
import org.kd.common.C64Helper;
import org.kd.common.ConsoleLogger;
import org.kd.common.Globals;
import org.kd.common.winter.WinterEffects;
import org.kd.xmas25.BannerMCh;
import org.kd.xmas25.WishesHelper;

public class Scene1
extends BasicC64Screen {
    private boolean snowing;
    private List<Sprite> snowflakes;
    public SpriteBatch batch2;

    public Scene1(String id) {
        super(id);
    }

    @Override
    public void create() {
        super.create();
        this.batch2 = new SpriteBatch();
        this.snowflakes = WinterEffects.createSnowflakeSprites();
        this.snowflakes.forEach(flake -> flake.setX((float)((double)flake.getX() + 21.0 * Math.random())));
        this.snowflakes.forEach(flake -> flake.setY(flake.getY() - 40.0f));
        this.snowing = false;
        float fontSize = this.standardFont.getLineHeight() + 1.0f;
        Globals.cursorY = Math.round((float)Globals.DEFAULT_CURSOR_Y - fontSize * (float)WishesHelper.initialLoading.size());
    }

    @Override
    public void update(float delta) {
        long frame = Gdx.graphics.getFrameId();
        if (this.snowing) {
            for (int startIndex = 0; startIndex <= 6; ++startIndex) {
                if (!this.snowing || frame <= (long)(400 + startIndex * 100)) continue;
                WinterEffects.snow(startIndex, this.snowflakes);
            }
            float fontSize = this.standardFont.getLineHeight() + 1.0f;
            if (frame < 400L) {
                Globals.cursorY = Math.round((float)Globals.DEFAULT_CURSOR_Y - fontSize * 15.0f);
            } else if (frame < 1150L) {
                Globals.cursorY = Math.round((float)Globals.DEFAULT_CURSOR_Y - fontSize * 14.0f);
            } else {
                Globals.cursorY = Math.round((float)Globals.DEFAULT_CURSOR_Y - fontSize * 18.0f + 3.0f);
                this.borderColor = C64Colors.WHITE;
                Globals.CURSOR_COLOR = C64Colors.WHITE;
            }
        }
        if (frame >= 400L) {
            this.snowing = true;
            ConsoleLogger.logBannerWithElapsedTime(BannerMCh.lines);
        }
    }

    @Override
    public void render() {
        float y;
        int i;
        super.render();
        long frame = Gdx.graphics.getFrameId();
        this.batch2.begin();
        for (i = 0; i < WishesHelper.initialLoading.size(); ++i) {
            y = Globals.DEFAULT_CURSOR_Y - (long)((i - 1) * 16);
            this.standardFont.draw((Batch)this.batch2, WishesHelper.initialLoading.get(i), 81.0f, y);
        }
        if (this.snowing) {
            for (i = 0; i < WishesHelper.startAppLines.size(); ++i) {
                y = Globals.DEFAULT_CURSOR_Y - (long)((8 + i) * 16);
                this.standardFont.draw((Batch)this.batch2, WishesHelper.startAppLines.get(i), 81.0f, y);
            }
            if (frame >= 1150L) {
                for (i = 0; i < WishesHelper.changeColorsLine.size(); ++i) {
                    y = Globals.DEFAULT_CURSOR_Y - (long)((13 + i) * 16);
                    this.standardFont.draw((Batch)this.batch2, WishesHelper.changeColorsLine.get(i), 81.0f, y);
                }
                BitmapFont whiteFont = C64Helper.createFont(15, "C64_Pro_Mono-STYLE.ttf");
                whiteFont.draw((Batch)this.batch2, "READY.", 81.0f, (float)Math.round(Globals.DEFAULT_CURSOR_Y - 256L + 2L));
            }
            for (int startIndex = 0; startIndex <= 6; ++startIndex) {
                if (frame <= (long)(400 + startIndex * 100)) continue;
                for (int i2 = startIndex; i2 < this.snowflakes.size(); i2 += 7) {
                    this.snowflakes.get(i2).draw(this.batch2);
                }
            }
        }
        if (frame >= 2650L) {
            float y2 = Math.round(Globals.DEFAULT_CURSOR_Y - 272L + 2L);
            this.whiteFont.draw((Batch)this.batch2, "POKE 53281, 14 : ? CHR$(147)", 81.0f, y2);
            this.blinkingCursor = false;
            if (frame >= 2800L) {
                this.snowing = false;
            }
        }
        this.batch2.end();
    }
}

