#version 450

layout(location = 0) in vec2 texCoord;

layout(location = 0) out vec4 outColor;

#include "ubo_perframe.glsl"

#include "noise.glsl"

#define FILM_GRAIN_AMOUNT   0.2
//#define FILM_GRAIN_TINT     vec3(0.5,0.75,1)
#define FILM_GRAIN_TINT     vec3(1,1,1)

void main() {

//    outColor = vec4(texCoord.x, texCoord.y, 0.0f, 1.0f);

    vec3 grain = random(texCoord.xy + vec2(sin(time)*0.5+0.5, cos(time)*0.5+0.5)) * FILM_GRAIN_TINT;

    //
    // vignette
    //

    // center position
    vec2 position = texCoord.xy - vec2(0.5);
	float len = length(position);
    //float vignette = pow(1.0-len, 3.0);
    float vignette = 1.0-len;
    vignette *= vignette;

#if 1
    if(mod(gl_FragCoord.y, 2.0) >= 1.0) {
        outColor = vec4(0.85,0.85,0.85,1);
//        outColor = vec4(0,0,0,1);
    } else {
#endif
        outColor = vec4(1,1,1,1);
    }

    outColor.rgb = mix(outColor.rgb, grain, FILM_GRAIN_AMOUNT);

#if 1
//    vec3 grd = mix(vec3(0.91,0,0), vec3(1,1,1), texCoord.y);
//    vec3 grd = mix(vec3(0.99,0.15,0), vec3(0.025,0.025,0.025), texCoord.y);
    //vec3 grd = mix(vec3(0.75,0.99,0), vec3(0.025,0.025,0.025), texCoord.y);
//    vec3 grd = mix(vec3(1.0, 1.0, 1.0), vec3(0.0, 0.0, 0.0), texCoord.y);


    vec3 firstColor = vec3(0.5, 0.25, 0.0);
    vec3 middleColor = vec3(0.25, 0.5, 0.0) * 3.0;
    vec3 endColor = vec3(0.0, 0.0, 0.0);

/*
    vec3 firstColor = vec3(1.0, 1.0, 1.0);
    vec3 middleColor = vec3(8.0, 8.0, 8.0);
    vec3 endColor = vec3(0.0, 0.0, 0.0);
*/
    float h = 0.5; // adjust position of middleColor
    vec3 grd = mix(mix(firstColor, middleColor, texCoord.y/h), mix(middleColor, endColor, (texCoord.y - h)/(1.0 - h)), step(h, texCoord.y));

    grd *= 1.0;

    outColor.rgb *= grd;
#endif

    outColor.rgb *= vignette;
    outColor.rgb *= u_fade;
}



