
Demo.prototype.sceneIntro = function () {
  this.setScene('intro');

  this.loader.addAnimation({
    "light": {
        "type": "Ambient",
        "properties": { "intensity": 2.0 },
        "castShadow": false
    }
    ,"color": [{
        "r": 0.8, "g": 0.8, "b": 0.8
    }]
});    

    this.loader.addAnimation({
      "light": {
          "type": "Directional",
          "properties": { "intensity": 1.5 },
          "castShadow": true
      }
      ,position:[{x:0.5,y:3,z:2}]
    });    

    const particleCount = 600;
  const emojiList = [
  '😂', '😎', '😡', '😍', '🥳', '🤯',
  ];

  emojiList.forEach((emoji) => {
    let particles = new Array(particleCount);
    for (let i = 0; i < particleCount; i++) {
      particles[i] = {
        x: Utils.random() * 10 - 5,
        y: Utils.random() * 10 - 5,
        z: -2,
        scale: Utils.random() * 1.5 + 0.5,
      };
    }
    this.loader.addAnimation({
      image: emoji,
      position: [
        {
          x: 0,
          y: -1,
          z: 0
        }
      ],
      /*angle:[{             
          //degreesY:()=>getSceneTimeFromStart()*60,              
          degreesZ:()=>Math.sin(getSceneTimeFromStart()*1.5)*15,      
        }],*/
      /*angle: [{
        degreesY: ()=> getSceneTimeFromStart() * 60,
        degreesX: ()=> getSceneTimeFromStart() * 60
     }],*/
      scale: [{ uniform3d: 1.0 }],
      "perspective": "3d",
      //"billboard": true,
      "additive": false,
      /*"material":{
        "blending": 'AdditiveBlending',
        "transparent":true,
        "depthWrite":false,
      },*/
      color: [{r:1,g:1,b:1}],
      //"scale":[{"uniform3d":.1}],
      "instancer": {
        "count": particleCount,
        "runInstanceFunction": (properties) => {

          const i = properties.index;
          const count = properties.count;
          const time = properties.time;
          let object = properties.object;
          let color = properties.color;

          const particle = particles[i]; 


          let scale = particle.scale;// * Math.min(time * 0.1, 1.0);
          object.position.x = particle.x;
          object.position.y = particle.y;
          object.position.z = particle.z;


            color.r = 1.0;
            color.g = 1.0;
            color.b = 0.0;
            color.a = Math.max(Math.sin(time*18.0), 0.0);
            const percent = time/6.0;
            if (i > particleCount*percent) {
              color.a = 0.0;
            }

          //}

          object.scale.x = scale;
          object.scale.y = scale;
          object.scale.z = scale;
        }
      }
    });
  });



  //};


}


Demo.prototype.sceneIntroTitle = function () {
  this.setScene('introTitle');
const alpha = 0.97;
this.loader.addAnimation({
    image: 'scenes/title.png',
    color: [
      {r:0, g:0, b:0, a:1}
    ]
  });

}


Demo.prototype.sceneOutro = function () {
  this.setScene('outro');

  this.loader.addAnimation({
    "light": {
        "type": "Ambient",
        "properties": { "intensity": 2.0 },
        "castShadow": false
    }
    ,"color": [{
        "r": 0.8, "g": 0.8, "b": 0.8
    }]
});    

    this.loader.addAnimation({
      "light": {
          "type": "Directional",
          "properties": { "intensity": 1.5 },
          "castShadow": true
      }
      ,position:[{x:0.5,y:3,z:2}]
    });    

    const particleCount = 2000;
    const particles = new Array(particleCount);
    for (let i = 0; i < particleCount; i++) {
      particles[i] = {
        scale: Utils.random() * 5.5 + 0.5,
        x: Utils.random() * 10 - 5,
        y: Utils.random() * 10 - 5,
        z: -2,
      };
    }

    this.loader.addAnimation({
      image: '🍞',
      position: [
        {
          x: 0,
          y: -1,
          z: 0
        }
      ],
      /*angle:[{             
          //degreesY:()=>getSceneTimeFromStart()*60,              
          degreesZ:()=>Math.sin(getSceneTimeFromStart()*1.5)*15,      
        }],*/
      /*angle: [{
        degreesY: ()=> getSceneTimeFromStart() * 60,
        degreesX: ()=> getSceneTimeFromStart() * 60
     }],*/
      scale: [{ uniform3d: 1.0 }],
      "perspective": "3d",
      //"billboard": true,
      /*"additive": true,
      "material":{
        "blending": 'AdditiveBlending',
        "transparent":true,
        "depthWrite":false,
      },*/
      color: [{r:1,g:1,b:1}],
      //"scale":[{"uniform3d":.1}],
      "instancer": {
        "count": particleCount,
        "runInstanceFunction": (properties) => {

          const i = properties.index;
          const count = properties.count;
          const time = properties.time;
          let object = properties.object;
          let color = properties.color;

          const particle =particles[i];


          let scale = particle.scale;// * Math.min(time * 0.1, 1.0);
          object.position.x = particle.x;
          object.position.y = particle.y;
          object.position.z = particle.z;


            color.r = 1.0;
            color.g = 1.0;
            color.b = 1.0;
            color.a = Math.min(time * 4.0, 1.0);
          //}

          object.scale.x = scale;
          object.scale.y = scale;
          object.scale.z = scale;
        }
      }
    });
  //};


}
