#version 450

layout(location = 0) in vec2 FragCoord;
layout(location = 0) out vec4 FragColor;

layout(set = 2, binding = 0) uniform sampler2D u_InputTexture;

layout(set = 3, binding = 0) uniform PushConstants {
    float u_Time;
    vec2 u_Resolution;
};

#define EPOCH 128.

#include <noise.glsl>

float iteration() {
    return floor(u_Time / EPOCH);
}

vec3 acesApprox(vec3 v) {
    v *= 0.6;
    float a = 2.51;
    float b = 0.03;
    float c = 2.43;
    float d = 0.59;
    float e = 0.14;
    return clamp((v * (a * v + b)) / (v * (c * v + d) + e), 0., 1.);
}

void main() {
    vec2 uv = FragCoord * 0.5 + 0.5;

    // Timing hack
    if (iteration() > 12. && iteration() < 16.) {
        uv.x += 3. * noise(1234. * noise(gl_FragCoord.y * 5.) * gl_FragCoord.y + u_Time) / u_Resolution.x;
    }

    // Chromatic aberration
    vec3 color = vec3(
            texture(u_InputTexture, uv + vec2(-1. / u_Resolution.x, 0.)).r,
            texture(u_InputTexture, uv).g,
            texture(u_InputTexture, uv + vec2(1. / u_Resolution.x, 0.)).b
        );

    // Vignette
    color = color - length(FragCoord) * 0.2;

    // Noise
    float noise_amount = 0.1;
    if (iteration() > 12. && iteration() < 16.) {
        noise_amount = 0.2;
    }
    vec2 seed = gl_FragCoord.xy;
    seed += vec2(noise(u_Time * 5.), noise(u_Time * 11.)) * u_Resolution;
    color += (noise(seed) - .5) * noise_amount;

    // Output
    // https://64.github.io/tonemapping/
    FragColor = vec4(acesApprox(max(color, 0.)), 1.);
}
