#ifndef LIB_CONSTANTS_GLSL
#define LIB_CONSTANTS_GLSL

// --------------------
// Math constants
// --------------------
#define PI_OVER_6     0.523598775598299       // Pi / 6 (30°)
#define PI_OVER_3     1.047197551196598       // Pi / 3
#define HALF_PI       1.5707963267948966      // Pi / 2
#define PI            3.14159265358979323846  // Pi
#define TWO_PI        6.28318530717958647692  // 2 * Pi

#define INV_PI_OVER_3 0.954929658551372       // 1 / (Pi/3) = 3 / Pi

// --------------------
// Quadrant angles (radians)
// --------------------
#define Q0 0.0
#define Q1 HALF_PI
#define Q2 PI
#define Q3 (3.0 * HALF_PI)

// --------------------
// Limits
// --------------------
#define MAX_LIGHTS 1   // maximum number of supported lights

#endif // LIB_CONSTANTS_GLSL