#version 410

//#define MAX_LIGHTS 3

#pragma include "p3d/uniform.glsl"
#pragma include "lib/shadow.glsl"
#pragma include "lib/constants.glsl"
#pragma include "lib/color.glsl"
#pragma include "lib/math.glsl"
#pragma include "lib/simplex3d.glsl"
#pragma include "colors.glsl"

// Uniform inputs
uniform float u_MaxShininess;
uniform float u_RimLightIntensity;
uniform float u_ShadowSamples;
uniform float u_ShadowSpread;
uniform float u_SpecularBlendStrength;
uniform int u_NumberOfLights;
uniform float u_SpecularPower;
uniform float u_Roughness;
uniform float u_Brightness;
uniform float u_Saturation;
uniform float u_Reflectivity;

uniform float u_Flash;

//uniform sampler2D u_BaseColorTex;
//uniform sampler2D u_MetallicRoughnessTex;
//uniform sampler2D u_NormalTex;
//uniform bool u_UseBaseColorTex;
//uniform bool u_UseMetallicRoughnessTex;
//uniform bool u_UseNormalTex;

uniform vec3 u_TexOrder;

uniform float u_Segment;
uniform float u_Time;
uniform sampler2D u_TextTex;
uniform float u_TextTexAspect;  // r = h/w

uniform int u_Color;

uniform float u_Scroll;


// Input from vertex shader
in vec4 vertInShadowSpaces[MAX_LIGHTS];
in vec4 vertColor;
in vec4 vertPosition;
//in vec4 domiPosition;
in vec2 vertMultiTexCoord0;
in vec3 vertNormal;
//in vec3 binormal;
in vec3 tangent;
in float neg;

in vec3 vertObjPosition;

// Output to the screen
//out vec4 fragColor;
//out vec4 reflectivityOut;
layout(location = 0) out vec4 fragColor;
layout(location = 1) out vec4 reflectivityOut;

#define MAX_FRESNEL_POWER 5.0
#define MAX_SHININESS     127.75

// Clamp value to [0,1] (short alias)
float sat(float x) { return clamp(x, 0.0, 1.0); }

//vec3 dir_to_rgb(vec3 v) { return v * 0.5 + 0.5; } // map [-1,1] -> [0,1]

//#define BULBS 16.0  // Topaz * 2
//#define BULBS 26.0  // Card
#define BULBS 48.0  // Card
//#define BULBS 52.0  // Card * 2

#define GAIN_0 10.0

#define BEG 0.0
#define END 94.0

#define M_PI 3.141592653589793

#define CELL_SIZE 40.0      // skala: promień heksa w pikselach
#define INTERVAL 1.0

// promień heksa w lokalnym układzie (w jednostkach siatki)
#define HEX_RADIUS 0.8

// Signed distance do regularnego heksa, radius = promień
float sdHex(vec2 hexPos, float radius) {
    // heks jako przecięcie 6 półpłaszczyzn (6 normalnych co 60)
    float dist = -1e9;

    // φ ustawia orientację heksa
    const float phi = M_PI / 3.0;

    for (int i = 0; i < 6; i++) {
        float angle = M_PI / 3.0 * float(i) + phi;
        vec2 edgeN = vec2(cos(angle), sin(angle));  // normalna do jednej z krawędzi
        dist = max(dist, dot(edgeN, hexPos));
    }

    // dist = max_i (n_i·hexPos) - radius
    return dist - radius;
}

vec3 cubeRound(vec3 c) {
    vec3 r = floor(c + 0.5);
    vec3 diff = abs(r - c);

    if (diff.x > diff.y && diff.x > diff.z)
        r.x = -r.y - r.z;
    else if (diff.y > diff.z)
        r.y = -r.x - r.z;
    else
        r.z = -r.x - r.y;

    return r;
}

// Rotate the uv coords for a flip dot plane around the x-axis.
vec2 flipX(vec2 uv, float angle){
    vec3 ray    = vec3(uv, 3.0);
    vec3 normal = vec3(0.0, sin(angle), cos(angle));
    float denom = dot(normal, ray);
    float param = (ray.z * normal.z) / denom;

    vec3 hit = ray * param;
    return vec2(hit.x, hit.y / normal.z);
}


// Proceduralny wzór, zero tekstur, tylko sin/cos/dot
float display(vec2 cellCoord, float timeValue){
    // cellCoord to indeks komórki (heksa); przeskalujmy go, żeby było gęściej
    vec2 x = cellCoord * 0.3;
    float timeScaled = timeValue * 0.5;

    // Fala kierunkowa
    float color1 = 0.5 + 0.5 * sin(dot(x, vec2(1.37, 2.11)) + timeScaled * 3.0);

    // "Wirujący" środek, ale bez znajomości rozmiaru tekstury
    vec2 center = vec2(sin(-timeScaled * 1.7) * 3.0,
                       cos(-timeScaled * 1.3) * 3.0);

    // Zamiast length() (sqrt) - używamy dot(diff,diff) dla wydajności
    vec2 diffVec  = x - center;
    float color2 = 0.5 + 0.5 * cos(dot(diffVec, diffVec) * 0.7);

    float color = 0.5 * (color1 + color2);

    return 0.5 + 0.5 * cos(M_PI * color / 0.5 + timeScaled * 3.0);
}


// Prosty, szybki hash 2D -> [0,1)
float hash21(vec2 h) {
    vec2 q = fract(h * vec2(123.34, 456.21));
    q += dot(q, q + 34.345);
    return fract(q.x * q.y);
}


// Każda komórka ma własne "pseudolosowe" opóźnienie
float delay(vec2 cellId){
    return hash21(cellId);
}





// phase: dowolna wartość, 0..1 to jeden pełny obieg tęczy
vec3 rainbowColor(float phase)
{
    float x = fract(phase);              // 0..1
    float a = x * 6.28318530718;         // 2 * PI

    // prosty kolor tęczy na bazie przesuniętych cosinusów, zakres 0..1
    vec3 c;
    c.r = 0.5 + 0.5 * cos(a);
    c.g = 0.5 + 0.5 * cos(a - 2.09439510239);   // 2PI/3
    c.b = 0.5 + 0.5 * cos(a - 4.18879020479);   // 4PI/3

    // twoje "czarne" i "białe"
    vec3 dark  = vec3(0.1);  // 0.1, 0.1, 0.1
    vec3 light = vec3(0.2);  // 0.2, 0.2, 0.2

    // przeskalowanie z 0..1 do 0.1..0.2
    return mix(dark, light, c);
}











vec2 smoothRot(vec2 p,float s,float m,float c,float d)
{
  s*=0.5;
  float k=length(p);
  float x=asin(sin(atan(p.x,p.y)*s)*(1.0-m))*k;
  float ds=k*s;
  float y=mix(ds,2.0*ds-sqrt(x*x+ds*ds),c);
  return vec2(x/s,y/s-d);
}

mat2 rotate(float a)
{
	float c = cos(a);
	float s = sin(a);
	return mat2(c, s, -s, c);
}

float vDrop(vec2 uv,float t)
{
    float xoff = sin(uv.y*25.0)*0.16;
    xoff *= smoothstep(0.0,1.0,0.5+sin(length(uv)+u_Time*0.3)*0.5);
    uv.x+=xoff;
    uv.y *= 2.;
    uv.x = uv.x*16.0;						// H-Count
    float dx = fract(uv.x);
    uv.x = floor(uv.x);
    uv.y *= 0.5;							// stretch
    float o=sin(uv.x*215.4);				// offset
    float s=cos(uv.x*33.1)*.3 +.7;			// speed
    float trail = mix(18.0,5.0,s);			// trail length
    //float trail = 5.0;
    float yv = fract(uv.y + t*s + o) * (trail*1.5);
    yv = 1.0/yv;
    yv = smoothstep(0.0,1.0,yv*yv);
    yv = sin(yv*PI)*(s*5.0);
    float d2 = sin(dx*PI);
    return yv*(d2*d2);
}



// x – np. uv.x, może być dowolny (0..inf), powtarza się co 6.0
float triSmooth(float x)
{
    // 1) Zawijamy do przedziału 0..6
    float period = 6.0;
    float t = mod(x, period);      // 0..6

    // 2) Robimy z tego "trójkąt" 0->3->0
    float hhalf = period * 0.5;     // 3.0
    float upDown = (t <= hhalf) ? t : (period - t);  // 0..3..0

    // 3) Normalizujemy do 0..1
    float u = upDown / hhalf;       // 0..1..0

    // 4) Wygładzamy – wolno na początku/końcu, szybciej w środku
    float eased = smoothstep(0.0, 1.0, u); // 0..1..0, z ease-in/out

    // 5) Skala z powrotem do 0..3
    return eased * hhalf;           // 0..3..0
}






void main() {

    vec4 diffuseColor = texture(p3d_TextureModulate[0], vertMultiTexCoord0) * vertColor;

    if (u_Color == 0) {
        // UV in [0,1] from object space
        vec2 uv = vertObjPosition.xy + vec2(0.5, 0.0);

        // Hex grid space in cell units (logical width of the strip)
        vec2 worldCoord = ((uv + vec2(u_Segment, 0.0)) * 692.8 * 0.25) / CELL_SIZE;
//        vec2 worldCoord = ((uv + vec2(u_Segment, 0.0)) * 692.8) / CELL_SIZE;

        // Pixel -> axial (pointy-top hex coordinates)
        float q      = 0.57735026919 * worldCoord.x - 0.33333333333 * worldCoord.y;
        float axialR = 0.66666666667 * worldCoord.y;

        // Axial -> cube
        vec3 cube = vec3(q, -q - axialR, axialR);
        vec3 rc   = cubeRound(cube);
        float rq  = rc.x;
        float rr  = rc.z;

        // Hex cell index
        vec2 cellIndex = vec2(rq, rr);

        // Axial -> pixel (hex center in grid space)
        float cx = 1.73205080757 * rq + 0.86602540378 * rr;
        float cy = 1.5 * rr;
        vec2 hexCenter = vec2(cx, cy);

        // Local coordinates inside the hex
        vec2 local = worldCoord - hexCenter;

        // Flip timing
        float timeBase = u_Time / INTERVAL + 0.5 * delay(cellIndex) + cellIndex.y / 40.0;
        float timeFrac = fract(timeBase);
        float timeStep = timeBase - timeFrac;

        // Current and next flip state
        float d0 = step(0.5, display(cellIndex, timeStep));
        float d1 = step(0.5, display(cellIndex, timeStep + 1.0));

        float phase = mix(d0, d1, smoothstep(0.0, 1.0, timeFrac));

        // Flap plane
        vec2 plane = flipX(local, M_PI * phase);

        // Hex shape mask
        float dist = sdHex(plane, HEX_RADIUS);
        float aa   = smoothstep(0.0, fwidth(dist), -dist);

        float color = mix(0.2, 1.0, step(phase, 0.5));

        diffuseColor.rgb *= 1.0 + aa * color * GAIN_0;
    }

    if (u_Color == 1) {
        vec2 uv = vertObjPosition.xy + vec2(0.5, 0.0);
        vec2 id = floor(uv * BULBS) / BULBS;
        vec2 st = uv * BULBS - id * BULBS - vec2(0.5, 0.5);
        vec2 address = id + vec2(u_Segment, 0.0);
        float factor = smoothstep(0.5, 0.4, length(st));
        float r = u_TextTexAspect;
//        float shift = r * (u_Segment + 94.0 * 1.5 - 1.0);
        float shift = r * (u_Segment + u_Scroll * END * 1.5 - 1.0);
        vec2 coord = fma(id, vec2(r, 1.0), vec2(shift, -0.02));
        float probe = texture(u_TextTex, coord).r;
        factor *= probe;
        diffuseColor.rgb = mix((rainbowColor(u_Scroll + 0.5) - 0.1) * 2.0, (rainbowColor(u_Scroll) - 0.05) * GAIN_1 * 1.5 * (1.0 + u_Flash), factor);

    }

    if (u_Color == 2) {
        // 'screenburn' smooth remix - Del 05/12/2021


        vec2 uv = vertObjPosition.xy + vec2(0.5, 0.0) + vec2(u_Segment, 0.0);
        uv.x = triSmooth(uv.x) / 3.0; // 0..3..0 z wygładzeniem, okres 6.0
//        uv.x /= 6.0 - 0.5; // 0..3..0 z wygładzeniem, okres 6.0

        float dd0 = length(uv);
        float dd1 = smoothstep(0.0,0.3,dd0);
        uv *= rotate(fract(0.6+u_Time*-0.01)*6.28);
    //    uv = smoothRot(uv,8.0,0.05,0.0,-0.1);
          uv = smoothRot(uv,4.0,0.35,16.0,0.05);

        float drop = vDrop(uv.yx,u_Time*0.5);
        vec3 linecol1 = vec3(0.75,0.45,0.325)*1.5;
        vec3 linecol2 = vec3(0.4,0.75,0.325)*1.5;
        vec3 linecol = mix(linecol1,linecol2,0.5+sin(u_Time*0.2+dd0*.7)*0.5);

        vec3 backcol = vec3(0.01,0.04,0.1);
        vec3 col = mix(backcol,linecol,drop)*dd1;
        diffuseColor.rgb = col;
    }

    if (diffuseColor.a < 0.5) discard;
//    if (diffuseColor.a < rand(gl_FragCoord.xy)) discard;


    diffuseColor = color_ops(diffuseColor, u_Saturation, u_Brightness);

    vec4 roughnessMap = texture(p3d_TextureSelector[0], vertMultiTexCoord0);

    vec4 normalTex = texture(p3d_TextureNormal[0], vertMultiTexCoord0);

//    float roughness = roughnessMap.g;
    float roughness = 0.0;

//
//    float occlusion = roughnessMap.r;  // AO in red
//    float metallic  = roughnessMap.b;  // Metallic in blue
//

    float shininess = (1.0 - roughness) * MAX_SHININESS * u_MaxShininess;

    vec4 diffuse  = vec4(0.0, 0.0, 0.0, diffuseColor.a);
    vec4 specular = vec4(0.0, 0.0, 0.0, diffuseColor.a);
    vec4 rim      = vec4(0.0, 0.0, 0.0, diffuseColor.a);

//
//    vec3 materialSpecularColor = p3d_Material.specular;
//

    vec3 Nv = normalize(vertNormal);
    vec3 Tv = normalize(tangent - Nv * dot(tangent, Nv)); // upewnij T ⟂ N
    vec3 Bv = cross(Nv, Tv);                               // brak sign — prosto i szybko

    vec3 nMap = normalize(texture(p3d_TextureNormal[0], vertMultiTexCoord0).rgb * 2.0 - 1.0);
//    vec3 normal = u_UseNormalTex ? normalize(mat3(Tv, Bv, Nv) * nMap) : Nv;
    vec3 normal = normalize(mat3(Tv, Bv, Nv) * nMap);

    vec3 eyeDirection = normalize(-vertPosition.xyz);

    vec3 test;

    for (int i = 0; i < u_NumberOfLights; ++i) {  // i = 0

        vec3 lightDirection = p3d_LightSource[i].position.xyz - vertPosition.xyz * p3d_LightSource[i].position.w;

        vec3 unitLightDirection = normalize(lightDirection);
        vec3 halfwayDirection   = normalize(unitLightDirection + eyeDirection);

        float lightDistance = length(lightDirection);

        float attenuation = 1 / (
            p3d_LightSource[i].constantAttenuation +
            p3d_LightSource[i].linearAttenuation * lightDistance +
            p3d_LightSource[i].quadraticAttenuation * (lightDistance * lightDistance)
        );

        if (attenuation <= 0.0) { continue; }

        // Diffuse
        float diffuseIntensity  = dot(normal, unitLightDirection);
        if (diffuseIntensity < 0.0) { continue; }
//        vec4 diffuseTemp = vec4(
//            clamp(diffuseColor.rgb * p3d_LightSource[i].diffuse.rgb * diffuseIntensity, 0.0 , 1.0), diffuseColor.a
//        );
//        diffuseTemp = clamp(diffuseTemp, vec4(0), diffuseColor);
        vec4 diffuseTemp = vec4(
            clamp(diffuseColor.rgb * p3d_LightSource[i].diffuse.rgb * diffuseIntensity, 0.0 , 1.0), diffuseColor.a
        );


        // Specular
        float specularIntensity = sat(dot(normal, halfwayDirection));
        vec4 lightSpecularColor = p3d_LightSource[i].specular;
        vec4 materialSpecularColor = vec4(vec3(1.0 - roughness), diffuseColor.a);

//
//        vec4 materialSpecularColor = vec4(mix(vec3(0.04), diffuseColor.rgb, metallic), diffuseColor.a);
//

        float fresnelFactor = dot(halfwayDirection, eyeDirection);
        fresnelFactor = max(fresnelFactor, 0.0);
        fresnelFactor = 1.0 - fresnelFactor;
        fresnelFactor = pow(fresnelFactor, MAX_FRESNEL_POWER);
        materialSpecularColor.rgb = mix(
            materialSpecularColor.rgb,
            vec3(u_SpecularBlendStrength),
            sat(fresnelFactor)
        );

        vec4 specularTemp = vec4(vec3(0.0), diffuseColor.a);
        specularTemp.rgb  = lightSpecularColor.rgb * pow(specularIntensity, shininess);
        specularTemp.rgb *= materialSpecularColor.rgb;
        specularTemp.rgb  = clamp(specularTemp.rgb, 0.0, 1.0);  // Comment to have more specular
        specularTemp.rgb *= u_SpecularPower;

        // Spot
        float unitLightDirectionDelta = dot(normalize(p3d_LightSource[i].spotDirection), -unitLightDirection);
        if (unitLightDirectionDelta < p3d_LightSource[i].spotCosCutoff) { continue; }
        float spotExponent = p3d_LightSource[i].spotExponent;
        diffuseTemp.rgb *= (spotExponent <= 0.0 ? 1.0 : pow(unitLightDirectionDelta, spotExponent));

        // Shadow
        float shadow = sh(
            p3d_LightSource[i].shadowMap,
            vertInShadowSpaces[i],
            u_ShadowSpread,
            u_ShadowSamples // float selector: 0..4
        );

//        shadow = 1.0;

        diffuseTemp.rgb  *= shadow;
        specularTemp.rgb *= shadow;

//        test = vec3(diffuseTemp);

        diffuseTemp.rgb  *= attenuation;
        specularTemp.rgb *= attenuation;

        diffuse  += diffuseTemp;
        specular += specularTemp;

        // Rim
        vec4 rimLight = vec4(0.0);
        rimLight.rgb = vec3(1.0 - max(0.0, dot(normalize(-vertPosition.xyz), normalize(normal))));
        rimLight.rgb = pow(rimLight.rgb, vec3(2.0)) * u_RimLightIntensity;
        rimLight.rgb *= diffuse.rgb;
        rim += rimLight;

    }

    vec4 ambient = p3d_Material.ambient * p3d_LightModel.ambient * diffuseColor;

    vec3 color = diffuse.rgb + rim.rgb + specular.rgb + ambient.rgb + p3d_Material.emission.rgb;

//    color.rgb = test;
//    color.rgb = diffuseTemp.rgb;
//    color.rgb = diffuseColor.rgb;
//    color.rgb = Tv;
//    color.rgb = normal;
//    color.rgb = vertNormal;
//    color.rgb = tangent;
//    color.rgb = dir_to_rgb(normalize(tangent));
//    color.rgb = vec3(u_ShadowSamples);
//    color.rgb = vec3(u_ShadowSpread * 100.0);

    fragColor = vec4(color, diffuseColor.a);
    reflectivityOut = vec4(vec3(u_Reflectivity), 1.0);
}
