Demo.prototype.addScoreCalculator = function ()
{

    window.score = 0;
    window.tempScore = 0;
    this.loader.addAnimation({
    runFunction:()=>{
        let score = Math.floor(window.score + window.tempScore);

        const [d4, d3, d2, d1] = score.toString().padStart(4, '0').split('').map(Number);
        window.d1=d1;
        window.d2=d2;
        window.d3=d3;
        window.d4=d4;
      
    }
});

const fragShaderSuffix = `
  vec2 coord=vMapUv.xy;
  coord.t=coord.t+fakeTime;
  gl_FragColor = texture2D(map, coord);
  float x = mod((vMapUv.y)*1.0,0.1);
  if (x>0.05){
   x = 0.1-x;
  }
  gl_FragColor.rgb*=min(0.7+x/0.05*0.3*1.0, 1.0);
`;

this.loader.addAnimation([
    {
      object: {
        name: '3d_models/meter.obj'
      },
      textureProperties: [{ wrapS: 'RepeatWrapping', wrapT: 'RepeatWrapping'}],
    position:[{
        x:12,
        y:6,
        z:-1,
        }],
      angle: [
        {
          degreesX: 90,
        }
      ],
      scale: [{ uniform3d: 1, z:0.2 }],
      shader:{
        fragmentShaderPrefix:`
          uniform float fakeTime;
        `,
        fragmentShaderSuffix: fragShaderSuffix,
        variable: [
          { name: 'fakeTime', value: [()=> -.1 * d1] }
        ]
      } 
    }
  ]);

this.loader.addAnimation([
    {
      object: {
        name: '3d_models/meter.obj'
      },
      textureProperties: [{ wrapS: 'RepeatWrapping', wrapT: 'RepeatWrapping'}],
    position:[{
        x:10,
        y:6,
        z:-1,
        }],
      angle: [
        {
          degreesX: 90,
        }
      ],
      scale: [{ uniform3d: 1, z:0.2 }],
      shader:{
        fragmentShaderPrefix:`
          uniform float fakeTime;
        `,
        fragmentShaderSuffix: fragShaderSuffix,
        variable: [
            { name: 'fakeTime', value: [()=> -.1 * d2] }
        ]
      } 
    }
  ]);

this.loader.addAnimation([
    {
      object: {
        name: '3d_models/meter.obj'
      },
      textureProperties: [{ wrapS: 'RepeatWrapping', wrapT: 'RepeatWrapping'}],
    position:[{
        x:8,
        y:6,
        z:-1,
        }],
      angle: [
        {
          degreesX: 90,
        }
      ],
      scale: [{ uniform3d: 1, z:0.2 }],
      shader:{
        fragmentShaderPrefix:`
          uniform float fakeTime;
        `,
        fragmentShaderSuffix: fragShaderSuffix,
        variable: [
         { name: 'fakeTime', value: [()=> -.1 * d3] }
        ]
      } 
    }
  ]);

this.loader.addAnimation([
    {
      object: {
        name: '3d_models/meter.obj'
      },
      textureProperties: [{ wrapS: 'RepeatWrapping', wrapT: 'RepeatWrapping'}],
    position:[{
        x:6,
        y:6,
        z:-1,
        }],
      angle: [
        {
          degreesX: 90,
        }
      ],
      scale: [{ uniform3d: 1, z:0.2 }],
      shader:{
        fragmentShaderPrefix:`
          uniform float fakeTime;
        `,
        fragmentShaderSuffix: fragShaderSuffix,
        variable: [
           { name: 'fakeTime', value: [()=> -.1 * d4] }
        ]
      } 
    }
  ]);
};