;------------------------------
;Type-fun
;
;code by Gordian
;csdb.dk/scener/?id=37254
;
;1024b intro
;Lovebyte 2025
;
;975 bytes of code
;2 bytes of header
;------------------------------


.TARGET_SIZE=1024

IntPartTable=$0d40
FractPartTable=$0d80
SourceOrig=$0df0
Source=$0df8


;16 steps of scaling
;8 bytes - width of big char
;256 chars
;32kB for 256 patterns
Target=$0e00

Charset=$a000
Screen1=$a800
Screen2=$b000
RomCharset=$b800

FourChars=$c000
CharTmpBuffer=$c100
Sin=$c200


SOURCE_WIDTH=64
DITHER=0

NumPixels=$02
Error=$03
SourceIndex=$04
IntPart=$05
FractPart=$06
ScreenSwap=$07
d011Offset=$08
GenerateSinusValue=$09
;$0a
GenerateSinusDelta=$0b
;$0c
Mode=$0d

MODE_BAR=$f0
MODE_CHAR=$f1
MODE_LINE=$f2

*=$0900-4 ; SYS 2300

   sei
   jmp Start

.DATA_START

ScrollText
;!for i=0 to 255
;!byte i
;!end
!byte MODE_BAR
!scr "    hi bytelovers!",$53,$53,$53
!scr "    "
!byte MODE_CHAR
!scr "welcome to 2025"
!scr "    "
!byte MODE_LINE
!scr "let's dive in and experience the magic of bytes!"
!scr "   ",$4d,$4e,$4d,$4e,$4d,$4e,$66,$66,$69,$69,$69
!scr "   "


Colors
;!byte 1,7,15,14,12,11,9,6,6,9,11,12,14,15,7,1
;!byte 1,1,7,15,15,12,12,11,11,12,12,15,15,7,1,1
;!byte 1,3,3,14,14,4,4,6,6,4,4,14,14,3,3,1 ;blue
;!byte 1,7,13,15,12,8,11,9,9,11,8,12,15,13,7,1
!byte 1,13,3,12,4,2,11,9,9,11,2,4,12,3,13,1

!if(DITHER){
Dither
;!byte $55,$cc,$77,$ff
!byte $11,$92,$55,$ff
}

UsedPatterns
!byte 0,1,3,6,7,8,12,14,15,16,18,24,28,30,31,48,51,54,56,60,62,63,70,96,98,99,102,103,107,108,110,112,118,119,120,124,126,127,128,129,131,135,136,137,143,145,147,148,152,153,156,157,159,185,192,193,195,199,201,204,207,224,225,227,231,237,239,240,241,243,247,248,249,252,254,255

.DATA_END

.CODE_START
Start
  ; sei
   
   lda #0
   sta $d020
   sta $d021
   ldx #16
-
   sta $02,x
   dex
   bpl -

   lda #MODE_BAR
   sta Mode
   
   
;clear bitmap using ROM      
   ldx #>Target
   stx $2c
- 
   jsr $e416
   lda $2c
   cmp #$d0
   bne -   
;   

   

;GenerateSinus   
   ldy #$3f
   ldx #$00

   ; Accumulate the delta (normal 16-bit addition)
 --
   lda GenerateSinusValue
   clc
   adc GenerateSinusDelta
   sta GenerateSinusValue
   lda GenerateSinusValue+1
   adc GenerateSinusDelta+1
   sta GenerateSinusValue+1
  
   and #$f
   asl
   asl
   asl
   
   sta Sin+$c0,x
   sta Sin+$80,y

;eor #$3f (max)
;but anded and shifted
;so eored by #$78
   eor #$78
   sta Sin+$40,x
   sta Sin+$00,y

   lda GenerateSinusDelta
   adc #$04
   sta GenerateSinusDelta
   bcc +
   inc GenerateSinusDelta+1
+
   inx
   dey
   bpl --
;   
   


;dividing 64/i   
   ldy #64
--   
   tya
   sta $fb

   lda #64
   sta $fa
   
   lda #0
   ldx #7
   clc
-
   rol $fa
   rol
   cmp $fb
   bcc +
   sbc $fb
+
   dex
   bpl -
   rol $fa
   
   sta FractPartTable-1,y
   lda $fa
   sta IntPartTable-1,y
   dey
   bne --
;

      
   

      
;copy ROM charset   
   lda #$33
   sta $01

   ldy #0
   sty $fa
   sty $fc

   
   lda #$d0
   sta $fb
   
   lda #>RomCharset
   sta $fd
   
   ldx #7
   ;ldy #0
-
   lda ($fa),y
   sta ($fc),y
   iny
   bne -
   inc $fd
   inc $fb 
   dex
   bpl -
;   

   ;lda #0
   inx
   stx $80
   stx $fa
   stx $fd

   lda #$36
   sta $01
   
   lda #>Target
   sta $fb
   lda #>Charset
   sta $81
   

;bits to bytes      
ScaleCharLoop
   lda $fd  ; patterns from 0 to 255   
   
   ldx #7
   ldy #0
-
   lsr
   pha
   bcs +
   lda #0
   !byte $2c
+
   lda #255
;store current pattern   
;for scaling
   sta SourceOrig,x

;store current pattern
;in the charset
   lda $fd
   sta ($80),y
   inc $80
   bne +
   inc $81
+  
   pla
   dex
   bpl -


   ldx #76-1 
-   
   cmp UsedPatterns,x
   beq ++
   dex
   bpl -

   lax $fa
   sbx #256-8*16
   bcc +
   inc $fb
+   
   
   inc $fd
   bne ScaleCharLoop
   jmp EndScaleCharLoop

++

   txa
   pha
   lda $fd
   eor #$ff
   jsr PrintHexValue
   pla
   tax
   
   lda #<Source
   sta $fe
   lda #>Source
   sta $ff
   
;for i=0 to 63   
   lda #64
   sta $fc  ;TARGET_WIDTH
ScalingLoop  
   ldy #7
-   
   lda SourceOrig,y
   sta ($fe),y
   dey
   bpl -

   lda $fc
   sta NumPixels
   tax
   lda IntPartTable-1,x
   sta IntPart
   lda FractPartTable-1,x
   sta FractPart
   
   lda #0
   sta Error   
   
;while ($NumPixels-- > 0)    
ScalingLineLoop
;$Target[] = $Source;
   lda Source
   cmp #$80
   
   ldy #7
.a
   rla ($fa),y
   dey
   bpl .a 

;$Source += $IntPart;   
   clc
   ldx IntPart
-   
   ldy #7
.b
   rla ($fe),y
   dey
   bpl .b
   
   
      
   dex
   bne -

   
;$E += $FractPart;
   lda Error
   clc
   adc FractPart
   sta Error
   
;if ($E >= $TgtWidth) {   
   cmp $fc
   bcc +
   
;$E -= $TgtWidth;   
   sec
   sbc $fc
   sta Error
   
   clc  
   ldy #7
.c
   rla ($fe),y
   dey
   bpl .c  
   
;end if

+
;end while   
   dec NumPixels
   bne ScalingLineLoop
    
   
   lax $fa
   sbx #256-8
   stx $fa
   bcc +
   inc $fb
+
   
   lax $fc
   ;sec
   sbx #4
   stx $fc
   beq +
   jmp ScalingLoop

+   


;merge 0-15, 1-14, etc.
;to get two sides

;start of current Target pattern   

   lda $fa
   sec
   sbc #128
   sta $92
   lda $fb
   sbc #0
   sta $93
   
   lda #<CharTmpBuffer
   sta $94
   lda #>CharTmpBuffer
   sta $95
   
   ldy #127
-
   lda ($92),y
   sta ($94),y
   dey
   bpl -
   
   
  ; lda #0
   iny
   sty $a0
---   
   
   ldx $a0
   beq +
-
   ldy #7
.d
   rla ($94),y
   dey
   bpl .d
   
   dex
   bpl -
   

+
   lax $94
   sbx #256-8
   stx $94
   bcc +
   inc $95
+
   
   lax $a0
   sbx #256-4
   stx $a0
   cpx #64
   bne ---
   
   
   lax $94
   sbx #8
   stx $94
   bcs +
   dec $95
+
   
   ldx #15
--   
!if(DITHER){
   txa
   pha
}
   ldy #7
.f
!if(DITHER){
   txa
   pha
   
   lsr
   lsr
   tax
   
   lda ($92),y
   and Dither,x
   sta $10
   
   txa
   eor #3
   tax
   lda ($94),y
   and Dither,x

   ora $10
   sta ($92),y
}else{
   lda ($92),y
   ora ($94),y
   sta ($92),y
}
   
   lda #0
   sta RomCharset,y

!if(DITHER){   
   pla
   tax
}   
   dey
   bpl .f
   
   lda $94
   sec
   sbc #8
   sta $94
   bcs +
   dec $95
+   
      
   lda $92
   clc
   adc #8
   sta $92
   bcc +
   inc $93
+   
!if(DITHER){
   pla
   tax
}   
   
   dex
   bpl --

   inc $fd
   beq +
   jmp ScaleCharLoop
+   

EndScaleCharLoop
   ldx #0
   stx $02
   stx $03
   stx $04
   inx
   stx $dd00
   
Loop
   lda #250
-
   cmp $d012
   bne -

   lda d011Offset
   sec
   sbc #2
   and #7
   sta d011Offset
   bne ++
   
   lda .ScrollCharLineOffset
   clc
   adc #1
   and #7
   sta .ScrollCharLineOffset
   bne ++
   
   ;;lda #0
;   sta .ScrollCharLineOffset
      
   lda .ScrollTextPtr
   clc
   adc #1
   cmp #$6d
   bcc +
   lda #0
+
   sta .ScrollTextPtr   
  
   lax $03
   sbx #256-13
   stx $03
++


   lda $02
   ldx Mode
   cpx #MODE_CHAR
   bne +   
   lda $03
   clc
   adc $02
+
   sta $04  

   lda d011Offset
   ora #$10
   ;and #$7f
   sta $d011   
   
   lda #<FourChars
   sta $fc
   lda #>FourChars
   sta $fd
   
   ldx #0
--   
   lda #0
   sta $fb
.ScrollTextPtr=*+1   
   lda ScrollText,x
   cmp #MODE_BAR
   bcc +
   sta Mode
   lda #0
+   
   asl
   rol $fb
   asl
   rol $fb
   asl
   rol $fb
   
  ; clc
  ; adc #<RomCharset   
   sta $fa
   lda $fb
   adc #>RomCharset
   sta $fb
   
   ldy #7
-
   lda ($fa),y
   sta ($fc),y
   dey
   bpl -
   
   lda $fc
   clc
   adc #8
   sta $fc
   bcc +
   inc $fd
+   
   inx
   cpx #4
   bne --
   

   
   lda #<(Screen1+0*40+16)
  ; sta $fe
   sta $fc
   
   ;lda ScreenSwap
   lda $02
   and #1
   beq +
   lda #$a8
   ldx #>(Screen2+0*40+16)
   bvc ++
+
   lda #$c8
   ldx #>(Screen1+0*40+16)
++
   sta $d018
   stx $fd

   lda #>($d800+0*40+16)
   sta $ff
   
   lda .ScrollCharLineOffset
   eor #7
   sta $05
   
   ldx #0
--  
   lda #0
   sta $fa
.ScrollCharLineOffset=*+1   
   lda FourChars,x
;*128
   lsr
   ror $fa
   sta $fb
   
   lda #>Target
   adc $fb
   sta $fb


   ldy $04
   lda Sin,y
   tay
   clc
   adc $fa
   sta $fa
   bcc +
   inc $fb
+   
   
   tya

   lsr
   lsr
   lsr
   ;and #$f
   tay
   lda Colors,y
   sta .Color

   ldy #7
-
   lda ($fa),y
   sta ($fc),y
   lda $fc
   sta $fe
.Color=*+1
   lda #0
   sta ($fe),y
   dey
   bpl -
   
   lda $fc
   clc
   adc #40
   sta $fc
   bcc +
   inc $fd
   inc $ff
+   


   ldy Mode
   cpy #MODE_CHAR
   bne ++
   lda $05
   and #7
   bne +
   lda $04
   ;clc
   adc #13
   sta $04
+
   dec $05
   jmp +
++

   cpy #MODE_BAR
   beq +
   inc $04
+
   inx
   cpx #25
   bne --
   
;increment angle index
   inc $02

  ; inc ScreenSwap
   
   jmp Loop
   
   
PrintHexValue
   pha
   lsr
   lsr
   lsr
   lsr
   jsr PrintHexNybble
   pla
   and #$0f
PrintHexNybble
   cmp #$0a
   bcs PHN_IsLetter
PHN_IsDigit
   ora #$30
   bne PHN_Print
PHN_IsLetter
   sbc #$09
PHN_Print
   sta $0400,x
   inx
   rts

.CODE_END

!if(.TARGET_SIZE<=64){
.HEADER_SIZE=0
}else{
.HEADER_SIZE=2
}

!message "  ----- code section is ", (.CODE_END - .CODE_START), " bytes long"
!message "  ----- data section is ", (.DATA_END - .DATA_START), " bytes long"
!message "  ----- prg has ", (.DATA_END - .CODE_START + .HEADER_SIZE) , " bytes, with basic has ", (.DATA_END - .CODE_START + 12 + .HEADER_SIZE) , " bytes"
!message "  ----- w/o basic ", .TARGET_SIZE-(.DATA_END - .CODE_START + .HEADER_SIZE) , " bytes free, with basic ", .TARGET_SIZE-(.DATA_END - .CODE_START + 12 + .HEADER_SIZE) , " bytes free"   