;;
;; play with "cycles=max" in dosbox
;;

org     100h

  
    mov  al, 13h
    int  10h
    les  si, [bx]
    mov  ds, si

pallette_loop1:
    mov dx, 3C9h
    mov al, cl
    shr ax, 1
    or cl, cl
    js noBlue
    shr ax, 1
    out dx, al
    out dx, al
    shl al, 1
    jmp pallette_loop1_end
  noBlue:
    out dx, al
    out dx, al
  pallette_loop1_end:
    out dx, al
    loop pallette_loop1

paintStart:
    add ax, [di]
    rcr ax, 1
    add ax, [di-256]
    rcr ax, 1
    dec ax
    mov [di], ax
    cmpsw
    loop paintStart
    dec dx
    jnz paintStart
frameloop:
    mov ax, 0xCCCD
    mul di
    sub dx, 140 + 114 * 256

    push cx
    mov cl, 16
  loopD:
    mov al, dh
    imul cl
    test si, 1
    jnz endOfW
    cmp ax, 8 * 256
   codeW:
    jl endOfW
    xor si, 1
  endOfW
    mov bp, ax
    inc ah
    shl ax, 3
    add ah, 53
    mov ch, ah
    test bp, bp
    jns skipYY
    neg bp
  skipYY:
    mov al, dl
    imul cl
    push ax
    inc ah
    shl ax, 3
    mov bl, ah
    pop ax
    test ax, ax
    jns skipXX
    neg ax
  skipXX:
    add bp, ax
    shr bp, 2
    mov bh, cl
    add bx, si
  timer1:
    shl bl, 1
    mov ax, [bx]
    xchg bl, ch
    xchg bl, bh
    shl bl, 1
    add ax, [bx]
    jno noOverflow
    rcr ax, 1
  noOverflow:
    cmp bp, ax
    jge paint
    inc cx
    test si, 3
    jz no_B
    jp no_B
    sub dl, ah
    xor si, 2
  no_B:
    cmp cl, 128
    jb loopD
  paint:
    mov al, cl
    sub al, 16 + 62
    imul al
    shr ax, 5
    cmp cl, 16
    jle realPaint
    and bl, 8
    add al, bl
  realPaint:
    test si, 1
    jz noWH
    and si, 0xFFFF - 3
    add al, 128
  noWH:
    stosb
    inc di
    inc di
    pop cx
    dec cx
    jnz frameloop
    mov ax, si
    neg ax
    sar ax, 2
    cwd
    xor ax, dx
    sub ax, dx
    mov [cs:codeW - 2], ax
    dec cl
    mov dx, 0x330
    rep cs outsb
    mov si, [gs:0x46C-1]
    add si, 256*3
    jno frameloop
    mov dx, 63
    jmp paintStart
MUSIC:
    db 0xC3, 122, 0x93, 0x3C, 0x7F  ; seashore

