.include "swis.asm"


.equ tex1,0x30000


.org 0x8000

Start:

screen_addr:
main:
	; Set Screen Mode 13 (320*256*8bpp)
	swi 0x116
	swi 0x10d

	; Disable cursor
	swi 0x36

	; Change palette
	adr r5,pal1
	mov r4,#0xF0
	mov r2,#15
pal_loop1:
	swi 0x113	; change pal
	mov r0,r2	; palette number
	swi 0
	swi 0x110	; no flash

	ldrb r3,[r5],#1
	and r0,r4,r3,LSR #1
	swi 0
	and r0,r4,r3,LSL #1
	swi 0
	and r0,r4,r3,LSL #4
	swi 0

	subs r2,r2,#1
	bne pal_loop1

	; Init sines
	mov r1,#2048
	mov r2,#32	; CX	; Starting Y (changed a bit from the X86 for the curve drawn to be more consistent)
	mov r3,#772	; SI	; Controls amplitude (I set it to be almost in the 0-255 range)
	mov r0,#sines
singen:
	mov r4,r2,LSR #8		; R4 = (CX >> 8)
	strb r4,[r0],#1			; Write 
	mov r4,#40				; Controls frequency (40 just happens to loop about 256 pixels)
	mul r4,r2,r4			; R4 = 40 * CX
	add r2,r2,r3			; CX = CX + SI	; moved here compared to where is at x86 code, to make sine more even
	sub r3,r3,r4,ASR #16	; SI = SI - (R4 >> 16) (DX in the x86 IMUL)
	subs r1,r1,#1
	bne singen



	mov r0,#sines
	adr r1,tex1

	mov r4,#256
	texGenY:
		mov r3,#256
		texGenX:
			mov r2,#0
			mov r10,#4
			recurse:
				mov r8,r4,LSL r10
				ldrb r6,[r0,r8]
				mov r7,r3,LSL r10
				ldrb r5,[r0,r7]
				add r7,r7,r8
				add r7,r7,r5,LSR r10
				ldrb r9,[r0,r7]
				add r5,r5,r6
				add r5,r5,r9
				;and r5,r5,#255
				add r2,r2,r5,LSR r10
			subs r10,r10,#1
			bne recurse
			and r2,r2,#255
			mov r2,r2,LSR #4
			strb r2,[r1],#1
			subs r3,r3,#1
		bne texGenX
	subs r4,r4,#1
	bne texGenY


	; Read VDU values (Start Address mainly)
	adr r0, screen_addr_input
	adr r1, screen_addr
	swi OS_ReadVduVariables
	ldr r1,[r1]

	mov r1,#screen_addr
	ldr r1,[r1]
	mov r4,#255
	patarnY:
		mov r3,#31
		patarnX:
			eor r5,r4,r3
			;and r5,r5,#15
			;add r5,r5,#47
			strb r5,[r1,#289]
			strb r5,[r1],#1
		subs r3,r3,#1
		bne patarnX
		add r1,r1,#289
	subs r4,r4,#1
	bne patarnY

	swi OS_ReadMonotonicTime
	adr r2,stime
	str r0,[r2]

main_loop:

	swi OS_ReadMonotonicTime
	adr r2,stime
	ldr r3,[r2]
	sub r12,r0,r3

	mov r10,r12,LSR #10

	mov r1,#screen_addr
	ldr r1,[r1]
	add r1,r1,#32

	adr r8,tex1
	mov r11,r12,LSR #3
	and r11,r11,#255
	add r8,r8,r11

	mov r6,#sines

	mov r3,#255
	rendLoopY:
		mov r9,r12
		mov r7,r9,LSR #12
		cmp r7,#0
		beq oofterma

		add r7,r3,r12
		and r7,r7,#255
		ldrb r7,[r6,r7]
		add r9,r7,r12,LSR #1

		oofterma:

		mov r2,#256
		rendLoopX:
			ldrb r4,[r8],#1
			ldrb r5,[r8,r9,LSR #2]
			add r4,r4,r5,LSR #1
			mov r4,r4,LSR #1

			add r4,r4,r10,LSL #6

			strb r4,[r1],#1
			subs r2,r2,#1
		bne rendLoopX
		add r1,r1,#64
	subs r3,r3,#1
	bne rendLoopY

	mov r0,#OSByte_Vsync
	swi OS_Byte

	swi OS_ReadEscapeState
	bcc main_loop

	swi OS_Exit

pal1:
.byte 31,30,21,19,10,34,36,71,36,34,10,11,20,21,30,31

screen_addr_input:
	.long VD_ScreenStart, -1

stime:
	.long 0


sines:
