org 100h

main:
    mov     dx, interrupt
    mov     ax, 251Ch
    int     21h
.main:
    jmp   main ; sorry for the infinite loop; if you start your entry on Friday 22 pm there's no time make nice shit

interrupt:
    ;pusha ; if I have time to make a proper version, we probably shouldn't trash all the registers in interrupt ;)
    mov     bp, base
    mov     ax, 0x0120 ; enable other waveforms than just sine
    call    bp
    ; handle chord progression
    mov ax, word [time+bp-base]
    mov bx, chordprog
    xchg al, ah   ; al = current chord progression, ah = 0..255 within that progression
    xlatb         ; find the index of current chord progression
    shr ah, 6     ; ah = 0..3 within the chord progression
    add al, ah
    xlatb
    mov byte [interrupt.chord+bp-base], al ; mutate the add instruction that adds the chord
    ; process the channels
    mov cl, 4
    mov si, channel_0
.loop:
    mov ax, word [time+1+bp-base]
    bt [si+9], ax
    jnc .skip
    mov al, byte [time+bp-base]
    div byte [si+8] ; ah = time within row, al = row
    test ah, ah
    jnz .skip ; if the time is not divisible by the first byte, don't advance the pattern
    and al, 7
    mov bx, si
    xlatb     ; al = note
    test al, al
    jz  .skip ; if note is 0, skip also this note
    add al, 1 ; mutated, cannot be replaced with inc ax
.chord equ $-1
    aam 7   ; ah = octave, al = note within octave
    mov bx, notetable
    xlatb    ; al = frequency, ah = octave
    xchg cl, ah
    shl al, cl ; shift frequency up by octaves
    mov cl, ah ; al is now the frequency
    add si, 10 ; now si points to the beginning of OPL settings operator settings for this channel
    add ah, 0xA0
    call bp
    add ah, 0x10
    salc
    call bp  ; al = 0 i.e. note off
    lodsb
    call bp  ; note on & set bank
    mov al, cl
    aam 3   ; undo the stupid OPL mapping from channel to operator (0 -> 0, 1 -> 1, 2 -> 2, 3 -> 8, 4 -> 9, 5 -> 10, 6 -> 16...)
    aad 8
    xchg ah, al
    mov di, 8
.writeloop:
    add ah, byte [reladdrs+bp-base+di-1]
    lodsb
    call bp
    dec di
    jnz .writeloop
.continue:
    loop .loop
    inc word [time+bp-base] ; increment time
.done:
    ;popa
    iret
.skip:
    add si, channel_1 - channel_0
    jmp .continue

base equ $

writereg:
    mov dx, 0x220
    xchg ah, al
    out dx, al
    inc dx
    xchg ah, al
    out dx, al
    ret

time:
    dw 0
    db 0

reladdrs:  ;  these are deltas of the register addresses, and the list is in reverse order, so op3 attack & decay is the first byte in the actual data
    db 0xE0 - 0x80 ; op1 Waveform Select
    db 0x80 - 0x20 ; op1 Sustain Level	Release Rate
    db 0x20 - 0x60 ; op1 Tremolo	Vibrato	Sustain	KSR	Frequency Multiplication Factor
    db 0x60 - 0xE3 ; op1 Attack Rate	Decay Rate
    db 0xE3 - 0x83 ; op2 Waveform Select
    db 0x83 - 0x23 ; op2 Sustain Level	Release Rate
    db 0x23 - 0x63 ; op2 Tremolo	Vibrato	Sustain	KSR	Frequency Multiplication Factor
    db 0x63 - 0x00 ; op2 Attack Rate	Decay Rate

notetable:
    db 45, 48, 54, 60, 64, 72, 80 ; justly tuned diatonic scale, according to 5-limit tuning. starting from 7th (B if this would be C-major scale)

chordprog:
    db 8,12,8,12,16,16,20,8 ; chord orderlist
    db 1,0,0,1
    db 1,0,0,4
    db 5,3,4,5
    db 5,3,0  ; ,1

channel_0:
    db     1,0,5,1,3,4,5,3  ; what pattern the channel is playing
    db     4                ; speed
    db     0b11111111       ; when the channel is active
    db     0b00111000       ; note on (b5), block (b2-b4), fnum hi (b0-b1)
    db     0x88             ; op2 attack & decay
    db     0b00000010       ; op2 tremolo & vibrato
    db     0x66             ; op2 sustain & release
    db     0x02             ; op2 waveform
    db     0xCC             ; op1 attack & decay
    db     0b0000000010     ; op1 tremolo & vibrato
    db     0x64             ; op1 sustain & release
    db     0x01             ; op1 waveform

channel_1:
    db     1,0,5,1,0,3,5,7  ; what pattern the channel is playing
    db     8                ; speed
    db     0b11110000       ; when the channel is active
    db     0b00110100       ; note on (b5), block (b2-b4), fnum hi (b0-b1)
    db     0x85             ; op2 attack & decay
    db     0b11000001       ; op2 tremolo & vibrato
    db     0x65             ; op2 sustain & release
    db     0x00             ; op2 waveform
    db     0xCE             ; op1 attack & decay
    db     0b11100100       ; op1 tremolo & vibrato
    db     0xE8             ; op1 sustain & release
    db     0x01             ; op1 waveform

channel_2:
    db     8,0,7,12,0,7,8,0 ; pattern
    db     6                ; speed
    db     0b11101110       ; when the channel is active
    db     0b00110100       ; note on (b5), block (b2-b4), fnum hi (b0-b1)
    db     0x99             ; op2 attack & decay
    db     0b00000010       ; op2 tremolo & vibrato
    db     0x66             ; op2 sustain & release
    db     0x02             ; op2 waveform
    db     0xCC             ; op1 attack & decay
    db     0b0000000011     ; op1 tremolo & vibrato
    db     0x6E             ; op1 sustain & release
    db     0x01             ; op1 waveform

channel_3:
    db     1,0,5,0,1,0,5,3  ; what pattern the channel is playing
    db     16               ; speed
    db     0b11111100       ; when the channel is active
    db     0b00101100       ; note on (b5), block (b2-b4), fnum hi (b0-b1)
    db     0x33             ; op2 attack & decay
    db     0b00000100       ; op2 tremolo & vibrato
    db     0x62             ; op2 sustain & release
    db     0x01             ; op2 waveform
    db     0x00             ; op1 attack & decay
    ;db     0b00000010       ; op1 tremolo & vibrato (no need to set these because attach and decay are 0)
    ;db     0x00             ; op1 sustain & release
    ;db     0x00             ; op1 waveform
