;------------------------------
;They are spraying
;
;code by Gordian
;csdb.dk/scener/?id=37254
;
;256b gfx
;Lovebyte 2025
;
;173 bytes of code
;67 bytes of data
;2 bytes of header
;242 bytes total
;------------------------------


.TARGET_SIZE=256

*=$ac0-3 ; SYS 2749

.CODE_START
   sei
   bvc Start
   
Aircraft
!byte $c0,$00,$18,$78,$00,$78,$1e,$00,$f0,$0f,$c1,$f0,$07,$fb,$e0,$01
!byte $ff,$c0,$00,$ff,$80,$00,$7f,$00,$00,$3f,$80,$00,$7f,$80,$00,$7f
!byte $80,$30,$e7,$c0,$7f,$c3,$c0,$07,$81,$c0,$03,$80,$e0,$01,$80,$60
!byte $00,$80,$70,$00,$c0,$30,$00,$c0,$10,$00,$80,$18,$00,$00,$08
   
Start
;Clear screen 
;and set white ink      
   lda #1
   sta $d021
   jsr $e536
   
;Set sprite pointers
;and colors   
   inx
-
   lda #Aircraft/64
   sta $7f8,x
   sta $d027,x ;$2b=$b
   dex
   bpl -
   
   lda #7
   sta $d015     
   sta $02
   tax

;Draw chemtrails
;1st starting at (11,7)
;2nd at (16,12)
;3rd at (21,17)
--   
   txa
   clc
   adc #4 ;x=y+4
   tay
   bvc +
-
   jsr $e9f0
      
   lda #$4e
   sta ($d1),y
   dey
   bmi ++
   inx
+   
   cpx #25
   bne -
++   
   lax $02
   sbx #256-5 ;y=y+5
   stx $02

   cpx #18 ;until y<18
   bcc --
   
   
;Set sprites
;positions
   
   lda #($c8-$21)
   ldy #5
-
   sta $d000,y
   dey
   adc #$21
   sta $d000,y 
   sbc #($28+$21)
   dey
   bpl -
   
;Generate 3 gradients (192 lines)
;as pattern
;7-1,6-2,5-3,4-4,3-5,2-6,1-7,0-8
   ldx #2
ThreeGradients
   sty $fa
   
   ldy #7
Gradient  
   lda $fa
   sta $fb
   
   lda #7
   sta $fd
GradientLine
   lda Colors,x
   asl $fb
   bcc +
   lda Colors+1,x
+
Ptr=*+1
   sta $cf
   dec Ptr

   dec $fd
   bpl GradientLine

   asl $fa
   dey
   bpl Gradient
   
   dex
   bpl ThreeGradients

Loop
   ldy #59
-
   cpy $d012
   bne -
   
   ldy #$bf
--   
   lda $0010,y
   ldx $d012
-
   cpx $d012
   beq -

   sta $d020
   sta $d021
   
;ROM data as shifts
   lda ($fc),y ;$fd has $ff
   and #3
   sta $d016      
      
   dey
   bne --
   
;;Reset scroll
  ; sty $d016

;Wait for raster 0
;and set top color again
-
   cpy $d012
   bne -
   
   lda #14
   sta $d020
   sta $d021
   
   bne Loop

     
.CODE_END 

.DATA_START

Colors
;!byte 12,14,4,4
;!byte 12,4,14,14
;!byte 10,14,4,4
;!byte 8,14,4,4
;!byte 8,4,14,14
!byte 10,4,14,14

.DATA_END


!if(.TARGET_SIZE<=64){
.HEADER_SIZE=0
}else{
.HEADER_SIZE=2
}

!message "  ----- code section is ", (.CODE_END - .CODE_START), " bytes long"
!message "  ----- data section is ", (.DATA_END - .DATA_START), " bytes long"
!message "  ----- prg has ", (.DATA_END - .CODE_START + .HEADER_SIZE) , " bytes, with basic has ", (.DATA_END - .CODE_START + 12 + .HEADER_SIZE) , " bytes"
!message "  ----- w/o basic ", .TARGET_SIZE-(.DATA_END - .CODE_START + .HEADER_SIZE) , " bytes free, with basic ", .TARGET_SIZE-(.DATA_END - .CODE_START + 12 + .HEADER_SIZE) , " bytes free"   