;------------------------------
;Undersea adventures
;
;code by Gordian
;csdb.dk/scener/?id=37254
;
;256b game
;Lovebyte 2025
;
;242 bytes of code
;12 bytes of data
;2 bytes of header
;256 bytes total
;------------------------------

.TARGET_SIZE=256

BUBBLE=$2e
OBJECT=$5a
GROUND1=$47
GROUND2=$48
GROUND3=$a0

CRAFT_WIDTH=4
CRAFT_HEIGHT=3


PosY=$fb
Counter=$fc
Lives=$fd


*=$080d ; SYS 2061

.CODE_START

   sei
   
   lda #3
   sta Lives

   ldx #$ff
   stx $5a
  ; stx $5b
   stx $58
  ; stx $59
   stx Counter
   jsr $a3e8 

   stx $d418
   dex
   stx $d40f   

   lda #$80
   sta $d412 
   
   lda #$60
   sta $e777
   
   
Start
   lda #11
   sta $d021
   sta PosY      
   jsr $e536   
   
   lda #$35
   sta $01
   
MainLoop
;Scroll
   ldx #24
-   
   ldy #0
   jsr $e9f0
   jsr $ea24
   jsr $e762
   dex 
   bpl -
;---
   stx $d020
   stx $d021


;Bubbles and objects   
   lda $d41b 
   pha
   and #$f
   tax
   jsr $e9f0

   ldx #BUBBLE
   pla
   pha
Range=*+1   
   cmp #230
   bcc +
   ldx #OBJECT
+
;   ldy #39
   lda ($d1),y  
   cmp #$20
   bne +
   txa 
   sta ($d1),y   
+   
;---     



;Water flora
   ;lda $d41b
   pla
   and #7
   adc #17
   tax

-   
   jsr $e9f0
   txa
   and #1
   adc #GROUND1
   
  ; ldy #39
   sta ($d1),y   
   inx
   cpx #25
   bcc -
;---   
 

   
;Craft
   ldx PosY
   jsr $e9f0

   lda $dc00
   lsr
   bcs NotUp
   ldy #11+2*40
   dex
   bpl NotDown
   inx
      

NotUp
   lsr
   bcs NotDown
   ldy #11
   inx
   cpx #20
   bcc NotDown
   dex   

NotDown
   stx PosY
   
   lda #$20
   sta ($d1),y

   jsr $e9f0

   ldy #10
   ldx #CRAFT_HEIGHT*CRAFT_WIDTH-1
--
   lda Craft,x
   pha
   cmp #$20
   beq ++
   lda ($d1),y
   cmp #OBJECT
   beq +
   cmp #GROUND1
   beq +
   cmp #GROUND2
   bne ++
   
+   
   dec Lives
-
   inc $d020
   lda $dc01
   cmp #$ef
   bne -
   lda Lives
   beq -
   jmp Start
++
   pla
   sta ($d1),y
   iny
   
   txa
   and #CRAFT_WIDTH-1
   bne +
   tya
   clc
   adc #40-CRAFT_WIDTH
   tay
+      
   dex   
   bpl --
;---   
  
   lda Counter 
   and #%00111111
   bne +
   dec Range 
+   
   inc Counter
   
   ldx Lives
   lda #$53
-
   sta $0400-1,x
   dex
   bne -
   
   jmp MainLoop


.CODE_END

.DATA_START   

Craft
!byte $60,$69,$60,$60
!byte $04,$d7,$3e,$60
!byte $60,$df,$60,$60

.DATA_END

!if(.TARGET_SIZE<=64){
.HEADER_SIZE=0
}else{
.HEADER_SIZE=2
}

!message "  ----- code section is ", (.CODE_END - .CODE_START), " bytes long"
!message "  ----- data section is ", (.DATA_END - .DATA_START), " bytes long"
!message "  ----- prg has ", (.DATA_END - .CODE_START + .HEADER_SIZE) , " bytes, with basic has ", (.DATA_END - .CODE_START + 12 + .HEADER_SIZE) , " bytes"
!message "  ----- w/o basic ", .TARGET_SIZE-(.DATA_END - .CODE_START + .HEADER_SIZE) , " bytes free, with basic ", .TARGET_SIZE-(.DATA_END - .CODE_START + 12 + .HEADER_SIZE) , " bytes free"   